/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.util.PaintUtils;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener2;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardSize;
import oracle.bali.ewt.wizard.WizardWindowTitle;

public class WizardDialog
extends JDialog {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private WizardListener2 _listener;
    private boolean _finishPage;
    private boolean _welcomePage;
    private WelcomeWizardPage _welcomeWizardPage;
    private boolean _skipNextTime;
    private WizardWindowTitle _windowTitle;
    private Locale _locale;
    private Component _centerOver;
    private int _initialWidth = -1;
    private int _initialHeight = -1;
    private Runnable _runnable = null;

    public WizardDialog() {
        this(null, (Frame)null, true);
    }

    public WizardDialog(BaseWizard baseWizard) {
        this(baseWizard, (Frame)null, true);
    }

    public WizardDialog(BaseWizard baseWizard, Frame frame) {
        this(baseWizard, frame, true);
    }

    public WizardDialog(BaseWizard baseWizard, Frame frame, boolean bl) {
        super(frame, "", bl);
        this._init(baseWizard);
    }

    public WizardDialog(BaseWizard baseWizard, Dialog dialog) {
        this(baseWizard, dialog, true);
    }

    public WizardDialog(BaseWizard baseWizard, Dialog dialog, boolean bl) {
        super(dialog, "", bl);
        this._init(baseWizard);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(BaseWizard baseWizard) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._wizard = baseWizard;
        this._windowTitle.setWizard(this._wizard);
    }

    public void setWizardTitle(String string) {
        this._windowTitle.setBaseTitle(string);
    }

    public String getWizardTitle() {
        return this._windowTitle.getBaseTitle();
    }

    public void setWelcomePageIncluded(boolean bl) {
        this._welcomePage = bl;
    }

    public boolean isWelcomePageIncluded() {
        return this._welcomePage;
    }

    public void setWelcomeWizardPage(WelcomeWizardPage welcomeWizardPage) {
        this._welcomeWizardPage = welcomeWizardPage;
        this.setWelcomePageIncluded(welcomeWizardPage != null);
    }

    public WelcomeWizardPage getWelcomeWizardPage() {
        return this._welcomeWizardPage;
    }

    public void setFinishPageIncluded(boolean bl) {
        this._finishPage = bl;
    }

    public boolean isFinishPageIncluded() {
        return this._finishPage;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public Component getCenterOver() {
        return this._centerOver;
    }

    public void setCenterOver(Component component) {
        this._centerOver = component;
    }

    public boolean runDialog() {
        return this.runDialog(null);
    }

    public boolean runDialog(Runnable runnable) {
        BaseWizard baseWizard = this._wizard;
        if (this.isVisible() || baseWizard == null || baseWizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this._runnable = runnable;
        this.getContentPane().add((Component)baseWizard, "Center");
        baseWizard.addWizardListener(this._listener);
        this._initialWidth = -1;
        this._initialHeight = -1;
        if (this._welcomeWizardPage != null) {
            this._skipNextTime = this._welcomeWizardPage.isSkipNextTime();
            baseWizard.restart();
            if (this._skipNextTime) {
                baseWizard.doNext();
            }
        }
        this._windowTitle.setCanUpdate(true);
        this._windowTitle.updateTitle();
        this.pack();
        ((Component)this).setBackground(baseWizard.getBackground());
        this.getContentPane().setBackground(baseWizard.getBackground());
        Component component = this.getCenterOver();
        if (component == null) {
            component = this.getParent();
        }
        WindowUtils.centerWindow(this, component);
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        this._cancelled = false;
        ((Component)this).setVisible(true);
        if (this.isModal() && this._wizard != null) {
            baseWizard.removeWizardListener(this._listener);
            this._windowTitle.setCanUpdate(false);
            this.getContentPane().remove(baseWizard);
        }
        return !this._cancelled;
    }

    public void setLocale(Locale locale) {
        this._locale = locale;
    }

    public Locale getLocale() {
        Locale locale = this._locale;
        if (locale != null) {
            return locale;
        }
        Container container = this.getParent();
        if (container != null && (locale = container.getLocale()) != null) {
            return locale;
        }
        return super.getLocale();
    }

    public Dimension getPreferredSize() {
        if (this._wizard != null) {
            return WizardSize.getWizardWindowSize(this._wizard.getDefaultWizardSize());
        }
        return WizardSize.getWizardWindowSize(0);
    }

    public void dispose() {
        super.dispose();
        if (this._wizard == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this._windowTitle.setWizard(null);
        this.getContentPane().remove(this._wizard);
        this._wizard.removeWizardListener(this._listener);
        this._wizard.dispose();
        this._listener = null;
        this._windowTitle = null;
        this._wizard = null;
        this._locale = null;
        this._centerOver = null;
    }

    protected void dismissDialog(boolean bl) {
        this._cancelled = bl;
        if (this.isVisible()) {
            ((Component)this).setVisible(false);
            if (!this.isModal()) {
                this._wizard.removeWizardListener(this._listener);
                this._windowTitle.setCanUpdate(false);
                this.getContentPane().remove(this._wizard);
            }
            if (!this._cancelled && this._runnable != null) {
                PaintUtils.invokeAfterRepaint(this._runnable);
                this._runnable = null;
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n;
        int n2;
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() != 101) {
            return;
        }
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        if (this._initialWidth != -1) {
            n3 = Math.max(this._initialWidth, n3);
        }
        if (this._initialHeight != -1) {
            n4 = Math.max(this._initialHeight, n4);
        }
        if (n2 != n3 || n != n4) {
            ((Component)this).setSize(n3, n4);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this._wizard.__doCancelClick();
        }
        super.processWindowEvent(windowEvent);
    }

    private void _init(BaseWizard baseWizard) {
        WindowUtils.registerWindow(this);
        this._wizard = baseWizard;
        this._listener = new WizListener();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        this.enableEvents(65L);
        this.setDefaultCloseOperation(0);
        this._windowTitle = new WizardWindowTitle(this, baseWizard);
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardFinished(WizardEvent wizardEvent) {
            WizardPage wizardPage = WizardDialog.this._wizard.getProgressWizardPage();
            WizardPage wizardPage2 = WizardDialog.this._wizard.getEndOfProcessWizardPage();
            if (wizardPage == null && wizardPage2 == null) {
                WizardDialog.this.dismissDialog(false);
                return;
            }
            WizardPage wizardPage3 = WizardDialog.this._wizard.getNextPage(wizardEvent.getPage());
            while (wizardPage3 == null || wizardPage3 != wizardPage && wizardPage3 != wizardPage2) {
                if (wizardPage3 == null) {
                    WizardDialog.this.dismissDialog(false);
                    break;
                }
                wizardPage3 = WizardDialog.this._wizard.getNextPage(wizardPage3);
            }
        }

        public void wizardCanceled(WizardEvent wizardEvent) {
            WizardDialog.this.dismissDialog(true);
            if (WizardDialog.this._welcomeWizardPage != null) {
                WizardDialog.this._welcomeWizardPage.setSkipNextTime(WizardDialog.this._skipNextTime);
            }
        }

        public void wizardClosed(WizardEvent wizardEvent) {
            WizardDialog.this.dismissDialog(false);
        }
    }
}

