/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener2;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardSize;
import oracle.bali.ewt.wizard.WizardWindowTitle;

public class WizardFrame
extends JFrame {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private WizardListener2 _listener;
    private boolean _skipNextTime;
    private WelcomeWizardPage _welcomeWizardPage;
    private int _initialWidth = -1;
    private int _initialHeight = -1;
    private WizardWindowTitle _windowTitle;

    public WizardFrame() {
        this(null, "");
    }

    public WizardFrame(BaseWizard baseWizard) {
        this(baseWizard, "");
    }

    public WizardFrame(BaseWizard baseWizard, String string) {
        super(string);
        WindowUtils.registerWindow(this);
        this._wizard = baseWizard;
        this._listener = new WizListener();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        this.enableEvents(65L);
        this.setDefaultCloseOperation(0);
        this._windowTitle = new WizardWindowTitle(this, this._wizard);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(BaseWizard baseWizard) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._wizard = baseWizard;
        this._windowTitle.setWizard(this._wizard);
    }

    public void setWizardTitle(String string) {
        this._windowTitle.setBaseTitle(string);
    }

    public String getWizardTitle() {
        return this._windowTitle.getBaseTitle();
    }

    public void setWelcomeWizardPage(WelcomeWizardPage welcomeWizardPage) {
        this._welcomeWizardPage = welcomeWizardPage;
    }

    public WelcomeWizardPage getWelcomeWizardPage() {
        return this._welcomeWizardPage;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        BaseWizard baseWizard = this._wizard;
        if (baseWizard == null || baseWizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this.getContentPane().add((Component)baseWizard, "Center");
        baseWizard.addWizardListener(this._listener);
        this._initialWidth = -1;
        this._initialHeight = -1;
        if (this._welcomeWizardPage != null) {
            this._skipNextTime = this._welcomeWizardPage.isSkipNextTime();
            if (this._skipNextTime && this._wizard.getSelectedPage() == this._welcomeWizardPage) {
                baseWizard.doNext();
            }
        }
        this._windowTitle.setCanUpdate(true);
        this._windowTitle.updateTitle();
        this.pack();
        ((Component)this).setBackground(baseWizard.getBackground());
        this.getContentPane().setBackground(baseWizard.getBackground());
        WindowUtils.centerWindow(this);
        this._initialWidth = this.getWidth();
        this._initialHeight = this.getHeight();
        this._cancelled = false;
        super.show();
    }

    public Dimension getPreferredSize() {
        if (this._wizard != null) {
            return WizardSize.getWizardWindowSize(this._wizard.getDefaultWizardSize());
        }
        return WizardSize.getWizardWindowSize(0);
    }

    public void dispose() {
        super.dispose();
        if (this._wizard == null) {
            return;
        }
        WindowUtils.unregisterWindow(this);
        this._windowTitle.setWizard(null);
        this._windowTitle = null;
        this.getContentPane().remove(this._wizard);
        this._wizard.removeWizardListener(this._listener);
        this._wizard.dispose();
        this._listener = null;
        this._wizard = null;
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101) {
            int n;
            int n2;
            int n3 = n2 = this.getWidth();
            int n4 = n = this.getHeight();
            if (this._initialWidth != -1) {
                n3 = Math.max(this._initialWidth, n3);
            }
            if (this._initialHeight != -1) {
                n4 = Math.max(this._initialHeight, n4);
            }
            if (n2 != n3 || n != n4) {
                ((Component)this).setSize(n3, n4);
            }
        }
    }

    protected void dismissFrame(boolean bl) {
        this._cancelled = bl;
        if (this.isVisible()) {
            ((Component)this).setVisible(false);
            this._wizard.removeWizardListener(this._listener);
            this._windowTitle.setCanUpdate(false);
            this.getContentPane().remove(this._wizard);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this._wizard.__doCancelClick();
        }
        super.processWindowEvent(windowEvent);
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardFinished(WizardEvent wizardEvent) {
            WizardPage wizardPage = WizardFrame.this._wizard.getProgressWizardPage();
            WizardPage wizardPage2 = WizardFrame.this._wizard.getEndOfProcessWizardPage();
            if (wizardPage == null && wizardPage2 == null) {
                WizardFrame.this.dismissFrame(false);
                return;
            }
            WizardPage wizardPage3 = WizardFrame.this._wizard.getNextPage(wizardEvent.getPage());
            while (wizardPage3 == null || wizardPage3 != wizardPage && wizardPage3 != wizardPage2) {
                if (wizardPage3 == null) {
                    WizardFrame.this.dismissFrame(false);
                    break;
                }
                wizardPage3 = WizardFrame.this._wizard.getNextPage(wizardPage3);
            }
        }

        public void wizardCanceled(WizardEvent wizardEvent) {
            WizardFrame.this.dismissFrame(true);
            if (WizardFrame.this._welcomeWizardPage != null) {
                WizardFrame.this._welcomeWizardPage.setSkipNextTime(WizardFrame.this._skipNextTime);
            }
        }

        public void wizardClosed(WizardEvent wizardEvent) {
            WizardFrame.this.dismissFrame(false);
        }
    }
}

