/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardValidateEvent;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bali.share.event.ListenerManager;

public class WizardPage {
    public static final int NOT_ADDED_INDEX = -1;
    private String _label;
    private String _pageTitle;
    private Component _content;
    private boolean _enabled;
    private boolean _visible;
    private Component _initialFocus;
    private boolean _canAdvance;
    private boolean _canGoBack;
    private boolean _visited;
    private boolean _branching;
    private boolean _valid;
    private Vector _validationComponents;
    private BaseWizard _parent;
    private ListenerManager _wizardValidateListeners;
    private PropertyChangeSupport _propertySupport;
    private String _accessibleDescription = "";

    public WizardPage(Component component) {
        this(component, null);
    }

    public WizardPage(Component component, String string) {
        this(component, string, null);
    }

    public WizardPage(Component component, String string, String string2) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        this._enabled = true;
        this._visible = true;
        this._label = string;
        this._content = component;
        this._canAdvance = true;
        this._canGoBack = true;
        this._valid = true;
        this._initialFocus = null;
        this._pageTitle = string2;
    }

    public void setVisible(boolean bl) {
        if (bl != this._visible) {
            this._visible = bl;
            this._firePropertyChange("visible", bl);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setContent(Component component) {
        if (component == null) {
            throw new IllegalArgumentException();
        }
        Component component2 = this._content;
        if (component2 != component) {
            this._content = component;
            this.firePropertyChange("content", component2, component);
        }
    }

    public Component getContent() {
        return this._content;
    }

    public void setLabel(String string) {
        String string2 = this._label;
        if (string2 != string) {
            this._label = string;
            this.firePropertyChange("label", string2, string);
        }
    }

    public String getLabel() {
        return this._label;
    }

    public void setEnabled(boolean bl) {
        if (this._enabled != bl) {
            this._enabled = bl;
            this._firePropertyChange("enabled", bl);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setCanAdvance(boolean bl) {
        if (bl != this.getCanAdvance()) {
            this._canAdvance = bl;
            this._firePropertyChange("canAdvance", bl);
        }
    }

    public boolean getCanAdvance() {
        return this._canAdvance;
    }

    public void setCanGoBack(boolean bl) {
        if (bl != this.getCanGoBack()) {
            this._canGoBack = bl;
            this._firePropertyChange("canGoBack", bl);
        }
    }

    public boolean getCanGoBack() {
        return this._canGoBack;
    }

    public boolean isSelected() {
        BaseWizard baseWizard = this.getParent();
        if (baseWizard == null) {
            return false;
        }
        return baseWizard.getSelectedPage() == this;
    }

    public int getIndex() {
        BaseWizard baseWizard = this.getParent();
        if (baseWizard == null) {
            return -1;
        }
        return baseWizard.__getPageIndex(this);
    }

    public BaseWizard getParent() {
        return this._parent;
    }

    public Component getInitialFocus() {
        return this._initialFocus;
    }

    public void setInitialFocus(Component component) {
        this._initialFocus = component;
    }

    public String getAccessibleDescription() {
        return this._accessibleDescription;
    }

    public void setAccessibleDescription(String string) {
        String string2 = this._accessibleDescription;
        this._accessibleDescription = string;
        this.firePropertyChange("accessibleDescription", string2, this._accessibleDescription);
    }

    public void setPageTitle(String string) {
        String string2 = this._pageTitle;
        if (string2 != string) {
            this._pageTitle = string;
            this.firePropertyChange("pageTitle", string2, this._pageTitle);
        }
    }

    public String getPageTitle() {
        return this._pageTitle;
    }

    public void setBranching(boolean bl) {
        if (bl != this.isBranching()) {
            this._branching = bl;
            this._firePropertyChange("branching", this._branching);
        }
    }

    public boolean isBranching() {
        return this._branching;
    }

    public boolean isVisited() {
        return this._visited;
    }

    public void setValid(boolean bl) {
        if (bl != this._valid) {
            this._valid = bl;
            this._firePropertyChange("valid", this._valid);
        }
    }

    public boolean isValid() {
        return this._valid;
    }

    public void reset() {
        this.__setVisited(false);
        this.setValid(true);
    }

    public void addValidationComponent(ValidationComponent validationComponent) {
        if (validationComponent != null) {
            if (this._validationComponents == null) {
                this._validationComponents = new Vector();
            }
            if (!this._validationComponents.contains(validationComponent)) {
                this._validationComponents.add(validationComponent);
            }
        }
    }

    public void removeValidationComponent(ValidationComponent validationComponent) {
        if (this._validationComponents != null) {
            this._validationComponents.remove(validationComponent);
        }
    }

    public void removeAllValidationComponents() {
        if (this._validationComponents != null) {
            this._validationComponents.removeAllElements();
        }
    }

    public ValidationComponent[] getValidationComponents() {
        if (this._validationComponents != null) {
            return this._validationComponents.toArray(new ValidationComponent[0]);
        }
        return new ValidationComponent[0];
    }

    public synchronized void addWizardValidateListener(WizardValidateListener wizardValidateListener) {
        if (this._wizardValidateListeners == null) {
            this._wizardValidateListeners = new ListenerManager();
        }
        this._wizardValidateListeners.addListener((EventListener)wizardValidateListener);
    }

    public synchronized void removeWizardValidateListener(WizardValidateListener wizardValidateListener) {
        if (this._wizardValidateListeners != null) {
            this._wizardValidateListeners.removeListener((EventListener)wizardValidateListener);
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + ",pageTitle=" + this.getPageTitle();
        string = string + ",label=" + this.getLabel();
        if (!this.isEnabled()) {
            string = string + ",disabled";
        }
        if (!this.isVisible()) {
            string = string + ",hidden";
        }
        if (this.isSelected()) {
            string = string + ",selected";
        }
        if (this.isVisited()) {
            string = string + ",visited";
        }
        return string;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(string, object, object2);
        }
    }

    protected boolean validatePage() {
        WizardValidateEvent wizardValidateEvent = new WizardValidateEvent(this, 2000, this);
        this.processWizardValidateEvent(wizardValidateEvent);
        return !wizardValidateEvent.isCancelled();
    }

    protected void processWizardValidateEvent(WizardValidateEvent wizardValidateEvent) {
        Enumeration enumeration;
        int n = wizardValidateEvent.getID();
        ListenerManager listenerManager = this._wizardValidateListeners;
        if (listenerManager != null && (enumeration = listenerManager.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                WizardValidateListener wizardValidateListener = (WizardValidateListener)enumeration.nextElement();
                wizardValidateListener.wizardValidatePage(wizardValidateEvent);
            }
        }
    }

    void __setParent(BaseWizard baseWizard) {
        this._parent = baseWizard;
        this._visited = false;
    }

    void __setVisited(boolean bl) {
        this._visited = bl;
    }

    private void _firePropertyChange(String string, boolean bl) {
        this.firePropertyChange(string, bl ? Boolean.FALSE : Boolean.TRUE, bl ? Boolean.TRUE : Boolean.FALSE);
    }
}

