/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.graphics.IconStrip;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardSize;

class WizardRoadMap
extends LWComponent
implements Accessible {
    private static final IconStrip[] _ICON_STRIPS = new IconStrip[6];
    private static final Icon[][] _ICONS = new Icon[6][7];
    private static final String[] _STRIP_IMAGES = new String[]{"icons/simple-first.png", "icons/simple-middle.png", "icons/simple-last.png", "icons/branch-first.png", "icons/branch-middle.png", "icons/branch-last.png"};
    private static final int _SIMPLE_FIRST = 0;
    private static final int _SIMPLE_MIDDLE = 1;
    private static final int _SIMPLE_LAST = 2;
    private static final Insets _INSET = new Insets(0, 6, 0, 4);
    private static final Border _LIST_BORDER = new EmptyBorder(13, 0, 6, 0);
    private static final Border _BORDER = new EmptyBorder(7, 0, 7, 0);
    private static final Color _VISITED_STEP_COLOR = new Color(114, 0, 124);
    private static final Color _UNVISITED_STEP_COLOR = new Color(0, 51, 153);
    private static final Color _ERROR_STEP_COLOR = new Color(255, 0, 51);
    private static final Color _FOCUSSTEP_BORDER_COLOR = new Color(157, 171, 194);
    private BaseWizard _wizard;
    private Listener _listener;
    private JList _list;
    private DefaultListModel _model;
    private boolean _ignoreSel;
    private int _canGoBackIndex;
    private int _canAdvanceIndex;
    private boolean _allLinksEnabled;
    private boolean _isVisitedLinkEnabled;
    private boolean _navigationRangeDirty;

    public WizardRoadMap(BaseWizard baseWizard) {
        this._wizard = baseWizard;
        this._listener = new Listener();
        this._model = new DefaultListModel();
        this._list = new RoadMapList(this._model);
        this.setBorder(_BORDER);
        JScrollPane jScrollPane = new JScrollPane(this._list);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        WizardPage[] wizardPageArray = this._wizard.__getAllPages();
        int n = 0;
        while (n < wizardPageArray.length) {
            this.addPage(wizardPageArray[n]);
            ++n;
        }
        this._list.setSelectedValue(this._wizard.getSelectedPage(), true);
        this._wizard.addWizardListener(this._listener);
        this._wizard.addPropertyChangeListener(this._listener);
        this._list.addListSelectionListener(this._listener);
    }

    public void addPage(WizardPage wizardPage) {
        if (wizardPage != null) {
            wizardPage.addPropertyChangeListener(this._listener);
            this._addPage(wizardPage);
        }
    }

    public void removePage(WizardPage wizardPage) {
        if (wizardPage != null) {
            wizardPage.removePropertyChangeListener(this._listener);
            this._removePage(wizardPage);
        }
    }

    public void setAllLinksEnabled(boolean bl) {
        if (bl != this._allLinksEnabled) {
            this._allLinksEnabled = bl;
            this.repaint();
        }
    }

    public boolean isAllLinksEnabled() {
        return this._allLinksEnabled;
    }

    public void setVisitedLinkEnabled(boolean bl) {
        if (bl != this._isVisitedLinkEnabled) {
            this._isVisitedLinkEnabled = bl;
            this.repaint();
        }
    }

    public boolean isVisitedLinkEnabled() {
        return this._isVisitedLinkEnabled;
    }

    public void dispose() {
        this._wizard.removeWizardListener(this._listener);
        this._wizard.removePropertyChangeListener(this._listener);
        this._wizard = null;
        this._list.removeListSelectionListener(this._listener);
        this._model = null;
        this._list = null;
        this._listener = null;
        this.removeAll();
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        if (bl2 != bl) {
            int n = this.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                this.getComponent(n2).setEnabled(bl);
                ++n2;
            }
        }
    }

    public Dimension getPreferredSize() {
        return WizardSize.getNavigationPanelSize(this._wizard.getDefaultWizardSize());
    }

    public boolean hasFocus() {
        return this._list.hasFocus();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWizardRoadMap();
        }
        return this.accessibleContext;
    }

    private void _addPage(WizardPage wizardPage) {
        if (wizardPage.isVisible()) {
            this._navigationRangeDirty = true;
            WizardPage wizardPage2 = this._getNextVisiblePage(wizardPage);
            this._ignoreSel = true;
            if (wizardPage2 == null) {
                this._model.addElement(wizardPage);
            } else {
                this._model.add(this._model.indexOf(wizardPage2), wizardPage);
            }
            this._ignoreSel = false;
        }
    }

    private void _removePage(WizardPage wizardPage) {
        this._navigationRangeDirty = true;
        this._ignoreSel = true;
        this._model.removeElement(wizardPage);
        this._ignoreSel = false;
    }

    private boolean _isEnabled(WizardPage wizardPage, int n) {
        if (wizardPage != null && this._wizard.isEnabled(wizardPage)) {
            if (!this._wizard.__isSequential()) {
                return true;
            }
            WizardPage wizardPage2 = this._wizard.getSelectedPage();
            if (wizardPage == wizardPage2) {
                return true;
            }
            if (this.isAllLinksEnabled() || this.isVisitedLinkEnabled()) {
                if (this._navigationRangeDirty) {
                    this._updateCanGoBackIndex();
                    this._updateCanAdvanceIndex();
                    this._navigationRangeDirty = false;
                }
                if (n >= this._canGoBackIndex && n <= this._canAdvanceIndex) {
                    if (this.isAllLinksEnabled()) {
                        return true;
                    }
                    if (wizardPage.isVisited()) {
                        return true;
                    }
                }
            }
            if (wizardPage == this._wizard.getNextPage(wizardPage2) && this._wizard.getCanAdvance()) {
                return true;
            }
            if (wizardPage == this._wizard.getPreviousPage(wizardPage2) && this._wizard.getCanGoBack()) {
                return true;
            }
        }
        return false;
    }

    private WizardPage _getNextVisiblePage(WizardPage wizardPage) {
        if (wizardPage == null) {
            return null;
        }
        int n = this._wizard.__getPageIndex(wizardPage);
        int n2 = this._wizard.__getActualPageCount();
        while (++n < n2) {
            WizardPage wizardPage2 = this._wizard.__getPageAt(n);
            if (wizardPage2 == null || !this._model.contains(wizardPage2)) continue;
            return wizardPage2;
        }
        return null;
    }

    private void _updateCanGoBackIndex() {
        WizardPage wizardPage;
        WizardPage wizardPage2 = wizardPage = this._wizard.getSelectedPage();
        while (wizardPage2 != null) {
            boolean bl;
            boolean bl2 = bl = wizardPage2 == wizardPage ? this._wizard.getCanGoBack() : wizardPage2.getCanGoBack();
            if (!bl) {
                this._canGoBackIndex = this._model.indexOf(wizardPage2);
                break;
            }
            wizardPage2 = this._wizard.getPreviousPage(wizardPage2);
        }
        if (wizardPage2 == null) {
            this._canGoBackIndex = 0;
        }
    }

    private void _updateCanAdvanceIndex() {
        WizardPage wizardPage;
        WizardPage wizardPage2 = wizardPage = this._wizard.getSelectedPage();
        while (wizardPage2 != null) {
            boolean bl;
            boolean bl2 = bl = wizardPage2 == wizardPage ? this._wizard.getCanAdvance() : wizardPage2.getCanAdvance();
            if (!bl) {
                this._canAdvanceIndex = this._model.indexOf(wizardPage2);
                break;
            }
            wizardPage2 = this._wizard.getNextPage(wizardPage2);
        }
        if (wizardPage2 == null) {
            this._canAdvanceIndex = this._model.getSize() - 1;
        }
    }

    private class Listener
    extends WizardAdapter
    implements PropertyChangeListener,
    ListSelectionListener {
        private Listener() {
        }

        public void wizardSelectionChanged(WizardEvent wizardEvent) {
            WizardRoadMap.this._navigationRangeDirty = true;
            WizardPage wizardPage = wizardEvent.getPage();
            WizardRoadMap.this._list.setSelectedIndex(WizardRoadMap.this._model.indexOf(wizardPage));
            WizardRoadMap.this._list.setFixedCellHeight(1);
            WizardRoadMap.this._list.setFixedCellHeight(-1);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            Object object2 = propertyChangeEvent.getNewValue();
            if (object == WizardRoadMap.this._wizard) {
                if ("pageAdded".equals(string)) {
                    WizardRoadMap.this.addPage((WizardPage)object2);
                } else if ("pageRemoved".equals(string)) {
                    WizardRoadMap.this.removePage((WizardPage)object2);
                }
            } else if (object instanceof WizardPage) {
                WizardPage wizardPage = (WizardPage)object;
                if ("enabled".equals(string) || "canAdvance".equals(string) || "canGoBack".equals(string)) {
                    WizardRoadMap.this._navigationRangeDirty = true;
                    WizardRoadMap.this.repaint();
                } else if ("label".equals(string) || "branching".equals(string) || "valid".equals(string)) {
                    WizardRoadMap.this.repaint();
                } else if ("visible".equals(string)) {
                    if (Boolean.TRUE.equals(object2)) {
                        WizardRoadMap.this._addPage(wizardPage);
                    } else {
                        WizardRoadMap.this._removePage(wizardPage);
                    }
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            WizardPage wizardPage;
            if (WizardRoadMap.this._ignoreSel) {
                return;
            }
            WizardPage wizardPage2 = (WizardPage)WizardRoadMap.this._list.getSelectedValue();
            if (wizardPage2 != (wizardPage = WizardRoadMap.this._wizard.getSelectedPage())) {
                boolean bl = !WizardRoadMap.this._wizard.__isSequential() || WizardRoadMap.this._model.indexOf(wizardPage2) >= WizardRoadMap.this._model.indexOf(wizardPage);
                WizardRoadMap.this._wizard.selectPage(wizardPage2, bl);
                wizardPage = WizardRoadMap.this._wizard.getSelectedPage();
                if (wizardPage2 != wizardPage) {
                    WizardRoadMap.this._list.setSelectedIndex(WizardRoadMap.this._model.indexOf(wizardPage));
                }
            }
        }
    }

    private class AccessibleWizardRoadMap
    extends JComponent.AccessibleJComponent {
        private AccessibleWizardRoadMap() {
            super(WizardRoadMap.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private class RoadMapList
    extends JList {
        public RoadMapList(ListModel listModel) {
            this.setModel(listModel);
            this.setCellRenderer(new CellRenderer());
            this.setSelectionModel(new SelectionModel());
            this.setBorder(_LIST_BORDER);
            this.setOpaque(false);
        }

        public int getNextMatch(String string, int n, Position.Bias bias) {
            return -1;
        }

        protected void processComponentKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() != 401 || !this.isEnabled()) {
                return;
            }
            int n = this.getLeadSelectionIndex();
            boolean bl = keyEvent.isControlDown() && !keyEvent.isShiftDown();
            int n2 = this.getModel().getSize();
            int n3 = -1;
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    n3 = this._getNextIndex(false, n, n2);
                    break;
                }
                case 40: {
                    n3 = this._getNextIndex(true, n, n2);
                    break;
                }
                case 32: {
                    n3 = n;
                    bl = false;
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    break;
                }
                default: {
                    return;
                }
            }
            keyEvent.consume();
            if (n3 != -1) {
                if (bl && n3 != n) {
                    this.getSelectionModel().setLeadSelectionIndex(n3);
                } else if (!this.isSelectedIndex(n3)) {
                    this.setSelectedIndex(n3);
                }
            }
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506 && SwingUtilities.isLeftMouseButton(mouseEvent) && this.isEnabled()) {
                mouseEvent.consume();
            }
            super.processMouseMotionEvent(mouseEvent);
        }

        private int _getNextIndex(boolean bl, int n, int n2) {
            int n3;
            if (n == -1 && !bl) {
                n = n2;
            }
            if ((n3 = this._getNextEnabledIndex(bl, n, n2)) == -1) {
                return n;
            }
            return n3;
        }

        private int _getNextEnabledIndex(boolean bl, int n, int n2) {
            int n3 = n = bl ? n + 1 : n - 1;
            if (n < 0 || n >= n2) {
                return -1;
            }
            WizardPage wizardPage = (WizardPage)WizardRoadMap.this._model.get(n);
            if (WizardRoadMap.this._isEnabled(wizardPage, n)) {
                return n;
            }
            return this._getNextEnabledIndex(bl, n, n2);
        }

        private class CellRenderer
        extends JLabel
        implements ListCellRenderer {
            private StepBorder _border = new StepBorder();
            static /* synthetic */ Class class$oracle$bali$ewt$wizard$WizardRoadMap;

            public CellRenderer() {
                this.setBorder(this._border);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                int n2;
                WizardPage wizardPage = (WizardPage)object;
                String string = wizardPage.getLabel();
                bl = wizardPage.isSelected();
                boolean bl3 = WizardRoadMap.this._isEnabled(wizardPage, n);
                boolean bl4 = wizardPage.isVisited();
                boolean bl5 = !bl4 && !bl || wizardPage.isValid();
                this.setEnabled(bl3);
                this.setText(bl3 && !bl ? "<HTML><u>" + string + "</u>" : string);
                int n3 = n2 = wizardPage.isBranching() ? 3 : 0;
                n2 += n == 0 ? 0 : (n != WizardRoadMap.this._model.size() - 1 ? 1 : 2);
                if (bl3) {
                    int n4;
                    int n5 = !bl5 ? 4 : (n4 = !bl4 ? 2 : 0);
                    if (bl) {
                        ++n4;
                    }
                    this.setIcon(this._getIcon(n2, n4));
                } else {
                    this.setDisabledIcon(this._getIcon(n2, 6));
                }
                this.setFont(bl3 && (bl || !bl5) ? jList.getFont().deriveFont(1) : jList.getFont());
                if (bl3) {
                    Color color = bl5 ? (bl4 ? _VISITED_STEP_COLOR : _UNVISITED_STEP_COLOR) : _ERROR_STEP_COLOR;
                    this.setForeground(color);
                }
                if (bl) {
                    this.setOpaque(true);
                    this.setBackground(Color.white);
                } else {
                    this.setOpaque(false);
                }
                this._border.setEmpty(!bl2);
                if (this.getPreferredSize().width > WizardRoadMap.this._list.getParent().getWidth()) {
                    this.setToolTipText(string);
                } else {
                    this.setToolTipText(null);
                }
                return this;
            }

            private Icon _getIcon(int n, int n2) {
                if (_ICON_STRIPS[n] == null) {
                    Image image = ImageUtils.getImageResource(class$oracle$bali$ewt$wizard$WizardRoadMap == null ? (class$oracle$bali$ewt$wizard$WizardRoadMap = CellRenderer.class$("oracle.bali.ewt.wizard.WizardRoadMap")) : class$oracle$bali$ewt$wizard$WizardRoadMap, _STRIP_IMAGES[n]);
                    _ICON_STRIPS[n] = new IconStrip(image, 7, false);
                }
                if (_ICONS[n][n2] == null) {
                    _ICONS[n][n2] = _ICON_STRIPS[n].getIcon(n2);
                }
                return _ICONS[n][n2];
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }

            private class StepBorder
            implements Border {
                private boolean _isEmpty;

                private StepBorder() {
                }

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    if (!this._isEmpty) {
                        graphics.setColor(_FOCUSSTEP_BORDER_COLOR);
                        graphics.drawLine(n, n2, n + n3 - 1, n2);
                        graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                    }
                }

                public Insets getBorderInsets(Component component) {
                    return _INSET;
                }

                public boolean isBorderOpaque() {
                    return !this._isEmpty;
                }

                public void setEmpty(boolean bl) {
                    this._isEmpty = bl;
                }
            }
        }

        private class SelectionModel
        extends DefaultListSelectionModel {
            public SelectionModel() {
                this.setSelectionMode(0);
            }

            public void setSelectionInterval(int n, int n2) {
                if (n == -1 || n2 == -1) {
                    return;
                }
                WizardPage wizardPage = (WizardPage)RoadMapList.this.getModel().getElementAt(n2);
                if (!WizardRoadMap.this._isEnabled(wizardPage, n2)) {
                    return;
                }
                super.setSelectionInterval(n2, n2);
            }

            public void removeSelectionInterval(int n, int n2) {
            }

            public void clearSelection() {
            }
        }
    }
}

