/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.DWizard;
import oracle.bali.share.util.IntegerUtils;

class WizardWindowTitle
extends WizardAdapter
implements PropertyChangeListener {
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_OTHER = "WIZARD.TITLE_OTHER";
    private BaseWizard _wizard;
    private String _baseTitle;
    private Window _wizardWindow;
    private boolean _canUpdate;

    public WizardWindowTitle(Window window, BaseWizard baseWizard) {
        this._wizardWindow = window;
        this.setWizard(baseWizard);
    }

    public void setWizard(BaseWizard baseWizard) {
        if (baseWizard != this._wizard) {
            if (this._wizard != null) {
                this._wizard.removeWizardListener(this);
                this._wizard.removePropertyChangeListener(this);
            }
            this._wizard = baseWizard;
            if (this._wizard != null) {
                this._wizard.addWizardListener(this);
                this._wizard.addPropertyChangeListener(this);
            }
        }
    }

    public void setBaseTitle(String string) {
        if (string != this._baseTitle) {
            this._baseTitle = string;
            this.updateTitle();
        }
    }

    public String getBaseTitle() {
        return this._baseTitle;
    }

    public void setCanUpdate(boolean bl) {
        this._canUpdate = bl;
    }

    public void updateTitle() {
        if (!this._canUpdate) {
            return;
        }
        if (this._wizard != null && this._baseTitle != null) {
            String string = this._baseTitle;
            WizardPage wizardPage = this._wizard.getSelectedPage();
            if (wizardPage != null) {
                Object object;
                int n = this._wizard.getPageCount();
                int n2 = -1;
                int n3 = 0;
                if (this._wizard instanceof DWizard) {
                    n3 = n;
                    n2 = ((DWizard)this._wizard).getCurrentPageIndex();
                } else {
                    int n4 = 0;
                    while (n4 < n) {
                        object = this._wizard.getPageAt(n4);
                        if (object == wizardPage) {
                            n2 = n3;
                        }
                        if (((WizardPage)object).isVisible()) {
                            ++n3;
                        }
                        ++n4;
                    }
                }
                object = ResourceBundle.getBundle(_BUNDLE, this._wizardWindow.getLocale());
                MessageFormat messageFormat = new MessageFormat(((ResourceBundle)object).getString(_KEY_OTHER));
                Object[] objectArray = new Object[]{this._baseTitle, IntegerUtils.getInteger((int)(++n2)), IntegerUtils.getInteger((int)n3)};
                string = messageFormat.format(objectArray);
            }
            if (this._wizardWindow instanceof Dialog) {
                ((Dialog)this._wizardWindow).setTitle(string);
            } else if (this._wizardWindow instanceof Frame) {
                ((Frame)this._wizardWindow).setTitle(string);
            }
        }
    }

    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        this.updateTitle();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("pageAdded".equals(string) || "pageRemoved".equals(string) || "pageVisible".equals(string)) {
            this.updateTitle();
        }
    }
}

