/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard.dWizard;

import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.dWizard.NullSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence;
import oracle.bali.ewt.wizard.dWizard.WizardSequence2;
import oracle.bali.ewt.wizard.dWizard.WizardSequenceEvent;
import oracle.bali.ewt.wizard.dWizard.WizardSequenceListener;

public class DWizard
extends Wizard {
    private static int _NO_DIRECTION = 0;
    private static int _FORWARD = 1;
    private static int _BACKWARD = 2;
    private WizardSequence _sequence;
    private int _currentIndex;
    private Listener _listener;
    private int _dir = _NO_DIRECTION;

    public DWizard() {
        this(NullSequence.getWizardSequence());
    }

    public DWizard(WizardSequence wizardSequence) {
        this.setSequence(wizardSequence);
    }

    public void setSequence(WizardSequence wizardSequence) {
        if (this._sequence != null) {
            if (this._sequence instanceof WizardSequence2) {
                ((WizardSequence2)this._sequence).removeWizardSequenceListener(this._listener);
            }
            this.removeAllPages();
        }
        if (wizardSequence == null) {
            wizardSequence = NullSequence.getWizardSequence();
        }
        this._sequence = wizardSequence;
        if (wizardSequence instanceof WizardSequence2) {
            WizardSequence2 wizardSequence2 = (WizardSequence2)wizardSequence;
            int n = wizardSequence2.getPageCount();
            int n2 = 0;
            while (n2 < n) {
                this.addPage(wizardSequence2.getPageAt(n2));
                ++n2;
            }
            if (this._listener == null) {
                this._listener = new Listener();
            }
            wizardSequence2.addWizardSequenceListener(this._listener);
        } else if (this.isRoadmapVisible()) {
            this.setRoadmapVisible(false);
        }
        this.restart();
    }

    public WizardSequence getSequence() {
        return this._sequence;
    }

    public void goBackwards() {
        if (this._sequence.getPreviousPage() != null) {
            this.doPrevious();
        }
    }

    public void goForward() {
        if (this._sequence.getNextPage() != null) {
            this.doNext();
        }
    }

    public void enableButtons() {
        super.enableButtons();
    }

    public void restart() {
        this.reset();
        this._sequence.goToFirstPage();
        this._currentIndex = 0;
        WizardPage wizardPage = this._sequence.getCurrentPage();
        if (wizardPage != null) {
            this.selectPage(wizardPage, false);
        }
    }

    public int getCurrentPageIndex() {
        if (this.getSequence() instanceof WizardSequence2) {
            return super.getCurrentPageIndex();
        }
        return this._currentIndex;
    }

    public int getPageCount() {
        if (this.getSequence() instanceof WizardSequence2) {
            return super.getPageCount();
        }
        return this._sequence.getPageCount();
    }

    public WizardPage getNextPage(WizardPage wizardPage) {
        if (this._sequence instanceof WizardSequence2) {
            return super.getNextPage(wizardPage);
        }
        if (wizardPage == null) {
            return null;
        }
        return this._sequence.getNextPage();
    }

    public WizardPage getPreviousPage(WizardPage wizardPage) {
        if (this._sequence instanceof WizardSequence2) {
            return super.getPreviousPage(wizardPage);
        }
        if (wizardPage == null) {
            return null;
        }
        return this._sequence.getPreviousPage();
    }

    public void setRoadmapVisible(boolean bl) {
        if (bl && !(this.getSequence() instanceof WizardSequence2)) {
            bl = false;
        }
        super.setRoadmapVisible(bl);
    }

    public void dispose() {
        super.dispose();
        this._sequence = null;
        this._currentIndex = -1;
        this._listener = null;
    }

    protected void doNext() {
        this._dir = _FORWARD;
        super.doNext();
        this._dir = _NO_DIRECTION;
    }

    protected void doPrevious() {
        this._dir = _BACKWARD;
        super.doPrevious();
        this._dir = _NO_DIRECTION;
    }

    protected void selectPage(WizardPage wizardPage, boolean bl) {
        WizardPage wizardPage2 = this.getSelectedPage();
        if (wizardPage != null) {
            if (this._sequence instanceof WizardSequence2) {
                if (wizardPage != wizardPage2) {
                    WizardSequence2 wizardSequence2 = (WizardSequence2)this._sequence;
                    wizardSequence2.selectPage(wizardPage);
                }
            } else {
                boolean bl2;
                boolean bl3 = this._dir == _FORWARD || this._dir == _NO_DIRECTION;
                boolean bl4 = bl2 = this._dir == _BACKWARD || this._dir == _NO_DIRECTION;
                if (bl3 && wizardPage == this._sequence.getNextPage()) {
                    this._checkAdded(wizardPage);
                    ++this._currentIndex;
                    this._sequence.goForward();
                } else if (bl2 && wizardPage == this._sequence.getPreviousPage()) {
                    this._checkAdded(wizardPage);
                    --this._currentIndex;
                    this._sequence.goBackwards();
                } else if (wizardPage == this._sequence.getCurrentPage()) {
                    this._checkAdded(wizardPage);
                }
            }
        }
        super.selectPage(wizardPage, bl);
    }

    private void _checkAdded(WizardPage wizardPage) {
        if (wizardPage != null && wizardPage.getParent() != this) {
            this.addPage(wizardPage, null);
        }
    }

    private WizardPage _getPageAt(int n) {
        if (n < 0 || n >= super.getPageCount()) {
            return null;
        }
        return this.getPageAt(n);
    }

    private class Listener
    implements WizardSequenceListener {
        private Listener() {
        }

        public void pagesAdded(WizardSequenceEvent wizardSequenceEvent) {
            int n = wizardSequenceEvent.getStartIndex();
            int n2 = n + wizardSequenceEvent.getPageCount();
            WizardSequence2 wizardSequence2 = wizardSequenceEvent.getWizardSequence();
            WizardPage wizardPage = DWizard.this._getPageAt(n);
            int n3 = n;
            while (n3 < n2) {
                DWizard.this.addPage(wizardSequence2.getPageAt(n3), wizardPage);
                ++n3;
            }
        }

        public void pagesRemoved(WizardSequenceEvent wizardSequenceEvent) {
            int n = wizardSequenceEvent.getStartIndex();
            int n2 = wizardSequenceEvent.getPageCount();
            int n3 = 0;
            while (n3 < n2) {
                WizardPage wizardPage = DWizard.this._getPageAt(n);
                if (wizardPage != null) {
                    DWizard.this.removePage(DWizard.this._getPageAt(n));
                }
                ++n3;
            }
        }
    }
}

