/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.geom.Point2D;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.LWComponent;

public class GlassPane
extends LWComponent
implements KeyListener {
    private JLECanvas _canvas;
    private transient boolean _skipFocusGrab = false;

    GlassPane(JLECanvas jLECanvas) {
        this._canvas = jLECanvas;
        ((Component)((Object)this)).setName(jLECanvas.getName() + ".glassComponent");
        long l = 60L;
        ((Component)((Object)this)).enableEvents(l);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this._redispatchToTool(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this._redispatchToTool(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this._redispatchToTool(keyEvent);
    }

    public boolean isInteriorTransparent() {
        return true;
    }

    public Dimension getPreferredSize() {
        return ((Component)((Object)this._canvas)).getSize();
    }

    protected void processEventImpl(AWTEvent aWTEvent) {
        super.processEventImpl(aWTEvent);
        if (aWTEvent.getID() == 501) {
            if (!this._skipFocusGrab) {
                ((Component)((Object)this)).requestFocus();
            } else {
                this._skipFocusGrab = false;
            }
        }
        if (this._canvas.JLEEventEnabled(aWTEvent.getID())) {
            this._redispatchToTool(aWTEvent);
        }
    }

    public void skipFocusGrab() {
        this._skipFocusGrab = true;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private void _redispatchToTool(AWTEvent aWTEvent) {
        JLEEvent jLEEvent = null;
        int n = aWTEvent.getID();
        switch (n) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                Point point = this._canvas.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
                Point2D point2D = this._canvas.deviceToContent(point.x, point.y);
                jLEEvent = new JLEEvent(this, n, mouseEvent.getWhen(), mouseEvent.getModifiers(), point2D.getX(), point2D.getY(), mouseEvent.getClickCount());
                break;
            }
            case 400: 
            case 401: 
            case 402: {
                KeyEvent keyEvent = (KeyEvent)aWTEvent;
                jLEEvent = new JLEEvent(this, n, keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                break;
            }
            case 1004: 
            case 1005: {
                FocusEvent focusEvent = (FocusEvent)aWTEvent;
                jLEEvent = new JLEEvent(this, n);
            }
        }
        this._canvas.processJLEEvent(jLEEvent);
        if (jLEEvent.isConsumed() && aWTEvent instanceof InputEvent) {
            ((InputEvent)aWTEvent).consume();
        }
    }

    private class Access
    extends AccessibleLWComponent {
        public Access() {
            super((LWComponent)GlassPane.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.GLASS_PANE;
        }
    }
}

