/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.bali.jle.PropertyManager;
import oracle.bali.share.collection.StringKey;

public class ListPropertyManager
implements PropertyManager {
    private int _size;
    private Link _firstLink;
    private Link _lastLink;
    private VetoableChangeSupport _vetoSupport;
    private PropertyChangeSupport _changeSupport;
    private Object _source;

    public ListPropertyManager() {
        this(null);
    }

    public ListPropertyManager(Object object) {
        this._source = object == null ? this : object;
    }

    public int size() {
        return this._size;
    }

    public Enumeration keys() {
        return new ListEnumeration(this._firstLink, true);
    }

    public Object get(Object object) {
        Link link = this._find(object);
        if (link == null) {
            return PropertyManager.NOT_FOUND_OBJECT;
        }
        return link.value;
    }

    public synchronized Object put(Object object, Object object2) {
        String string;
        if (object == PropertyManager.REJECTED_VALUE || object == PropertyManager.NOT_FOUND_OBJECT || object2 == PropertyManager.REJECTED_VALUE) {
            throw new IllegalArgumentException("PM keys cannot be special values");
        }
        if (object2 == PropertyManager.NOT_FOUND_OBJECT) {
            return this.remove(object);
        }
        Link link = this._find(object);
        Object object3 = link != null ? link.value : PropertyManager.NOT_FOUND_OBJECT;
        String string2 = string = object instanceof StringKey ? ((StringKey)object).getString() : object.toString();
        if (this._vetoSupport != null) {
            try {
                this._vetoSupport.fireVetoableChange(string, object3, object2);
            }
            catch (PropertyVetoException propertyVetoException) {
                return PropertyManager.REJECTED_VALUE;
            }
        }
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, object3, object2);
        }
        if (link == null) {
            this._add(object, object2);
            return PropertyManager.NOT_FOUND_OBJECT;
        }
        link.value = object2;
        return object3;
    }

    public synchronized Object remove(Object object) {
        String string;
        Link link = this._find(object);
        if (link == null) {
            return PropertyManager.NOT_FOUND_OBJECT;
        }
        String string2 = string = object instanceof StringKey ? ((StringKey)object).getString() : object.toString();
        if (this._vetoSupport != null) {
            try {
                this._vetoSupport.fireVetoableChange(string, link.value, PropertyManager.NOT_FOUND_OBJECT);
            }
            catch (PropertyVetoException propertyVetoException) {
                return PropertyManager.REJECTED_VALUE;
            }
        }
        Link link2 = link.nextLink;
        Link link3 = link.prevLink;
        if (link2 != null) {
            link2.prevLink = link3;
        }
        if (link3 != null) {
            link3.nextLink = link2;
        } else {
            this._firstLink = link2;
        }
        --this._size;
        link.nextLink = null;
        link.prevLink = null;
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(string, link.value, PropertyManager.NOT_FOUND_OBJECT);
        }
        return link.value;
    }

    public synchronized void clear() {
        if (this._vetoSupport != null) {
            try {
                this._vetoSupport.fireVetoableChange(null, null, null);
            }
            catch (PropertyVetoException propertyVetoException) {
                return;
            }
        }
        Link link = this._firstLink;
        while (link != null) {
            Link link2 = link.nextLink;
            link.nextLink = null;
            link.prevLink = null;
            link = link2;
        }
        this._size = 0;
        if (this._changeSupport != null) {
            this._changeSupport.firePropertyChange(null, null, null);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport == null) {
            this._changeSupport = new PropertyChangeSupport(this._source);
        }
        this._changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._changeSupport != null) {
            this._changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport == null) {
            this._vetoSupport = new VetoableChangeSupport(this._source);
        }
        this._vetoSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this._vetoSupport != null) {
            this._vetoSupport.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public synchronized String toString() {
        String string = super.toString() + ", size is " + this.size() + ", Links:";
        Link link = this._firstLink;
        while (link != null) {
            string = string + link.toString() + "\n";
            link = link.nextLink;
        }
        return string;
    }

    private void _add(Object object, Object object2) {
        Link link = new Link();
        link.key = object;
        link.value = object2;
        link.prevLink = null;
        link.nextLink = this._firstLink;
        if (this._firstLink != null) {
            this._firstLink.prevLink = link;
        }
        this._firstLink = link;
        ++this._size;
    }

    private synchronized Link _find(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("key can't be null");
        }
        Link link = this._firstLink;
        while (link != null) {
            if (link.key.equals(object)) {
                return link;
            }
            link = link.nextLink;
        }
        return null;
    }

    private static class ListEnumeration
    implements Enumeration {
        private Link _currLink;
        private boolean _enumerateKeys;

        public ListEnumeration(Link link, boolean bl) {
            this._enumerateKeys = bl;
            this._currLink = link;
        }

        public boolean hasMoreElements() {
            return this._currLink != null;
        }

        public Object nextElement() {
            if (this._currLink == null) {
                throw new NoSuchElementException();
            }
            Object object = this._enumerateKeys ? this._currLink.key : this._currLink.value;
            this._currLink = this._currLink.nextLink;
            return object;
        }
    }

    private static class Link {
        public Object key;
        public Object value;
        public Link nextLink;
        public Link prevLink;

        public String toString() {
            return "Key:" + this.key + ", Value:" + this.value;
        }
    }
}

