/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import oracle.ewt.EwtComponent;
import oracle.ewt.ruler.Ruler;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.scrolling.scrollBox.ScrollBox;

public class RulerScrollBox
extends ScrollBox {
    Ruler _vRuler = new Ruler(false);
    Ruler _hRuler = new Ruler(true);
    Tracker _tracker;
    VTracker _vTracker;
    HTracker _hTracker;
    ScrollbarTracker _scTracker;
    private boolean _markerVisible = true;
    static final Dimension _ZERO_SIZE = new Dimension();

    public RulerScrollBox(EwtComponent ewtComponent) {
        this(ewtComponent, 1, 1);
    }

    public RulerScrollBox(EwtComponent ewtComponent, int n, int n2) {
        super((Component)ewtComponent, n, n2);
        this.setContent((Component)((Object)new ContentPanel(ewtComponent, this._hRuler, this._vRuler)));
        this.setBackground(this._vRuler.getBackground());
        this._hTracker = new HTracker();
        this._hRuler.addMouseMotionListener(this._hTracker);
        this._vTracker = new VTracker();
        this._vRuler.addMouseMotionListener(this._vTracker);
        this._tracker = new Tracker();
        this.getContent().addMouseMotionListener(this._tracker);
        this.addHAdjustmentListener(new Scroller(this._hRuler));
        this.addVAdjustmentListener(new Scroller(this._vRuler));
    }

    public Ruler getHorizontalRuler() {
        return this._hRuler;
    }

    public Ruler getVerticalRuler() {
        return this._vRuler;
    }

    public EwtComponent getInnerContent() {
        return ((ContentPanel)((Object)this.getContent())).getInner();
    }

    public void setInnerContent(EwtComponent ewtComponent) {
        ((ContentPanel)((Object)this.getContent())).setInner(ewtComponent);
        this.invalidateCanvas();
    }

    public void setMarkerVisible(boolean bl) {
        if (bl != this._markerVisible) {
            if (!bl) {
                this._vRuler.setMarkerPosition(-1);
                this._hRuler.setMarkerPosition(-1);
                this._hRuler.removeMouseMotionListener(this._hTracker);
                this._vRuler.removeMouseMotionListener(this._vTracker);
                this.getContent().removeMouseMotionListener(this._tracker);
            } else {
                this._hRuler.addMouseMotionListener(this._hTracker);
                this._vRuler.addMouseMotionListener(this._vTracker);
                this.getContent().addMouseMotionListener(this._tracker);
            }
            this._markerVisible = bl;
        }
    }

    public boolean isMarkerVisible() {
        return this._markerVisible;
    }

    public boolean isHorizontalRulerVisible() {
        return this._hRuler.isVisible();
    }

    public void setHorizontalRulerVisible(boolean bl) {
        if (bl != this.isHorizontalRulerVisible()) {
            this._hRuler.setVisible(bl);
            this.invalidateCanvas();
        }
    }

    public boolean isVerticalRulerVisible() {
        return this._vRuler.isVisible();
    }

    public void setVerticalRulerVisible(boolean bl) {
        if (bl != this.isVerticalRulerVisible()) {
            this._vRuler.setVisible(bl);
            this.invalidateCanvas();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Component component = this.getContent();
        if (component != null) {
            component.setBackground(color);
        }
    }

    private class HTracker
    extends MouseMotionAdapter {
        private HTracker() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            RulerScrollBox.this._hRuler.freezeRepaints();
            RulerScrollBox.this._hRuler.setMarkerPosition(mouseEvent.getX() - RulerScrollBox.this._hRuler.getCanvasOrigin().x);
            RulerScrollBox.this._hRuler.paintImmediate();
            RulerScrollBox.this._hRuler.unfreezeRepaints();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }
    }

    private class VTracker
    extends MouseMotionAdapter {
        private VTracker() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            RulerScrollBox.this._vRuler.freezeRepaints();
            RulerScrollBox.this._vRuler.setMarkerPosition(mouseEvent.getY() - RulerScrollBox.this._vRuler.getCanvasOrigin().y);
            RulerScrollBox.this._vRuler.paintImmediate();
            RulerScrollBox.this._vRuler.unfreezeRepaints();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }
    }

    private class ScrollbarTracker
    extends MouseMotionAdapter {
        private ScrollbarTracker() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = component.getLocation();
            RulerScrollBox.this._hRuler.freezeRepaints();
            RulerScrollBox.this._vRuler.freezeRepaints();
            RulerScrollBox.this._hRuler.setMarkerPosition(mouseEvent.getX() - RulerScrollBox.this._vRuler.getSize().width - RulerScrollBox.this._hRuler.getCanvasOrigin().x);
            RulerScrollBox.this._vRuler.setMarkerPosition(mouseEvent.getY() - RulerScrollBox.this._hRuler.getSize().height - RulerScrollBox.this._vRuler.getCanvasOrigin().y);
            RulerScrollBox.this._hRuler.paintImmediate();
            RulerScrollBox.this._vRuler.paintImmediate();
            RulerScrollBox.this._hRuler.unfreezeRepaints();
            RulerScrollBox.this._vRuler.unfreezeRepaints();
        }
    }

    private class Tracker
    extends MouseMotionAdapter {
        private Tracker() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            Point point = component.getLocation();
            RulerScrollBox.this._hRuler.freezeRepaints();
            RulerScrollBox.this._vRuler.freezeRepaints();
            RulerScrollBox.this._hRuler.setMarkerPosition(point.x + mouseEvent.getX() - RulerScrollBox.this._hRuler.getCanvasOrigin().x);
            RulerScrollBox.this._vRuler.setMarkerPosition(point.y + mouseEvent.getY() - RulerScrollBox.this._vRuler.getCanvasOrigin().y);
            RulerScrollBox.this._hRuler.paintImmediate();
            RulerScrollBox.this._vRuler.paintImmediate();
            RulerScrollBox.this._hRuler.unfreezeRepaints();
            RulerScrollBox.this._vRuler.unfreezeRepaints();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseMoved(mouseEvent);
        }
    }

    private class Scroller
    implements AdjustmentListener {
        private Ruler _ruler;

        public Scroller(Ruler ruler) {
            this._ruler = ruler;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            this._ruler.setScrollPosition(adjustmentEvent.getValue());
        }
    }

    private class ContentPanel
    extends EwtComponent {
        private EwtComponent _content;

        ContentPanel(EwtComponent ewtComponent, Ruler ruler, Ruler ruler2) {
            ((Container)((Object)this)).setLayout(null);
            if (ewtComponent != null) {
                this.setInner(ewtComponent);
            }
            ((Container)((Object)this)).add((Component)ruler);
            ((Container)((Object)this)).add((Component)ruler2);
        }

        public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
            this.getInner().attachHAdjustable(adjustable);
        }

        public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
            this.getInner().attachVAdjustable(adjustable);
        }

        public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
            this.getInner().detachAdjustable(adjustable);
        }

        public void handleHScroll(int n, int n2) throws ScrollableException {
            EwtComponent ewtComponent = this.getInner();
            if (ewtComponent != null) {
                try {
                    ewtComponent.handleHScroll(n, n2);
                }
                catch (ScrollableException scrollableException) {
                    // empty catch block
                }
            }
        }

        public void handleVScroll(int n, int n2) throws ScrollableException {
            EwtComponent ewtComponent = this.getInner();
            if (ewtComponent != null) {
                try {
                    ewtComponent.handleVScroll(n, n2);
                }
                catch (ScrollableException scrollableException) {
                    // empty catch block
                }
            }
        }

        public Adjustable getHAdjustable() {
            EwtComponent ewtComponent = this.getInner();
            return ewtComponent != null ? ewtComponent.getHAdjustable() : null;
        }

        public Adjustable getVAdjustable() {
            EwtComponent ewtComponent = this.getInner();
            return ewtComponent != null ? ewtComponent.getVAdjustable() : null;
        }

        public boolean isHScrollable() {
            return true;
        }

        public boolean isVScrollable() {
            return true;
        }

        public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
            EwtComponent ewtComponent = this.getInner();
            if (ewtComponent != null) {
                ewtComponent.addMouseMotionListener(mouseMotionListener);
            }
            RulerScrollBox.this._scTracker = new ScrollbarTracker();
            ((Component)((Object)this.getVAdjustable())).addMouseMotionListener(RulerScrollBox.this._scTracker);
            ((Component)((Object)this.getHAdjustable())).addMouseMotionListener(RulerScrollBox.this._scTracker);
        }

        public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
            EwtComponent ewtComponent = this.getInner();
            if (ewtComponent != null) {
                ewtComponent.removeMouseMotionListener(mouseMotionListener);
            }
            ((Component)((Object)this.getVAdjustable())).removeMouseMotionListener(RulerScrollBox.this._scTracker);
            ((Component)((Object)this.getHAdjustable())).removeMouseMotionListener(RulerScrollBox.this._scTracker);
        }

        protected Dimension layoutCanvas() {
            Ruler ruler = RulerScrollBox.this.getHorizontalRuler();
            Ruler ruler2 = RulerScrollBox.this.getVerticalRuler();
            EwtComponent ewtComponent = this.getInner();
            Dimension dimension = RulerScrollBox.this.isHorizontalRulerVisible() ? ruler.getPreferredSize() : _ZERO_SIZE;
            Dimension dimension2 = RulerScrollBox.this.isVerticalRulerVisible() ? ruler2.getPreferredSize() : _ZERO_SIZE;
            Dimension dimension3 = this.getInnerSize();
            ruler.setBounds(dimension2.width, 0, dimension3.width - dimension2.width - 1, dimension.height);
            ruler2.setBounds(0, dimension.height, dimension2.width, dimension3.height - dimension.height - 1);
            if (ewtComponent != null) {
                ewtComponent.setBounds(dimension2.width, dimension.height, dimension3.width - dimension2.width - 1, dimension3.height - dimension.height - 1);
            }
            return ewtComponent.getCanvasSize();
        }

        void setInner(EwtComponent ewtComponent) {
            EwtComponent ewtComponent2 = this._content;
            if (ewtComponent != ewtComponent2) {
                if (ewtComponent2 != null) {
                    ((Container)((Object)this)).remove((Component)ewtComponent2);
                    ewtComponent2.removeMouseMotionListener(RulerScrollBox.this._tracker);
                }
                this._content = ewtComponent;
                if (ewtComponent != null) {
                    ((Container)((Object)this)).add((Component)ewtComponent);
                    if (RulerScrollBox.this.isMarkerVisible()) {
                        ewtComponent.addMouseMotionListener(RulerScrollBox.this._tracker);
                    }
                }
            }
        }

        EwtComponent getInner() {
            return this._content;
        }
    }
}

