/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.event;

import java.awt.event.KeyEvent;
import java.util.EventObject;
import oracle.bali.jle.geom.Point2D;
import oracle.ewt.event.KeyStroke;

public class JLEEvent
extends EventObject {
    public static final long FOCUS_EVENT_MASK = 4L;
    public static final long KEY_EVENT_MASK = 8L;
    public static final long MOUSE_EVENT_MASK = 16L;
    public static final long MOUSE_MOTION_EVENT_MASK = 32L;
    public static final long ALL_EVENT_MASK = 60L;
    public static final int RESERVED_ID_MAX = 1999;
    public static final int KEY_FIRST = 400;
    public static final int KEY_LAST = 402;
    public static final int MOUSE_FIRST = 500;
    public static final int MOUSE_LAST = 506;
    public static final int FOCUS_FIRST = 1004;
    public static final int FOCUS_LAST = 1005;
    public static final int MOUSE_CLICKED = 500;
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int KEY_TYPED = 400;
    public static final int KEY_PRESSED = 401;
    public static final int KEY_RELEASED = 402;
    public static final int FOCUS_GAINED = 1004;
    public static final int FOCUS_LOST = 1005;
    public static final int SHIFT_MASK = 1;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int ALT_MASK = 8;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    private int _id;
    private boolean _consumed = false;
    private int _modifiers;
    private long _when;
    private double _x;
    private double _y;
    private int _clickCount;
    private int _keyCode;
    private char _keyChar;

    public JLEEvent(Object object, int n, long l, int n2, double d, double d2, int n3, int n4, char c) {
        super(object);
        this._id = n;
        this._when = l;
        this._modifiers = n2;
        this._x = d;
        this._y = d2;
        this._clickCount = n3;
        this._keyCode = n4;
        this._keyChar = c;
    }

    public JLEEvent(Object object, int n, long l, int n2, double d, double d2, int n3) {
        this(object, n, l, n2, d, d2, n3, 0, '\uffff');
    }

    public JLEEvent(Object object, int n, long l, int n2, int n3, char c) {
        this(object, n, l, n2, Double.NaN, Double.NaN, -1, n3, c);
    }

    public JLEEvent(Object object, int n) {
        this(object, n, 0L, 0, Double.NaN, Double.NaN, -1, 0, '\uffff');
    }

    public int getID() {
        return this._id;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "] on " + this.getSource();
    }

    public void consume() {
        if (this._id >= 1004 && this._id <= 1005) {
            throw new IllegalStateException("focus events cannot be consumed");
        }
        this._consumed = true;
    }

    public boolean isConsumed() {
        return this._consumed;
    }

    public String paramString() {
        String string;
        switch (this.getID()) {
            case 501: {
                string = "MOUSE_PRESSED";
                break;
            }
            case 502: {
                string = "MOUSE_RELEASED";
                break;
            }
            case 500: {
                string = "MOUSE_CLICKED";
                break;
            }
            case 504: {
                string = "MOUSE_ENTERED";
                break;
            }
            case 505: {
                string = "MOUSE_EXITED";
                break;
            }
            case 503: {
                string = "MOUSE_MOVED";
                break;
            }
            case 506: {
                string = "MOUSE_DRAGGED";
                break;
            }
            case 401: {
                string = "KEY_PRESSED";
                break;
            }
            case 402: {
                string = "KEY_RELEASED";
                break;
            }
            case 400: {
                string = "KEY_TYPED";
                break;
            }
            case 1004: {
                string = "FOCUS_GAINED";
                break;
            }
            case 1005: {
                string = "FOCUS_LOST";
                break;
            }
            default: {
                string = "unknown type";
            }
        }
        String string2 = this.isActionKey() || this._keyCode == 10 || this._keyCode == 8 || this._keyCode == 9 || this._keyCode == 27 || this._keyCode == 127 || this._keyCode >= 96 && this._keyCode <= 105 ? KeyEvent.getKeyText(this._keyCode) : (this._keyChar == '\n' || this._keyChar == '\b' || this._keyChar == '\t' || this._keyChar == '\u001b' || this._keyChar == '\u007f' ? KeyEvent.getKeyText(this._keyChar) : "'" + this._keyChar + "'");
        String string3 = "";
        if (this._modifiers > 0) {
            string3 = ",modifiers=" + KeyEvent.getKeyModifiersText(this._modifiers);
        }
        return string + ",(" + this._x + "," + this._y + ")" + ",clickCount=" + this.getClickCount() + string3 + ",keyCode=" + this.getKeyCode() + ",keyString=" + string2 + ",consumed=" + this.isConsumed();
    }

    public boolean isShiftDown() {
        return (this._modifiers & 1) != 0;
    }

    public boolean isControlDown() {
        return (this._modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this._modifiers & 4) != 0;
    }

    public boolean isAltDown() {
        return (this._modifiers & 8) != 0;
    }

    public long getWhen() {
        return this._when;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public Point2D getPoint2D() {
        double d;
        double d2;
        JLEEvent jLEEvent = this;
        synchronized (jLEEvent) {
            d2 = this._x;
            d = this._y;
        }
        return new Point2D.Double(d2, d);
    }

    public synchronized void translatePoint(double d, double d2) {
        this._x += d;
        this._y += d2;
    }

    public int getClickCount() {
        return this._clickCount;
    }

    public char getKeyChar() {
        return this._keyChar;
    }

    public int getKeyCode() {
        return this._keyCode;
    }

    public boolean isActionKey() {
        switch (this._keyCode) {
            case 19: 
            case 20: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 144: 
            case 145: 
            case 154: 
            case 155: {
                return true;
            }
        }
        return false;
    }

    public boolean isMouseEvent() {
        return this._id >= 500 && this._id <= 506;
    }

    public boolean isKeyEvent() {
        return this._id >= 400 && this._id <= 402;
    }

    public boolean isFocusEvent() {
        return this._id >= 1004 && this._id <= 1005;
    }

    public boolean equals(KeyStroke keyStroke) {
        if (!this.isKeyEvent()) {
            return false;
        }
        if (this.getModifiers() != keyStroke.getModifiers()) {
            return false;
        }
        if (keyStroke.getKeyCode() != 0) {
            return keyStroke.getKeyCode() == this.getKeyCode();
        }
        if (this.getID() == 400) {
            return Character.toUpperCase(keyStroke.getKeyChar()) == Character.toUpperCase(this.getKeyChar());
        }
        return Character.toUpperCase(keyStroke.getKeyChar()) == this.getKeyCode();
    }
}

