/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.geom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.bali.jle.geom.NoninvertibleTransformException;
import oracle.bali.jle.geom.Point2D;

public class AffineTransform
implements Cloneable,
Serializable {
    public static final int IDENTITY = 0;
    public static final int TRANSLATION = 1;
    public static final int UNIFORM_SCALE = 2;
    public static final int GENERAL_SCALE = 4;
    public static final int ANY_SCALE_MASK = 6;
    public static final int QUADRANT_ROTATION = 8;
    public static final int GENERAL_ROTATION = 16;
    public static final int ANY_ROTATION_MASK = 24;
    public static final int GENERAL_TRANSFORM = 32;
    static final int APPLY_TRANSLATE = 1;
    static final int APPLY_SCALE = 2;
    static final int APPLY_SHEAR = 4;
    private static final int HI_SHIFT = 3;
    private static final int HI_TRANSLATE = 8;
    private static final int HI_SCALE = 16;
    private static final int HI_SHEAR = 32;
    double m00;
    double m10;
    double m01;
    double m11;
    double m02;
    double m12;
    transient int state;
    private static int[] rot90conversion = new int[]{4, 5, 4, 5, 2, 3, 6, 7};

    private AffineTransform(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.state = n;
    }

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
        this.state = affineTransform.state;
    }

    public AffineTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
        this.updateState();
    }

    public AffineTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length > 5) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
        this.updateState();
    }

    public AffineTransform(float[][] fArray) {
        this.m00 = fArray[0][0];
        this.m10 = fArray[1][0];
        this.m01 = fArray[0][1];
        this.m11 = fArray[1][1];
        if (fArray[0].length > 2 && fArray[1].length > 2) {
            this.m02 = fArray[0][2];
            this.m12 = fArray[1][2];
        }
        this.updateState();
    }

    public AffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.updateState();
    }

    public AffineTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m10 = dArray[1];
        this.m01 = dArray[2];
        this.m11 = dArray[3];
        if (dArray.length > 5) {
            this.m02 = dArray[4];
            this.m12 = dArray[5];
        }
        this.updateState();
    }

    public AffineTransform(double[][] dArray) {
        this.m00 = dArray[0][0];
        this.m10 = dArray[1][0];
        this.m01 = dArray[0][1];
        this.m11 = dArray[1][1];
        if (dArray[0].length > 2 && dArray[1].length > 2) {
            this.m02 = dArray[0][2];
            this.m12 = dArray[1][2];
        }
        this.updateState();
    }

    public static AffineTransform getTranslateInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d);
        return affineTransform;
    }

    public static AffineTransform getRotateInstance(double d, double d2, double d3) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToRotation(d, d2, d3);
        return affineTransform;
    }

    public static AffineTransform getScaleInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d, d2);
        return affineTransform;
    }

    public static AffineTransform getShearInstance(double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToShear(d, d2);
        return affineTransform;
    }

    public int getType() {
        int n = 0;
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                n = 1;
            }
            case 6: {
                if (this.m00 * this.m01 + this.m10 * this.m11 != 0.0) {
                    return 32;
                }
                n |= 0x10;
                if (this.m00 != this.m11 || this.m01 != -this.m10) {
                    n |= 4;
                    break;
                }
                if (this.m00 * this.m11 - this.m01 * this.m10 == 1.0) break;
                n |= 2;
                break;
            }
            case 5: {
                n = 1;
            }
            case 4: {
                n |= 8;
                if (this.m01 != -this.m10) {
                    n |= 4;
                    break;
                }
                if (this.m01 == 1.0 || this.m10 == 1.0) break;
                n |= 2;
                break;
            }
            case 3: {
                n = 1;
            }
            case 2: {
                if (this.m00 < 0.0 && this.m11 < 0.0) {
                    n |= 8;
                }
                if (this.m00 == this.m11) {
                    n |= 2;
                    break;
                }
                n |= 4;
                break;
            }
            case 1: {
                n = 1;
            }
            case 0: 
        }
        return n;
    }

    public double getDeterminant() {
        return this.m00 * this.m11 - this.m01 * this.m10;
    }

    void updateState() {
        double d;
        double d2;
        double d3;
        double d4 = this.m01;
        this.state = d4 == 0.0 && (d3 = this.m10) == 0.0 ? ((d4 = this.m00) == 1.0 && (d3 = this.m11) == 1.0 ? (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0) : 2 | (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0)) : ((d2 = this.m00) == 0.0 && (d = this.m11) == 0.0 ? 4 | (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0) : 6 | (this.m02 != 0.0 || this.m12 != 0.0 ? 1 : 0));
    }

    private void stateError() {
        throw new InternalError("missing case in transform state switch");
    }

    public void getMatrix(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m10;
        dArray[2] = this.m01;
        dArray[3] = this.m11;
        if (dArray.length > 5) {
            dArray[4] = this.m02;
            dArray[5] = this.m12;
        }
    }

    public void getMatrix(double[][] dArray) {
        dArray[0][0] = this.m00;
        dArray[1][0] = this.m10;
        dArray[0][1] = this.m01;
        dArray[1][1] = this.m11;
        dArray[0][2] = this.m02;
        dArray[1][2] = this.m12;
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void translate(double d, double d2) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                this.m02 = d * this.m00 + d2 * this.m01 + this.m02;
                this.m12 = d * this.m10 + d2 * this.m11 + this.m12;
                return;
            }
            case 6: {
                this.m02 = d * this.m00 + d2 * this.m01;
                this.m12 = d * this.m10 + d2 * this.m11;
                this.state = 7;
                return;
            }
            case 5: {
                this.m02 = d2 * this.m01 + this.m02;
                this.m12 = d * this.m10 + this.m12;
                return;
            }
            case 4: {
                this.m02 = d2 * this.m01;
                this.m12 = d * this.m10;
                this.state = 5;
                return;
            }
            case 3: {
                this.m02 = d * this.m00 + this.m02;
                this.m12 = d2 * this.m11 + this.m12;
                return;
            }
            case 2: {
                this.m02 = d * this.m00;
                this.m12 = d2 * this.m11;
                this.state = 3;
                return;
            }
            case 1: {
                this.m02 = d + this.m02;
                this.m12 = d2 + this.m12;
                return;
            }
            case 0: 
        }
        this.m02 = d;
        this.m12 = d2;
        this.state = 1;
    }

    public void rotate(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        if (Math.abs(d2) < 1.0E-15) {
            if (d3 < 0.0) {
                this.m00 = -this.m00;
                this.m11 = -this.m11;
                int n = this.state;
                if ((n & 4) != 0) {
                    this.m01 = -this.m01;
                    this.m10 = -this.m10;
                } else {
                    this.state = this.m00 == 1.0 && this.m11 == 1.0 ? n & 0xFFFFFFFD : n | 2;
                }
            }
            return;
        }
        if (Math.abs(d3) < 1.0E-15) {
            if (d2 < 0.0) {
                double d4 = this.m00;
                this.m00 = -this.m01;
                this.m01 = d4;
                d4 = this.m10;
                this.m10 = -this.m11;
                this.m11 = d4;
            } else {
                double d5 = this.m00;
                this.m00 = this.m01;
                this.m01 = -d5;
                d5 = this.m10;
                this.m10 = this.m11;
                this.m11 = -d5;
            }
            this.state = rot90conversion[this.state];
            return;
        }
        double d6 = this.m00;
        double d7 = this.m01;
        this.m00 = d3 * d6 + d2 * d7;
        this.m01 = -d2 * d6 + d3 * d7;
        d6 = this.m10;
        d7 = this.m11;
        this.m10 = d3 * d6 + d2 * d7;
        this.m11 = -d2 * d6 + d3 * d7;
        this.updateState();
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(d2, d3);
        this.rotate(d);
        this.translate(-d2, -d3);
    }

    public void scale(double d, double d2) {
        int n = this.state;
        switch (n) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                this.m00 *= d;
                this.m11 *= d2;
            }
            case 4: 
            case 5: {
                this.m01 *= d2;
                this.m10 *= d;
                return;
            }
            case 2: 
            case 3: {
                this.m00 *= d;
                this.m11 *= d2;
                return;
            }
            case 0: 
            case 1: 
        }
        this.m00 = d;
        this.m11 = d2;
        this.state = n | 2;
    }

    public void shear(double d, double d2) {
        int n = this.state;
        switch (n) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double d3 = this.m00;
                double d4 = this.m01;
                this.m00 = d3 + d4 * d2;
                this.m01 = d3 * d + d4;
                d3 = this.m10;
                d4 = this.m11;
                this.m10 = d3 + d4 * d2;
                this.m11 = d3 * d + d4;
                return;
            }
            case 4: 
            case 5: {
                this.m00 = this.m01 * d2;
                this.m11 = this.m10 * d;
                this.state = n | 2;
                return;
            }
            case 2: 
            case 3: {
                this.m01 = this.m00 * d;
                this.m10 = this.m11 * d2;
                this.state = n | 4;
                return;
            }
            case 0: 
            case 1: 
        }
        this.m01 = d;
        this.m10 = d2;
        this.state = n | 2 | 4;
    }

    public void setToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
        this.state = 0;
    }

    public void setToTranslation(double d, double d2) {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = d;
        this.m12 = d2;
        this.state = 1;
    }

    public void setToRotation(double d) {
        this.m02 = 0.0;
        this.m12 = 0.0;
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        if (Math.abs(d2) < 1.0E-15) {
            this.m10 = 0.0;
            this.m01 = 0.0;
            if (d3 < 0.0) {
                this.m11 = -1.0;
                this.m00 = -1.0;
                this.state = 2;
            } else {
                this.m11 = 1.0;
                this.m00 = 1.0;
                this.state = 0;
            }
            return;
        }
        if (Math.abs(d3) < 1.0E-15) {
            this.m11 = 0.0;
            this.m00 = 0.0;
            if (d2 < 0.0) {
                this.m01 = 1.0;
                this.m10 = -1.0;
            } else {
                this.m01 = -1.0;
                this.m10 = 1.0;
            }
            this.state = 4;
            return;
        }
        this.m00 = d3;
        this.m01 = -d2;
        this.m10 = d2;
        this.m11 = d3;
        this.state = 6;
    }

    public void setToRotation(double d, double d2, double d3) {
        this.setToRotation(d);
        double d4 = this.m10;
        double d5 = 1.0 - this.m00;
        this.m02 = d2 * d5 + d3 * d4;
        this.m12 = d3 * d5 - d2 * d4;
        this.state |= 1;
    }

    public void setToScale(double d, double d2) {
        this.m00 = d;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = d2;
        this.m02 = 0.0;
        this.m12 = 0.0;
        this.state = 2;
    }

    public void setToShear(double d, double d2) {
        this.m00 = 1.0;
        this.m01 = d;
        this.m10 = d2;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
        this.state = 6;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.m00;
        this.m10 = affineTransform.m10;
        this.m01 = affineTransform.m01;
        this.m11 = affineTransform.m11;
        this.m02 = affineTransform.m02;
        this.m12 = affineTransform.m12;
        this.state = affineTransform.state;
    }

    public void setTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.updateState();
    }

    public void concatenate(AffineTransform affineTransform) {
        int n = this.state;
        int n2 = affineTransform.state;
        switch (n2 << 3 | n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 56: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
            }
            case 24: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
            }
            case 8: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
                this.state = n2;
                return;
            }
            case 48: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
            }
            case 16: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
                this.state = n2;
                return;
            }
            case 40: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
            }
            case 32: {
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
                this.m11 = 0.0;
                this.m00 = 0.0;
                this.state = n2;
                return;
            }
            case 15: {
                double d = affineTransform.m02;
                double d2 = affineTransform.m12;
                this.m02 = d * this.m00 + d2 * this.m01 + this.m02;
                this.m12 = d * this.m10 + d2 * this.m11 + this.m12;
                return;
            }
            case 14: {
                double d = affineTransform.m02;
                double d3 = affineTransform.m12;
                this.m02 = d * this.m00 + d3 * this.m01;
                this.m12 = d * this.m10 + d3 * this.m11;
                this.state = 7;
                return;
            }
            case 13: {
                this.m02 = affineTransform.m12 * this.m01 + this.m02;
                this.m12 = affineTransform.m02 * this.m10 + this.m12;
                return;
            }
            case 12: {
                this.m02 = affineTransform.m12 * this.m01;
                this.m12 = affineTransform.m02 * this.m10;
                this.state = 5;
                return;
            }
            case 11: {
                this.m02 = affineTransform.m02 * this.m00 + this.m02;
                this.m12 = affineTransform.m12 * this.m11 + this.m12;
                return;
            }
            case 10: {
                this.m02 = affineTransform.m02 * this.m00;
                this.m12 = affineTransform.m12 * this.m11;
                this.state = 3;
                return;
            }
            case 9: {
                this.m02 = affineTransform.m02 + this.m02;
                this.m12 = affineTransform.m12 + this.m12;
                return;
            }
            case 22: 
            case 23: {
                double d = affineTransform.m00;
                double d4 = affineTransform.m11;
                this.m00 *= d;
                this.m11 *= d4;
                this.m01 *= d4;
                this.m10 *= d;
                return;
            }
            case 20: 
            case 21: {
                this.m01 *= affineTransform.m11;
                this.m10 *= affineTransform.m00;
                return;
            }
            case 18: 
            case 19: {
                this.m00 *= affineTransform.m00;
                this.m11 *= affineTransform.m11;
                return;
            }
            case 17: {
                this.m00 = affineTransform.m00;
                this.m11 = affineTransform.m11;
                this.state = 3;
                return;
            }
            case 38: 
            case 39: {
                double d = affineTransform.m01;
                double d5 = affineTransform.m10;
                double d6 = this.m00;
                this.m00 = this.m01 * d5;
                this.m01 = d6 * d;
                d6 = this.m10;
                this.m10 = this.m11 * d5;
                this.m11 = d6 * d;
                return;
            }
            case 36: 
            case 37: {
                this.m00 = this.m01 * affineTransform.m10;
                this.m01 = 0.0;
                this.m11 = this.m10 * affineTransform.m01;
                this.m10 = 0.0;
                this.state = n ^ 6;
                return;
            }
            case 34: 
            case 35: {
                this.m01 = this.m00 * affineTransform.m01;
                this.m00 = 0.0;
                this.m10 = this.m11 * affineTransform.m10;
                this.m11 = 0.0;
                this.state = n ^ 6;
                return;
            }
            case 33: {
                this.m00 = 0.0;
                this.m01 = affineTransform.m01;
                this.m10 = affineTransform.m10;
                this.m11 = 0.0;
                this.state = 5;
                return;
            }
        }
        double d = affineTransform.m00;
        double d7 = affineTransform.m01;
        double d8 = affineTransform.m02;
        double d9 = affineTransform.m10;
        double d10 = affineTransform.m11;
        double d11 = affineTransform.m12;
        switch (n) {
            default: {
                this.stateError();
            }
            case 6: {
                this.state = n | n2;
            }
            case 7: {
                double d12 = this.m00;
                double d13 = this.m01;
                this.m00 = d * d12 + d9 * d13;
                this.m01 = d7 * d12 + d10 * d13;
                this.m02 += d8 * d12 + d11 * d13;
                d12 = this.m10;
                d13 = this.m11;
                this.m10 = d * d12 + d9 * d13;
                this.m11 = d7 * d12 + d10 * d13;
                this.m12 += d8 * d12 + d11 * d13;
                return;
            }
            case 4: 
            case 5: {
                double d14 = this.m01;
                this.m00 = d9 * d14;
                this.m01 = d10 * d14;
                this.m02 += d11 * d14;
                d14 = this.m10;
                this.m10 = d * d14;
                this.m11 = d7 * d14;
                this.m12 += d8 * d14;
                break;
            }
            case 2: 
            case 3: {
                double d15 = this.m00;
                this.m00 = d * d15;
                this.m01 = d7 * d15;
                this.m02 += d8 * d15;
                d15 = this.m11;
                this.m10 = d9 * d15;
                this.m11 = d10 * d15;
                this.m12 += d11 * d15;
                break;
            }
            case 1: {
                this.m00 = d;
                this.m01 = d7;
                this.m02 += d8;
                this.m10 = d9;
                this.m11 = d10;
                this.m12 += d11;
                this.state = n2 | 1;
                return;
            }
        }
        this.updateState();
    }

    public void preConcatenate(AffineTransform affineTransform) {
        int n = this.state;
        int n2 = affineTransform.state;
        switch (n2 << 3 | n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return;
            }
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
                this.state = n | 1;
                return;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                this.m02 += affineTransform.m02;
                this.m12 += affineTransform.m12;
                return;
            }
            case 16: 
            case 17: {
                this.state = n | 2;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                double d = affineTransform.m00;
                double d2 = affineTransform.m11;
                if ((n & 4) != 0) {
                    this.m01 *= d;
                    this.m10 *= d2;
                    if ((n & 2) != 0) {
                        this.m00 *= d;
                        this.m11 *= d2;
                    }
                } else {
                    this.m00 *= d;
                    this.m11 *= d2;
                }
                if ((n & 1) != 0) {
                    this.m02 *= d;
                    this.m12 *= d2;
                }
                return;
            }
            case 36: 
            case 37: {
                n |= 2;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                this.state = n ^ 4;
            }
            case 38: 
            case 39: {
                double d = affineTransform.m01;
                double d3 = affineTransform.m10;
                double d4 = this.m00;
                this.m00 = this.m10 * d;
                this.m10 = d4 * d3;
                d4 = this.m01;
                this.m01 = this.m11 * d;
                this.m11 = d4 * d3;
                d4 = this.m02;
                this.m02 = this.m12 * d;
                this.m12 = d4 * d3;
                return;
            }
        }
        double d = affineTransform.m00;
        double d5 = affineTransform.m01;
        double d6 = affineTransform.m02;
        double d7 = affineTransform.m10;
        double d8 = affineTransform.m11;
        double d9 = affineTransform.m12;
        switch (n) {
            default: {
                this.stateError();
            }
            case 7: {
                double d10 = this.m02;
                double d11 = this.m12;
                d6 += d10 * d + d11 * d5;
                d9 += d10 * d7 + d11 * d8;
            }
            case 6: {
                this.m02 = d6;
                this.m12 = d9;
                double d10 = this.m00;
                double d11 = this.m10;
                this.m00 = d10 * d + d11 * d5;
                this.m10 = d10 * d7 + d11 * d8;
                d10 = this.m01;
                d11 = this.m11;
                this.m01 = d10 * d + d11 * d5;
                this.m11 = d10 * d7 + d11 * d8;
                break;
            }
            case 5: {
                double d12 = this.m02;
                double d13 = this.m12;
                d6 += d12 * d + d13 * d5;
                d9 += d12 * d7 + d13 * d8;
            }
            case 4: {
                this.m02 = d6;
                this.m12 = d9;
                double d12 = this.m10;
                this.m00 = d12 * d5;
                this.m10 = d12 * d8;
                d12 = this.m01;
                this.m01 = d12 * d;
                this.m11 = d12 * d7;
                break;
            }
            case 3: {
                double d14 = this.m02;
                double d15 = this.m12;
                d6 += d14 * d + d15 * d5;
                d9 += d14 * d7 + d15 * d8;
            }
            case 2: {
                this.m02 = d6;
                this.m12 = d9;
                double d14 = this.m00;
                this.m00 = d14 * d;
                this.m10 = d14 * d7;
                d14 = this.m11;
                this.m01 = d14 * d5;
                this.m11 = d14 * d8;
                break;
            }
            case 1: {
                double d16 = this.m02;
                double d17 = this.m12;
                d6 += d16 * d + d17 * d5;
                d9 += d16 * d7 + d17 * d8;
            }
            case 0: {
                this.m02 = d6;
                this.m12 = d9;
                this.m00 = d;
                this.m10 = d7;
                this.m01 = d5;
                this.m11 = d8;
                this.state = n | n2;
                return;
            }
        }
        this.updateState();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d);
                }
                return new AffineTransform(this.m11 / d, -this.m10 / d, -this.m01 / d, this.m00 / d, (this.m01 * this.m12 - this.m11 * this.m02) / d, (this.m10 * this.m02 - this.m00 * this.m12) / d, 7);
            }
            case 6: {
                double d = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d);
                }
                return new AffineTransform(this.m11 / d, -this.m10 / d, -this.m01 / d, this.m00 / d, 0.0, 0.0, 6);
            }
            case 5: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, -this.m12 / this.m10, -this.m02 / this.m01, 5);
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(0.0, 1.0 / this.m01, 1.0 / this.m10, 0.0, 0.0, 0.0, 4);
            }
            case 3: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, -this.m02 / this.m00, -this.m12 / this.m11, 3);
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                return new AffineTransform(1.0 / this.m00, 0.0, 0.0, 1.0 / this.m11, 0.0, 0.0, 2);
            }
            case 1: {
                return new AffineTransform(1.0, 0.0, 0.0, 1.0, -this.m02, -this.m12, 1);
            }
            case 0: 
        }
        return new AffineTransform();
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                point2D2.setLocation(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
                return point2D2;
            }
            case 6: {
                point2D2.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
                return point2D2;
            }
            case 5: {
                point2D2.setLocation(d2 * this.m01 + this.m02, d * this.m10 + this.m12);
                return point2D2;
            }
            case 4: {
                point2D2.setLocation(d2 * this.m01, d * this.m10);
                return point2D2;
            }
            case 3: {
                point2D2.setLocation(d * this.m00 + this.m02, d2 * this.m11 + this.m12);
                return point2D2;
            }
            case 2: {
                point2D2.setLocation(d * this.m00, d2 * this.m11);
                return point2D2;
            }
            case 1: {
                point2D2.setLocation(d + this.m02, d2 + this.m12);
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation(d, d2);
        return point2D2;
    }

    public void transform(Point2D[] point2DArray, int n, Point2D[] point2DArray2, int n2, int n3) {
        int n4 = this.state;
        while (--n3 >= 0) {
            Point2D point2D;
            Point2D point2D2 = point2DArray[n++];
            double d = point2D2.getX();
            double d2 = point2D2.getY();
            if ((point2D = point2DArray2[n2++]) == null) {
                point2D = point2D2 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                point2DArray2[n2 - 1] = point2D;
            }
            switch (n4) {
                default: {
                    this.stateError();
                }
                case 7: {
                    point2D.setLocation(d * this.m00 + d2 * this.m01 + this.m02, d * this.m10 + d2 * this.m11 + this.m12);
                    break;
                }
                case 6: {
                    point2D.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
                    break;
                }
                case 5: {
                    point2D.setLocation(d2 * this.m01 + this.m02, d * this.m10 + this.m12);
                    break;
                }
                case 4: {
                    point2D.setLocation(d2 * this.m01, d * this.m10);
                    break;
                }
                case 3: {
                    point2D.setLocation(d * this.m00 + this.m02, d2 * this.m11 + this.m12);
                    break;
                }
                case 2: {
                    point2D.setLocation(d * this.m00, d2 * this.m11);
                    break;
                }
                case 1: {
                    point2D.setLocation(d + this.m02, d2 + this.m12);
                    break;
                }
                case 0: {
                    point2D.setLocation(d, d2);
                }
            }
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray2 == fArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = fArray[n++];
                    double d8 = fArray[n++];
                    fArray2[n2++] = (float)(d * d7 + d2 * d8 + d3);
                    fArray2[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = fArray[n++];
                    double d13 = fArray[n++];
                    fArray2[n2++] = (float)(d * d12 + d9 * d13);
                    fArray2[n2++] = (float)(d10 * d12 + d11 * d13);
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = fArray[n++];
                    fArray2[n2++] = (float)(d * (double)fArray[n++] + d14);
                    fArray2[n2++] = (float)(d15 * d17 + d16);
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = fArray[n++];
                    fArray2[n2++] = (float)(d * (double)fArray[n++]);
                    fArray2[n2++] = (float)(d18 * d19);
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(d * (double)fArray[n++] + d20);
                    fArray2[n2++] = (float)(d21 * (double)fArray[n++] + d22);
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)(d * (double)fArray[n++]);
                    fArray2[n2++] = (float)(d23 * (double)fArray[n++]);
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    fArray2[n2++] = (float)((double)fArray[n++] + d);
                    fArray2[n2++] = (float)((double)fArray[n++] + d24);
                }
                return;
            }
            case 0: 
        }
        if (fArray != fArray2 || n != n2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = dArray[n++];
                    double d8 = dArray[n++];
                    dArray2[n2++] = d * d7 + d2 * d8 + d3;
                    dArray2[n2++] = d4 * d7 + d5 * d8 + d6;
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = dArray[n++];
                    double d13 = dArray[n++];
                    dArray2[n2++] = d * d12 + d9 * d13;
                    dArray2[n2++] = d10 * d12 + d11 * d13;
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = dArray[n++];
                    dArray2[n2++] = d * dArray[n++] + d14;
                    dArray2[n2++] = d15 * d17 + d16;
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = dArray[n++];
                    dArray2[n2++] = d * dArray[n++];
                    dArray2[n2++] = d18 * d19;
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    dArray2[n2++] = d * dArray[n++] + d20;
                    dArray2[n2++] = d21 * dArray[n++] + d22;
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    dArray2[n2++] = d * dArray[n++];
                    dArray2[n2++] = d23 * dArray[n++];
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] + d;
                    dArray2[n2++] = dArray[n++] + d24;
                }
                return;
            }
            case 0: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = fArray[n++];
                    double d8 = fArray[n++];
                    dArray[n2++] = d * d7 + d2 * d8 + d3;
                    dArray[n2++] = d4 * d7 + d5 * d8 + d6;
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = fArray[n++];
                    double d13 = fArray[n++];
                    dArray[n2++] = d * d12 + d9 * d13;
                    dArray[n2++] = d10 * d12 + d11 * d13;
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = fArray[n++];
                    dArray[n2++] = d * (double)fArray[n++] + d14;
                    dArray[n2++] = d15 * d17 + d16;
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = fArray[n++];
                    dArray[n2++] = d * (double)fArray[n++];
                    dArray[n2++] = d18 * d19;
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    dArray[n2++] = d * (double)fArray[n++] + d20;
                    dArray[n2++] = d21 * (double)fArray[n++] + d22;
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    dArray[n2++] = d * (double)fArray[n++];
                    dArray[n2++] = d23 * (double)fArray[n++];
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    dArray[n2++] = (double)fArray[n++] + d;
                    dArray[n2++] = (double)fArray[n++] + d24;
                }
                return;
            }
            case 0: 
        }
        while (--n3 >= 0) {
            dArray[n2++] = fArray[n++];
            dArray[n2++] = fArray[n++];
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                while (--n3 >= 0) {
                    double d7 = dArray[n++];
                    double d8 = dArray[n++];
                    fArray[n2++] = (float)(d * d7 + d2 * d8 + d3);
                    fArray[n2++] = (float)(d4 * d7 + d5 * d8 + d6);
                }
                return;
            }
            case 6: {
                double d = this.m00;
                double d9 = this.m01;
                double d10 = this.m10;
                double d11 = this.m11;
                while (--n3 >= 0) {
                    double d12 = dArray[n++];
                    double d13 = dArray[n++];
                    fArray[n2++] = (float)(d * d12 + d9 * d13);
                    fArray[n2++] = (float)(d10 * d12 + d11 * d13);
                }
                return;
            }
            case 5: {
                double d = this.m01;
                double d14 = this.m02;
                double d15 = this.m10;
                double d16 = this.m12;
                while (--n3 >= 0) {
                    double d17 = dArray[n++];
                    fArray[n2++] = (float)(d * dArray[n++] + d14);
                    fArray[n2++] = (float)(d15 * d17 + d16);
                }
                return;
            }
            case 4: {
                double d = this.m01;
                double d18 = this.m10;
                while (--n3 >= 0) {
                    double d19 = dArray[n++];
                    fArray[n2++] = (float)(d * dArray[n++]);
                    fArray[n2++] = (float)(d18 * d19);
                }
                return;
            }
            case 3: {
                double d = this.m00;
                double d20 = this.m02;
                double d21 = this.m11;
                double d22 = this.m12;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(d * dArray[n++] + d20);
                    fArray[n2++] = (float)(d21 * dArray[n++] + d22);
                }
                return;
            }
            case 2: {
                double d = this.m00;
                double d23 = this.m11;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(d * dArray[n++]);
                    fArray[n2++] = (float)(d23 * dArray[n++]);
                }
                return;
            }
            case 1: {
                double d = this.m02;
                double d24 = this.m12;
                while (--n3 >= 0) {
                    fArray[n2++] = (float)(dArray[n++] + d);
                    fArray[n2++] = (float)(dArray[n++] + d24);
                }
                return;
            }
            case 0: 
        }
        while (--n3 >= 0) {
            fArray[n2++] = (float)dArray[n++];
            fArray[n2++] = (float)dArray[n++];
        }
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                d -= this.m02;
                d2 -= this.m12;
            }
            case 6: {
                double d3 = this.m00 * this.m11 - this.m01 * this.m10;
                if (Math.abs(d3) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d3);
                }
                point2D2.setLocation((d * this.m11 - d2 * this.m01) / d3, (d2 * this.m00 - d * this.m10) / d3);
                return point2D2;
            }
            case 5: {
                d -= this.m02;
                d2 -= this.m12;
            }
            case 4: {
                if (this.m01 == 0.0 || this.m10 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation(d2 / this.m10, d / this.m01);
                return point2D2;
            }
            case 3: {
                d -= this.m02;
                d2 -= this.m12;
            }
            case 2: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                point2D2.setLocation(d / this.m00, d2 / this.m11);
                return point2D2;
            }
            case 1: {
                point2D2.setLocation(d - this.m02, d2 - this.m12);
                return point2D2;
            }
            case 0: 
        }
        point2D2.setLocation(d, d2);
        return point2D2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws NoninvertibleTransformException {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m02;
                double d4 = this.m10;
                double d5 = this.m11;
                double d6 = this.m12;
                double d7 = d * d5 - d2 * d4;
                if (Math.abs(d7) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d7);
                }
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    double d8 = dArray[n++] - d3;
                    double d9 = dArray[n++] - d6;
                    dArray2[n2++] = (d8 * d5 - d9 * d2) / d7;
                    dArray2[n2++] = (d9 * d - d8 * d4) / d7;
                }
            }
            case 6: {
                double d = this.m00;
                double d10 = this.m01;
                double d11 = this.m10;
                double d12 = this.m11;
                double d13 = d * d12 - d10 * d11;
                if (Math.abs(d13) <= Double.MIN_VALUE) {
                    throw new NoninvertibleTransformException("Determinant is " + d13);
                }
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    double d14 = dArray[n++];
                    double d15 = dArray[n++];
                    dArray2[n2++] = (d14 * d12 - d15 * d10) / d13;
                    dArray2[n2++] = (d15 * d - d14 * d11) / d13;
                }
            }
            case 5: {
                double d = this.m01;
                double d16 = this.m02;
                double d17 = this.m10;
                double d18 = this.m12;
                if (d == 0.0 || d17 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    double d19 = dArray[n++] - d16;
                    dArray2[n2++] = (dArray[n++] - d18) / d;
                    dArray2[n2++] = d19 / d17;
                }
            }
            case 4: {
                double d = this.m01;
                double d20 = this.m10;
                if (d == 0.0 || d20 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    double d21 = dArray[n++];
                    dArray2[n2++] = dArray[n++] / d;
                    dArray2[n2++] = d21 / d20;
                }
            }
            case 3: {
                double d = this.m00;
                double d22 = this.m02;
                double d23 = this.m11;
                double d24 = this.m12;
                if (d == 0.0 || d23 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    dArray2[n2++] = (dArray[n++] - d22) / d;
                    dArray2[n2++] = (dArray[n++] - d24) / d23;
                }
            }
            case 2: {
                double d = this.m00;
                double d25 = this.m11;
                if (d == 0.0 || d25 == 0.0) {
                    throw new NoninvertibleTransformException("Determinant is 0");
                }
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    dArray2[n2++] = dArray[n++] / d;
                    dArray2[n2++] = dArray[n++] / d25;
                }
            }
            case 1: {
                double d = this.m02;
                double d26 = this.m12;
                while (true) {
                    if (--n3 < 0) {
                        return;
                    }
                    dArray2[n2++] = dArray[n++] - d;
                    dArray2[n2++] = dArray[n++] - d26;
                }
            }
            case 0: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public Point2D deltaTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                point2D2.setLocation(d * this.m00 + d2 * this.m01, d * this.m10 + d2 * this.m11);
                return point2D2;
            }
            case 4: 
            case 5: {
                point2D2.setLocation(d2 * this.m01, d * this.m10);
                return point2D2;
            }
            case 2: 
            case 3: {
                point2D2.setLocation(d * this.m00, d2 * this.m11);
                return point2D2;
            }
            case 0: 
            case 1: 
        }
        point2D2.setLocation(d, d2);
        return point2D2;
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == dArray && n2 > n && n2 < n + n3 * 2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
            n = n2;
        }
        switch (this.state) {
            default: {
                this.stateError();
            }
            case 6: 
            case 7: {
                double d = this.m00;
                double d2 = this.m01;
                double d3 = this.m10;
                double d4 = this.m11;
                while (--n3 >= 0) {
                    double d5 = dArray[n++];
                    double d6 = dArray[n++];
                    dArray2[n2++] = d5 * d + d6 * d2;
                    dArray2[n2++] = d5 * d3 + d6 * d4;
                }
                return;
            }
            case 4: 
            case 5: {
                double d = this.m01;
                double d7 = this.m10;
                while (--n3 >= 0) {
                    double d8 = dArray[n++];
                    dArray2[n2++] = dArray[n++] * d;
                    dArray2[n2++] = d8 * d7;
                }
                return;
            }
            case 2: 
            case 3: {
                double d = this.m00;
                double d9 = this.m11;
                while (--n3 >= 0) {
                    dArray2[n2++] = dArray[n++] * d;
                    dArray2[n2++] = dArray[n++] * d9;
                }
                return;
            }
            case 0: 
            case 1: 
        }
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    private static double _matround(double d) {
        return Math.rint(d * 1.0E15) / 1.0E15;
    }

    public String toString() {
        return "AffineTransform[[" + AffineTransform._matround(this.m00) + ", " + AffineTransform._matround(this.m01) + ", " + AffineTransform._matround(this.m02) + "], [" + AffineTransform._matround(this.m10) + ", " + AffineTransform._matround(this.m11) + ", " + AffineTransform._matround(this.m12) + "]]";
    }

    public boolean isIdentity() {
        return this.state == 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)object;
        return this.m00 == affineTransform.m00 && this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m10 == affineTransform.m10 && this.m11 == affineTransform.m11 && this.m12 == affineTransform.m12;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.updateState();
    }
}

