/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.geom;

import java.awt.Rectangle;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Line2D;
import oracle.bali.jle.geom.Point2D;

public abstract class Rectangle2D {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        int n = this.outcode(d, d2);
        int n2 = this.outcode(d3, d4);
        while ((n & n2) == 0) {
            double d5;
            if (n == 0) {
                if (n2 == 0) {
                    return true;
                }
                d5 = d;
                d = d3;
                d3 = d5;
                d5 = d2;
                d2 = d4;
                d4 = d5;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
            if ((n & 5) != 0) {
                d5 = this.getX();
                if ((n & 4) != 0) {
                    d5 += this.getWidth();
                }
                d2 += (d5 - d) * (d4 - d2) / (d3 - d);
                d = d5;
            } else if ((n & 0xA) != 0) {
                d5 = this.getY();
                if ((n & 8) != 0) {
                    d5 += this.getHeight();
                }
                d += (d5 - d2) * (d3 - d) / (d4 - d2);
                d2 = d5;
            }
            n = this.outcode(d, d2);
        }
        return false;
    }

    public boolean intersectsLine(Line2D line2D) {
        return this.intersectsLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D point2D) {
        return this.outcode(point2D.getX(), point2D.getY());
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.setRect(d, d2, d3, d4);
    }

    public Rectangle2D getBounds2D() {
        return this;
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        return d >= d3 && d2 >= d4 && d < d3 + this.getWidth() && d2 < d4 + this.getHeight();
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX();
        double d6 = this.getY();
        return d + d3 > d5 && d2 + d4 > d6 && d < d5 + this.getWidth() && d2 < d6 + this.getHeight();
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX();
        double d6 = this.getY();
        return d >= d5 && d2 >= d6 && d + d3 <= d5 + this.getWidth() && d2 + d4 <= d6 + this.getHeight();
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.max(rectangle2D.getLeft(), rectangle2D2.getLeft());
        double d2 = Math.max(rectangle2D.getTop(), rectangle2D2.getTop());
        double d3 = Math.min(rectangle2D.getRight(), rectangle2D2.getRight());
        double d4 = Math.min(rectangle2D.getBottom(), rectangle2D2.getBottom());
        rectangle2D3.setBoundsFromDiagonal(d, d2, d3, d4);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.min(rectangle2D.getLeft(), rectangle2D2.getLeft());
        double d2 = Math.min(rectangle2D.getTop(), rectangle2D2.getTop());
        double d3 = Math.max(rectangle2D.getRight(), rectangle2D2.getRight());
        double d4 = Math.max(rectangle2D.getBottom(), rectangle2D2.getBottom());
        rectangle2D3.setBoundsFromDiagonal(d, d2, d3, d4);
    }

    public void add(double d, double d2) {
        double d3 = Math.min(this.getLeft(), d);
        double d4 = Math.max(this.getRight(), d);
        double d5 = Math.min(this.getTop(), d2);
        double d6 = Math.max(this.getBottom(), d2);
        this.setRect(d3, d5, d4 - d3, d6 - d5);
    }

    public void add(Point2D point2D) {
        this.add(point2D.getX(), point2D.getY());
    }

    public void add(Rectangle2D rectangle2D) {
        double d = Math.min(this.getLeft(), rectangle2D.getLeft());
        double d2 = Math.max(this.getRight(), rectangle2D.getRight());
        double d3 = Math.min(this.getTop(), rectangle2D.getTop());
        double d4 = Math.max(this.getBottom(), rectangle2D.getBottom());
        this.setRect(d, d3, d2 - d, d4 - d3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)object;
            return this.getX() == rectangle2D.getX() && this.getY() == rectangle2D.getY() && this.getWidth() == rectangle2D.getWidth() && this.getHeight() == rectangle2D.getHeight();
        }
        return super.equals(object);
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public abstract boolean isEmpty();

    public double getLeft() {
        return this.getX();
    }

    public double getTop() {
        return this.getY();
    }

    public double getRight() {
        return this.getX() + this.getWidth();
    }

    public double getBottom() {
        return this.getY() + this.getHeight();
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public void setBounds(Point2D point2D, Dimension2D dimension2D) {
        this.setBounds(point2D.getX(), point2D.getY(), dimension2D.getWidth(), dimension2D.getHeight());
    }

    public void setBounds(Rectangle2D rectangle2D) {
        this.setBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setBoundsFromDiagonal(double d, double d2, double d3, double d4) {
        double d5;
        if (d3 < d) {
            d5 = d;
            d = d3;
            d3 = d5;
        }
        if (d4 < d2) {
            d5 = d2;
            d2 = d4;
            d4 = d5;
        }
        this.setBounds(d, d2, d3 - d, d4 - d2);
    }

    public void setBoundsFromDiagonal(Point2D point2D, Point2D point2D2) {
        this.setBoundsFromDiagonal(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public void setBoundsFromCenter(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d3 - d);
        double d6 = Math.abs(d4 - d2);
        this.setBounds(d - d5, d2 - d6, d5 * 2.0, d6 * 2.0);
    }

    public void setBoundsFromCenter(Point2D point2D, Point2D point2D2) {
        this.setBoundsFromCenter(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (d < 0.0 || d2 < 0.0) {
            return new Rectangle();
        }
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = Math.floor(d3);
        double d6 = Math.floor(d4);
        double d7 = Math.ceil(d3 + d);
        double d8 = Math.ceil(d4 + d2);
        return new Rectangle((int)d5, (int)d6, (int)(d7 - d5), (int)(d8 - d6));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static class Double
    extends Rectangle2D {
        private double x;
        private double y;
        private double width;
        private double height;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.setRect(d, d2, d3, d4);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (this.width <= 0.0) {
                n |= 5;
            } else if (d < this.x) {
                n |= 1;
            } else if (d > this.x + this.width) {
                n |= 4;
            }
            if (this.height <= 0.0) {
                n |= 0xA;
            } else if (d2 < this.y) {
                n |= 2;
            } else if (d2 > this.y + this.height) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.intersect(this, rectangle2D, double_);
            return double_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.union(this, rectangle2D, double_);
            return double_;
        }

        public String toString() {
            return "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Float
    extends Rectangle2D {
        private float x;
        private float y;
        private float width;
        private float height;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.setRect(f, f2, f3, f4);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (this.width <= 0.0f) {
                n |= 5;
            } else if (d < (double)this.x) {
                n |= 1;
            } else if (d > (double)(this.x + this.width)) {
                n |= 4;
            }
            if (this.height <= 0.0f) {
                n |= 0xA;
            } else if (d2 < (double)this.y) {
                n |= 2;
            } else if (d2 > (double)(this.y + this.height)) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Rectangle2D rectangle2D2 = rectangle2D instanceof Float ? new Float() : new Double();
            Rectangle2D.intersect(this, rectangle2D, rectangle2D2);
            return rectangle2D2;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Rectangle2D rectangle2D2 = rectangle2D instanceof Float ? new Float() : new Double();
            Rectangle2D.union(this, rectangle2D, rectangle2D2);
            return rectangle2D2;
        }

        public String toString() {
            return "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

