/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.util.Enumeration;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.ListPropertyManager;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.AccessibleLayoutItem;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.graphics.TransparencyFilter;

public class BaseItem
implements LayoutItem {
    private String _name;
    private AffineTransform _itemTran;
    private AffineTransform _deviceTran;
    private double _x;
    private double _y;
    private double _width;
    private double _height;
    private LayoutItem _parent;
    private PropertyManager _pm;
    private long _enabledEvents;
    private ListenerManager _listeners;
    private String _defaultName = null;
    private AffineTransform _lastTrans = new AffineTransform();
    private Rectangle _lastRect;
    private boolean _boundsChange = true;
    private Image _cachedImage;
    private double _cachedZoomX;
    private double _cachedZoomY;
    private AccessibleContext _accessibleContext;
    private static int _sInstanceCounter = 0;
    private static final ImmTransform _sIdentity = ImmTransform.getIdentity();
    private static final Color _sTransparentColor = Color.magenta;
    private static boolean _sCacheAllowed = true;
    private static int _sScaleHint = 2;

    public static boolean isZoomCachingAllowed() {
        return _sCacheAllowed;
    }

    public static void setZoomCachingAllowed(boolean bl) {
        _sCacheAllowed = bl;
    }

    public BaseItem() {
        this._itemTran = new AffineTransform();
        this._deviceTran = new AffineTransform();
        this.getPropertyManager().put(LayoutItem.ITEM_TRANSFORM_KEY, this._itemTran.clone());
        this.getPropertyManager().put(LayoutItem.DEVICE_TRANSFORM_KEY, this._deviceTran.clone());
        this._enabledEvents = 0L;
        this._height = 0.0;
        this._width = 0.0;
        this._y = 0.0;
        this._x = 0.0;
    }

    public String getName() {
        if (this._name == null) {
            this._name = this.getDefaultName();
        }
        return this._name;
    }

    public JLECanvas getCanvas() {
        if (this._parent != null) {
            return this._parent.getCanvas();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public Rectangle2D getItemBounds() {
        return new Rectangle2D.Double(this._x, this._y, this._width, this._height);
    }

    public Dimension2D getItemSize() {
        return new Dimension2D.Double(this._width, this._height);
    }

    public void setItemSize(double d, double d2) {
        boolean bl = this.updateBounds(this._x, this._y, d, d2);
        if (bl) {
            this.getPropertyManager().put(LayoutItem.BOUNDS_KEY, this.getItemBounds());
        }
    }

    public void setItemLocation(double d, double d2) {
        double d3 = this._x;
        double d4 = this._y;
        boolean bl = this.updateBounds(d, d2, this._width, this._height);
        AffineTransform affineTransform = this.getItemTransform();
        affineTransform.translate(d - d3, d2 - d4);
        this._itemTran = affineTransform;
        this.getPropertyManager().put(LayoutItem.ITEM_TRANSFORM_KEY, this._itemTran.clone());
        try {
            LayoutItem layoutItem = this.getItemParent();
            this.updateDeviceTransform(layoutItem != null ? new ImmTransform(layoutItem.getDeviceTransform()) : _sIdentity);
        }
        catch (TransformException transformException) {
            throw new IllegalStateException("couldn't set location transform");
        }
        if (bl) {
            this.getPropertyManager().put(LayoutItem.BOUNDS_KEY, this.getItemBounds());
        }
    }

    public void setItemBounds(double d, double d2, double d3, double d4) {
        double d5 = this._x;
        double d6 = this._y;
        boolean bl = this.updateBounds(d, d2, d3, d4);
        AffineTransform affineTransform = this.getItemTransform();
        affineTransform.translate(this._x - d5, this._y - d6);
        this._itemTran = affineTransform;
        try {
            LayoutItem layoutItem = this.getItemParent();
            this.updateDeviceTransform(layoutItem != null ? new ImmTransform(layoutItem.getDeviceTransform()) : _sIdentity);
        }
        catch (TransformException transformException) {
            throw new IllegalStateException("couldn't set location transform");
        }
        if (bl) {
            this.getPropertyManager().put(LayoutItem.BOUNDS_KEY, this.getItemBounds());
        }
    }

    public Point2D getItemLocation() {
        return new Point2D.Double(this._x, this._y);
    }

    public AffineTransform getItemTransform() {
        return (AffineTransform)this._itemTran.clone();
    }

    public void setItemTransform(AffineTransform affineTransform) throws TransformException {
        if (affineTransform == null) {
            throw new IllegalArgumentException("item can't have null transform");
        }
        int n = affineTransform.getType();
        this._itemTran = (AffineTransform)affineTransform.clone();
        boolean bl = this.updateBounds(this._itemTran.getTranslateX(), this._itemTran.getTranslateY(), this._width, this._height);
        this.getPropertyManager().put(LayoutItem.ITEM_TRANSFORM_KEY, affineTransform.clone());
        LayoutItem layoutItem = this.getItemParent();
        this.updateDeviceTransform(layoutItem != null ? new ImmTransform(layoutItem.getDeviceTransform()) : _sIdentity);
        if (bl) {
            this.getPropertyManager().put(LayoutItem.BOUNDS_KEY, this.getItemBounds());
        }
    }

    public AffineTransform getDeviceTransform() {
        return (AffineTransform)this._deviceTran.clone();
    }

    public final void paintItem(Graphics graphics, AffineTransform affineTransform) {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas == null) {
            return;
        }
        if (jLECanvas.isZoomed()) {
            this.paintItemZoomed(graphics, affineTransform, jLECanvas.getZoomX(), jLECanvas.getZoomY());
        } else {
            this.paintItemImpl(graphics, affineTransform);
        }
    }

    public void paintItemImpl(Graphics graphics, AffineTransform affineTransform) {
    }

    public void paintItemZoomed(Graphics graphics, AffineTransform affineTransform, double d, double d2) {
        Point point = ItemUtils.parentToDevice((LayoutItem)this, this.getItemLocation());
        boolean bl = this._useCachedImage(d, d2);
        if (bl) {
            graphics.drawImage(this._cachedImage, point.x, point.y, null);
            return;
        }
        JLECanvas jLECanvas = this.getCanvas();
        AffineTransform affineTransform2 = new AffineTransform(affineTransform);
        Graphics graphics2 = null;
        Image image = ItemUtils.getItemImage(this);
        Image image2 = null;
        if (image != null) {
            Dimension2D dimension2D = this.getItemSize();
            double d3 = jLECanvas.getEngineUnitsPerPixelX();
            double d4 = jLECanvas.getEngineUnitsPerPixelY();
            double d5 = dimension2D.getWidth() / d3;
            double d6 = dimension2D.getHeight() / d4;
            Dimension2D dimension2D2 = jLECanvas.getZoom();
            graphics2 = graphics;
            Rectangle rectangle = graphics2.getClipBounds();
            graphics = image.getGraphics();
            graphics.setClip(0, 0, (int)Math.ceil(d5), (int)Math.ceil(d6));
            graphics.setColor(_sTransparentColor);
            graphics.fillRect(0, 0, (int)Math.ceil(d5), (int)Math.ceil(d6));
            graphics.translate(-point.x, -point.y);
            affineTransform2.scale(1.0 / dimension2D2.getWidth(), 1.0 / dimension2D2.getHeight());
            this.paintItemImpl(graphics, affineTransform2);
            Image image3 = ((Component)((Object)jLECanvas)).createImage(new FilteredImageSource(image.getSource(), (ImageFilter)new TransparencyFilter(_sTransparentColor)));
            int n = (int)(d * d5);
            int n2 = (int)(d2 * d6);
            image2 = image3.getScaledInstance(n, n2, BaseItem.getImageScaleHint());
            graphics.dispose();
            image.flush();
            image3.flush();
            this._cachedImage = image2;
            this._cachedZoomX = d;
            this._cachedZoomY = d2;
            graphics2.drawImage(image2, point.x, point.y, null);
        }
    }

    public static void setImageScaleHint(int n) {
        _sScaleHint = n;
    }

    public static int getImageScaleHint() {
        return _sScaleHint;
    }

    public void repaintItem(double d, double d2, double d3, double d4) {
        if (this.getCanvas() != null) {
            Rectangle rectangle = ItemUtils.itemToDevice(this, d, d2, d3, d4);
            this.getCanvas().repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void printItem(Graphics graphics, AffineTransform affineTransform) {
        this.paintItem(graphics, affineTransform);
    }

    public boolean eventEnabled(JLEEvent jLEEvent) {
        switch (jLEEvent.getID()) {
            case 503: 
            case 506: {
                if ((this._enabledEvents & 0x20L) == 0L) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this._enabledEvents & 0x10L) == 0L) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this._enabledEvents & 8L) == 0L) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this._enabledEvents & 4L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    public final void processEvent(JLEEvent jLEEvent) {
        if (!this.eventEnabled(jLEEvent)) {
            return;
        }
        int n = jLEEvent.getID();
        if (this._listeners != null) {
            Enumeration enumeration = this._listeners.getListeners();
            while (enumeration.hasMoreElements()) {
                JLEEventListener jLEEventListener = (JLEEventListener)enumeration.nextElement();
                switch (n) {
                    case 503: {
                        jLEEventListener.mouseMoved(jLEEvent);
                        break;
                    }
                    case 506: {
                        jLEEventListener.mouseDragged(jLEEvent);
                        break;
                    }
                    case 501: {
                        jLEEventListener.mousePressed(jLEEvent);
                        break;
                    }
                    case 502: {
                        jLEEventListener.mouseReleased(jLEEvent);
                        break;
                    }
                    case 500: {
                        jLEEventListener.mouseClicked(jLEEvent);
                        break;
                    }
                    case 504: {
                        jLEEventListener.mouseEntered(jLEEvent);
                        break;
                    }
                    case 505: {
                        jLEEventListener.mouseExited(jLEEvent);
                        break;
                    }
                    case 401: {
                        jLEEventListener.keyPressed(jLEEvent);
                        break;
                    }
                    case 402: {
                        jLEEventListener.keyReleased(jLEEvent);
                        break;
                    }
                    case 400: {
                        jLEEventListener.keyTyped(jLEEvent);
                        break;
                    }
                    case 1004: {
                        jLEEventListener.focusGained(jLEEvent);
                        break;
                    }
                    case 1005: {
                        jLEEventListener.focusLost(jLEEvent);
                    }
                }
            }
        }
        if (!jLEEvent.isConsumed()) {
            switch (n) {
                case 503: 
                case 506: {
                    this.processMouseMotionEvent(jLEEvent);
                    break;
                }
                case 500: 
                case 501: 
                case 502: 
                case 504: 
                case 505: {
                    this.processMouseEvent(jLEEvent);
                    break;
                }
                case 400: 
                case 401: 
                case 402: {
                    this.processKeyEvent(jLEEvent);
                }
            }
            if (n == 1004 || n == 1005) {
                this.processFocusEvent(jLEEvent);
            }
        }
    }

    public boolean allowsChildren() {
        return false;
    }

    public void addItem(LayoutItem layoutItem, int n) {
        throw new IllegalStateException("item does not allow children");
    }

    public void addItem(LayoutItem layoutItem) {
        throw new IllegalStateException("item does not allow children");
    }

    public void removeItem(LayoutItem layoutItem) {
    }

    public void removeItem(int n) {
    }

    public void removeAllItems() {
    }

    public int getItemCount() {
        return 0;
    }

    public LayoutItem getItem(int n) {
        return null;
    }

    public LayoutItem[] getItems() {
        return new LayoutItem[0];
    }

    public void setItemParent(LayoutItem layoutItem) {
        this._parent = layoutItem;
        try {
            this.updateDeviceTransform(layoutItem != null ? new ImmTransform(layoutItem.getDeviceTransform()) : _sIdentity);
        }
        catch (TransformException transformException) {
            this._parent = null;
            this.setDeviceTransform(this.getItemTransform());
            this.getPropertyManager().put(LayoutItem.PARENT_KEY, null);
            throw new IllegalStateException("couldn't set parent transform");
        }
        this.getPropertyManager().put(LayoutItem.PARENT_KEY, layoutItem);
    }

    public LayoutItem getItemParent() {
        return this._parent;
    }

    public boolean contains(double d, double d2) {
        return d >= 0.0 && d < this._width && d2 >= 0.0 && d2 < this._height;
    }

    public LayoutItem getItemAt(double d, double d2) {
        return this.contains(d, d2) ? this : null;
    }

    public boolean hitTest(double d, double d2) {
        return d >= 0.0 && d < this._width && d2 >= 0.0 && d2 < this._height;
    }

    public LayoutItem getHitItem(double d, double d2) {
        return this.hitTest(d, d2) ? this : null;
    }

    public PropertyManager getPropertyManager() {
        if (this._pm == null) {
            this._pm = this.createPropertyManager();
        }
        return this._pm;
    }

    public Object getProperty(Object object) {
        return this.getPropertyManager().get(object);
    }

    public Object putProperty(Object object, Object object2) {
        return this.getPropertyManager().put(object, object2);
    }

    public Object removeProperty(Object object) {
        return this.getPropertyManager().remove(object);
    }

    public Object clone() throws CloneNotSupportedException {
        BaseItem baseItem = (BaseItem)super.clone();
        baseItem._name = null;
        baseItem._itemTran = new AffineTransform();
        baseItem._deviceTran = new AffineTransform();
        baseItem._height = 0.0;
        baseItem._width = 0.0;
        baseItem._y = 0.0;
        baseItem._x = 0.0;
        baseItem.setItemBounds(this._x, this._y, this._width, this._height);
        baseItem._parent = null;
        baseItem._pm = null;
        baseItem._enabledEvents = 0L;
        baseItem._listeners = null;
        baseItem._accessibleContext = null;
        return baseItem;
    }

    public void enableJLEEvents(long l) {
        this._enabledEvents |= l;
    }

    public void addJLEEventListener(JLEEventListener jLEEventListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)jLEEventListener);
    }

    public void removeJLEEventListener(JLEEventListener jLEEventListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)jLEEventListener);
        }
    }

    public final void repaintItem() {
        this.repaintItem(0.0, 0.0, this._width, this._height);
    }

    public void paintImmediate(double d, double d2, double d3, double d4) {
        if (this.getCanvas() != null) {
            Rectangle rectangle = ItemUtils.itemToDevice(this, d, d2, d3, d4);
            this.getCanvas().paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public final void paintImmediate() {
        this.paintImmediate(0.0, 0.0, this._width, this._height);
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public boolean hasFocus() {
        JLECanvas jLECanvas = this.getCanvas();
        return jLECanvas == null ? false : jLECanvas.getFocusedItem() == this;
    }

    public void requestFocus() {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null) {
            jLECanvas.setFocusedItem(this);
        }
    }

    public Rectangle getDeviceRect(AffineTransform affineTransform) {
        if (this._boundsChange || !affineTransform.equals(this._lastTrans)) {
            this._lastRect = GeometryUtils.toRectangle(ItemUtils.transformRect(affineTransform, 0.0, 0.0, this._width, this._height, false));
            this._boundsChange = false;
            this._lastTrans.setTransform(affineTransform);
        }
        return new Rectangle(this._lastRect);
    }

    public void transferFocus() {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null) {
            jLECanvas.setFocusNext();
        }
    }

    public void invalidateZoomImage() {
        this._cachedImage = null;
    }

    public boolean isZoomImageValid() {
        return this._cachedImage != null;
    }

    protected String getDefaultName() {
        if (this._defaultName == null) {
            this._defaultName = this.getBaseClassName() + _sInstanceCounter++;
        }
        return this._defaultName;
    }

    protected String getBaseClassName() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public void updateDeviceTransform(ImmTransform immTransform) throws TransformException {
        int n = immTransform.getType();
        AffineTransform affineTransform = this.getItemTransform();
        affineTransform.preConcatenate(immTransform);
        this.setDeviceTransform(affineTransform);
    }

    public final AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = this.createAccessibleContext();
        }
        return this._accessibleContext;
    }

    protected void setDeviceTransform(AffineTransform affineTransform) {
        this._deviceTran = affineTransform;
        this.getPropertyManager().put(LayoutItem.DEVICE_TRANSFORM_KEY, affineTransform.clone());
    }

    protected PropertyManager createPropertyManager() {
        return new ListPropertyManager(this);
    }

    protected void processMouseMotionEvent(JLEEvent jLEEvent) {
    }

    protected void processMouseEvent(JLEEvent jLEEvent) {
    }

    protected void processKeyEvent(JLEEvent jLEEvent) {
    }

    protected void processFocusEvent(JLEEvent jLEEvent) {
    }

    protected boolean updateBounds(double d, double d2, double d3, double d4) {
        boolean bl;
        boolean bl2 = d3 != this._width || d4 != this._height;
        boolean bl3 = bl = bl2 || d != this._x || d2 != this._y;
        if (d3 < 0.0) {
            d3 = -d3;
            d = d <= this._x ? this._x - d3 : this._x + this._width;
        }
        if (d4 < 0.0) {
            d4 = -d4;
            d2 = d2 <= this._y ? this._y - d4 : this._y + this._height;
        }
        this._x = d;
        this._y = d2;
        this._width = d3;
        this._height = d4;
        this._boundsChange = true;
        if (bl2) {
            this.invalidateZoomImage();
        }
        return bl;
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleLayoutItem(this);
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    private boolean _useCachedImage(double d, double d2) {
        return this._cachedImage != null && BaseItem.isZoomCachingAllowed() && d == this._cachedZoomX && d2 == this._cachedZoomY;
    }
}

