/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.ImmTransform;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.item.LWComponentContainer;
import oracle.bali.jle.util.ItemUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.util.ComponentUtils;
import oracle.ewt.util.WindowUtils;

public class ComponentItem
extends BaseItem {
    private Component _comp;
    private Component _mouseTarget;
    private Component _mouseMotionTarget;
    private String _displayName;
    private Container _hidden;
    private Rectangle _deviceBounds;
    private double _scaleX = 1.0;
    private double _scaleY = 1.0;
    private Cursor _cursor;
    private long _eventMask;
    private Listener _listener;
    private boolean _mouseConsume;
    private static Container _defaultHidden;
    static /* synthetic */ Class class$java$awt$Component;

    public ComponentItem(Component component) {
        this(component, 60L);
    }

    public ComponentItem(Component component, long l) {
        this._init(component, l);
    }

    public ComponentItem(Class clazz, long l) {
        if (clazz == null) {
            throw new IllegalArgumentException("can't create null class");
        }
        if (!(class$java$awt$Component == null ? (class$java$awt$Component = ComponentItem.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("class not a Component");
        }
        Component component = null;
        try {
            component = (Component)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("couldn't create wrapped Component");
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("couldn't create wrapped Component");
        }
        if (component == null) {
            throw new IllegalArgumentException("couldn't create wrapped Component");
        }
        this._init(component, l);
    }

    public String getName() {
        if (this._displayName == null) {
            this._displayName = this.getDefaultName() + ": " + this._comp.getClass().getName();
        }
        return this._displayName;
    }

    public void setItemSize(double d, double d2) {
        super.setItemSize(d, d2);
        this._updateBounds();
    }

    public void updateDeviceTransform(ImmTransform immTransform) throws TransformException {
        super.updateDeviceTransform(immTransform);
        JLECanvas jLECanvas = this.getCanvas();
        this._updateCanvas(jLECanvas);
        AffineTransform affineTransform = this.getDeviceTransform();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        if (this._scaleX != d || this._scaleY != d2) {
            int n = (int)Math.round((double)this._deviceBounds.width * (d / this._scaleX));
            int n2 = (int)Math.round((double)this._deviceBounds.height * (d2 / this._scaleY));
            this._comp.setSize(n, n2);
            this._scaleX = d;
            this._scaleY = d2;
        }
        this._updateBounds();
    }

    public Object clone() throws CloneNotSupportedException {
        ComponentItem componentItem = (ComponentItem)super.clone();
        Constructor<?> constructor = null;
        try {
            constructor = this._comp.getClass().getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CloneNotSupportedException();
        }
        try {
            componentItem._comp = (Component)constructor.newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CloneNotSupportedException();
        }
        catch (InstantiationException instantiationException) {
            throw new CloneNotSupportedException();
        }
        componentItem._comp.addFocusListener(componentItem._listener);
        componentItem._updateCanvas(null);
        componentItem._deviceBounds = this._comp.getBounds();
        AffineTransform affineTransform = this.getDeviceTransform();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        componentItem.setItemSize((double)this._deviceBounds.width / d, (double)this._deviceBounds.height / d2);
        componentItem._eventMask = this._eventMask;
        componentItem.enableJLEEvents(this._eventMask);
        return componentItem;
    }

    public void paintItemImpl(Graphics graphics, AffineTransform affineTransform) {
        if (this._hidden == null) {
            this._updateCanvas(null);
        }
        Rectangle rectangle = this.getDeviceRect(affineTransform);
        Graphics graphics2 = graphics.create();
        Rectangle rectangle2 = graphics.getClipBounds().intersection(rectangle);
        graphics2.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics2.translate(rectangle.x, rectangle.y);
        try {
            this._comp.paint(graphics2);
            Object var7_6 = null;
            graphics2.dispose();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            graphics2.dispose();
            throw throwable;
        }
    }

    public boolean isFocusTraversable() {
        return this._comp.isFocusTraversable();
    }

    public Component getComponent() {
        return this._comp;
    }

    public void pack() {
        Dimension dimension = this._comp.getPreferredSize();
        double d = dimension.width;
        double d2 = dimension.height;
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null) {
            d *= jLECanvas.getEngineUnitsPerPixelX();
            d2 *= jLECanvas.getEngineUnitsPerPixelY();
        }
        this.setItemSize(d, d2);
    }

    public void setForcedMouseConsumption(boolean bl) {
        this._mouseConsume = bl;
    }

    public boolean hasForcedMouseConsumption() {
        return this._mouseConsume;
    }

    public String toString() {
        return "ComponentItem: " + this._comp.getName();
    }

    protected void processMouseMotionEvent(JLEEvent jLEEvent) {
        this._redispatchMouseEvent(jLEEvent);
    }

    protected void processMouseEvent(JLEEvent jLEEvent) {
        this._redispatchMouseEvent(jLEEvent);
    }

    protected void processKeyEvent(JLEEvent jLEEvent) {
        if (jLEEvent.getSource() == this) {
            return;
        }
        KeyEvent keyEvent = new KeyEvent(this._comp, jLEEvent.getID(), jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getKeyCode(), jLEEvent.getKeyChar());
        if (this._comp instanceof LWComponent) {
            ((LWComponent)this._comp).redispatchEvent((AWTEvent)keyEvent);
        } else {
            this._comp.dispatchEvent(keyEvent);
        }
        if (keyEvent.isConsumed()) {
            jLEEvent.consume();
        }
    }

    protected void processFocusEvent(JLEEvent jLEEvent) {
        if (jLEEvent.getSource() == this) {
            boolean bl = this.hasFocus();
            if (bl && jLEEvent.getID() == 1004) {
                this._comp.requestFocus();
                this._comp.addKeyListener(this._listener);
            } else if (!bl && jLEEvent.getID() == 1005) {
                Window window = WindowUtils.getWindow((Component)this._comp);
                if (window.getFocusOwner() == this._comp) {
                    this._comp.transferFocus();
                }
                this._comp.removeKeyListener(this._listener);
            }
        }
    }

    protected double getScaleX() {
        return this._scaleX;
    }

    protected double getScaleY() {
        return this._scaleY;
    }

    protected AccessibleContext createAccessibleContext() {
        if (this.getComponent() instanceof Accessible) {
            return ((Accessible)((Object)this.getComponent())).getAccessibleContext();
        }
        return super.createAccessibleContext();
    }

    private void _init(Component component, long l) {
        this._mouseConsume = true;
        this._listener = new Listener();
        if (component == null) {
            throw new IllegalArgumentException("comp must be instantiated");
        }
        this._comp = component;
        this._comp.addFocusListener(this._listener);
        this._updateCanvas(null);
        this._deviceBounds = this._comp.getBounds();
        if (this._deviceBounds.width <= 0 && this._deviceBounds.height <= 0) {
            this._comp.invalidate();
            this._comp.validate();
            Dimension dimension = this._comp.getPreferredSize();
            this._deviceBounds.width = dimension.width;
            this._deviceBounds.height = dimension.height;
        }
        this.setItemSize(this._deviceBounds.width, this._deviceBounds.height);
        this._eventMask = l;
        this.enableJLEEvents(l);
    }

    private void _keyToCanvas(KeyEvent keyEvent) {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas == null) {
            return;
        }
        JLEEvent jLEEvent = new JLEEvent(this, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
        jLECanvas.processJLEEvent(jLEEvent);
    }

    private void _redispatchMouseEvent(JLEEvent jLEEvent) {
        Cursor cursor;
        Point point;
        int n = jLEEvent.getID();
        int n2 = (int)Math.round(jLEEvent.getX() * this._scaleX);
        int n3 = (int)Math.round(jLEEvent.getY() * this._scaleY);
        Component component = this._comp;
        if (n == 506 || n == 502) {
            component = this._mouseTarget;
        } else {
            component = ComponentUtils.getTargetComponent((Component)this._comp, (Point)new Point(n2, n3));
            if (n == 503) {
                if (this._mouseMotionTarget != null && this._mouseMotionTarget != component) {
                    point = this._targetToComp(this._mouseMotionTarget, n2, n3);
                    this._sendEvent(this._mouseMotionTarget, 505, jLEEvent, point.x, point.y);
                    n = 504;
                }
                this._mouseMotionTarget = component;
            }
        }
        if (component != null && component != this._comp) {
            point = this._targetToComp(component, n2, n3);
            n2 = point.x;
            n3 = point.y;
        }
        if (n == 501) {
            this._mouseTarget = component;
        }
        boolean bl = this._sendEvent(component, n, jLEEvent, n2, n3);
        if (n == 502) {
            this._mouseTarget = null;
        }
        if (bl || this.hasForcedMouseConsumption()) {
            jLEEvent.consume();
        }
        if ((cursor = component.getCursor()) != this._cursor) {
            this._cursor = cursor;
            this.putProperty(LayoutItem.CURSOR_KEY, cursor);
        }
    }

    private boolean _sendEvent(Component component, int n, JLEEvent jLEEvent, int n2, int n3) {
        MouseEvent mouseEvent = new MouseEvent(component, n, jLEEvent.getWhen(), jLEEvent.getModifiers(), n2, n3, jLEEvent.getClickCount(), false);
        if (component instanceof LWComponent) {
            ((LWComponent)component).redispatchEvent((AWTEvent)mouseEvent);
        } else {
            component.dispatchEvent(mouseEvent);
        }
        return mouseEvent.isConsumed();
    }

    private Point _targetToComp(Component component, int n, int n2) {
        while (component != this._comp) {
            Point point = component.getLocation();
            n -= point.x;
            n2 -= point.y;
            component = component.getParent();
        }
        return new Point(n, n2);
    }

    private void _updateCanvas(JLECanvas jLECanvas) {
        if (jLECanvas == null) {
            this._hidden = this._getDefaultHiddenContainer();
        } else if (this._hidden == this._getDefaultHiddenContainer()) {
            this._hidden = jLECanvas.getComponentContainer(this._comp);
        }
        Container container = this._comp.getParent();
        if (container != this._hidden) {
            this._hidden.add(this._comp, this, -1);
        }
    }

    private void _updateBounds() {
        LayoutItem layoutItem = this.getItemParent();
        this._deviceBounds = layoutItem == null ? ItemUtils.itemToDevice((LayoutItem)this, this.getItemBounds()) : ItemUtils.parentToDevice((LayoutItem)this, this.getItemBounds());
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null && jLECanvas.isZoomed()) {
            this._deviceBounds.x = (int)((double)this._deviceBounds.x / jLECanvas.getZoomX());
            this._deviceBounds.y = (int)((double)this._deviceBounds.y / jLECanvas.getZoomY());
            this._deviceBounds.width = (int)((double)this._deviceBounds.width / jLECanvas.getZoomX());
            this._deviceBounds.height = (int)((double)this._deviceBounds.height / jLECanvas.getZoomY());
        }
        this._comp.setBounds(this._deviceBounds.x, this._deviceBounds.y, this._deviceBounds.width, this._deviceBounds.height);
        this._comp.validate();
    }

    private Container _getDefaultHiddenContainer() {
        if (_defaultHidden == null) {
            _defaultHidden = new LWComponentContainer(null);
        }
        return _defaultHidden;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Listener
    implements FocusListener,
    KeyListener {
        Listener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            ComponentItem.this.getCanvas().setFocusedItem(ComponentItem.this);
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 9) {
                ComponentItem.this._keyToCanvas(keyEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 9) {
                ComponentItem.this._keyToCanvas(keyEvent);
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() != 9) {
                ComponentItem.this._keyToCanvas(keyEvent);
            }
        }
    }
}

