/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkPort;
import oracle.bali.jle.item.LinkPortEvent;
import oracle.bali.jle.item.LinkPortListener;
import oracle.ewt.event.ListenerManager;

public class DefaultLinkPort
implements LinkPort,
PropertyChangeListener {
    private static final int _sDIR_RIGHT = 1;
    private static final int _sDIR_DOWN = 4;
    public static final int UPPER_LEFT = 0;
    public static final int UPPER_CENTER = 1;
    public static final int UPPER_RIGHT = 2;
    public static final int CENTER_LEFT = 4;
    public static final int CENTER = 5;
    public static final int CENTER_RIGHT = 6;
    public static final int LOWER_LEFT = 8;
    public static final int LOWER_CENTER = 9;
    public static final int LOWER_RIGHT = 10;
    private LayoutItem _item;
    private int _type;
    private double _x;
    private double _y;
    private boolean _dead = false;
    private ListenerManager _listeners;

    public DefaultLinkPort(LayoutItem layoutItem, int n) {
        if (layoutItem == null || n < 0 || n > 10) {
            throw new IllegalArgumentException();
        }
        this._item = layoutItem;
        this._type = n;
        this._recalculateLocation();
        PropertyManager propertyManager = this._item.getPropertyManager();
        propertyManager.addPropertyChangeListener(this);
    }

    public LayoutItem getItem() {
        return this._item;
    }

    public void die() {
        this._dead = true;
        PropertyManager propertyManager = this._item.getPropertyManager();
        propertyManager.removePropertyChangeListener(this);
        this.fireLinkPortEvent(2);
        this._listeners = null;
        this._item = null;
        this._y = Double.NaN;
        this._x = Double.NaN;
    }

    public boolean isDead() {
        return this._dead;
    }

    public Point2D getLocation() {
        return new Point2D.Double(this._x, this._y);
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public void addLinkPortListener(LinkPortListener linkPortListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)linkPortListener);
    }

    public void removeLinkPortListener(LinkPortListener linkPortListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)linkPortListener);
        }
    }

    public LinkPortListener[] getLinkPortListeners() {
        Object[] objectArray;
        if (this._listeners == null) {
            return new LinkPortListener[0];
        }
        Enumeration enumeration = this._listeners.getListeners();
        if (enumeration == null) {
            return new LinkPortListener[0];
        }
        Vector<Object[]> vector = new Vector<Object[]>();
        while (enumeration.hasMoreElements()) {
            objectArray = (LinkPortListener)enumeration.nextElement();
            vector.addElement(objectArray);
        }
        objectArray = new LinkPortListener[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public final boolean isUpper() {
        return this._type / 4 == 0;
    }

    public final boolean isLower() {
        return this._type / 4 == 2;
    }

    public final boolean isLeft() {
        return this._type % 4 == 0;
    }

    public final boolean isRight() {
        return this._type % 4 == 2;
    }

    public boolean isCenter() {
        return this._type == 5;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(string) || LayoutItem.BOUNDS_KEY.equals(string)) {
            this._recalculateLocation();
        }
    }

    public String toString() {
        String string = null;
        switch (this._type) {
            case 5: {
                string = "Center";
                break;
            }
            case 4: {
                string = "Center Left";
                break;
            }
            case 6: {
                string = "Center Right";
                break;
            }
            case 9: {
                string = "Lower Center";
                break;
            }
            case 8: {
                string = "Lower Left";
                break;
            }
            case 10: {
                string = "Lower Right";
                break;
            }
            case 1: {
                string = "Upper Center";
                break;
            }
            case 0: {
                string = "Upper Left";
                break;
            }
            case 2: {
                string = "Upper Right";
            }
        }
        return "(" + this._x + "," + this._y + ") " + string + " on " + this._item;
    }

    protected void fireLinkPortEvent(int n) {
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._listeners == null ? null : this._listeners.getListeners();
        if (enumeration == null) {
            return;
        }
        LinkPortEvent linkPortEvent = new LinkPortEvent(this, n);
        while (enumeration.hasMoreElements()) {
            LinkPortListener linkPortListener = (LinkPortListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    linkPortListener.portMoved(linkPortEvent);
                }
            }
        }
    }

    private void _recalculateLocation() {
        Dimension2D dimension2D = this._item.getItemSize();
        switch (this._type) {
            case 0: {
                this._x = 0.0;
                this._y = 0.0;
                break;
            }
            case 1: {
                this._x = dimension2D.getWidth() / 2.0;
                this._y = 0.0;
                break;
            }
            case 2: {
                this._x = dimension2D.getWidth();
                this._y = 0.0;
                break;
            }
            case 4: {
                this._x = 0.0;
                this._y = dimension2D.getHeight() / 2.0;
                break;
            }
            case 5: {
                this._x = dimension2D.getWidth() / 2.0;
                this._y = dimension2D.getHeight() / 2.0;
                break;
            }
            case 6: {
                this._x = dimension2D.getWidth();
                this._y = dimension2D.getHeight() / 2.0;
                break;
            }
            case 8: {
                this._x = 0.0;
                this._y = dimension2D.getHeight();
                break;
            }
            case 9: {
                this._x = dimension2D.getWidth() / 2.0;
                this._y = dimension2D.getHeight();
                break;
            }
            case 10: {
                this._x = dimension2D.getWidth();
                this._y = dimension2D.getHeight();
            }
        }
        this.fireLinkPortEvent(1);
    }
}

