/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import oracle.bali.jle.ComponentContainer;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.popup.PopupRoot;
import oracle.ewt.popup.PopupUtils;
import oracle.ewt.util.ComponentUtils;

public class LWComponentContainer
extends LWComponent
implements ComponentContainer,
FocusListener,
PopupRoot {
    private JLECanvas _canvas;
    private Hashtable _items;

    public LWComponentContainer(JLECanvas jLECanvas) {
        ((Container)((Object)this)).setLayout(null);
        this._canvas = jLECanvas;
        this._items = new Hashtable();
        long l = 60L;
        ((Component)((Object)this)).enableEvents(l);
    }

    public Container getContainer() {
        return this;
    }

    public boolean isShowing() {
        return true;
    }

    public void paint(Graphics graphics) {
    }

    public void paintComponents(Graphics graphics) {
    }

    public void paintImmediateUnclipped(int n, int n2, int n3, int n4) {
        if (this._canvas != null) {
            if (this._canvas.isZoomed()) {
                Dimension2D dimension2D = this._canvas.getZoom();
                double d = dimension2D.getWidth();
                double d2 = dimension2D.getHeight();
                int n5 = (int)((double)n * d);
                int n6 = (int)((double)n2 * d2);
                int n7 = (int)((double)n3 * d);
                int n8 = (int)((double)n4 * d2);
                this._canvas.paintImmediateCanvas(n5, n6, n7, n8);
            } else {
                this._canvas.paintImmediateCanvas(n, n2, n3, n4);
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension size() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (this._canvas != null) {
            if (this._canvas.isZoomed()) {
                Dimension2D dimension2D = this._canvas.getZoom();
                double d = dimension2D.getWidth();
                double d2 = dimension2D.getHeight();
                int n5 = (int)((double)n * d);
                int n6 = (int)((double)n2 * d2);
                int n7 = (int)((double)n3 * d);
                int n8 = (int)((double)n4 * d2);
                this._canvas.repaintCanvas(n5, n6, n7, n8);
            } else {
                this._canvas.repaintCanvas(n, n2, n3, n4);
            }
        }
    }

    protected void addImpl(Component component, Object object, int n) {
        super.addImpl(component, object, n);
        this._items.put(component, (LayoutItem)object);
        component.addFocusListener(this);
    }

    public void remove(int n) {
        Component component = ((Container)((Object)this)).getComponent(n);
        component.removeFocusListener(this);
        this._items.remove(component);
        super.remove(n);
    }

    public void removeAll() {
        Component[] componentArray = ((Container)((Object)this)).getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].removeFocusListener(this);
            this._items.remove(componentArray[n]);
            ++n;
        }
        super.removeAll();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this._canvas != null) {
            LayoutItem layoutItem = (LayoutItem)this._items.get(focusEvent.getSource());
            if (layoutItem == null) {
                return;
            }
            this._canvas.setActualFocusedItem(layoutItem);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addPopup(Component component) {
        PopupUtils.findPopupOwner((Component)((Object)this._canvas)).addPopup(component);
    }

    public boolean isPopup(Component component) {
        return PopupUtils.findPopupOwner((Component)((Object)this._canvas)).isPopup(component);
    }

    public void showPopup(Component component, int n, int n2) {
        Component component2 = (Component)PopupUtils.findPopupOwner((Component)((Object)this._canvas));
        Point point = ComponentUtils.translatePoint((Component)((Object)this), (Component)component2, (int)n, (int)n2);
        PopupUtils.findPopupOwner((Component)((Object)this._canvas)).showPopup(component, point.x, point.y);
    }

    public void removePopup(Component component) {
        PopupUtils.findPopupOwner((Component)((Object)this._canvas)).removePopup(component);
    }

    public void setPopupBounds(Component component, int n, int n2, int n3, int n4) {
        PopupUtils.findPopupOwner((Component)((Object)this._canvas)).setPopupBounds(component, n, n2, n3, n4);
    }
}

