/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;

public class BaseTool
implements LayoutTool,
JLEEventListener {
    private JLECanvas _canvas;
    private JLEEventSource _eventSource;
    private Rectangle2D _immediate;
    private boolean _consumeKeys;
    private boolean _consumeMouse;
    private boolean _enabled = true;
    private int _mouseMask = 0;
    private int _primaryMouse = 16;
    private static String _sAssertWarning = " - tool should not partially consume event sets";

    public void drawHighlight(Graphics graphics) {
    }

    public void drop() {
        long l = this.getDefaultEnabledEvents();
        if (l != 0L) {
            this._eventSource.removeJLEEventListener(this);
        }
        this._canvas = null;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        this._canvas = jLECanvas;
        this._eventSource = jLEEventSource;
        long l = this.getDefaultEnabledEvents();
        if (l != 0L) {
            this._eventSource.addJLEEventListener(this);
            this._eventSource.enableJLEEvents(l);
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public void setPrimaryMouseButton(int n) {
        if (n != 16 && n != 8 && n != 4) {
            throw new IllegalArgumentException();
        }
        this._primaryMouse = n;
    }

    public int getPrimaryMouseButton() {
        return this._primaryMouse;
    }

    public boolean isPrimaryMouseEvent(JLEEvent jLEEvent) {
        int n = jLEEvent.getID();
        if (n == 501 || n == 502 || n == 500 || n == 506) {
            return (jLEEvent.getModifiers() & this.getPrimaryMouseButton()) != 0;
        }
        return false;
    }

    public JLECanvas getCanvas() {
        return this._canvas;
    }

    public JLEEventSource getEventSource() {
        return this._eventSource;
    }

    public long getDefaultEnabledEvents() {
        return 0L;
    }

    public void yield() {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null) {
            jLECanvas.setTool(jLECanvas.getDefaultTool());
        }
    }

    public boolean isActive() {
        return this.getCanvas() != null;
    }

    public final void mouseClicked(JLEEvent jLEEvent) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseClicked(jLEEvent);
        if (this._consumeMouse) {
            jLEEvent.consume();
        }
    }

    public final void mousePressed(JLEEvent jLEEvent) {
        this._consumeMouse = false;
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = jLEEvent.isConsumed();
        this.processMousePressed(jLEEvent);
        if (bl || !bl && jLEEvent.isConsumed()) {
            this._consumeMouse = true;
        }
    }

    public final void mouseReleased(JLEEvent jLEEvent) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseReleased(jLEEvent);
        if (this._consumeMouse) {
            jLEEvent.consume();
        }
    }

    public final void mouseEntered(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.processMouseEntered(jLEEvent);
    }

    public final void mouseExited(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.processMouseExited(jLEEvent);
    }

    public final void mouseDragged(JLEEvent jLEEvent) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseDragged(jLEEvent);
        if (this._consumeMouse) {
            jLEEvent.consume();
        }
    }

    public final void mouseMoved(JLEEvent jLEEvent) {
        if (!this._consumeMouse && !this.isEnabled()) {
            return;
        }
        this.processMouseMoved(jLEEvent);
    }

    public final void keyTyped(JLEEvent jLEEvent) {
        if (!this._consumeKeys && !this.isEnabled()) {
            return;
        }
        this.processKeyTyped(jLEEvent);
        if (this._consumeKeys) {
            jLEEvent.consume();
        }
    }

    public final void keyPressed(JLEEvent jLEEvent) {
        this._consumeKeys = false;
        if (!this.isEnabled()) {
            return;
        }
        boolean bl = jLEEvent.isConsumed();
        this.processKeyPressed(jLEEvent);
        if (bl || !bl && jLEEvent.isConsumed()) {
            this._consumeKeys = true;
        }
    }

    public final void keyReleased(JLEEvent jLEEvent) {
        if (!this._consumeKeys && !this.isEnabled()) {
            return;
        }
        this.processKeyReleased(jLEEvent);
        if (this._consumeKeys) {
            jLEEvent.consume();
        }
        this._consumeKeys = false;
    }

    public final void focusGained(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.processFocusGained(jLEEvent);
    }

    public final void focusLost(JLEEvent jLEEvent) {
        if (!this.isEnabled()) {
            return;
        }
        this.processFocusLost(jLEEvent);
    }

    protected void processMouseClicked(JLEEvent jLEEvent) {
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
    }

    protected void processMouseEntered(JLEEvent jLEEvent) {
    }

    protected void processMouseExited(JLEEvent jLEEvent) {
    }

    protected void processMouseDragged(JLEEvent jLEEvent) {
    }

    protected void processMouseMoved(JLEEvent jLEEvent) {
    }

    protected void processKeyTyped(JLEEvent jLEEvent) {
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
    }

    protected void processKeyReleased(JLEEvent jLEEvent) {
    }

    protected void processFocusGained(JLEEvent jLEEvent) {
    }

    protected void processFocusLost(JLEEvent jLEEvent) {
    }

    protected void updateImmediately() {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getImmediateRect();
        if (rectangle2D == null) {
            jLECanvas.paintImmediateInterior();
        } else {
            Rectangle rectangle = jLECanvas.contentToDevice(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            jLECanvas.paintImmediateCanvas(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        }
        this.setImmediateRect(rectangle2D);
    }

    protected Rectangle2D getImmediateRect() {
        return this._immediate;
    }

    protected void setImmediateRect(Rectangle2D rectangle2D) {
        this._immediate = rectangle2D;
    }

    protected void addImmediateRect(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return;
        }
        if (this._immediate == null) {
            this._immediate = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            Rectangle2D.union(this._immediate, rectangle2D, this._immediate);
        }
    }

    protected final void addImmediateRect(double d, double d2, double d3, double d4) {
        this.addImmediateRect(new Rectangle2D.Double(d, d2, d3, d4));
    }
}

