/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.EventListener;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.LayoutItemTransfer;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.ClipboardToolEvent;
import oracle.bali.jle.tool.ClipboardToolListener;
import oracle.bali.jle.tool.ClipboardToolValidateEvent;
import oracle.bali.jle.tool.SelectedItemProvider;
import oracle.bali.jle.tool.undo.ClipboardUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public class ClipboardTool
extends BaseTool
implements ClipboardOwner {
    private static final Object _CUT_PARENT_KEY = new StringKey("_CUT_PARENT_KEY");
    private static final Object _CUT_INDEX_KEY = new StringKey("_CUT_INDEX_KEY");
    private static final Object _CUT_KEY = new StringKey("_CUT_KEY");
    private static final KeyStroke _sDefaultCopyStroke = new KeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke _sDefaultCutStroke = new KeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke _sDefaultPasteStroke = new KeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final Clipboard _sJLEClipboard = new Clipboard("JLEClipboard");
    private static final DataFlavor _sMultiFlavor = LayoutItemTransfer.MULTI_LAYOUT_ITEM_FLAVOR;
    private static final DataFlavor _sFlavor = LayoutItemTransfer.LAYOUT_ITEM_FLAVOR;
    private SelectedItemProvider _selector;
    private KeyStroke _copyStroke = _sDefaultCopyStroke;
    private KeyStroke _cutStroke = _sDefaultCutStroke;
    private KeyStroke _pasteStroke = _sDefaultPasteStroke;
    private boolean _postUndo = false;
    private ListenerManager _listeners;
    private double _pasteOffset = 0.0;

    public ClipboardTool(SelectedItemProvider selectedItemProvider) {
        if (selectedItemProvider == null) {
            throw new IllegalArgumentException("selection provider cannot be null");
        }
        this._selector = selectedItemProvider;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._postUndo = jLECanvas.hasUndoableEditListeners();
    }

    public void drop() {
        super.drop();
        this._postUndo = false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean fireClipboardToolEvent(int var1_1, LayoutItem[] var2_2) {
        var4_3 = false;
        if (var1_1 == 1 || var1_1 == 3 || var1_1 == 5) {
            var3_4 /* !! */  = new ClipboardToolValidateEvent(this, var1_1, var2_2);
            var4_3 = true;
        } else {
            var3_4 /* !! */  = new ClipboardToolEvent(this, var1_1, var2_2);
        }
        v0 = var5_5 = this._listeners == null ? null : this._listeners.getListeners();
        if (var5_5 != null) ** GOTO lbl28
        return true;
lbl-1000:
        // 1 sources

        {
            var6_6 = (ClipboardToolListener)var5_5.nextElement();
            if (var1_1 == 1) {
                var6_6.itemsCopying(var3_4 /* !! */ );
                continue;
            }
            if (var1_1 == 2) {
                var6_6.itemsCopied(var3_4 /* !! */ );
                continue;
            }
            if (var1_1 == 3) {
                var6_6.itemsCutting(var3_4 /* !! */ );
                continue;
            }
            if (var1_1 == 4) {
                var6_6.itemsCut(var3_4 /* !! */ );
                continue;
            }
            if (var1_1 == 5) {
                var6_6.itemsPasting(var3_4 /* !! */ );
                continue;
            }
            if (var1_1 != 6) continue;
            var6_6.itemsPasted(var3_4 /* !! */ );
lbl28:
            // 8 sources

            ** while (var5_5.hasMoreElements())
        }
lbl29:
        // 1 sources

        return var4_3 ? !((Cancelable)var3_4 /* !! */ ).isCancelled() : true;
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        LayoutItem[] layoutItemArray = null;
        boolean bl = false;
        if (jLEEvent.equals(this._copyStroke)) {
            this.processCopy();
        } else if (jLEEvent.equals(this._cutStroke)) {
            layoutItemArray = this.processCut();
            bl = true;
        } else if (jLEEvent.equals(this._pasteStroke)) {
            layoutItemArray = this.processPaste();
        } else {
            return;
        }
        if (layoutItemArray != null && this._postUndo) {
            ClipboardUndo clipboardUndo = new ClipboardUndo(layoutItemArray, bl, this);
            this.getCanvas().processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)clipboardUndo));
        }
        jLEEvent.consume();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public LayoutItem[] processCopy() {
        LayoutItem[] layoutItemArray = this._selector.getSelectedItems();
        return this.processCopy(layoutItemArray, true);
    }

    public LayoutItem[] processCut(LayoutItem[] layoutItemArray) {
        if (layoutItemArray == null || !this.isOKToCut()) {
            return null;
        }
        JLECanvas jLECanvas = this.getCanvas() != null ? this.getCanvas() : layoutItemArray[0].getCanvas();
        LayoutItem[] layoutItemArray2 = ItemUtils.removeChildren(jLECanvas, layoutItemArray);
        if (!this.fireClipboardToolEvent(3, layoutItemArray2)) {
            return null;
        }
        if ((layoutItemArray2 = this.processCopy(layoutItemArray2, false)) == null) {
            return null;
        }
        int n = 0;
        while (n < layoutItemArray2.length) {
            LayoutItem layoutItem = layoutItemArray2[n];
            LayoutItem layoutItem2 = layoutItem.getItemParent();
            int n2 = ItemUtils.getItemIndex(layoutItem, layoutItem2);
            layoutItem.putProperty(_CUT_PARENT_KEY, layoutItem2);
            layoutItem.putProperty(_CUT_INDEX_KEY, new Integer(n2));
            layoutItem.putProperty(_CUT_KEY, null);
            layoutItem.getItemParent().removeItem(layoutItemArray2[n]);
            ++n;
        }
        this.fireClipboardToolEvent(4, layoutItemArray2);
        jLECanvas.repaintInterior();
        return layoutItemArray2;
    }

    public final LayoutItem[] processCut() {
        LayoutItem[] layoutItemArray = this._selector.getSelectedItems();
        return this.processCut(layoutItemArray);
    }

    public LayoutItem[] processPaste() {
        Clipboard clipboard = ClipboardTool.getClipboard();
        Transferable transferable = clipboard.getContents(this);
        LayoutItem[] layoutItemArray = null;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = -1;
        LayoutItem layoutItem = null;
        Point2D point2D = null;
        if (transferable != null && this.isOKToPaste(transferable)) {
            LayoutItem[] layoutItemArray2 = this._selector.getSelectedItems();
            if (layoutItemArray2.length > 0 && this._pasteOffset != 0.0) {
                LayoutItem layoutItem2 = this._findUpperLeft(layoutItemArray2);
                d = this._pasteOffset;
                point2D = layoutItem2.getItemLocation();
                layoutItem = layoutItem2.getItemParent();
                n = ItemUtils.getItemIndex(layoutItem2, layoutItem);
            }
            int n2 = 0;
            while (n2 < layoutItemArray2.length) {
                this._selector.processDeselect(layoutItemArray2[n2]);
                ++n2;
            }
            try {
                if (transferable.isDataFlavorSupported(_sMultiFlavor)) {
                    layoutItemArray = (LayoutItem[])transferable.getTransferData(_sMultiFlavor);
                    if (!this.fireClipboardToolEvent(5, layoutItemArray)) {
                        return null;
                    }
                    if (layoutItemArray.length > 0 && d > 0.0) {
                        LayoutItem layoutItem3 = this._findUpperLeft(layoutItemArray);
                        Point2D point2D2 = layoutItem3.getItemLocation();
                        d2 -= point2D2.getX();
                        d3 -= point2D2.getY();
                        d2 += d;
                        d3 += d;
                    }
                    int n3 = 0;
                    while (n3 < layoutItemArray.length) {
                        layoutItemArray[n3] = this._pasteItem(layoutItemArray[n3], layoutItem, point2D, d2, d3, n);
                        ++n3;
                    }
                } else if (transferable.isDataFlavorSupported(_sFlavor)) {
                    LayoutItem layoutItem4 = (LayoutItem)transferable.getTransferData(_sFlavor);
                    layoutItemArray = new LayoutItem[]{layoutItem4};
                    if (!this.fireClipboardToolEvent(5, layoutItemArray)) {
                        return null;
                    }
                    if (d > 0.0) {
                        Point2D point2D3 = layoutItem4.getItemLocation();
                        d2 -= point2D3.getX();
                        d3 -= point2D3.getY();
                        d2 += d;
                        d3 += d;
                    }
                    layoutItemArray[0] = this._pasteItem(layoutItem4, layoutItem, point2D, d2, d3, n);
                }
                if (layoutItemArray != null) {
                    this.fireClipboardToolEvent(6, layoutItemArray);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return layoutItemArray;
    }

    public boolean isOKToPaste(Transferable transferable) {
        return transferable != null && (transferable.isDataFlavorSupported(LayoutItemTransfer.MULTI_LAYOUT_ITEM_FLAVOR) || transferable.isDataFlavorSupported(LayoutItemTransfer.LAYOUT_ITEM_FLAVOR));
    }

    public final boolean isOKToPaste() {
        if (!this.isActive()) {
            return false;
        }
        return this.isOKToPaste(ClipboardTool.getClipboard().getContents(this));
    }

    public boolean isOKToCopy() {
        return this._selector.getSelectedItemCount() > 0;
    }

    public boolean isOKToCut() {
        return this._selector.getSelectedItemCount() > 0;
    }

    public KeyStroke getCopyKeyStroke() {
        return this._copyStroke;
    }

    public void setCopyKeyStroke(KeyStroke keyStroke) {
        this._copyStroke = keyStroke;
    }

    public KeyStroke getCutKeyStroke() {
        return this._cutStroke;
    }

    public void setCutKeyStroke(KeyStroke keyStroke) {
        this._cutStroke = keyStroke;
    }

    public KeyStroke getPasteKeyStroke() {
        return this._pasteStroke;
    }

    public void setPasteKeyStroke(KeyStroke keyStroke) {
        this._copyStroke = keyStroke;
    }

    public long getDefaultEnabledEvents() {
        return 8L;
    }

    public SelectedItemProvider getSelectedItemProvider() {
        return this._selector;
    }

    public void addClipboardToolListener(ClipboardToolListener clipboardToolListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)clipboardToolListener);
    }

    public void removeClipboardToolListener(ClipboardToolListener clipboardToolListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)clipboardToolListener);
        }
    }

    protected LayoutItem[] processCopy(LayoutItem[] layoutItemArray, boolean bl) {
        if (layoutItemArray == null || !this.isOKToCopy()) {
            return null;
        }
        if (bl && !this.fireClipboardToolEvent(1, layoutItemArray)) {
            return null;
        }
        LayoutItemTransfer layoutItemTransfer = new LayoutItemTransfer(layoutItemArray);
        Clipboard clipboard = ClipboardTool.getClipboard();
        clipboard.setContents(layoutItemTransfer, this);
        if (bl) {
            this.fireClipboardToolEvent(2, layoutItemArray);
        }
        return layoutItemArray;
    }

    public static Clipboard getClipboard() {
        return _sJLEClipboard;
    }

    public double getPasteOffset() {
        return this._pasteOffset;
    }

    public void setPasteOffset(double d) {
        this._pasteOffset = d;
    }

    private LayoutItem _pasteItem(LayoutItem layoutItem, LayoutItem layoutItem2, Point2D point2D, double d, double d2, int n) {
        Object object;
        int n2;
        LayoutItem layoutItem3 = layoutItem;
        boolean bl = false;
        if (layoutItem.removeProperty(_CUT_KEY) == PropertyManager.NOT_FOUND_OBJECT) {
            bl = true;
            try {
                layoutItem3 = (LayoutItem)layoutItem3.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                layoutItem3 = null;
                return null;
            }
        }
        if (layoutItem3 == null) {
            return null;
        }
        LayoutItem layoutItem4 = layoutItem2 != null ? layoutItem2 : null;
        int n3 = n2 = layoutItem2 != null ? n : -1;
        if (layoutItem4 == null) {
            if (bl) {
                layoutItem4 = layoutItem.getItemParent();
                n2 = ItemUtils.getItemIndex(layoutItem, layoutItem4);
            } else {
                object = layoutItem3.removeProperty(_CUT_PARENT_KEY);
                if (object != PropertyManager.NOT_FOUND_OBJECT) {
                    layoutItem4 = (LayoutItem)object;
                }
                if ((object = layoutItem3.removeProperty(_CUT_INDEX_KEY)) != PropertyManager.NOT_FOUND_OBJECT) {
                    n2 = (Integer)object;
                }
            }
        }
        if (layoutItem4 == null || this.getCanvas() != layoutItem4.getCanvas()) {
            layoutItem4 = this.getCanvas().getContentItem();
        } else if (n2 >= 0 && n2 > layoutItem4.getItemCount()) {
            n2 = -1;
        }
        if (point2D != null) {
            object = layoutItem3.getItemLocation();
            double d3 = ((Point2D)object).getX() + d + point2D.getX();
            double d4 = ((Point2D)object).getY() + d2 + point2D.getY();
            layoutItem3.setItemLocation(d3, d4);
        }
        layoutItem4.addItem(layoutItem3, n2);
        this._selector.processSelect(layoutItem3);
        return layoutItem3;
    }

    private LayoutItem _findUpperLeft(LayoutItem[] layoutItemArray) {
        double d = Double.MAX_VALUE;
        LayoutItem layoutItem = layoutItemArray[0];
        int n = 0;
        while (n < layoutItemArray.length) {
            Point2D point2D = layoutItemArray[n].getItemLocation();
            double d2 = point2D.getX() + point2D.getY();
            if (d2 < d) {
                layoutItem = layoutItemArray[n];
                d = d2;
            }
            ++n;
        }
        return layoutItem;
    }
}

