/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Graphics;
import java.util.EventListener;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutTool;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventListener;
import oracle.bali.jle.event.JLEEventSource;
import oracle.ewt.event.ListenerManager;

public final class CompoundTool
implements LayoutTool,
JLEEventSource,
JLEEventListener {
    private LayoutTool[] _tools;
    private long _enabledEvents;
    private ListenerManager _listeners;
    private JLECanvas _canvas;
    private JLEEventSource _eventSource;
    private int _count;
    private boolean _enabled = true;
    private static int _sCount = 0;

    public CompoundTool(LayoutTool layoutTool, LayoutTool layoutTool2) {
        this(new LayoutTool[]{layoutTool, layoutTool2});
    }

    public CompoundTool(LayoutTool layoutTool, LayoutTool layoutTool2, LayoutTool layoutTool3) {
        this(new LayoutTool[]{layoutTool, layoutTool2, layoutTool3});
    }

    public CompoundTool(LayoutTool[] layoutToolArray) {
        if (layoutToolArray == null || layoutToolArray.length == 0) {
            throw new IllegalArgumentException("must supply at least one LayoutTool");
        }
        this._tools = new LayoutTool[layoutToolArray.length];
        System.arraycopy(layoutToolArray, 0, this._tools, 0, this._tools.length);
        this._enabledEvents = 0L;
        this._count = _sCount++;
    }

    public void drawHighlight(Graphics graphics) {
        int n = 0;
        while (n < this._tools.length) {
            Object var5_4;
            Graphics graphics2 = graphics.create();
            try {
                this._tools[n].drawHighlight(graphics2);
                var5_4 = null;
                graphics2.dispose();
            }
            catch (Throwable throwable) {
                var5_4 = null;
                graphics2.dispose();
                throw throwable;
            }
            ++n;
        }
    }

    public void drop() {
        int n = this._tools.length - 1;
        while (n >= 0) {
            this._tools[n].drop();
            --n;
        }
        this._eventSource.removeJLEEventListener(this);
        this._enabledEvents = 0L;
        this._eventSource = null;
        this._canvas = null;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        this._canvas = jLECanvas;
        this._eventSource = jLEEventSource;
        this._eventSource.addJLEEventListener(this);
        int n = 0;
        while (n < this._tools.length) {
            this._tools[n].pickup(jLECanvas, this);
            ++n;
        }
        this._eventSource.enableJLEEvents(this._enabledEvents);
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void enableJLEEvents(long l) {
        this._enabledEvents |= l;
        if (this._eventSource != null) {
            this._eventSource.enableJLEEvents(l);
        }
    }

    public void addJLEEventListener(JLEEventListener jLEEventListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)jLEEventListener);
    }

    public void removeJLEEventListener(JLEEventListener jLEEventListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)jLEEventListener);
        }
    }

    public void mouseClicked(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void mousePressed(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void mouseReleased(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void mouseEntered(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void mouseExited(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void mouseDragged(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void mouseMoved(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void keyTyped(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void keyPressed(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void keyReleased(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void focusGained(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public void focusLost(JLEEvent jLEEvent) {
        this._processJLEEvent(jLEEvent);
    }

    public LayoutTool[] getTools() {
        LayoutTool[] layoutToolArray = new LayoutTool[this._tools.length];
        System.arraycopy(this._tools, 0, layoutToolArray, 0, layoutToolArray.length);
        return layoutToolArray;
    }

    /*
     * Unable to fully structure code
     */
    private void _processJLEEvent(JLEEvent var1_1) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this._JLEEventEnabled(var1_1.getID())) {
            return;
        }
        v0 = var2_2 = this._listeners == null ? null : this._listeners.getListeners();
        if (var2_2 != null) ** GOTO lbl45
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = (JLEEventListener)var2_2.nextElement();
            switch (var1_1.getID()) {
                case 500: {
                    var3_3.mouseClicked(var1_1);
                    break;
                }
                case 501: {
                    var3_3.mousePressed(var1_1);
                    break;
                }
                case 502: {
                    var3_3.mouseReleased(var1_1);
                    break;
                }
                case 504: {
                    var3_3.mouseEntered(var1_1);
                    break;
                }
                case 505: {
                    var3_3.mouseExited(var1_1);
                    break;
                }
                case 503: {
                    var3_3.mouseMoved(var1_1);
                    break;
                }
                case 506: {
                    var3_3.mouseDragged(var1_1);
                    break;
                }
                case 400: {
                    var3_3.keyTyped(var1_1);
                    break;
                }
                case 401: {
                    var3_3.keyPressed(var1_1);
                    break;
                }
                case 402: {
                    var3_3.keyReleased(var1_1);
                    break;
                }
                case 1004: {
                    var3_3.focusGained(var1_1);
                    break;
                }
                case 1005: {
                    var3_3.focusLost(var1_1);
                }
            }
lbl45:
            // 14 sources

            ** while (var2_2.hasMoreElements())
        }
lbl46:
        // 1 sources

    }

    private boolean _JLEEventEnabled(int n) {
        switch (n) {
            case 503: 
            case 506: {
                if ((this._enabledEvents & 0x20L) == 0L) break;
                return true;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                if ((this._enabledEvents & 0x10L) == 0L) break;
                return true;
            }
            case 400: 
            case 401: 
            case 402: {
                if ((this._enabledEvents & 8L) == 0L) break;
                return true;
            }
            case 1004: 
            case 1005: {
                if ((this._enabledEvents & 4L) == 0L) break;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "CompoundTool" + this._count;
    }
}

