/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.EventListener;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.TransformException;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.CreateToolEvent;
import oracle.bali.jle.tool.CreateToolListener;
import oracle.bali.jle.tool.CreateToolValidateEvent;
import oracle.bali.jle.tool.undo.CreateUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public abstract class CreateTool
extends BaseTool {
    public static final int DRAG_CREATE_MODE = 1;
    public static final int CLICK_CREATE_MODE = 2;
    public static final int ALL_CREATE_MODE = 3;
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private double _defaultWidth = 5.0;
    private double _defaultHeight = 5.0;
    private transient boolean _banding;
    private boolean _yields = true;
    private int _createMode = 1;
    private ListenerManager _listeners;

    protected CreateTool() {
    }

    public void drawHighlight(Graphics graphics) {
        if (this.isDrawingHighlight()) {
            JLECanvas jLECanvas = this.getCanvas();
            Rectangle2D rectangle2D = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
            Rectangle rectangle = jLECanvas.contentToDevice(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            Color color = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
        }
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._endY = 0.0;
        this._startY = 0.0;
        this._endX = 0.0;
        this._startX = 0.0;
        this.setDrawingHighlight(false);
    }

    public long getDefaultEnabledEvents() {
        return 48L;
    }

    public boolean getYieldsAfterUse() {
        return this._yields;
    }

    public void setYieldsAfterUse(boolean bl) {
        this._yields = bl;
    }

    public LayoutItem processCreate(LayoutItem layoutItem, Point2D point2D, Dimension2D cloneable) {
        Cloneable cloneable2;
        Rectangle2D.Double double_ = new Rectangle2D.Double(point2D.getX(), point2D.getY(), cloneable == null ? 0.0 : cloneable.getWidth(), cloneable == null ? 0.0 : cloneable.getHeight());
        if (!this.fireCreateToolEvent(1, null, layoutItem, double_)) {
            return null;
        }
        LayoutItem layoutItem2 = this.createNewItem();
        if (layoutItem2 == null) {
            return null;
        }
        if (cloneable == null || cloneable.getWidth() <= 0.0 || cloneable.getHeight() <= 0.0) {
            cloneable2 = layoutItem2.getItemSize();
            cloneable = ((Dimension2D)cloneable2).getWidth() > 0.0 && ((Dimension2D)cloneable2).getHeight() > 0.0 ? cloneable2 : this.getDefaultCreateSize();
        }
        layoutItem2.setItemSize(cloneable.getWidth(), cloneable.getHeight());
        cloneable2 = layoutItem2.getItemTransform();
        ((AffineTransform)cloneable2).translate(point2D.getX(), point2D.getY());
        try {
            layoutItem2.setItemTransform((AffineTransform)cloneable2);
        }
        catch (TransformException transformException) {
            return null;
        }
        if (!layoutItem.allowsChildren()) {
            return null;
        }
        layoutItem.addItem(layoutItem2, 0);
        this.fireCreateToolEvent(2, layoutItem2, layoutItem, new Rectangle2D.Double(point2D.getX(), point2D.getY(), cloneable.getWidth(), cloneable.getHeight()));
        return layoutItem2;
    }

    public void addCreateToolListener(CreateToolListener createToolListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)createToolListener);
    }

    public void removeCreateToolListener(CreateToolListener createToolListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)createToolListener);
        }
    }

    public void setDefaultCreateSize(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("default size must be non-zero");
        }
        this._defaultWidth = d;
        this._defaultHeight = d2;
    }

    public Dimension2D getDefaultCreateSize() {
        return new Dimension2D.Double(this._defaultWidth, this._defaultHeight);
    }

    public void setCreateMode(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("invalid create mode");
        }
        this._createMode = n;
    }

    public int getCreateMode() {
        return this._createMode;
    }

    protected abstract LayoutItem createNewItem();

    protected void processMousePressed(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        this._startX = jLEEvent.getX();
        this._startY = jLEEvent.getY();
        jLEEvent.consume();
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        LayoutItem layoutItem = null;
        LayoutItem layoutItem2 = ItemUtils.getParentAt(this.getCanvas().getContentItem(), this._startX, this._startY);
        if (layoutItem2 != null) {
            Object object;
            Dimension2D dimension2D = null;
            Point2D point2D = null;
            boolean bl = false;
            if ((this.getCreateMode() & 1) != 0 && this.isDrawingHighlight()) {
                object = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
                object = ItemUtils.transformRect(this.getCanvas().getDeviceTransform(), ((Rectangle2D)object).getX(), ((Rectangle2D)object).getY(), ((Rectangle2D)object).getWidth(), ((Rectangle2D)object).getHeight(), false);
                object = ItemUtils.deviceToItem(layoutItem2, (Rectangle2D)object);
                dimension2D = new Dimension2D.Double(((Rectangle2D)object).getWidth(), ((Rectangle2D)object).getHeight());
                point2D = new Point2D.Double(((Rectangle2D)object).getX(), ((Rectangle2D)object).getY());
                bl = true;
            } else if ((this.getCreateMode() & 2) != 0 && !this.isDrawingHighlight()) {
                point2D = ItemUtils.transformPoint(this.getCanvas().getDeviceTransform(), new Point2D.Double(this._startX, this._startY), false);
                point2D = ItemUtils.deviceToItem(layoutItem2, point2D);
                bl = true;
            }
            if (bl) {
                layoutItem = this.processCreate(layoutItem2, point2D, dimension2D);
                if (dimension2D == null) {
                    dimension2D = layoutItem.getItemSize();
                }
                object = this.getCanvas();
                if (layoutItem != null && ((JLECanvas)object).hasUndoableEditListeners()) {
                    CreateUndo createUndo = new CreateUndo(layoutItem, layoutItem2);
                    ((JLECanvas)object).processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)createUndo));
                }
            }
        }
        this.setDrawingHighlight(false);
        this.setImmediateRect(null);
        this.updateImmediately();
        jLEEvent.consume();
        if (this.getYieldsAfterUse() && layoutItem != null) {
            this.yield();
        }
    }

    protected void processMouseDragged(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        if ((this.getCreateMode() & 1) == 0) {
            return;
        }
        this.setDrawingHighlight(true);
        this._endX = jLEEvent.getX();
        this._endY = jLEEvent.getY();
        Rectangle2D rectangle2D = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
        this.addImmediateRect(rectangle2D);
        this.updateImmediately();
        jLEEvent.consume();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected boolean fireCreateToolEvent(int var1_1, LayoutItem var2_2, LayoutItem var3_3, Rectangle2D var4_4) {
        var6_5 = false;
        if (var1_1 == 1) {
            var5_6 /* !! */  = new CreateToolValidateEvent(this, var1_1, var2_2, var3_3, var4_4);
            var6_5 = true;
        } else {
            var5_6 /* !! */  = new CreateToolEvent(this, var1_1, var2_2, var3_3, var4_4);
        }
        v0 = var7_7 = this._listeners == null ? null : this._listeners.getListeners();
        if (var7_7 != null) ** GOTO lbl16
        return true;
lbl-1000:
        // 1 sources

        {
            var8_8 = (CreateToolListener)var7_7.nextElement();
            if (var1_1 == 1) {
                var8_8.itemCreating(var5_6 /* !! */ );
                continue;
            }
            if (var1_1 != 2) continue;
            var8_8.itemCreated(var5_6 /* !! */ );
lbl16:
            // 4 sources

            ** while (var7_7.hasMoreElements())
        }
lbl17:
        // 1 sources

        return var6_5 ? !((Cancelable)var5_6 /* !! */ ).isCancelled() : true;
    }

    protected final boolean isDrawingHighlight() {
        return this._banding;
    }

    protected final void setDrawingHighlight(boolean bl) {
        this._banding = bl;
    }

    protected final ListenerManager getCreateListeners() {
        return this._listeners;
    }
}

