/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Component;
import java.util.EventListener;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseItem;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.EventPassthroughTool;
import oracle.bali.jle.tool.InlineEditHandler;
import oracle.bali.jle.tool.InlineEditToolEvent;
import oracle.bali.jle.tool.InlineEditToolListener;
import oracle.bali.jle.tool.undo.InlineEditUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public class InlineEditTool
extends BaseTool {
    public static final Object EDIT_HANDLER_KEY = new StringKey("EDIT_HANDLER_KEY");
    private boolean _postUndo;
    private LayoutItem _editing;
    private int _savedIndex;
    private LayoutItem _editControl;
    private InlineEditHandler _handler;
    private EventPassthroughTool _passthrough;
    private boolean _reEnablePassthrough;
    private LayoutItem _firstClick;
    private boolean _commit;
    private Object _oldValue;
    private double _pressX;
    private double _pressY;
    private double _mouseTolX;
    private double _mouseTolY;
    private ListenerManager _listeners;
    private transient boolean _restoreCaching;
    private static double _MOUSE_TOLERANCE = 1.0;

    public InlineEditTool(EventPassthroughTool eventPassthroughTool) {
        if (eventPassthroughTool == null) {
            throw new IllegalArgumentException("passthrough can't be null");
        }
        this._passthrough = eventPassthroughTool;
    }

    public static InlineEditHandler getInlineEditHandler(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(EDIT_HANDLER_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT ? null : (InlineEditHandler)object;
    }

    public static void setInlineEditHandler(LayoutItem layoutItem, InlineEditHandler inlineEditHandler) {
        if (layoutItem == null) {
            return;
        }
        Object object = inlineEditHandler == null ? PropertyManager.NOT_FOUND_OBJECT : inlineEditHandler;
        layoutItem.putProperty(EDIT_HANDLER_KEY, object);
    }

    public void drop() {
        super.drop();
        this._postUndo = false;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._mouseTolX = _MOUSE_TOLERANCE * jLECanvas.getEngineUnitsPerPixelX();
        this._mouseTolY = _MOUSE_TOLERANCE * jLECanvas.getEngineUnitsPerPixelY();
        this._postUndo = jLECanvas.hasUndoableEditListeners();
    }

    public long getDefaultEnabledEvents() {
        return 24L;
    }

    public EventPassthroughTool getEventPassthroughTool() {
        return this._passthrough;
    }

    public void processInlineEditStart(LayoutItem layoutItem, InlineEditHandler inlineEditHandler, JLEEvent jLEEvent) {
        if (layoutItem == null || inlineEditHandler == null) {
            throw new IllegalArgumentException();
        }
        this._editControl = inlineEditHandler.getEditControlItem();
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        if (layoutItem2 == null) {
            return;
        }
        this._savedIndex = ItemUtils.getItemIndex(layoutItem, layoutItem2);
        Rectangle2D rectangle2D = layoutItem.getItemBounds();
        layoutItem2.removeItem(layoutItem);
        layoutItem2.repaintItem();
        this._editing = layoutItem;
        this._oldValue = inlineEditHandler.startEdit(this, layoutItem);
        this.fireInlineEditToolEvent(1, layoutItem, this._oldValue);
        this._editControl.setItemSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        this._editControl.setItemLocation(rectangle2D.getX(), rectangle2D.getY());
        layoutItem2.addItem(this._editControl);
        if (BaseItem.isZoomCachingAllowed()) {
            this._restoreCaching = true;
            BaseItem.setZoomCachingAllowed(false);
        }
        this._reEnablePassthrough = this._passthrough.isEnabled();
        LayoutItem[] layoutItemArray = new LayoutItem[]{this._editControl};
        this._passthrough.setTargetItems(layoutItemArray);
        this._passthrough.setForcedMouseConsumption(true);
        this._passthrough.setEnabled(true);
        this.getCanvas().setFocusedItem(this._editControl);
        this._passthrough.processJLEEvent(jLEEvent);
    }

    public void processInlineEditCommit(LayoutItem layoutItem, InlineEditHandler inlineEditHandler) {
        if (layoutItem == null || inlineEditHandler == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItem != this._editing) {
            return;
        }
        Object object = inlineEditHandler.commitEdit(this, layoutItem);
        this.fireInlineEditToolEvent(3, layoutItem, object);
        if (this._postUndo) {
            InlineEditUndo inlineEditUndo = new InlineEditUndo(layoutItem, this._oldValue, object);
            this.getCanvas().processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)inlineEditUndo));
        }
        this._oldValue = null;
        this._restoreItem();
    }

    public void processInlineEditCancel(LayoutItem layoutItem, InlineEditHandler inlineEditHandler) {
        if (layoutItem == null || inlineEditHandler == null) {
            throw new IllegalArgumentException();
        }
        if (layoutItem != this._editing) {
            return;
        }
        inlineEditHandler.cancelEdit(this, layoutItem);
        this.fireInlineEditToolEvent(2, layoutItem, this._oldValue);
        this._restoreItem();
    }

    public void addInlineEditToolListener(InlineEditToolListener inlineEditToolListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)inlineEditToolListener);
    }

    public void removeInlineEditToolListener(InlineEditToolListener inlineEditToolListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)inlineEditToolListener);
        }
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas == null) {
            return;
        }
        LayoutItem layoutItem = jLECanvas.getHitItem(jLEEvent.getX(), jLEEvent.getY());
        if (this._editing != null && (layoutItem == null || layoutItem != this._editControl)) {
            this.processInlineEditCommit(this._editing, this._handler);
            return;
        }
        this._pressX = jLEEvent.getX();
        this._pressY = jLEEvent.getY();
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        LayoutItem layoutItem = this.getCanvas().getHitItem(jLEEvent.getX(), jLEEvent.getY());
        if (layoutItem == null) {
            return;
        }
        InlineEditHandler inlineEditHandler = InlineEditTool.getInlineEditHandler(layoutItem);
        if (inlineEditHandler == null) {
            return;
        }
        this._handler = inlineEditHandler;
        if (jLEEvent.isConsumed()) {
            if (this._firstClick == layoutItem) {
                if (Math.abs(jLEEvent.getX() - this._pressX) > this._mouseTolX || Math.abs(jLEEvent.getY() - this._pressY) > this._mouseTolY) {
                    return;
                }
                this._firstClick = null;
                this.processInlineEditStart(layoutItem, this._handler, new JLEEvent(jLEEvent.getSource(), 501, jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getX(), jLEEvent.getY(), jLEEvent.getClickCount()));
            } else {
                this._firstClick = layoutItem;
            }
        } else {
            this._firstClick = null;
            this.processInlineEditStart(layoutItem, this._handler, new JLEEvent(jLEEvent.getSource(), 501, jLEEvent.getWhen(), jLEEvent.getModifiers(), jLEEvent.getX(), jLEEvent.getY(), jLEEvent.getClickCount()));
        }
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        if (this._editing != null && this._handler != null && jLEEvent.getKeyChar() == '\u001b') {
            jLEEvent.consume();
            this.processInlineEditCancel(this._editing, this._handler);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void fireInlineEditToolEvent(int var1_1, LayoutItem var2_2, Object var3_3) {
        var4_4 = new InlineEditToolEvent(this, var1_1, var2_2, var3_3);
        v0 = var5_5 = this._listeners == null ? null : this._listeners.getListeners();
        if (var5_5 != null) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            var6_6 = (InlineEditToolListener)var5_5.nextElement();
            if (var1_1 == 1) {
                var6_6.itemEditStarting(var4_4);
                continue;
            }
            if (var1_1 == 2) {
                var6_6.itemEditCancelling(var4_4);
                continue;
            }
            if (var1_1 != 3) continue;
            var6_6.itemEditCommitting(var4_4);
lbl14:
            // 5 sources

            ** while (var5_5.hasMoreElements())
        }
lbl15:
        // 1 sources

    }

    private void _restoreItem() {
        LayoutItem layoutItem = this._editControl.getItemParent();
        layoutItem.removeItem(this._editControl);
        layoutItem.addItem(this._editing, this._savedIndex);
        this._passthrough.setEnabled(this._reEnablePassthrough);
        this._passthrough.setTargetItems(null);
        this._passthrough.setForcedMouseConsumption(false);
        ((Component)((Object)this.getCanvas().getGlassComponent())).requestFocus();
        if (this._restoreCaching) {
            BaseItem.setZoomCachingAllowed(true);
            if (this._editing instanceof BaseItem) {
                ((BaseItem)this._editing).invalidateZoomImage();
            }
        }
        this._restoreCaching = false;
        this._editing = null;
        this._editControl = null;
    }
}

