/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import oracle.bali.jle.JLEAutoScroller;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.PropertyManager;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.tool.ActivationEvent;
import oracle.bali.jle.tool.ActivationListener;
import oracle.bali.jle.tool.BaseTool;
import oracle.bali.jle.tool.DefaultBoundsPainter;
import oracle.bali.jle.tool.SelectedItemProvider;
import oracle.bali.jle.tool.SelectionEvent;
import oracle.bali.jle.tool.SelectionListener;
import oracle.bali.jle.tool.SelectionPainter;
import oracle.bali.jle.tool.SelectionValidateEvent;
import oracle.bali.jle.tool.undo.DeleteUndo;
import oracle.bali.jle.tool.undo.SelectionUndo;
import oracle.bali.jle.util.GeometryUtils;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.event.Cancelable;
import oracle.ewt.event.ListenerManager;
import oracle.ewt.undo.CompoundEdit;
import oracle.ewt.undo.UndoableEdit;
import oracle.ewt.undo.UndoableEditEvent;

public class SelectionTool
extends BaseTool
implements SelectedItemProvider,
PropertyChangeListener {
    public static final Object SELECTED_KEY = new StringKey("SELECTED_KEY");
    public static final Object REJECT_SELECTION_KEY = new StringKey("REJECT_SELECTION_KEY");
    private Vector _selectedItems = new Vector();
    private transient boolean _selecting;
    private transient boolean _gotPress;
    private transient boolean _autoscrolling;
    private double _startX;
    private double _startY;
    private double _endX;
    private double _endY;
    private SelectionPainter _painter;
    private boolean _postUndo;
    private ListenerManager _listeners;
    private ListenerManager _aListeners;
    private boolean _deleteAllowed = true;
    private boolean _multipleSelectAllowed = true;

    public void drawHighlight(Graphics graphics) {
        Object object;
        Object object2;
        Object object3;
        if (this._selecting) {
            object3 = this.getCanvas();
            object2 = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
            Rectangle rectangle = ((JLECanvas)object3).contentToDevice(((Rectangle2D)object2).getX(), ((Rectangle2D)object2).getY(), ((Rectangle2D)object2).getWidth(), ((Rectangle2D)object2).getHeight());
            object = graphics.getColor();
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor((Color)object);
        }
        object3 = this.getSelectionPainter();
        if (this.getSelectedItemCount() > 0 && ((LayoutItem[])(object2 = this.getSelectedItems())).length > 0) {
            int n = 0;
            while (n < ((Object)object2).length) {
                object = object2[n];
                Rectangle2D rectangle2D = object.getItemBounds();
                Rectangle rectangle = ItemUtils.parentToDevice((LayoutItem)object, rectangle2D);
                object3.drawSelection(graphics, (LayoutItem)object, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n;
            }
        }
    }

    public long getDefaultEnabledEvents() {
        return 56L;
    }

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._endY = 0.0;
        this._startY = 0.0;
        this._endX = 0.0;
        this._startX = 0.0;
        this._selecting = false;
        this._autoscrolling = false;
        this._postUndo = jLECanvas.hasUndoableEditListeners();
    }

    public void drop() {
        this._postUndo = false;
        this._autoscrolling = false;
        super.drop();
    }

    protected void processMouseClicked(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        if (!this.isPrimaryMouseEvent(jLEEvent)) {
            this.fireActivationEvent(2, jLEEvent);
        } else if (jLEEvent.getClickCount() > 1 && this.getSelectedItemCount() > 0) {
            this.fireActivationEvent(1, jLEEvent);
        }
    }

    protected void processMousePressed(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        if (this.isPrimaryMouseEvent(jLEEvent)) {
            this._gotPress = true;
        }
        this._startX = this._endX = jLEEvent.getX();
        this._startY = this._endY = jLEEvent.getY();
        JLECanvas jLECanvas = this.getCanvas();
        LayoutItem layoutItem = SelectionTool.getSelectableItemAt(jLECanvas, this._startX, this._startY);
        int n = jLEEvent.getModifiers();
        if ((n & 3) == 0 || layoutItem == null || !this.isMultipleSelectAllowed()) {
            Object object;
            int n2 = this._selectedItems.size();
            if (n2 > 0) {
                object = new LayoutItem[n2];
                this._selectedItems.copyInto((Object[])object);
                int n3 = 0;
                while (n3 < n2) {
                    Object object2 = object[n3];
                    this.processDeselect((LayoutItem)object2, jLEEvent);
                    if (this._postUndo) {
                        SelectionUndo selectionUndo = new SelectionUndo((LayoutItem)object2, false, this);
                        jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)selectionUndo));
                    }
                    ++n3;
                }
                jLEEvent.consume();
            }
            if (layoutItem != null) {
                this.processSelect(layoutItem, jLEEvent);
                if (this._postUndo) {
                    object = new SelectionUndo(layoutItem, true, this);
                    jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)object));
                }
                jLEEvent.consume();
            }
        } else if (layoutItem != null) {
            boolean bl = SelectionTool.isSelected(layoutItem);
            if (bl) {
                this.processDeselect(layoutItem, jLEEvent);
            } else {
                this.processSelect(layoutItem, jLEEvent);
            }
            if (this._postUndo) {
                SelectionUndo selectionUndo = new SelectionUndo(layoutItem, !bl, this);
                jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)selectionUndo));
            }
            jLEEvent.consume();
        }
        if (layoutItem != null) {
            layoutItem.repaintItem();
        }
    }

    protected void processMouseReleased(JLEEvent jLEEvent) {
        JLEAutoScroller.getJLEAutoScroller().cancel();
        this._autoscrolling = false;
        this._gotPress = false;
        this._selecting = false;
        this._endY = 0.0;
        this._endX = 0.0;
        this._startY = 0.0;
        this._startX = 0.0;
        this.setImmediateRect(null);
        this.updateImmediately();
    }

    protected void processMouseDragged(JLEEvent jLEEvent) {
        if (!(this._gotPress && this.isMultipleSelectAllowed() && this.isPrimaryMouseEvent(jLEEvent))) {
            return;
        }
        this._autoscrolling = JLEAutoScroller.getJLEAutoScroller().checkAutoScroll(this.getCanvas(), jLEEvent);
        this._selecting = true;
        this._endX = jLEEvent.getX();
        this._endY = jLEEvent.getY();
        Rectangle2D rectangle2D = GeometryUtils.getDrawRect(this._startX, this._startY, this._endX, this._endY);
        this._rectangleSelect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        this.addImmediateRect(rectangle2D);
        this.updateImmediately();
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed()) {
            return;
        }
        int n = jLEEvent.getKeyCode();
        switch (n) {
            case 8: 
            case 127: {
                if (!this.isDeleteAllowed() || this.getSelectedItemCount() == 0) {
                    return;
                }
                LayoutItem[] layoutItemArray = this.getSelectedItems();
                JLECanvas jLECanvas = this.getCanvas();
                Object object = this._postUndo && layoutItemArray.length > 1 ? new CompoundEdit() : null;
                int n2 = 0;
                while (n2 < layoutItemArray.length) {
                    LayoutItem layoutItem = layoutItemArray[n2];
                    int n3 = -1;
                    LayoutItem layoutItem2 = null;
                    if (this._postUndo) {
                        layoutItem2 = layoutItem.getItemParent();
                        n3 = ItemUtils.getItemIndex(layoutItem, layoutItem2);
                    }
                    this.processDelete(layoutItem, jLEEvent);
                    if (this._postUndo) {
                        DeleteUndo deleteUndo = new DeleteUndo(layoutItem, layoutItem2, n3);
                        if (layoutItemArray.length > 1) {
                            object.addEdit((UndoableEdit)deleteUndo);
                        } else {
                            object = deleteUndo;
                        }
                    }
                    ++n2;
                }
                if (this._postUndo) {
                    if (layoutItemArray.length > 1) {
                        object.end();
                    }
                    jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)object));
                }
                jLEEvent.consume();
                break;
            }
            case 9: {
                boolean bl = jLEEvent.isControlDown();
                if (bl) {
                    ((Component)((Object)this.getCanvas())).transferFocus();
                    return;
                }
                boolean bl2 = jLEEvent.isShiftDown();
                LayoutItem[] layoutItemArray = this.getSelectedItems();
                int n4 = this.getSelectedItemCount();
                LayoutItem layoutItem = n4 == 0 ? null : (bl2 ? layoutItemArray[0] : layoutItemArray[n4 - 1]);
                LayoutItem layoutItem3 = layoutItem;
                while ((layoutItem = bl2 ? this.getCanvas().getFocusPrevious(layoutItem, true) : this.getCanvas().getFocusNext(layoutItem, true)) != null && !SelectionTool.isSelectable(layoutItem) && layoutItem != layoutItem3) {
                }
                if (layoutItem == null || !SelectionTool.isSelectable(layoutItem)) {
                    return;
                }
                int n5 = 0;
                while (n5 < layoutItemArray.length) {
                    this.processDeselect(layoutItemArray[n5], jLEEvent);
                    ++n5;
                }
                this.processSelect(layoutItem, jLEEvent);
                jLEEvent.consume();
            }
        }
    }

    public boolean isDeleteAllowed() {
        return this._deleteAllowed;
    }

    public void setDeleteAllowed(boolean bl) {
        this._deleteAllowed = bl;
    }

    public void setMultipleSelectAllowed(boolean bl) {
        this._multipleSelectAllowed = bl;
    }

    public boolean isMultipleSelectAllowed() {
        return this._multipleSelectAllowed;
    }

    public final boolean toggleSelection(LayoutItem layoutItem) {
        if (SelectionTool.isSelected(layoutItem)) {
            return this.processDeselect(layoutItem);
        }
        return this.processSelect(layoutItem);
    }

    public final boolean processSelect(LayoutItem layoutItem) {
        return this.processSelect(layoutItem, null);
    }

    public boolean processSelect(LayoutItem layoutItem, EventObject eventObject) {
        AccessibleContext accessibleContext;
        if (!this.fireSelectionEvent(1, layoutItem, eventObject)) {
            return false;
        }
        if (!SelectionTool.setSelected(layoutItem, true)) {
            return false;
        }
        if (!this._selectedItems.contains(layoutItem)) {
            this._selectedItems.addElement(layoutItem);
        }
        layoutItem.getPropertyManager().addPropertyChangeListener(this);
        this.fireSelectionEvent(2, layoutItem, eventObject);
        layoutItem.repaintItem();
        JLECanvas jLECanvas = this.getCanvas();
        if (jLECanvas != null && (accessibleContext = jLECanvas.getAccessibleContext()) != null) {
            String string = layoutItem.getAccessibleContext().getAccessibleName();
            jLECanvas.getGlassComponent().getAccessibleContext().setAccessibleName(string);
        }
        return true;
    }

    public final boolean processDeselect(LayoutItem layoutItem) {
        return this.processDeselect(layoutItem, null);
    }

    public boolean processDeselect(LayoutItem layoutItem, EventObject eventObject) {
        if (!this.fireSelectionEvent(3, layoutItem, eventObject)) {
            return false;
        }
        layoutItem.getPropertyManager().removePropertyChangeListener(this);
        SelectionTool.setSelected(layoutItem, false);
        if (this._selectedItems.contains(layoutItem)) {
            this._selectedItems.removeElement(layoutItem);
        }
        this.fireSelectionEvent(4, layoutItem, eventObject);
        layoutItem.repaintItem();
        JLECanvas jLECanvas = this.getCanvas();
        AccessibleContext accessibleContext = jLECanvas.getAccessibleContext();
        if (accessibleContext != null) {
            jLECanvas.getGlassComponent().getAccessibleContext().setAccessibleName(null);
        }
        return true;
    }

    public void processDeselectAll() {
        this.processDeselectAll(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDeselectAll(EventObject eventObject) {
        JLECanvas jLECanvas = this.getCanvas();
        LayoutItem[] layoutItemArray = this.getSelectedItems();
        if (jLECanvas != null) {
            jLECanvas.freezeRepaints();
        }
        try {
            int n = 0;
            while (n < layoutItemArray.length) {
                this.processDeselect(layoutItemArray[n], eventObject);
                ++n;
            }
            Object var6_5 = null;
            if (jLECanvas == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (jLECanvas == null) throw throwable;
            jLECanvas.unfreezeRepaints();
            throw throwable;
        }
        jLECanvas.unfreezeRepaints();
    }

    public final boolean processDelete(LayoutItem layoutItem) {
        return this.processDelete(layoutItem, null);
    }

    public boolean processDelete(LayoutItem layoutItem, EventObject eventObject) {
        JLEEventSource jLEEventSource;
        if (!this.fireSelectionEvent(5, layoutItem, eventObject)) {
            return false;
        }
        if (SelectionTool.isSelected(layoutItem)) {
            this.processDeselect(layoutItem, eventObject);
            if (this._postUndo) {
                jLEEventSource = this.getCanvas();
                SelectionUndo selectionUndo = new SelectionUndo(layoutItem, false, this);
                ((JLECanvas)jLEEventSource).processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)selectionUndo));
            }
        }
        if ((jLEEventSource = layoutItem.getItemParent()) != null) {
            jLEEventSource.removeItem(layoutItem);
        }
        this.fireSelectionEvent(6, layoutItem, eventObject);
        if (jLEEventSource != null) {
            jLEEventSource.repaintItem();
        }
        return true;
    }

    public SelectionPainter getSelectionPainter() {
        if (this._painter == null) {
            this._painter = DefaultBoundsPainter.getPainter();
        }
        return this._painter;
    }

    public void setSelectionPainter(SelectionPainter selectionPainter) {
        this._painter = selectionPainter;
    }

    public int getSelectedItemCount() {
        return this._selectedItems.size();
    }

    public LayoutItem[] getSelectedItems() {
        Object[] objectArray = new LayoutItem[this._selectedItems.size()];
        this._selectedItems.copyInto(objectArray);
        return objectArray;
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        if (this._listeners == null) {
            this._listeners = new ListenerManager();
        }
        this._listeners.addListener((EventListener)selectionListener);
    }

    public void addActivationListener(ActivationListener activationListener) {
        if (this._aListeners == null) {
            this._aListeners = new ListenerManager();
        }
        this._aListeners.addListener((EventListener)activationListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        if (this._listeners != null) {
            this._listeners.removeListener((EventListener)selectionListener);
        }
    }

    public void removeActivationListener(ActivationListener activationListener) {
        if (this._aListeners != null) {
            this._aListeners.removeListener((EventListener)activationListener);
        }
    }

    public static boolean isSelected(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(SELECTED_KEY);
        return object != PropertyManager.NOT_FOUND_OBJECT;
    }

    public static boolean setSelected(LayoutItem layoutItem, boolean bl) {
        if (bl) {
            Object object = layoutItem.getProperty(REJECT_SELECTION_KEY);
            if (object != PropertyManager.NOT_FOUND_OBJECT) {
                return false;
            }
            layoutItem.putProperty(SELECTED_KEY, null);
        } else {
            layoutItem.removeProperty(SELECTED_KEY);
        }
        return true;
    }

    public static boolean isSelectable(LayoutItem layoutItem) {
        Object object = layoutItem.getProperty(REJECT_SELECTION_KEY);
        return object == PropertyManager.NOT_FOUND_OBJECT;
    }

    public static void setSelectable(LayoutItem layoutItem, boolean bl) {
        if (bl) {
            layoutItem.removeProperty(REJECT_SELECTION_KEY);
        } else {
            layoutItem.removeProperty(SELECTED_KEY);
            layoutItem.putProperty(REJECT_SELECTION_KEY, null);
        }
    }

    public static LayoutItem getSelectableItemAt(JLECanvas jLECanvas, double d, double d2) {
        LayoutItem layoutItem = jLECanvas.getHitItem(d, d2);
        while (layoutItem != null && !SelectionTool.isSelectable(layoutItem)) {
            layoutItem = layoutItem.getItemParent();
        }
        return layoutItem;
    }

    public static LayoutItem getSelectedItemAt(JLECanvas jLECanvas, double d, double d2) {
        LayoutItem layoutItem = jLECanvas.getHitItem(d, d2);
        while (layoutItem != null && !SelectionTool.isSelected(layoutItem)) {
            layoutItem = layoutItem.getItemParent();
        }
        return layoutItem;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        LayoutItem layoutItem;
        String string = propertyChangeEvent.getPropertyName();
        if (LayoutItem.DEVICE_TRANSFORM_KEY.equals(string) || LayoutItem.BOUNDS_KEY.equals(string)) {
            LayoutItem layoutItem2 = (LayoutItem)propertyChangeEvent.getSource();
            if (layoutItem2.getCanvas() != null) {
                this.refreshSelection(layoutItem2);
            }
        } else if (LayoutItem.PARENT_KEY.equals(string) && (layoutItem = (LayoutItem)propertyChangeEvent.getSource()).getCanvas() == null) {
            this.processDeselect(layoutItem, propertyChangeEvent);
        }
    }

    protected boolean fireSelectionEvent(int n, LayoutItem layoutItem, EventObject eventObject) {
        SelectionEvent selectionEvent;
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._listeners == null ? null : this._listeners.getListeners();
        if (enumeration == null) {
            return true;
        }
        boolean bl = false;
        switch (n) {
            case 1: 
            case 3: 
            case 5: {
                selectionEvent = new SelectionValidateEvent(this, n, layoutItem, eventObject);
                bl = true;
                break;
            }
            default: {
                selectionEvent = new SelectionEvent(this, n, layoutItem, eventObject);
                break;
            }
        }
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    selectionListener.itemSelecting(selectionEvent);
                    break;
                }
                case 2: {
                    selectionListener.itemSelected(selectionEvent);
                    break;
                }
                case 3: {
                    selectionListener.itemDeselecting(selectionEvent);
                    break;
                }
                case 4: {
                    selectionListener.itemDeselected(selectionEvent);
                    break;
                }
                case 5: {
                    selectionListener.itemDeleting(selectionEvent);
                    break;
                }
                case 6: {
                    selectionListener.itemDeleted(selectionEvent);
                }
            }
        }
        return bl ? !((Cancelable)selectionEvent).isCancelled() : true;
    }

    protected void fireActivationEvent(int n, JLEEvent jLEEvent) {
        Enumeration enumeration;
        Enumeration enumeration2 = enumeration = this._aListeners == null ? null : this._aListeners.getListeners();
        if (enumeration == null) {
            return;
        }
        ActivationEvent activationEvent = new ActivationEvent(this, n, jLEEvent);
        while (enumeration.hasMoreElements()) {
            ActivationListener activationListener = (ActivationListener)enumeration.nextElement();
            switch (n) {
                case 1: {
                    activationListener.selectionActivated(activationEvent);
                    break;
                }
                case 2: {
                    activationListener.secondaryMouseClicked(activationEvent);
                }
            }
        }
    }

    protected void refreshSelection(LayoutItem layoutItem) {
    }

    private void _rectangleSelect(double d, double d2, double d3, double d4) {
        BaseContainer baseContainer = this.getCanvas().getContentItem();
        Vector vector = ItemUtils.getAllItems(baseContainer);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SelectionUndo selectionUndo;
            JLECanvas jLECanvas;
            LayoutItem layoutItem = (LayoutItem)enumeration.nextElement();
            Rectangle2D rectangle2D = ItemUtils.parentToContent(layoutItem, layoutItem.getItemBounds());
            boolean bl = rectangle2D.intersects(d, d2, d3, d4);
            boolean bl2 = SelectionTool.isSelected(layoutItem);
            if (!SelectionTool.isSelectable(layoutItem)) continue;
            if (!bl2 && bl) {
                this.processSelect(layoutItem);
                if (this._postUndo) {
                    jLECanvas = this.getCanvas();
                    selectionUndo = new SelectionUndo(layoutItem, true, this);
                    jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)selectionUndo));
                }
                this.addImmediateRect(rectangle2D);
                continue;
            }
            if (!bl2 || bl) continue;
            this.processDeselect(layoutItem);
            if (this._postUndo) {
                jLECanvas = this.getCanvas();
                selectionUndo = new SelectionUndo(layoutItem, false, this);
                jLECanvas.processUndoableEditEvent(new UndoableEditEvent((Object)this, (UndoableEdit)selectionUndo));
            }
            this.addImmediateRect(rectangle2D);
        }
    }
}

