/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.awt.Toolkit;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.event.JLEEvent;
import oracle.bali.jle.event.JLEEventSource;
import oracle.bali.jle.tool.BaseTool;
import oracle.ewt.event.KeyStroke;
import oracle.ewt.undo.CannotRedoException;
import oracle.ewt.undo.CannotUndoException;
import oracle.ewt.undo.UndoManager;

public class UndoTool
extends BaseTool {
    private static final KeyStroke _sDefaultUndoStroke = new KeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final KeyStroke _sDefaultRedoStroke = new KeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1);
    private UndoManager _manager;
    private KeyStroke _undoStroke = _sDefaultUndoStroke;
    private KeyStroke _redoStroke = _sDefaultRedoStroke;

    public void pickup(JLECanvas jLECanvas, JLEEventSource jLEEventSource) {
        super.pickup(jLECanvas, jLEEventSource);
        this._manager = jLECanvas.getUndoManager();
    }

    public void drop() {
        super.drop();
        this._manager = null;
    }

    protected void processKeyPressed(JLEEvent jLEEvent) {
        if (jLEEvent.isConsumed() || this._manager == null) {
            return;
        }
        if (jLEEvent.equals(this._undoStroke)) {
            this.processUndo();
            jLEEvent.consume();
        } else if (jLEEvent.equals(this._redoStroke)) {
            this.processRedo();
            jLEEvent.consume();
        }
    }

    public long getDefaultEnabledEvents() {
        return 8L;
    }

    public void processUndo() {
        try {
            this._manager.undo();
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
    }

    public void processRedo() {
        try {
            this._manager.redo();
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public KeyStroke getUndoKeyStroke() {
        return this._undoStroke;
    }

    public void setUndoKeyStroke(KeyStroke keyStroke) {
        this._undoStroke = keyStroke;
    }

    public KeyStroke getRedoKeyStroke() {
        return this._redoStroke;
    }

    public void setRedoKeyStroke(KeyStroke keyStroke) {
        this._redoStroke = keyStroke;
    }
}

