/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.ClipboardTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class ClipboardUndo
extends LocalizedEdit {
    private LayoutItem[] _items;
    private boolean _isCut;
    private ClipboardTool _tool;

    public ClipboardUndo(LayoutItem[] layoutItemArray, boolean bl, ClipboardTool clipboardTool) {
        if (layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        this._items = layoutItemArray;
        this._isCut = bl;
        this._tool = clipboardTool;
    }

    public void undo() {
        super.undo();
        if (this._isCut) {
            this._tool.processPaste();
        } else {
            this._tool.processCut(this._items);
        }
    }

    public void redo() {
        super.redo();
        if (!this._isCut) {
            this._tool.processPaste();
        } else {
            this._tool.processCut(this._items);
        }
    }

    public void die() {
        super.die();
        this._items = null;
    }

    public String getBaseKey() {
        return this._isCut ? "CUT" : "PASTE";
    }

    public LayoutItem[] getItems() {
        LayoutItem[] layoutItemArray = new LayoutItem[this._items.length];
        System.arraycopy(this._items, 0, layoutItemArray, 0, this._items.length);
        return layoutItemArray;
    }

    public boolean isCut() {
        return this._isCut;
    }
}

