/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.tool.undo.LocalizedEdit;
import oracle.bali.jle.util.ItemUtils;
import oracle.ewt.util.Assert;

public class CreateUndo
extends LocalizedEdit {
    private LayoutItem _created;
    private LayoutItem _parent;
    private int _createdIndex;

    public CreateUndo(LayoutItem layoutItem, LayoutItem layoutItem2) {
        if (layoutItem == null || layoutItem2 == null) {
            throw new IllegalArgumentException();
        }
        this._created = layoutItem;
        this._parent = layoutItem2;
    }

    public void undo() {
        super.undo();
        Assert.assert((this._created.getItemParent() == this._parent ? 1 : 0) != 0, (String)"CreateUndo: item is not parented to expected parent");
        this._createdIndex = ItemUtils.getItemIndex(this._created, this._parent);
        this._parent.removeItem(this._created);
        this._parent.repaintItem();
    }

    public void redo() {
        super.redo();
        Assert.assert((this._created.getItemParent() == null ? 1 : 0) != 0, (String)"CreateUndo: item should not be parented for redo");
        this._parent.addItem(this._created, this._createdIndex);
        this._parent.repaintItem();
    }

    public void die() {
        super.die();
        this._created = null;
        this._parent = null;
    }

    public String getBaseKey() {
        return "CREATE";
    }

    public LayoutItem getCreatedItem() {
        return this._created;
    }

    public LayoutItem getParentItem() {
        return this._parent;
    }

    public Rectangle2D getCreatedBounds() {
        return this._created.getItemBounds();
    }
}

