/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class DeleteUndo
extends LocalizedEdit {
    private LayoutItem _deleted;
    private LayoutItem _parent;
    private int _index;

    public DeleteUndo(LayoutItem layoutItem, LayoutItem layoutItem2, int n) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        this._deleted = layoutItem;
        this._parent = layoutItem2;
        this._index = n;
    }

    public void undo() {
        super.undo();
        this._parent.addItem(this._deleted, this._index);
        this._parent.repaintItem();
    }

    public void redo() {
        super.redo();
        this._parent.removeItem(this._deleted);
        this._parent.repaintItem();
    }

    public void die() {
        super.die();
        this._deleted = null;
        this._parent = null;
    }

    public String getBaseKey() {
        return "DELETE";
    }

    public LayoutItem getDeletedItem() {
        return this._deleted;
    }
}

