/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.item.LinkItem;
import oracle.bali.jle.tool.LinkTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;

public class LinkUndo
extends LocalizedEdit {
    private LayoutItem _source;
    private LayoutItem _dest;
    private Point2D _sourcePt;
    private Point2D _destPt;
    private LinkItem _link;
    private LinkTool _tool;

    public LinkUndo(LinkItem linkItem, LayoutItem layoutItem, Point2D point2D, LayoutItem layoutItem2, Point2D point2D2, LinkTool linkTool) {
        if (linkItem == null || layoutItem == null || point2D == null || layoutItem2 == null || point2D2 == null || linkTool == null) {
            throw new IllegalArgumentException();
        }
        this._link = linkItem;
        this._source = layoutItem;
        this._sourcePt = point2D;
        this._dest = layoutItem2;
        this._destPt = point2D2;
        this._tool = linkTool;
    }

    public void undo() {
        super.undo();
        LayoutItem layoutItem = this._link.getItemParent();
        layoutItem.removeItem(this._link);
        layoutItem.repaintItem();
    }

    public void redo() {
        super.redo();
        this._link = this._tool.processLink(this._source, this._dest, this._sourcePt, this._destPt);
        this._link.repaintItem();
    }

    public void die() {
        super.die();
        this._source = null;
        this._sourcePt = null;
        this._dest = null;
        this._destPt = null;
        this._link = null;
        this._tool = null;
    }

    public String getBaseKey() {
        return "LINK";
    }
}

