/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import java.awt.Rectangle;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.undo.LocalizedEdit;
import oracle.bali.jle.util.ItemUtils;

public class MoveUndo
extends LocalizedEdit {
    private LayoutItem _moved;
    private double _dx;
    private double _dy;
    private BoundsTool _tool;
    private String _name;

    public MoveUndo(LayoutItem layoutItem, double d, double d2, BoundsTool boundsTool) {
        if (layoutItem == null) {
            throw new IllegalArgumentException();
        }
        this._moved = layoutItem;
        this._dx = d;
        this._dy = d2;
        this._tool = boundsTool;
    }

    public void undo() {
        super.undo();
        Rectangle rectangle = ItemUtils.parentToDevice(this._moved, this._moved.getItemBounds());
        BoundsTool.processMove(this._moved, -this._dx, -this._dy, this._tool);
        if (this._tool != null) {
            this._repaintOldLocation(rectangle);
        } else {
            this._moved.getCanvas().repaintInterior();
        }
    }

    public void redo() {
        super.redo();
        Rectangle rectangle = ItemUtils.parentToDevice(this._moved, this._moved.getItemBounds());
        BoundsTool.processMove(this._moved, this._dx, this._dy, this._tool);
        if (this._tool != null) {
            this._repaintOldLocation(rectangle);
        } else {
            this._moved.getCanvas().repaintInterior();
        }
    }

    public void die() {
        super.die();
        this._moved = null;
        this._tool = null;
    }

    public String getBaseKey() {
        return "MOVE";
    }

    public LayoutItem getMovedItem() {
        return this._moved;
    }

    private void _repaintOldLocation(Rectangle rectangle) {
        BoundsPainter boundsPainter = this._tool.getBoundsPainter();
        int n = boundsPainter.getControlPointWidth() / 2 + 1;
        int n2 = boundsPainter.getControlPointHeight() / 2 + 1;
        this._tool.getCanvas().repaintCanvas(rectangle.x - n, rectangle.y - n2, rectangle.width + n * 2, rectangle.height + n2 * 2);
    }
}

