/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.AffineTransform;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.NoninvertibleTransformException;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.util.GeometryUtils;

public class ItemUtils {
    private ItemUtils() {
    }

    public static Rectangle2D itemToParent(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        if (layoutItem == null || rectangle2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformRect(affineTransform, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), false);
    }

    public static Rectangle2D itemToParent(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformRect(affineTransform, d, d2, d3, d4, false);
    }

    public static Rectangle itemToDevice(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        return GeometryUtils.toRectangle(ItemUtils.itemToDeviceDouble(layoutItem, rectangle2D));
    }

    public static Rectangle2D itemToDeviceDouble(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        if (layoutItem == null || rectangle2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils.transformRect(affineTransform, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), false);
    }

    public static Dimension2D itemToDeviceDouble(LayoutItem layoutItem, Dimension2D dimension2D) {
        if (layoutItem == null || dimension2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils._transformDimension(affineTransform, dimension2D, false);
    }

    public static Rectangle2D itemToContent(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        JLECanvas jLECanvas = layoutItem.getCanvas();
        if (layoutItem == null || jLECanvas == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        Rectangle2D rectangle2D = ItemUtils.transformRect(affineTransform, d, d2, d3, d4, false);
        return jLECanvas.deviceToContent(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public static Rectangle2D itemToContent(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        return ItemUtils.itemToContent(layoutItem, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public static Rectangle itemToDevice(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return GeometryUtils.toRectangle(ItemUtils.transformRect(affineTransform, d, d2, d3, d4, false));
    }

    public static Rectangle parentToDevice(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        return ItemUtils.itemToDevice(layoutItem2 == null ? layoutItem : layoutItem2, rectangle2D);
    }

    public static Rectangle parentToDevice(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        return ItemUtils.itemToDevice(layoutItem2 == null ? layoutItem : layoutItem2, d, d2, d3, d4);
    }

    public static Rectangle2D parentToContent(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        return ItemUtils.itemToContent(layoutItem2 == null ? layoutItem : layoutItem2, d, d2, d3, d4);
    }

    public static Rectangle2D parentToContent(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        if (layoutItem == null || rectangle2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        return ItemUtils.parentToContent(layoutItem, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public static Rectangle2D parentToItem(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        if (layoutItem == null || rectangle2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformRect(affineTransform, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), true);
    }

    public static Rectangle2D parentToItem(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformRect(affineTransform, d, d2, d3, d4, true);
    }

    public static Rectangle2D deviceToItem(LayoutItem layoutItem, Rectangle2D rectangle2D) {
        if (layoutItem == null || rectangle2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils.transformRect(affineTransform, rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), true);
    }

    public static Rectangle2D deviceToItem(LayoutItem layoutItem, double d, double d2, double d3, double d4) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils.transformRect(affineTransform, d, d2, d3, d4, true);
    }

    public static Rectangle2D deviceToItem(LayoutItem layoutItem, Rectangle rectangle) {
        return ItemUtils.deviceToItem(layoutItem, new Rectangle2D.Double(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
    }

    public static Point2D itemToParent(LayoutItem layoutItem, Point2D point2D) {
        if (layoutItem == null || point2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformPoint(affineTransform, point2D, false);
    }

    public static Point2D itemToParent(LayoutItem layoutItem, double d, double d2) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformPoint(affineTransform, new Point2D.Double(d, d2), false);
    }

    public static Point itemToDevice(LayoutItem layoutItem, Point2D point2D) {
        if (layoutItem == null || point2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return GeometryUtils.toPoint(ItemUtils.transformPoint(affineTransform, point2D, false));
    }

    public static Point2D itemToDevice(LayoutItem layoutItem, double d, double d2) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils.transformPoint(affineTransform, new Point2D.Double(d, d2), false);
    }

    public static Point parentToDevice(LayoutItem layoutItem, Point2D point2D) {
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        return ItemUtils.itemToDevice(layoutItem2 == null ? layoutItem : layoutItem2, point2D);
    }

    public static Point2D parentToItem(LayoutItem layoutItem, Point2D point2D) {
        if (layoutItem == null || point2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformPoint(affineTransform, point2D, true);
    }

    public static Point2D parentToItem(LayoutItem layoutItem, double d, double d2) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils.transformPoint(affineTransform, new Point2D.Double(d, d2), true);
    }

    public static Point2D deviceToItem(LayoutItem layoutItem, Point2D point2D) {
        if (layoutItem == null || point2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils.transformPoint(affineTransform, point2D, true);
    }

    public static Point2D deviceToItem(LayoutItem layoutItem, double d, double d2) {
        if (layoutItem == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils.transformPoint(affineTransform, new Point2D.Double(d, d2), true);
    }

    public static Dimension2D deviceToItem(LayoutItem layoutItem, Dimension2D dimension2D) {
        if (layoutItem == null || dimension2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils._transformDimension(affineTransform, dimension2D, true);
    }

    public static Dimension2D deviceToItem(LayoutItem layoutItem, Dimension dimension) {
        return ItemUtils.deviceToItem(layoutItem, new Dimension2D.Double(dimension.width, dimension.height));
    }

    public static Dimension parentToDevice(LayoutItem layoutItem, Dimension2D dimension2D) {
        LayoutItem layoutItem2 = layoutItem.getItemParent();
        return ItemUtils.itemToDevice(layoutItem2 == null ? layoutItem : layoutItem2, dimension2D);
    }

    public static Dimension itemToDevice(LayoutItem layoutItem, Dimension2D dimension2D) {
        if (layoutItem == null || dimension2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return GeometryUtils.toDimension(ItemUtils._transformDimension(affineTransform, dimension2D, false));
    }

    public static Dimension2D itemToParent(LayoutItem layoutItem, Dimension2D dimension2D) {
        if (layoutItem == null || dimension2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getItemTransform();
        return ItemUtils._transformDimension(affineTransform, dimension2D, false);
    }

    public static Dimension2D parentToItem(LayoutItem layoutItem, Dimension2D dimension2D) {
        if (layoutItem == null || dimension2D == null) {
            throw new IllegalArgumentException("can't transform null param");
        }
        AffineTransform affineTransform = layoutItem.getDeviceTransform();
        return ItemUtils._transformDimension(affineTransform, dimension2D, true);
    }

    public static Rectangle2D transformRect(AffineTransform affineTransform, double d, double d2, double d3, double d4, boolean bl) {
        double[] dArray;
        dArray = new double[]{d, d2, dArray[0] + d3, dArray[1] + d4};
        if (bl) {
            try {
                affineTransform.inverseTransform(dArray, 0, dArray, 0, 2);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return null;
            }
        } else {
            affineTransform.transform(dArray, 0, dArray, 0, 2);
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(dArray[0], dArray[1], dArray[2] - dArray[0], dArray[3] - dArray[1]);
        return double_;
    }

    public static Point2D transformPoint(AffineTransform affineTransform, Point2D point2D, boolean bl) {
        if (bl) {
            try {
                affineTransform.inverseTransform(point2D, point2D);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                return null;
            }
        } else {
            affineTransform.transform(point2D, point2D);
        }
        return point2D;
    }

    private static Dimension2D _transformDimension(AffineTransform affineTransform, Dimension2D dimension2D, boolean bl) {
        return ItemUtils._transformDimension(affineTransform, dimension2D.getWidth(), dimension2D.getHeight(), bl);
    }

    private static Dimension2D _transformDimension(AffineTransform affineTransform, double d, double d2, boolean bl) {
        double d3 = affineTransform.getScaleX();
        double d4 = affineTransform.getScaleY();
        double d5 = bl ? d / d3 : d * d3;
        double d6 = bl ? d2 / d4 : d2 * d4;
        return new Dimension2D.Double(d5, d6);
    }

    public static LayoutItem getParentAt(LayoutItem layoutItem, double d, double d2) {
        if (layoutItem == null) {
            return null;
        }
        LayoutItem layoutItem2 = layoutItem.getItemAt(d, d2);
        while (layoutItem2 != null && !layoutItem2.allowsChildren()) {
            if (layoutItem2 == layoutItem) {
                return null;
            }
            layoutItem2 = layoutItem2.getItemParent();
        }
        return layoutItem2;
    }

    public static int getItemIndex(LayoutItem layoutItem, LayoutItem layoutItem2) {
        if (layoutItem2 == null) {
            return -1;
        }
        int n = layoutItem2.getItemCount() - 1;
        while (n >= 0) {
            if (layoutItem2.getItem(n) == layoutItem) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public static Vector getAllItems(LayoutItem layoutItem) {
        if (layoutItem == null) {
            return new Vector(0);
        }
        Vector vector = new Vector();
        ItemUtils._addChildren(vector, layoutItem);
        return vector;
    }

    public static LayoutItem[] removeChildren(JLECanvas jLECanvas, LayoutItem[] layoutItemArray) {
        if (jLECanvas == null || layoutItemArray == null) {
            throw new IllegalArgumentException();
        }
        Vector<LayoutItem> vector = new Vector<LayoutItem>(layoutItemArray.length);
        int n = 0;
        while (n < layoutItemArray.length) {
            vector.addElement(layoutItemArray[n]);
            ++n;
        }
        Vector vector2 = new Vector(layoutItemArray.length);
        BaseContainer baseContainer = jLECanvas.getContentItem();
        ItemUtils._removePreOrder(baseContainer, vector, vector2);
        Object[] objectArray = new LayoutItem[vector2.size()];
        vector2.copyInto(objectArray);
        return objectArray;
    }

    public static Image getItemImage(LayoutItem layoutItem) {
        JLECanvas jLECanvas = layoutItem.getCanvas();
        if (jLECanvas == null) {
            return null;
        }
        Dimension2D dimension2D = layoutItem.getItemSize();
        Dimension2D dimension2D2 = jLECanvas.getEngineUnitsPerPixel();
        Image image = ((Component)((Object)jLECanvas)).createImage((int)(dimension2D.getWidth() / dimension2D2.getWidth()), (int)(dimension2D.getHeight() / dimension2D2.getHeight()));
        return image;
    }

    public static LayoutItem getSharedAncestor(LayoutItem layoutItem, LayoutItem layoutItem2) {
        layoutItem = layoutItem.getItemParent();
        while (layoutItem != null) {
            if (ItemUtils.isAncestor(layoutItem, layoutItem2)) {
                return layoutItem;
            }
            layoutItem = layoutItem.getItemParent();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isAncestor(LayoutItem var0, LayoutItem var1_1) {
        if (var0 != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (var1_1 == var0) {
                return true;
            }
            var1_1 = var1_1.getItemParent();
lbl6:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    private static void _removePreOrder(LayoutItem layoutItem, Vector vector, Vector vector2) {
        if (vector.contains(layoutItem)) {
            vector2.addElement(layoutItem);
            vector.removeElement(layoutItem);
        } else if (layoutItem.getItemCount() > 0) {
            LayoutItem[] layoutItemArray = layoutItem.getItems();
            int n = 0;
            while (n < layoutItemArray.length) {
                ItemUtils._removePreOrder(layoutItemArray[n], vector, vector2);
                ++n;
            }
        }
    }

    private static void _addChildren(Vector vector, LayoutItem layoutItem) {
        vector.addElement(layoutItem);
        int n = layoutItem.getItemCount();
        if (n > 0) {
            LayoutItem[] layoutItemArray = layoutItem.getItems();
            int n2 = 0;
            while (n2 < n) {
                ItemUtils._addChildren(vector, layoutItemArray[n2]);
                ++n2;
            }
        }
    }
}

