/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MySQL4CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.MySQLCapturer;

public class MySQL4Capturer
extends MySQLCapturer {
    private static MySQL4CaptureQueries s_captureQueries;
    private String[] m_captureColumn = new String[]{"Field", "Type", "Collation", "Null", "Key", "Default", "Extra", "Privileges", "Comment"};

    public MySQL4Capturer(MigrationStorer storer, Connection conn) {
        super(storer, conn);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new MySQL4CaptureQueries();
        }
        return s_captureQueries;
    }

    protected int getColumnCaptureInfo(String columnHeader) {
        if (this.m_minorVersion < 1) {
            return super.getColumnCaptureInfo(columnHeader);
        }
        for (int i = 0; i < this.m_captureColumn.length; ++i) {
            if (!this.m_captureColumn[i].equalsIgnoreCase(columnHeader)) continue;
            return i + 1;
        }
        return 1;
    }

    protected void captureIndexForTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        boolean finished;
        HashSet<String> nameFilter = new HashSet<String>();
        StringBuffer query = new StringBuffer("SHOW INDEX FROM `${schema}`.`${table}`");
        this.processFilter(filter, query, nameFilter, "MD_INDEXES");
        CloseableResultSet crs = null;
        crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        boolean bl = finished = !rs.next();
        while (!finished) {
            int detailOrder = 1;
            if (context.shouldCancel()) {
                CaptureEvent event = new CaptureEvent(-1, "INDEX", "");
                context.getAudience().fireListeners(event);
                crs.close();
                return;
            }
            String colName = rs.getString(3);
            if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(colName)) {
                finished = !rs.next();
                continue;
            }
            DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
            int nonUnique = rs.getInt(2);
            MdIndexe index = new MdIndexe(tableId);
            index.setIndexName(rs.getString(3));
            String database = context.applyToSQLString("${schema}");
            String newQuery = "SHOW COLUMNS FROM `" + database + "`.`" + rs.getString(1) + "`";
            CloseableResultSet columnCrs = QueryCapture.issueSQL((String)newQuery, (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet columnRs = columnCrs.getResultSet();
            String indexkey = "";
            while (columnRs.next()) {
                if (!columnRs.getString(1).equals(rs.getString(5))) continue;
                indexkey = columnRs.getString(4);
                break;
            }
            columnCrs.close();
            if (indexkey.startsWith("PRI") && nonUnique == 0 && rs.getString(3).equals("PRIMARY")) {
                MdConstraint constraint = this.createPrimaryIndexConstraint(context, rs.getString(3), tableId);
                do {
                    this.createPrimaryIndexConstraintDetails(context, constraint, rs.getString(5), detailOrder++, tableId);
                } while (!(finished = !rs.next()) && rs.getString(3).equals(constraint.getObjectName()));
                continue;
            }
            index = new MdIndexe(tableId);
            index.setIndexName(rs.getString(3));
            if (indexkey.startsWith("UNI")) {
                index.setIndexType("UNIQUE");
            } else {
                index.setIndexType("NON_UNIQUE");
            }
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), index.getIndexName());
            context.getAudience().fireListeners(event);
            index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            do {
                this.createIndexDetails(context, index, rs, detailOrder++);
            } while (!(finished = !rs.next()) && rs.getString(3).equals(index.getIndexName()));
        }
        crs.close();
    }
}

