/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.MySQL4DbProvider;
import oracle.dbtools.migration.workbench.plugin.MySQL4OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.MySQLPlugin;

public class MySQL4Plugin
extends MySQLPlugin {
    public String getVersionNumber() {
        return "4.0";
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new MySQL4DbProvider(conn);
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (!platform.equals(this.getPlatformName())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (major == 4 && minor >= 0) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    public int getPlatformMask() {
        return 2;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new MySQL4OfflineCapturer();
    }
}

