/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.plugin.MySQL4CaptureQueries;

public class MySQL5CaptureQueries
extends MySQL4CaptureQueries {
    private static final String CAPTURE_SCHEMAS_QUERY = "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA";
    private static final String CAPTURE_TABLES_QUERY = "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES";

    public String getQueryForType(String type, MigrationObjectFilter filter) {
        if (type.equals("MD_SCHEMAS")) {
            if (filter != null && filter.getFilterType() != 0) {
                String filteredQuery = "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA " + filter.toWhereClause("SCHEMA_NAME");
                filteredQuery = filteredQuery.replaceFirst("WHERE", "WHERE (");
                filteredQuery = filteredQuery + "SCHEMA_NAME NOT IN ('information_schema', 'mysql'))";
                return "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA " + filter.toWhereClause("SCHEMA_NAME");
            }
            return "SELECT DISTINCT(SCHEMA_NAME) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME NOT IN ('information_schema', 'mysql')";
        }
        if (type.equals("MD_TABLES")) {
            if (filter != null) {
                return "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES " + filter.toWhereClause("TABLE_NAME") + " AND TABLE_SCHEMA = '${schema}'" + " AND TABLE_TYPE = 'BASE TABLE'";
            }
            return "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '${schema}' AND TABLE_TYPE = 'BASE TABLE'";
        }
        return null;
    }
}

