/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MySQL4Capturer;
import oracle.dbtools.migration.workbench.plugin.MySQL5CaptureQueries;
import oracle.dbtools.migration.workbench.plugin.MySQL5MigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.plugin.MySQLMigrationAddinArb;

public class MySQL5Capturer
extends MySQL4Capturer {
    private static MySQL5CaptureQueries s_captureQueries;
    private static final String CAPTURE_COLUMNS_QUERY = "SELECT COLUMN_NAME,IS_NULLABLE,COLUMN_TYPE,CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION,NUMERIC_SCALE,COLUMN_DEFAULT,COLUMN_KEY,PRIVILEGES,EXTRA,COLUMN_COMMENT FROM INFORMATION_SCHEMA.COLUMNS WHERE (TABLE_SCHEMA='";
    private static final String CAPTURE_INDEX_QUERY = "SELECT DISTINCT (INDEX_NAME) INDEX_NAME ,TABLE_NAME , SEQ_IN_INDEX,COLUMN_NAME ,SUB_PART , INDEX_TYPE,NON_UNIQUE FROM INFORMATION_SCHEMA.STATISTICS WHERE (TABLE_SCHEMA='";
    private static final String CAPTURE_CONSTRAINT_QUERY = "SELECT CONSTRAINT_NAME,CONSTRAINT_TYPE FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE (TABLE_SCHEMA ='";
    private static final String CAPTURE_CONSTRAINT_DETAILS_QUERY = "SELECT CONSTRAINT_NAME , TABLE_SCHEMA ,TABLE_NAME,COLUMN_NAME , REFERENCED_TABLE_SCHEMA ,REFERENCED_TABLE_NAME,REFERENCED_COLUMN_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE ( TABLE_SCHEMA ='";
    private static final String CAPTURE_STORED_PROGRAMS_QUERY = "SELECT ROUTINE_NAME , ROUTINE_TYPE , ROUTINE_DEFINITION,ROUTINE_SCHEMA ,CREATED , DEFINER , LAST_ALTERED,ROUTINE_COMMENT  FROM INFORMATION_SCHEMA.ROUTINES ";
    private static final String CAPTURE_VIEWS_QUERY = "SELECT TABLE_SCHEMA, TABLE_NAME, VIEW_DEFINITION, DEFINER  FROM  INFORMATION_SCHEMA.VIEWS ";
    private static final String INDEX_TYPE = "INDEX_TYPE";

    public MySQL5Capturer(MigrationStorer storer, Connection conn) {
        super(storer, conn);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new MySQL5CaptureQueries();
        }
        return s_captureQueries;
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        if (objType.equals("MD_STORED_PROGRAMS")) {
            this.captureStoredPrograms(context, filter);
        } else if (objType.equals("MD_VIEWS")) {
            this.captureViews(context, filter);
        } else {
            super.captureObjects(objType, context, filter);
        }
    }

    protected void captureUsers(CaptureContext context, MigrationObjectFilter filter) {
        try {
            CloseableResultSet allUsersCrs = null;
            CaptureAudience audience = context.getAudience();
            String schema = context.applyToSQLString("${schema}");
            String query = "SELECT DISTINCT GRANTEE FROM INFORMATION_SCHEMA.SCHEMA_PRIVILEGES WHERE TABLE_SCHEMA = '" + schema + "'";
            CloseableResultSet schemaUsersCrs = QueryCapture.issueSQL((String)query, (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet schemaUserRs = schemaUsersCrs.getResultSet();
            while (schemaUserRs.next()) {
                boolean finished;
                String captureUser = "SELECT GRANTEE , PRIVILEGE_TYPE, IS_GRANTABLE FROM INFORMATION_SCHEMA.USER_PRIVILEGES";
                StringBuffer allUsersQuery = new StringBuffer(captureUser + " WHERE GRANTEE LIKE " + "\"" + schemaUserRs.getString(1) + "\"");
                String host = this.getHostFromGrantee(schemaUserRs.getString(1));
                allUsersCrs = QueryCapture.issueSQL((String)allUsersQuery.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
                ResultSet rs = allUsersCrs.getResultSet();
                boolean bl = finished = !rs.next();
                while (!finished) {
                    if (context.shouldCancel()) {
                        CaptureEvent event = new CaptureEvent(-1, "USERS", "");
                        context.getAudience().fireListeners(event);
                        allUsersCrs.close();
                        return;
                    }
                    DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                    if (rs.getString(1) == null || rs.getString(1).length() <= 0) continue;
                    if (host.equals(this.getHostFromGrantee(rs.getString(1)))) {
                        boolean isFound = false;
                        PersistenceUtility util = this.getStorer().getPersistenceUtility();
                        CloseableIterator users = util.getUsersforSchemaId(schemaId);
                        while (users.hasNext()) {
                            MdUser mdUser = (MdUser)users.next();
                            String property = mdUser.getProperty(MySQLMigrationAddinArb.getString(10));
                            if (!mdUser.getObjectName().equalsIgnoreCase(this.getUserFromGrantee(rs.getString(1))) || !property.equalsIgnoreCase(rs.getString(1))) continue;
                            isFound = true;
                            break;
                        }
                        if (isFound) continue;
                        if (this.getUserFromGrantee(rs.getString(1)).length() > 0) {
                            MdUser user = new MdUser(schemaId, this.getUserFromGrantee(rs.getString(1)));
                            String password = this.getPassword(this.getUserFromGrantee(rs.getString(1)), host, context);
                            user.setPassword(password);
                            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                            user.addProperty(new AdditionalProperty(MySQLMigrationAddinArb.getString(10), rs.getString(1)), connectionId);
                            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)144), user.getUsername());
                            audience.fireListeners(event);
                            user = (MdUser)this.getStorer().storeObject((PersistableObject)user);
                            event.setEventId(4);
                            audience.fireListeners(event);
                            do {
                                this.createUserPrivilegeDetails(context, user, rs);
                            } while (!(finished = !rs.next()) && this.getUserFromGrantee(rs.getString(1)).equals(user.getUsername()));
                            continue;
                        }
                        finished = !rs.next();
                        continue;
                    }
                    rs.next();
                }
            }
            if (allUsersCrs != null) {
                allUsersCrs.close();
            }
            if (schemaUsersCrs != null) {
                schemaUsersCrs.close();
            }
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPassword(String user, String host, CaptureContext context) {
        CloseableResultSet cRs = null;
        try {
            StringBuffer query = new StringBuffer("SELECT HOST , USER , PASSWORD FROM mysql.user ");
            query.append("WHERE (HOST='" + host + "'" + " AND USER='" + user + "')");
            cRs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = cRs.getResultSet();
            rs.next();
            String string = rs.getString(3);
            return string;
        }
        catch (SQLException e) {
            String string = null;
            return string;
        }
        finally {
            if (cRs != null) {
                cRs.close();
            }
        }
    }

    private String getHostFromGrantee(String grantee) {
        String host = grantee.substring(grantee.lastIndexOf("@'") + 2, grantee.length() - 1);
        return host;
    }

    private String getUserFromGrantee(String grantee) {
        String host = grantee.substring(1, grantee.lastIndexOf("'@'"));
        return host;
    }

    protected void createUserPrivilegeDetails(CaptureContext context, MdUser user, ResultSet userRs) {
        try {
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            String privilege = this.getOracleSpecificPrivilege(userRs.getString(2));
            boolean isMySQLSpecific = false;
            if (privilege.length() == 0) {
                privilege = userRs.getString(2);
                isMySQLSpecific = true;
            }
            MdPrivilege priMdPrivilege = new MdPrivilege(schemaId, " ", "MD_USERS", privilege, new ClobHelper(" "));
            DBObjectId userId = util.getIdForUser(schemaId, user.getUsername());
            priMdPrivilege.setPrivelegeObjectId(userId);
            if (userRs.getString(3).equals("YES")) {
                priMdPrivilege.setAdminOption("Y");
            } else {
                priMdPrivilege.setAdminOption("N");
            }
            if (isMySQLSpecific) {
                priMdPrivilege.addProperty(new AdditionalProperty(MySQLMigrationAddinArb.getString(0), privilege), connectionId);
            }
            CaptureEvent event = new CaptureEvent(3, "USER PRIVILEGE", userRs.getString(2));
            context.getAudience().fireListeners(event);
            priMdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)priMdPrivilege);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(user.getKey());
            mdUserPrivilege.setPrivilegeId(priMdPrivilege.getKey());
            mdUserPrivilege = (MdUserPrivilege)this.getStorer().storeObject((PersistableObject)mdUserPrivilege);
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected void captureColumnDetails(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        CaptureAudience audience = context.getAudience();
        Object column = null;
        String schema = context.applyToSQLString("${schema}");
        String table = context.applyToSQLString("${table}");
        StringBuffer query = new StringBuffer(CAPTURE_COLUMNS_QUERY);
        query.append(schema).append("' AND binary TABLE_NAME='").append(table).append("'");
        if (filter != null) {
            StringBuffer tempBufForFilter = new StringBuffer();
            tempBufForFilter.append(filter.toWhereClause("COLUMN_NAME "));
            String replaceFirst = tempBufForFilter.toString().replaceAll("WHERE", "AND");
            query.append(replaceFirst);
        }
        query.append(")");
        CloseableResultSet crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        int order = 1;
        DBObjectId tableid = (DBObjectId)context.getContextVariable("TABLEID");
        while (rs.next()) {
            String extra;
            if (context.shouldCancel()) {
                CaptureEvent event = new CaptureEvent(-1, MigrationAddinArb.getString((int)134), "");
                context.getAudience().fireListeners(event);
                crs.close();
                return;
            }
            String[] groupValues = null;
            boolean isColumnCreated = false;
            MySQLColumnHelper mysqlColumnHelper = new MySQLColumnHelper(rs.getString(3));
            String dataType = mysqlColumnHelper.getDataTypeName();
            if ((dataType.equals("ENUM") || dataType.equals("SET")) && (groupValues = this.getAllValues(rs.getString(3))) != null) {
                column = dataType.equals("ENUM") ? new MdEnumColumn(tableid, rs.getString(1), Integer.valueOf(order++), groupValues, connectionId) : new MdSetColumn(tableid, rs.getString(1), Integer.valueOf(order++), groupValues, connectionId);
                isColumnCreated = true;
            }
            if ((extra = rs.getString(10)).equals("auto_increment") && !isColumnCreated) {
                String maxQuery = "SELECT MAX(`" + rs.getString(1) + "`)" + " FROM " + schema + "." + table;
                CloseableResultSet lastValCrs = QueryCapture.issueSQL((String)maxQuery, (Connection)this.m_sourceConnection, (CaptureContext)context);
                ResultSet lastValRs = lastValCrs.getResultSet();
                long lastVal = 0L;
                while (lastValRs.next()) {
                    lastVal = lastValRs.getLong(1);
                }
                lastValCrs.close();
                column = new MdIdentityColumn(tableid, rs.getString(1), Integer.valueOf(order++), 0L, 1L, lastVal, connectionId);
                isColumnCreated = true;
            }
            if (!isColumnCreated) {
                column = new MdColumn(tableid, rs.getString(1), Integer.valueOf(order++));
            }
            if (extra != null && extra.trim().length() > 0) {
                column.addProperty(new AdditionalProperty("EXTRA", extra), connectionId);
            }
            column.setColumnType(dataType);
            column.setPrecision(Integer.valueOf(mysqlColumnHelper.getPrecision()));
            if (mysqlColumnHelper.hasPrecisionAndScale()) {
                column.setScale(Integer.valueOf(mysqlColumnHelper.getScale()));
            }
            if (rs.getString(2).equalsIgnoreCase("YES")) {
                column.setNullable("Y");
            } else {
                column.setNullable("N");
            }
            String fieldKey = rs.getString(8);
            if (fieldKey.equals("PRI")) {
                // empty if block
            }
            column.setDefaultValue(rs.getString(7));
            String comment = rs.getString(11);
            if (comment != null && comment.length() > 0) {
                column.setComments(comment);
            }
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), column.getColumnName());
            audience.fireListeners(event);
            column = (MdColumn)this.getStorer().storeObject((PersistableObject)column);
            event.setEventId(4);
            audience.fireListeners(event);
            String privilege = rs.getString(9);
            if (privilege == null || privilege.trim().length() <= 0) continue;
            this.captureColumnPrivilege(privilege, context, (MdColumn)column);
        }
        crs.close();
    }

    protected void captureIndexForTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        boolean finished;
        StringBuffer query = new StringBuffer(CAPTURE_INDEX_QUERY);
        String schema = context.applyToSQLString("${schema}");
        String table = context.applyToSQLString("${table}");
        query.append(schema).append("' AND TABLE_NAME='").append(table).append("'");
        CloseableResultSet crs = null;
        if (filter != null) {
            StringBuffer tempBufForFilter = new StringBuffer();
            tempBufForFilter.append(filter.toWhereClause("INDEX_NAME "));
            String replaceFirst = tempBufForFilter.toString().replaceAll("WHERE", "AND");
            query.append(replaceFirst);
        }
        query.append(")");
        crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        boolean bl = finished = !rs.next();
        while (!finished) {
            int detailOrder = 1;
            if (context.shouldCancel()) {
                CaptureEvent event = new CaptureEvent(-1, "INDEX", "");
                context.getAudience().fireListeners(event);
                crs.close();
                return;
            }
            DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
            int nonUnique = rs.getInt(7);
            String newQuery = "select COLUMN_NAME , COLUMN_KEY from information_schema.columns where (TABLE_SCHEMA = '" + schema + "' AND TABLE_NAME ='" + rs.getString(2) + "')";
            CloseableResultSet columnCrs = QueryCapture.issueSQL((String)newQuery, (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet columnRs = columnCrs.getResultSet();
            String indexkey = "";
            while (columnRs.next()) {
                if (!columnRs.getString(1).equals(rs.getString(4))) continue;
                indexkey = columnRs.getString(2);
                break;
            }
            columnCrs.close();
            if (indexkey.startsWith("PRI") && nonUnique == 0 && rs.getString(1).equals("PRIMARY")) {
                MdConstraint constraint = this.createPrimaryIndexConstraint(context, rs.getString(1), tableId);
                do {
                    this.createPrimaryIndexConstraintDetails(context, constraint, rs.getString(4), detailOrder++, tableId);
                } while (!(finished = !rs.next()) && rs.getString(1).equals(constraint.getObjectName()));
                continue;
            }
            MdIndexe index = new MdIndexe(tableId);
            index.setIndexName(rs.getString(1));
            if (indexkey.startsWith("UNI")) {
                index.setIndexType("UNIQUE");
            } else {
                index.setIndexType("NON_UNIQUE");
            }
            String indexType = rs.getString(6);
            if (indexType != null && indexType.trim().length() > 0) {
                DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                index.addProperty(new AdditionalProperty(INDEX_TYPE, indexType), connectionId);
            }
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), index.getIndexName());
            context.getAudience().fireListeners(event);
            index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            do {
                this.createIndexDetails(context, index, rs, detailOrder++);
            } while (!(finished = !rs.next()) && rs.getString(1).equals(index.getIndexName()));
        }
        crs.close();
    }

    protected void createIndexDetails(CaptureContext context, MdIndexe index, ResultSet rs, int detailOrder) throws PersistenceException, SQLException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        MdIndexDetail detail = new MdIndexDetail(index.getKey(), util.getIdForColumn(index.getTableId(), rs.getString(4)), Integer.valueOf(detailOrder));
        int subPart = rs.getInt(5);
        if (!rs.wasNull()) {
            detail.setIndexPortion(Integer.valueOf(subPart));
        }
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
        context.getAudience().fireListeners(event);
        detail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)detail);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void captureConstraintForTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        String schema = context.applyToSQLString("${schema}");
        String table = context.applyToSQLString("${table}");
        StringBuffer constriantQuery = new StringBuffer(CAPTURE_CONSTRAINT_QUERY);
        constriantQuery.append(schema).append("' AND TABLE_NAME='").append(table).append("'");
        if (filter != null) {
            StringBuffer tempBufForFilter = new StringBuffer();
            tempBufForFilter.append(filter.toWhereClause("CONSTRAINT_NAME "));
            String replaceFirst = tempBufForFilter.toString().replaceAll("WHERE", "AND");
            constriantQuery.append(replaceFirst);
        }
        constriantQuery.append(")");
        CloseableResultSet contraintCrs = QueryCapture.issueSQL((String)constriantQuery.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
        DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
        ResultSet constraintRs = contraintCrs.getResultSet();
        while (constraintRs.next()) {
            if (!constraintRs.getString(2).equals("FOREIGN KEY")) continue;
            StringBuffer detailsQuery = new StringBuffer("SELECT DISTINCT CONSTRAINT_NAME , REFERENCED_TABLE_NAME FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE WHERE ");
            detailsQuery.append("CONSTRAINT_NAME ='").append(constraintRs.getString(1)).append("'");
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            CloseableResultSet detailsCrs = QueryCapture.issueSQL((String)detailsQuery.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet detailsRs = detailsCrs.getResultSet();
            detailsRs.next();
            DBObjectId reftableId = util.getIdForTable(schemaId, detailsRs.getString(2));
            MdConstraint migrConstraint = new MdConstraint(tableId, "MySQL");
            migrConstraint.setConstraintType("FOREIGN KEY");
            migrConstraint.setName(constraintRs.getString(1));
            migrConstraint.setReftableId(reftableId);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), migrConstraint.getName());
            context.getAudience().fireListeners(event);
            migrConstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)migrConstraint);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            this.processConstraintRow(context, migrConstraint, schemaId, schema);
        }
        contraintCrs.close();
    }

    private void processConstraintRow(CaptureContext context, MdConstraint migrConstraint, DBObjectId schemaId, String schema) throws SQLException, PersistenceException {
        StringBuffer query = new StringBuffer(CAPTURE_CONSTRAINT_DETAILS_QUERY);
        query.append(schema).append("' AND CONSTRAINT_NAME ='").append(migrConstraint.getName()).append("')");
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        CloseableResultSet crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        int constraintOrder = 1;
        while (rs.next()) {
            DBObjectId tableId = util.getIdForTable(schemaId, rs.getString(3));
            DBObjectId colId = util.getIdForColumn(tableId, rs.getString(4));
            DBObjectId reftableId = util.getIdForTable(schemaId, rs.getString(6));
            DBObjectId refcolId = util.getIdForColumn(reftableId, rs.getString(7));
            constraintOrder = this.createConstraintDetails(migrConstraint.getKey(), colId, "N", constraintOrder, context);
            constraintOrder = this.createConstraintDetails(migrConstraint.getKey(), refcolId, "Y", constraintOrder, context);
        }
        crs.close();
    }

    private int createConstraintDetails(DBObjectId migCon, DBObjectId colId, String flagIndicator, int constraintOrder, CaptureContext context) throws PersistenceException, SQLException {
        int order = constraintOrder;
        MdConstraintDetail detail = new MdConstraintDetail(migCon, Integer.valueOf(order++));
        detail.setColumnId(colId);
        detail.setRefFlag(flagIndicator);
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), "");
        context.getAudience().fireListeners(event);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
        detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
        return order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureStoredPrograms(CaptureContext context, MigrationObjectFilter filter) {
        CloseableResultSet crs = null;
        try {
            String schema = context.applyToSQLString("${schema}");
            StringBuffer query = new StringBuffer(CAPTURE_STORED_PROGRAMS_QUERY);
            query.append(" WHERE ( ROUTINE_SCHEMA='").append(schema).append("' ");
            if (filter != null) {
                StringBuffer tempBufForFilter = new StringBuffer();
                tempBufForFilter.append(filter.toWhereClause("ROUTINE_NAME "));
                String replaceFirst = tempBufForFilter.toString().replaceAll("WHERE", "AND");
                query.append(replaceFirst);
            }
            query.append(")");
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                MdStoredProgram storedProgram = new MdStoredProgram(schemaId, "MySQL");
                String programName = rs.getString(1);
                storedProgram.setName(programName);
                String programType = rs.getString(2);
                storedProgram.setProgramtype(programType);
                String comment = rs.getString(8);
                if (comment != null && comment.length() > 0) {
                    storedProgram.setComments(comment);
                }
                String innerQuery = "SHOW CREATE " + programType + " " + schema + "." + programName;
                CloseableResultSet innerCrs = QueryCapture.issueSQL((String)innerQuery, (Connection)this.m_sourceConnection, (CaptureContext)context);
                ResultSet innerRs = innerCrs.getResultSet();
                StringBuffer sql = new StringBuffer();
                while (innerRs.next()) {
                    sql.append(innerRs.getString(3));
                }
                innerCrs.close();
                String definition = sql.toString();
                if (definition.trim().length() == 0) {
                    Logger.getLogger("oracle.dbtools.migration").log(Level.WARNING, MySQL5MigrationAddinArb.getString(0), new Object[]{programType, schema, programName});
                    continue;
                }
                storedProgram.setNativeSql(definition);
                storedProgram.setCreatedOn(rs.getDate(5));
                storedProgram.setCreatedBy(rs.getString(6));
                storedProgram.setLastUpdatedOn(rs.getDate(7));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)136), storedProgram.getName());
                context.getAudience().fireListeners(event);
                storedProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)storedProgram);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureViews(CaptureContext context, MigrationObjectFilter filter) {
        CloseableResultSet crs = null;
        try {
            String schema = context.applyToSQLString("${schema}");
            StringBuffer query = new StringBuffer(CAPTURE_VIEWS_QUERY);
            query.append(" WHERE ( TABLE_SCHEMA='").append(schema).append("' ");
            if (filter != null) {
                StringBuffer tempBufForFilter = new StringBuffer();
                tempBufForFilter.append(filter.toWhereClause("TABLE_NAME "));
                String replaceFirst = tempBufForFilter.toString().replaceAll("WHERE", "AND");
                query.append(replaceFirst);
            }
            query.append(")");
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                MdView view = new MdView(schemaId, "MySQL");
                view.setViewName(rs.getString(2));
                view.setNativeSql(rs.getString(3));
                view.setCreatedBy(rs.getString(4));
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)137), view.getViewName());
                context.getAudience().fireListeners(event);
                view = (MdView)this.getStorer().storeObject((PersistableObject)view);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }
}

