/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.plugin.MySQL4OfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.plugin.MySQLOfflineUtils;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.ide.Ide;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MySQL5OfflineCapturer
extends MySQL4OfflineCapturer {
    private XMLDocument _xmlDocument;
    private Node _rootNode;

    public String captureInitializeImpl(String inputDirectory, Properties props) throws OfflineCaptureException {
        this.m_inputDirectory = inputDirectory;
        this.m_properties = props;
        try {
            String xmlFile = inputDirectory.concat(File.separator).concat(props.getProperty("alldbsfile"));
            FileInputStream in = new FileInputStream(new File(xmlFile));
            DOMParser parser = new DOMParser();
            parser.setPreserveWhitespace(false);
            String encoding = Ide.getEnvironOptions().getEncoding();
            if (encoding == null) {
                parser.parse((InputStream)in);
            } else {
                parser.parse((Reader)new BufferedReader(new InputStreamReader((InputStream)in, encoding)));
            }
            this._xmlDocument = parser.getDocument();
            this._rootNode = this._xmlDocument.getElementsByTagName("mysqldump").item(0);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return "MySQLOffline5";
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        if (objType.equals("MD_SCHEMAS")) {
            NodeList nodes = this._rootNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                this.captureDatabase(node, context);
            }
            this.captureConstraints(context);
            this.captureStoredPrograms(context);
            this.captureView(context);
        } else {
            super.captureObjects(objType, context, filter);
        }
    }

    private void captureDatabase(Node node, CaptureContext context) {
        if (node.getNodeName().equals("database")) {
            this.captureSchema(context, node);
        }
    }

    private void captureSchema(CaptureContext context, Node node) {
        try {
            String schemaName = XMLHelper.getAttributeNode((Node)node, (String)"name");
            if (!schemaName.equalsIgnoreCase("mysql") && !schemaName.equalsIgnoreCase("information_schema")) {
                CaptureAudience audience = context.getAudience();
                DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
                MdSchema schema = new MdSchema(catalogId);
                schema.setName(schemaName);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)141), schema.getName());
                audience.fireListeners(event);
                schema = (MdSchema)this.getStorer().storeObject((PersistableObject)schema);
                event.setEventId(4);
                audience.fireListeners(event);
                context.setContextVariable("SCHEMAID", (Object)schema.getKey());
                XMLNode[] tablesNode = XMLHelper.getChildNodes((Node)node, (String)"table_structure");
                for (int i = 0; i < tablesNode.length; ++i) {
                    this.captureTable((Node)tablesNode[i], context, schema);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureTable(Node node, CaptureContext context, MdSchema schema) {
        try {
            DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
            String tableName = XMLHelper.getAttributeNode((Node)node, (String)"name");
            Node optionNode = XMLHelper.getChildNode((Node)node, (String)"options");
            String commentNode = XMLHelper.getAttributeNode((Node)optionNode, (String)"Comment");
            if (!commentNode.equalsIgnoreCase("View")) {
                String qualifiedName = "";
                MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
                if (catalog != null && !catalog.getDummyFlag().equals("Y")) {
                    qualifiedName = catalog.getCatalogName() + ".";
                }
                String schemaName = schema.getName();
                qualifiedName = qualifiedName + schemaName + ".";
                qualifiedName = qualifiedName + tableName;
                MdTable table = new MdTable(schemaId, tableName, qualifiedName);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)138), table.getTableName());
                context.getAudience().fireListeners(event);
                table = (MdTable)this.getStorer().storeObject((PersistableObject)table);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                XMLNode[] fieldNodes = XMLHelper.getChildNodes((Node)node, (String)"field");
                for (int i = 0; i < fieldNodes.length; ++i) {
                    this.captureColumnDetails(context, table, (Node)fieldNodes[i], schema);
                }
                this.captureIndexes(context, table, node);
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureColumnDetails(CaptureContext context, MdTable table, Node fieldNode, MdSchema schema) {
        Object column = null;
        int order = 1;
        try {
            String nullValue;
            String extra;
            DBObjectId tableId = table.getKey();
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            boolean isColumnCreated = false;
            String columnName = XMLHelper.getAttributeNode((Node)fieldNode, (String)"Field");
            String qualifiedColumnName = "`" + schema.getObjectName() + "`.`" + table.getObjectName() + "`.`" + columnName + "`";
            String[] groupValues = null;
            String type = XMLHelper.getAttributeNode((Node)fieldNode, (String)"Type");
            MySQLColumnHelper mysqlColumnHelper = new MySQLColumnHelper(type);
            String dataType = mysqlColumnHelper.getDataTypeName();
            if ((dataType.equals("ENUM") || dataType.equals("SET")) && (groupValues = this.getAllValues(type)) != null) {
                column = dataType.equals("ENUM") ? new MdEnumColumn(tableId, columnName, Integer.valueOf(order++), groupValues, connectionId) : new MdSetColumn(tableId, columnName, Integer.valueOf(order++), groupValues, connectionId);
                isColumnCreated = true;
            }
            if ((extra = XMLHelper.getAttributeNode((Node)fieldNode, (String)"Extra")).equals("auto_increment") && this.m_getMaxOfColumn.containsKey(qualifiedColumnName) && !isColumnCreated) {
                Integer maxValue = (Integer)this.m_getMaxOfColumn.get(qualifiedColumnName);
                column = new MdIdentityColumn(tableId, columnName, Integer.valueOf(order++), 0L, 1L, (long)maxValue.intValue(), connectionId);
                isColumnCreated = true;
            }
            if (!isColumnCreated) {
                column = new MdColumn(tableId, columnName, Integer.valueOf(order++));
            }
            if (extra != null && extra.trim().length() > 0) {
                column.addProperty(new AdditionalProperty("EXTRA", extra), connectionId);
            }
            column.setColumnType(dataType);
            column.setPrecision(Integer.valueOf(mysqlColumnHelper.getPrecision()));
            if (mysqlColumnHelper.hasPrecisionAndScale()) {
                column.setScale(Integer.valueOf(mysqlColumnHelper.getScale()));
            }
            if ((nullValue = XMLHelper.getAttributeNode((Node)fieldNode, (String)"Null")).equalsIgnoreCase("YES")) {
                column.setNullable("Y");
            } else {
                column.setNullable("N");
            }
            String fieldKey = XMLHelper.getAttributeNode((Node)fieldNode, (String)"Key");
            if (fieldKey.equals("PRI")) {
                // empty if block
            }
            String defaultValue = XMLHelper.getAttributeNode((Node)fieldNode, (String)"Default");
            column.setDefaultValue(defaultValue);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), column.getColumnName());
            context.getAudience().fireListeners(event);
            column = (MdColumn)this.getStorer().storeObject((PersistableObject)column);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureIndexes(CaptureContext context, MdTable table, Node node) {
        try {
            String previousIndexName = "";
            String columnName = "";
            XMLNode[] keyNodes = XMLHelper.getChildNodes((Node)node, (String)"key");
            MdIndexe index = null;
            MdConstraint constraint = null;
            boolean indexCreated = false;
            boolean constraintCreated = false;
            for (int i = 0; i < keyNodes.length; ++i) {
                String keyName = XMLHelper.getAttributeNode((Node)keyNodes[i], (String)"Key_name");
                columnName = XMLHelper.getAttributeNode((Node)keyNodes[i], (String)"Column_name");
                String indexType = XMLHelper.getAttributeNode((Node)keyNodes[i], (String)"Index_type");
                String nonUnique = XMLHelper.getAttributeNode((Node)keyNodes[i], (String)"Non_unique");
                if (!previousIndexName.equalsIgnoreCase(keyName)) {
                    CaptureEvent event;
                    Node tableNode = keyNodes[i].getParentNode();
                    XMLNode[] fieldNodes = XMLHelper.getChildNodes((Node)tableNode, (String)"field");
                    String[] tableColumns = new String[fieldNodes.length];
                    String[] tableIndexes = new String[fieldNodes.length];
                    for (int j = 0; j < fieldNodes.length; ++j) {
                        tableColumns[j] = XMLHelper.getAttributeNode((Node)fieldNodes[j], (String)"Field");
                        tableIndexes[j] = XMLHelper.getAttributeNode((Node)fieldNodes[j], (String)"Key");
                    }
                    String indexkey = "";
                    for (int j = 0; j < tableColumns.length; ++j) {
                        if (!tableColumns[j].equals(columnName)) continue;
                        indexkey = tableIndexes[j];
                    }
                    if (indexkey.startsWith("PRI") && nonUnique.equals("0") && keyName.equals("PRIMARY")) {
                        indexCreated = false;
                        constraintCreated = true;
                        constraint = new MdConstraint(table.getKey(), "MySQL");
                        constraint.setName(keyName);
                        constraint.setConstraintType("PK");
                        event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), keyName);
                        context.getAudience().fireListeners(event);
                        constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                        event.setEventId(4);
                        context.getAudience().fireListeners(event);
                        previousIndexName = constraint.getObjectName();
                    } else {
                        indexCreated = true;
                        constraintCreated = false;
                        index = new MdIndexe(table.getKey());
                        index.setIndexName(keyName);
                        if (indexkey.startsWith("UNI")) {
                            index.setIndexType("UNIQUE");
                        } else {
                            index.setIndexType("NON_UNIQUE");
                        }
                        if (indexType != null && indexType.trim().length() > 0) {
                            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                            index.addProperty(new AdditionalProperty("INDEX_TYPE", indexType), connectionId);
                        }
                        event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), index.getIndexName());
                        context.getAudience().fireListeners(event);
                        index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
                        event.setEventId(4);
                        context.getAudience().fireListeners(event);
                        previousIndexName = index.getIndexName();
                    }
                }
                if (indexCreated && !constraintCreated) {
                    this.captureIndexDetails(context, (Node)keyNodes[i], index, columnName);
                    continue;
                }
                if (indexCreated || !constraintCreated) continue;
                this.captureConstraintIndexDetails(context, (Node)keyNodes[i], constraint, columnName);
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureConstraintIndexDetails(CaptureContext context, Node node, MdConstraint constraint, String columnName) {
        try {
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            String seqIndex = XMLHelper.getAttributeNode((Node)node, (String)"Seq_in_index");
            MdConstraintDetail detail = new MdConstraintDetail(constraint.getKey(), new Integer(seqIndex));
            detail.setColumnId(util.getIdForColumn(constraint.getTableId(), columnName));
            CaptureEvent detailevent = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getObjectName());
            context.getAudience().fireListeners(detailevent);
            detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
            detailevent.setEventId(4);
            context.getAudience().fireListeners(detailevent);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureIndexDetails(CaptureContext context, Node node, MdIndexe index, String columnName) {
        try {
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            String seqIndex = XMLHelper.getAttributeNode((Node)node, (String)"Seq_in_index");
            MdIndexDetail detail = new MdIndexDetail(index.getKey(), util.getIdForColumn(index.getTableId(), columnName), new Integer(seqIndex));
            CaptureEvent detailevent = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
            context.getAudience().fireListeners(detailevent);
            detail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)detail);
            detailevent.setEventId(4);
            context.getAudience().fireListeners(detailevent);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    private void captureView(CaptureContext context) throws PersistenceException {
        String filePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("views_info"));
        Object[] toArray = MySQLOfflineUtils.getViews(filePath).toArray();
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
        DBObjectId schemaId = null;
        for (int j = 0; j < toArray.length / 4; ++j) {
            CloseableIterator schemasforCatalogId = util.getSchemasforCatalogId(catalogId);
            while (schemasforCatalogId.hasNext()) {
                MdSchema schema = (MdSchema)schemasforCatalogId.next();
                String schemaName = schema.getName();
                if (!schemaName.equals((String)toArray[j * 4])) continue;
                schemaId = schema.getKey();
                break;
            }
            MdView view = new MdView(schemaId, "MySQL");
            view.setViewName((String)toArray[j * 4 + 1]);
            view.setNativeSql((String)toArray[j * 4 + 2]);
            view.setCreatedBy((String)toArray[j * 4 + 3]);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)137), view.getViewName());
            context.getAudience().fireListeners(event);
            view = (MdView)this.getStorer().storeObject((PersistableObject)view);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
    }

    protected void captureStoredPrograms(CaptureContext context) throws PersistenceException {
        String filePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("routines_info"));
        HashMap<String, String> allStoredProgram = MySQLOfflineUtils.getRoutines(filePath);
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
        DBObjectId schemaId = null;
        Set<String> keySet = allStoredProgram.keySet();
        for (String string : keySet) {
            String spDefination = allStoredProgram.get(string);
            String schemaName = "";
            String routineName = "";
            String routineType = "";
            String definer = "";
            StringTokenizer st = new StringTokenizer(string, ",");
            while (st.hasMoreElements()) {
                String token = st.nextToken().trim();
                if (token.startsWith("SCHEMA")) {
                    schemaName = token.substring(token.indexOf("=") + 2, token.length() - 1);
                }
                if (token.startsWith("DEFINER")) {
                    definer = token.substring(token.indexOf("=") + 1, token.length());
                }
                if (token.startsWith("ROUTINE_NAME")) {
                    routineName = token.substring(token.indexOf("=") + 1, token.length());
                }
                if (!token.startsWith("ROUTINE_TYPE")) continue;
                routineType = token.substring(token.indexOf("=") + 1, token.length());
            }
            CloseableIterator schemasforCatalogId = util.getSchemasforCatalogId(catalogId);
            while (schemasforCatalogId.hasNext()) {
                MdSchema schema = (MdSchema)schemasforCatalogId.next();
                if (!schema.getName().equals(schemaName)) continue;
                schemaId = schema.getKey();
                break;
            }
            if (schemaId == null) continue;
            MdStoredProgram storedProgram = new MdStoredProgram(schemaId, "MySQL");
            storedProgram.setName(routineName);
            storedProgram.setProgramtype(routineType);
            storedProgram.setNativeSql(spDefination);
            storedProgram.setCreatedBy(definer);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)136), storedProgram.getName());
            context.getAudience().fireListeners(event);
            storedProgram = (MdStoredProgram)this.getStorer().storeObject((PersistableObject)storedProgram);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
    }

    public String getModelName() throws CaptureException {
        return "MySQL5";
    }

    public String[] getScriptFiles(int platformCode) throws OfflineCaptureException {
        String[] files = new String[]{"master_5.", "get_table_5.", "get_col_table_5.", "get_max_col_5.", "get_stored_proc_5.", "get_constraint_5.", "mysql5.ocp"};
        for (int i = 0; i < files.length - 1; ++i) {
            files[i] = platformCode == 2 ? files[i].concat("sh") : files[i].concat("bat");
        }
        return files;
    }
}

