/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.MySQL4Plugin;
import oracle.dbtools.migration.workbench.plugin.MySQL5Converter;
import oracle.dbtools.migration.workbench.plugin.MySQL5DbProvider;
import oracle.dbtools.migration.workbench.plugin.MySQL5OfflineCapturer;

public class MySQL5Plugin
extends MySQL4Plugin {
    public String getVersionNumber() {
        return "5.0";
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new MySQL5DbProvider(conn);
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (!platform.equals(this.getPlatformName())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (major == 5 && minor >= 0) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    public int getPlatformMask() {
        return 4;
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new MySQL5Converter();
        }
        return this.m_converter;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new MySQL5OfflineCapturer();
    }
}

