/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPrivilege;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdUserPrivilege;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOnlineCapturer;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureQueries;
import oracle.dbtools.migration.capture.QueryCapture;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.MySQLCaptureQueries;
import oracle.dbtools.migration.workbench.plugin.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.plugin.MySQLConstraintExtractor;
import oracle.dbtools.migration.workbench.plugin.MySQLMigrationAddinArb;
import oracle.dbtools.migration.workbench.plugin.mysql.MySQLConstraintDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLCapturer
extends AbstractOnlineCapturer {
    public static final String MY_LANGUAGE_ID = "MySQL";
    private static final String CAPTURE_SCHEMAS_QUERY = "SHOW DATABASES";
    private static final String CAPTURE_TABLES_QUERY = "SHOW TABLES FROM `${schema}`";
    private static final String CAPTURE_COLUMNS_QUERY = "SHOW FULL COLUMNS FROM `${schema}`.`${table}`";
    protected static final String CAPTURE_INDEX_QUERY = "SHOW INDEX FROM `${schema}`.`${table}`";
    private static final String CAPTURE_CONSTRAINT_QUERY = "SHOW CREATE TABLE `${schema}`.`${table}`";
    private static final String CAPTURE_USERS_QUERY = "SELECT * FROM mysql.user";
    protected static final String PRIMARY_KEY_INDICATOR = "PRI";
    protected static final String ENUM_DATA_TYPE = "ENUM";
    protected static final String SET_DATA_TYPE = "SET";
    private static MySQLCaptureQueries s_captureQueries;
    private String[] m_captureColumn = new String[]{"Field", "Type", "Null", "Key", "Default", "Extra", "Privileges"};
    protected int m_minorVersion;
    protected int m_majorVersion;
    private String m_modelName;
    private Logger m_logger = Logger.getLogger("oracle.dbtools.migration");

    public MySQLCapturer(MigrationStorer storer, Connection sourceConnection) {
        super(storer, sourceConnection);
    }

    public CaptureQueries getCaptureQueries() {
        if (s_captureQueries == null) {
            s_captureQueries = new MySQLCaptureQueries();
        }
        return s_captureQueries;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        if (context.shouldCancel()) {
            CaptureEvent event = new CaptureEvent(-1, objType, "");
            context.getAudience().fireListeners(event);
            return;
        }
        try {
            if (objType.equals("MD_SCHEMAS")) {
                this.captureSchemas(context, filter);
                return;
            }
            if (objType.equals("MD_TABLES")) {
                this.captureTables(context, filter);
                return;
            }
            if (objType.equals("MD_CATALOGS")) {
                this.storeDefaultCatalog(context);
                return;
            }
            if (objType.equals("MD_USERS")) {
                this.captureUsers(context, filter);
                return;
            }
            if (objType.equals("MD_COLUMNS")) {
                this.captureColumnDetails(context, filter);
                return;
            }
            if (objType.equals("MD_INDEXES")) {
                this.captureIndexForTable(context, filter);
                return;
            }
            if (objType.equals("MD_INDEX_DETAILS")) return;
            if (objType.equals("MD_CONSTRAINTS")) {
                this.captureConstraintForTable(context, filter);
                return;
            }
            if (!objType.equals("MD_CONSTRAINT_DETAILS")) return;
        }
        catch (SQLException sqlex) {
            throw new CaptureException((Throwable)sqlex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureTables(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        HashSet<String> nameFilter = new HashSet<String>();
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(CAPTURE_TABLES_QUERY);
        this.processFilter(filter, query, nameFilter, "MD_TABLES");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String tableName;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(tableName = rs.getString(1))) continue;
                QueryCapture.processTableRow((ResultSet)rs, (MigrationStorer)this.getStorer(), (CaptureContext)context);
            }
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    protected void processFilter(MigrationObjectFilter filter, StringBuffer query, HashSet<String> nameFilter, String objType) {
        if (filter != null && !filter.getObjectType().equals(objType)) {
            throw new IllegalArgumentException("Filter is of incorrect type " + filter.getObjectType());
        }
        if (filter != null && filter.getFilterType() == 2) {
            query = query.append(" ").append(filter.getWhereClause());
        }
        if (filter != null && filter.getFilterType() == 1) {
            for (String name : filter.getObjectNames()) {
                nameFilter.add(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void captureSchemas(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        HashSet<String> nameFilter = new HashSet<String>();
        CloseableResultSet crs = null;
        StringBuffer query = new StringBuffer(CAPTURE_SCHEMAS_QUERY);
        this.processFilter(filter, query, nameFilter, "MD_SCHEMAS");
        try {
            crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet rs = crs.getResultSet();
            while (rs.next()) {
                String schemaName;
                if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(schemaName = rs.getString(1)) || rs.getString(1).equalsIgnoreCase("information_schema") || rs.getString(1).equalsIgnoreCase("mysql")) continue;
                QueryCapture.processSchemaRow((ResultSet)rs, (MigrationStorer)this.getStorer(), (CaptureContext)context);
            }
        }
        finally {
            if (crs != null) {
                crs.close();
            }
        }
    }

    protected void captureUsers(CaptureContext context, MigrationObjectFilter filter) {
        try {
            CloseableResultSet allUsersCrs = null;
            CaptureAudience audience = context.getAudience();
            String schema = context.applyToSQLString("${schema}");
            StringBuffer query = new StringBuffer("SELECT * FROM mysql.db WHERE Db = '" + schema + "'");
            CloseableResultSet schemaUsersCrs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet schemaUserRs = schemaUsersCrs.getResultSet();
            while (schemaUserRs.next()) {
                StringBuffer allUsersQuery = new StringBuffer("SELECT * FROM mysql.user WHERE USER ='" + schemaUserRs.getString(3) + "'");
                String host = schemaUserRs.getString(1);
                allUsersCrs = QueryCapture.issueSQL((String)allUsersQuery.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
                ResultSet rs = allUsersCrs.getResultSet();
                while (rs.next()) {
                    DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                    if (rs.getString(2) == null || rs.getString(2).length() <= 0 || !host.equals(rs.getString(1))) continue;
                    MdUser user = new MdUser(schemaId, rs.getString(2));
                    user.setPassword(rs.getString(3));
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)144), user.getUsername());
                    audience.fireListeners(event);
                    user = (MdUser)this.getStorer().storeObject((PersistableObject)user);
                    event.setEventId(4);
                    audience.fireListeners(event);
                    this.createUserPrivilegeDetails(context, user, rs);
                }
            }
            if (allUsersCrs != null) {
                allUsersCrs.close();
            }
            if (schemaUsersCrs != null) {
                schemaUsersCrs.close();
            }
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected void createUserPrivilegeDetails(CaptureContext context, MdUser user, ResultSet userRs) {
        try {
            DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            String isGrantable = userRs.getString(14);
            for (int i = 1; i <= 26; ++i) {
                if (!userRs.getString(i + 3).equals("Y") || i == 11) continue;
                String mysqlPrivilege = userRs.getMetaData().getColumnName(i + 3);
                String privilege = this.getOracleSpecificPrivilege(this.getPrivilege(mysqlPrivilege));
                boolean isMySQLSpecific = false;
                if (privilege.length() == 0) {
                    privilege = this.getPrivilege(mysqlPrivilege);
                    isMySQLSpecific = true;
                }
                MdPrivilege priMdPrivilege = new MdPrivilege(schemaId, " ", "MD_USERS", privilege, new ClobHelper(" "));
                priMdPrivilege.setPrivelegeObjectId(user.getKey());
                if (isGrantable.equals("Y")) {
                    priMdPrivilege.setAdminOption("Y");
                } else {
                    priMdPrivilege.setAdminOption("N");
                }
                if (isMySQLSpecific) {
                    priMdPrivilege.addProperty(new AdditionalProperty(MySQLMigrationAddinArb.getString(0), privilege), connectionId);
                }
                CaptureEvent event = new CaptureEvent(3, "USER PRIVILEGE", userRs.getString(2));
                context.getAudience().fireListeners(event);
                priMdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)priMdPrivilege);
                event.setEventId(4);
                context.getAudience().fireListeners(event);
                MdUserPrivilege mdUserPrivilege = new MdUserPrivilege(user.getKey());
                mdUserPrivilege.setPrivilegeId(priMdPrivilege.getKey());
                mdUserPrivilege = (MdUserPrivilege)this.getStorer().storeObject((PersistableObject)mdUserPrivilege);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        catch (PersistenceException e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected String getOracleSpecificPrivilege(String privilege) {
        if (privilege.equalsIgnoreCase("Select")) {
            return "SELECT";
        }
        if (privilege.equalsIgnoreCase("Insert")) {
            return "INSERT";
        }
        if (privilege.equalsIgnoreCase("Update")) {
            return "UPDATE";
        }
        if (privilege.equalsIgnoreCase("References")) {
            return "REFERENCES";
        }
        if (privilege.equalsIgnoreCase("Delete")) {
            return "DELETE";
        }
        if (privilege.equalsIgnoreCase("Alter")) {
            return "ALTER";
        }
        if (privilege.equalsIgnoreCase("Index")) {
            return "INDEX";
        }
        return "";
    }

    private String getPrivilege(String columnName) {
        String privilege = columnName.substring(0, columnName.lastIndexOf("_priv"));
        return privilege;
    }

    protected void captureColumnDetails(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        CaptureAudience audience = context.getAudience();
        Object column = null;
        HashSet<String> nameFilter = new HashSet<String>();
        StringBuffer query = new StringBuffer(CAPTURE_COLUMNS_QUERY);
        this.processFilter(filter, query, nameFilter, "MD_COLUMNS");
        CloseableResultSet crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        int order = 1;
        this.m_minorVersion = this.getDataBaseMinorVersion(this.m_sourceConnection);
        this.m_majorVersion = this.m_sourceConnection.getMetaData().getDatabaseMajorVersion();
        DBObjectId tableid = (DBObjectId)context.getContextVariable("TABLEID");
        while (rs.next()) {
            String comment;
            String extra;
            if (context.shouldCancel()) {
                CaptureEvent event = new CaptureEvent(-1, "COLUMN", "");
                context.getAudience().fireListeners(event);
                crs.close();
                return;
            }
            String colName = rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(1)));
            if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(colName)) continue;
            String[] groupValues = null;
            boolean isColumnCreated = false;
            String type = rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(2)));
            MySQLColumnHelper mysqlColumnHelper = new MySQLColumnHelper(type);
            String dataType = mysqlColumnHelper.getDataTypeName();
            if ((dataType.equals(ENUM_DATA_TYPE) || dataType.equals(SET_DATA_TYPE)) && (groupValues = this.getAllValues(type)) != null) {
                column = dataType.equals(ENUM_DATA_TYPE) ? new MdEnumColumn(tableid, colName, Integer.valueOf(order++), groupValues, connectionId) : new MdSetColumn(tableid, colName, Integer.valueOf(order++), groupValues, connectionId);
                isColumnCreated = true;
            }
            if ((extra = rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(6)))).equals("auto_increment") && !isColumnCreated) {
                String database = context.applyToSQLString("${schema}");
                String table = context.applyToSQLString("${table}");
                String maxQuery = "SELECT MAX(`" + colName + "`)" + " FROM " + database + "." + table;
                CloseableResultSet lastValCrs = QueryCapture.issueSQL((String)maxQuery, (Connection)this.m_sourceConnection, (CaptureContext)context);
                ResultSet lastValRs = lastValCrs.getResultSet();
                long lastVal = 0L;
                while (lastValRs.next()) {
                    lastVal = lastValRs.getLong(1);
                }
                lastValCrs.close();
                column = new MdIdentityColumn(tableid, colName, Integer.valueOf(order++), 0L, 1L, lastVal, connectionId);
                isColumnCreated = true;
            }
            if (!isColumnCreated) {
                column = new MdColumn(tableid, colName, Integer.valueOf(order++));
            }
            if (extra != null && extra.trim().length() > 0) {
                column.addProperty(new AdditionalProperty("EXTRA", extra), connectionId);
            }
            column.setColumnType(dataType);
            column.setPrecision(Integer.valueOf(mysqlColumnHelper.getPrecision()));
            if (mysqlColumnHelper.hasPrecisionAndScale()) {
                column.setScale(Integer.valueOf(mysqlColumnHelper.getScale()));
            }
            if (rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(3))).equalsIgnoreCase("YES")) {
                column.setNullable("Y");
            } else {
                column.setNullable("N");
            }
            String fieldKey = rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(4)));
            if (fieldKey.equals(PRIMARY_KEY_INDICATOR)) {
                // empty if block
            }
            column.setDefaultValue(rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(5))));
            if (this.m_majorVersion == 4 && this.m_minorVersion >= 1 && (comment = rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(8)))) != null && comment.length() > 0) {
                column.setComments(comment);
            }
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), column.getColumnName());
            audience.fireListeners(event);
            column = (MdColumn)this.getStorer().storeObject((PersistableObject)column);
            event.setEventId(4);
            audience.fireListeners(event);
            String privilege = rs.getString(this.getColumnCaptureInfo(MySQLMigrationAddinArb.getString(7)));
            if (privilege == null || privilege.trim().length() <= 0) continue;
            this.captureColumnPrivilege(privilege, context, (MdColumn)column);
        }
        crs.close();
    }

    protected int getDataBaseMinorVersion(Connection sourceConnection) throws SQLException {
        return sourceConnection.getMetaData().getDatabaseMinorVersion();
    }

    protected int getColumnCaptureInfo(String columnHeader) {
        for (int i = 0; i < this.m_captureColumn.length; ++i) {
            if (!this.m_captureColumn[i].equalsIgnoreCase(columnHeader)) continue;
            return i + 1;
        }
        return 1;
    }

    protected void captureColumnPrivilege(String privilege, CaptureContext context, MdColumn column) throws PersistenceException {
        DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
        StringTokenizer st = new StringTokenizer(privilege, ",");
        while (st.hasMoreTokens()) {
            String nextElement = (String)st.nextElement();
            if (nextElement == null) continue;
            MdPrivilege priMdPrivilege = new MdPrivilege(schemaId, " ", "MD_COLUMNS", nextElement, new ClobHelper(" "));
            priMdPrivilege.setPrivelegeObjectId(column.getKey());
            CaptureEvent event = new CaptureEvent(3, "COLUMN PRIVILEGE", nextElement);
            context.getAudience().fireListeners(event);
            priMdPrivilege = (MdPrivilege)this.getStorer().storeObject((PersistableObject)priMdPrivilege);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
    }

    protected String[] getAllValues(String dataTypedef) {
        String remBraces = dataTypedef.substring(dataTypedef.indexOf("(") + 1, dataTypedef.indexOf(")"));
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(remBraces, "'");
        while (st.hasMoreTokens()) {
            String nextElement = (String)st.nextElement();
            if (nextElement.equals(",")) continue;
            values.add(nextElement);
        }
        return values.toArray(new String[values.size()]);
    }

    protected void captureIndexForTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        boolean finished;
        HashSet<String> nameFilter = new HashSet<String>();
        StringBuffer query = new StringBuffer(CAPTURE_INDEX_QUERY);
        this.processFilter(filter, query, nameFilter, "MD_INDEXES");
        CloseableResultSet crs = null;
        crs = QueryCapture.issueSQL((String)query.toString(), (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        boolean bl = finished = !rs.next();
        while (!finished) {
            int detailOrder = 1;
            if (context.shouldCancel()) {
                CaptureEvent event = new CaptureEvent(-1, "INDEX", "");
                context.getAudience().fireListeners(event);
                crs.close();
                return;
            }
            String colName = rs.getString(3);
            if (filter != null && filter.getFilterType() == 1 && !nameFilter.contains(colName)) {
                finished = !rs.next();
                continue;
            }
            DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
            int nonUnique = rs.getInt(2);
            String database = context.applyToSQLString("${schema}");
            String newQuery = "SHOW COLUMNS FROM `" + database + "`.`" + rs.getString(1) + "`";
            CloseableResultSet columnCrs = QueryCapture.issueSQL((String)newQuery, (Connection)this.m_sourceConnection, (CaptureContext)context);
            ResultSet columnRs = columnCrs.getResultSet();
            String indexkey = "";
            while (columnRs.next()) {
                if (!columnRs.getString(1).equals(rs.getString(5))) continue;
                indexkey = columnRs.getString(4);
                break;
            }
            columnCrs.close();
            if (indexkey.startsWith(PRIMARY_KEY_INDICATOR) && nonUnique == 0 && rs.getString(3).equals("PRIMARY")) {
                MdConstraint constraint = this.createPrimaryIndexConstraint(context, rs.getString(3), tableId);
                do {
                    this.createPrimaryIndexConstraintDetails(context, constraint, rs.getString(5), detailOrder++, tableId);
                } while (!(finished = !rs.next()) && rs.getString(3).equals(constraint.getObjectName()));
                continue;
            }
            MdIndexe index = new MdIndexe(tableId);
            index.setIndexName(rs.getString(3));
            if (indexkey.startsWith("UNI")) {
                index.setIndexType("UNIQUE");
            } else {
                index.setIndexType("NON_UNIQUE");
            }
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), index.getIndexName());
            context.getAudience().fireListeners(event);
            index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
            do {
                this.createIndexDetails(context, index, rs, detailOrder++);
            } while (!(finished = !rs.next()) && rs.getString(3).equals(index.getIndexName()));
        }
        crs.close();
    }

    protected MdConstraint createPrimaryIndexConstraint(CaptureContext context, String constraintName, DBObjectId tableId) throws SQLException, PersistenceException {
        MdConstraint constraint = new MdConstraint(tableId, MY_LANGUAGE_ID);
        constraint.setName(constraintName);
        constraint.setConstraintType("PK");
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), constraintName);
        context.getAudience().fireListeners(event);
        constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
        return constraint;
    }

    protected void createPrimaryIndexConstraintDetails(CaptureContext context, MdConstraint con, String columnName, int detailOrder, DBObjectId tableId) throws PersistenceException, SQLException {
        MdConstraintDetail detail = new MdConstraintDetail(con.getKey(), Integer.valueOf(1));
        DBObjectId colId = this.getStorer().getPersistenceUtility().getIdForColumn(tableId, columnName);
        detail.setColumnId(colId);
        detail.setRefFlag("N");
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), con.getName());
        context.getAudience().fireListeners(event);
        detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void createIndexDetails(CaptureContext context, MdIndexe index, ResultSet rs, int detailOrder) throws PersistenceException, SQLException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        MdIndexDetail detail = new MdIndexDetail(index.getKey(), util.getIdForColumn(index.getTableId(), rs.getString(5)), Integer.valueOf(detailOrder));
        int subPart = rs.getInt(8);
        if (!rs.wasNull()) {
            detail.setIndexPortion(Integer.valueOf(subPart));
        }
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
        context.getAudience().fireListeners(event);
        detail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)detail);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void captureConstraintForTable(CaptureContext context, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        CloseableResultSet crs = QueryCapture.issueSQL((String)CAPTURE_CONSTRAINT_QUERY, (Connection)this.m_sourceConnection, (CaptureContext)context);
        ResultSet rs = crs.getResultSet();
        rs.next();
        this.processContraintRow(context, crs, filter);
        if (crs != null) {
            crs.close();
        }
    }

    private void processContraintRow(CaptureContext context, CloseableResultSet crs, MigrationObjectFilter filter) throws SQLException, PersistenceException {
        MySQLConstraintDetails[] constraints;
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
        DBObjectId tableId = (DBObjectId)context.getContextVariable("TABLEID");
        ResultSet rs = crs.getResultSet();
        String createTableStmt = rs.getString(2);
        MySQLConstraintExtractor extractor = new MySQLConstraintExtractor(createTableStmt);
        for (MySQLConstraintDetails cons : constraints = extractor.getConstraintDetails()) {
            if (context.shouldCancel()) {
                CaptureEvent event = new CaptureEvent(-1, MigrationAddinArb.getString((int)139), "");
                context.getAudience().fireListeners(event);
                crs.close();
                return;
            }
            if (filter != null && filter.getFilterType() == 1) {
                HashSet<String> nameFilter = new HashSet<String>();
                this.processFilter(filter, new StringBuffer(), nameFilter, "MD_CONSTRAINTS");
                if (!nameFilter.contains(cons.getName())) {
                    continue;
                }
            } else if (filter != null && filter.getFilterType() == 2) {
                this.m_logger.log(Level.SEVERE, "Where Clause Filter Not supported for Constraints in", new Object[]{"MySQL Capturer"});
                throw new UnsupportedOperationException("Where Clause Filter Not supported for Constraints");
            }
            MdConstraint migrconstraint = new MdConstraint(tableId, MY_LANGUAGE_ID);
            migrconstraint.setConstraintType("FOREIGN KEY");
            migrconstraint.setName(cons.getName());
            DBObjectId refTableId = util.getIdForTable(schemaId, cons.getReferencedTableName());
            migrconstraint.setReftableId(refTableId);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), migrconstraint.getName());
            context.getAudience().fireListeners(event);
            migrconstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)migrconstraint);
            int order = this.createConstraintDetails(tableId, migrconstraint, cons.getColumnNames(), "N", 1, context);
            this.createConstraintDetails(refTableId, migrconstraint, cons.getReferencedColumnNames(), "Y", order, context);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
    }

    protected int createConstraintDetails(DBObjectId tableId, MdConstraint migrconstraint, String[] cols, String flagIndicator, int order, CaptureContext context) throws PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        int constraintOrder = order;
        for (String colname : cols) {
            MdConstraintDetail detail = new MdConstraintDetail(migrconstraint.getKey(), Integer.valueOf(constraintOrder++));
            DBObjectId colId = util.getIdForColumn(tableId, colname);
            detail.setColumnId(colId);
            detail.setRefFlag(flagIndicator);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), migrconstraint.getName());
            context.getAudience().fireListeners(event);
            detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
        return constraintOrder;
    }

    protected void storeDefaultCatalog(CaptureContext context) throws PersistenceException {
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        MdCatalog catalog = new MdCatalog(connectionId);
        catalog.setDummyFlag("Y");
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)142), "");
        context.getAudience().fireListeners(event);
        catalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)catalog);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    public String getModelName() throws CaptureException {
        if (this.m_modelName == null) {
            try {
                DatabaseMetaData dbmd = this.m_sourceConnection.getMetaData();
                String url = dbmd.getURL();
                String[] parts = url.split("/");
                String user = dbmd.getUserName();
                String[] userParts = user.split("@");
                this.m_modelName = userParts[0] + "@" + parts[2] + ":" + this.m_sourceConnection.getCatalog() + " (" + dbmd.getDatabaseProductName() + ")";
            }
            catch (SQLException sqlex) {
                this.m_logger.log(Level.SEVERE, "Unable to get the model name in", new Object[]{"MySQL Capturer"});
                throw new CaptureException((Throwable)sqlex);
            }
        }
        return this.m_modelName;
    }
}

