/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

public class MySQLColumnHelper {
    private String _originalDefinition;
    private String _normalisedType;
    private INTERNAL_TYPE_CODES _internalTypeCode;
    private boolean _bHasPrecisionOnly;
    private boolean _bHasPrecisionAndScale;
    private int _precision;
    private int _scale;

    public MySQLColumnHelper(String mysqlDef) {
        this._originalDefinition = mysqlDef;
        this._internalTypeCode = MySQLColumnHelper._columnTypeAsInt(mysqlDef);
        this._normalisedType = MySQLColumnHelper._columnTypeAsString(this._internalTypeCode);
        this._bHasPrecisionOnly = MySQLColumnHelper._datatypeHasPrecisionOnly(this._internalTypeCode);
        this._bHasPrecisionAndScale = MySQLColumnHelper._datatypeHasPrecisionAndScale(this._internalTypeCode);
        this._precision = MySQLColumnHelper._getDatatypePrecision(mysqlDef);
        if (this._bHasPrecisionAndScale) {
            this._scale = MySQLColumnHelper._getDatatypeScale(mysqlDef);
        }
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() throws IllegalStateException {
        if (!this.hasPrecisionAndScale()) {
            throw new IllegalStateException("datatype " + this._normalisedType + " does not have scale");
        }
        return this._scale;
    }

    public boolean hasPrecisionAndScale() {
        return this._bHasPrecisionAndScale;
    }

    public boolean hasPrecisionOnly() {
        return this._bHasPrecisionOnly;
    }

    public String getDataTypeName() {
        return this._normalisedType;
    }

    private static String _columnTypeAsString(INTERNAL_TYPE_CODES colType) {
        switch (colType) {
            case _TINYINT_: {
                return "TINYINT";
            }
            case _SMALLINT_: {
                return "SMALLINT";
            }
            case _MEDIUMINT_: {
                return "MEDIUMINT";
            }
            case _INT_: {
                return "INT";
            }
            case _INTEGER_: {
                return "INTEGER";
            }
            case _BIGINT_: {
                return "BIGINT";
            }
            case _FLOAT_: {
                return "FLOAT";
            }
            case _DOUBLE_: {
                return "DOUBLE";
            }
            case _DOUBLE_PRECISION_: {
                return "DOUBLE PRECISION";
            }
            case _REAL_: {
                return "REAL";
            }
            case _DECIMAL_: {
                return "DECIMAL";
            }
            case _NUMERIC_: {
                return "NUMERIC";
            }
            case _DATE_: {
                return "DATE";
            }
            case _DATETIME_: {
                return "DATETIME";
            }
            case _TIMESTAMP_: {
                return "TIMESTAMP";
            }
            case _TIME_: {
                return "TIME";
            }
            case _YEAR_: {
                return "YEAR";
            }
            case _CHAR_: {
                return "CHAR";
            }
            case _VARCHAR_: {
                return "VARCHAR";
            }
            case _TINYBLOB_: {
                return "TINYBLOB";
            }
            case _TINYTEXT_: {
                return "TINYTEXT";
            }
            case _BLOB_: {
                return "BLOB";
            }
            case _TEXT_: {
                return "TEXT";
            }
            case _MEDIUMBLOB_: {
                return "MEDIUMBLOB";
            }
            case _MEDIUMTEXT_: {
                return "MEDIUMTEXT";
            }
            case _LONGBLOB_: {
                return "LONGBLOB";
            }
            case _LONGTEXT_: {
                return "LONGTEXT";
            }
            case _ENUM_: {
                return "ENUM";
            }
            case _SET_: {
                return "SET";
            }
            case _BIT_: {
                return "BIT";
            }
            case _BINARY_: {
                return "BINARY";
            }
            case _VARBINARY_: {
                return "VARBINARY";
            }
        }
        return null;
    }

    private static INTERNAL_TYPE_CODES _columnTypeAsInt(String colType) {
        if (colType.startsWith("tinyint")) {
            return INTERNAL_TYPE_CODES._TINYINT_;
        }
        if (colType.startsWith("smallint")) {
            return INTERNAL_TYPE_CODES._SMALLINT_;
        }
        if (colType.startsWith("mediumint")) {
            return INTERNAL_TYPE_CODES._MEDIUMINT_;
        }
        if (colType.startsWith("int")) {
            return INTERNAL_TYPE_CODES._INT_;
        }
        if (colType.startsWith("integer")) {
            return INTERNAL_TYPE_CODES._INTEGER_;
        }
        if (colType.startsWith("bigint")) {
            return INTERNAL_TYPE_CODES._BIGINT_;
        }
        if (colType.startsWith("float")) {
            return INTERNAL_TYPE_CODES._FLOAT_;
        }
        if (colType.startsWith("double")) {
            return INTERNAL_TYPE_CODES._DOUBLE_;
        }
        if (colType.startsWith("double precision")) {
            return INTERNAL_TYPE_CODES._DOUBLE_PRECISION_;
        }
        if (colType.startsWith("real")) {
            return INTERNAL_TYPE_CODES._REAL_;
        }
        if (colType.startsWith("decimal")) {
            return INTERNAL_TYPE_CODES._DECIMAL_;
        }
        if (colType.startsWith("numeric")) {
            return INTERNAL_TYPE_CODES._NUMERIC_;
        }
        if (colType.startsWith("date")) {
            return INTERNAL_TYPE_CODES._DATE_;
        }
        if (colType.startsWith("datetime")) {
            return INTERNAL_TYPE_CODES._DATETIME_;
        }
        if (colType.startsWith("timestamp")) {
            return INTERNAL_TYPE_CODES._TIMESTAMP_;
        }
        if (colType.startsWith("time")) {
            return INTERNAL_TYPE_CODES._TIME_;
        }
        if (colType.startsWith("year")) {
            return INTERNAL_TYPE_CODES._YEAR_;
        }
        if (colType.startsWith("char")) {
            return INTERNAL_TYPE_CODES._CHAR_;
        }
        if (colType.startsWith("varchar")) {
            return INTERNAL_TYPE_CODES._VARCHAR_;
        }
        if (colType.startsWith("tinyblob")) {
            return INTERNAL_TYPE_CODES._TINYBLOB_;
        }
        if (colType.startsWith("tinytext")) {
            return INTERNAL_TYPE_CODES._TINYTEXT_;
        }
        if (colType.startsWith("blob")) {
            return INTERNAL_TYPE_CODES._BLOB_;
        }
        if (colType.startsWith("text")) {
            return INTERNAL_TYPE_CODES._TEXT_;
        }
        if (colType.startsWith("mediumblob")) {
            return INTERNAL_TYPE_CODES._MEDIUMBLOB_;
        }
        if (colType.startsWith("mediumtext")) {
            return INTERNAL_TYPE_CODES._MEDIUMTEXT_;
        }
        if (colType.startsWith("longblob")) {
            return INTERNAL_TYPE_CODES._LONGBLOB_;
        }
        if (colType.startsWith("longtext")) {
            return INTERNAL_TYPE_CODES._LONGTEXT_;
        }
        if (colType.startsWith("enum")) {
            return INTERNAL_TYPE_CODES._ENUM_;
        }
        if (colType.startsWith("set")) {
            return INTERNAL_TYPE_CODES._SET_;
        }
        if (colType.startsWith("bit")) {
            return INTERNAL_TYPE_CODES._BIT_;
        }
        if (colType.startsWith("binary")) {
            return INTERNAL_TYPE_CODES._BINARY_;
        }
        if (colType.startsWith("varbinary")) {
            return INTERNAL_TYPE_CODES._VARBINARY_;
        }
        return INTERNAL_TYPE_CODES._INVALID_;
    }

    private static boolean _datatypeHasPrecisionOnly(INTERNAL_TYPE_CODES dataTypeCode) {
        boolean datatypeHasPrecisionOnly = false;
        if (dataTypeCode == INTERNAL_TYPE_CODES._TINYINT_ || dataTypeCode == INTERNAL_TYPE_CODES._SMALLINT_ || dataTypeCode == INTERNAL_TYPE_CODES._MEDIUMINT_ || dataTypeCode == INTERNAL_TYPE_CODES._INT_ || dataTypeCode == INTERNAL_TYPE_CODES._INTEGER_ || dataTypeCode == INTERNAL_TYPE_CODES._BIGINT_ || dataTypeCode == INTERNAL_TYPE_CODES._YEAR_ || dataTypeCode == INTERNAL_TYPE_CODES._CHAR_ || dataTypeCode == INTERNAL_TYPE_CODES._VARCHAR_ || dataTypeCode == INTERNAL_TYPE_CODES._TINYBLOB_ || dataTypeCode == INTERNAL_TYPE_CODES._TINYTEXT_ || dataTypeCode == INTERNAL_TYPE_CODES._BLOB_ || dataTypeCode == INTERNAL_TYPE_CODES._TEXT_ || dataTypeCode == INTERNAL_TYPE_CODES._MEDIUMBLOB_ || dataTypeCode == INTERNAL_TYPE_CODES._MEDIUMTEXT_ || dataTypeCode == INTERNAL_TYPE_CODES._LONGBLOB_ || dataTypeCode == INTERNAL_TYPE_CODES._LONGTEXT_ || dataTypeCode == INTERNAL_TYPE_CODES._BIT_ || dataTypeCode == INTERNAL_TYPE_CODES._BINARY_ || dataTypeCode == INTERNAL_TYPE_CODES._VARBINARY_) {
            datatypeHasPrecisionOnly = true;
        }
        return datatypeHasPrecisionOnly;
    }

    private static boolean _datatypeHasPrecisionAndScale(INTERNAL_TYPE_CODES datatypeAsInt) {
        boolean datatypeHasPrecisionAndScale = false;
        if (datatypeAsInt == INTERNAL_TYPE_CODES._FLOAT_ || datatypeAsInt == INTERNAL_TYPE_CODES._DOUBLE_ || datatypeAsInt == INTERNAL_TYPE_CODES._DOUBLE_PRECISION_ || datatypeAsInt == INTERNAL_TYPE_CODES._REAL_ || datatypeAsInt == INTERNAL_TYPE_CODES._DECIMAL_) {
            datatypeHasPrecisionAndScale = true;
        }
        return datatypeHasPrecisionAndScale;
    }

    private static int _getDatatypePrecision(String datatype) {
        int endIndex;
        int startIndex = datatype.indexOf("(") + 1;
        if (-1 != startIndex && -1 != (endIndex = datatype.indexOf(")", startIndex))) {
            Integer intPrecision;
            String strPrecision = null;
            try {
                strPrecision = datatype.substring(startIndex, endIndex);
            }
            catch (StringIndexOutOfBoundsException e) {
                return MySQLColumnHelper._defaultPrecision(datatype);
            }
            try {
                intPrecision = new Integer(strPrecision);
            }
            catch (NumberFormatException e) {
                return MySQLColumnHelper._defaultPrecision(datatype);
            }
            return intPrecision;
        }
        return MySQLColumnHelper._defaultPrecision(datatype);
    }

    private static int _getDatatypeScale(String datatype) {
        int endIndex;
        int startIndex = datatype.indexOf(",") + 1;
        if (-1 != startIndex && -1 != (endIndex = datatype.indexOf(")", startIndex))) {
            Integer intScale;
            String strScale = null;
            try {
                strScale = datatype.substring(startIndex, endIndex);
            }
            catch (StringIndexOutOfBoundsException e) {
                return MySQLColumnHelper._defaultScale(datatype);
            }
            try {
                intScale = new Integer(strScale);
            }
            catch (NumberFormatException e) {
                return MySQLColumnHelper._defaultScale(datatype);
            }
            return intScale;
        }
        return MySQLColumnHelper._defaultScale(datatype);
    }

    private static int _defaultPrecision(String colType) {
        if (colType.startsWith("tinyint")) {
            return 3;
        }
        if (colType.startsWith("smallint")) {
            return 5;
        }
        if (colType.startsWith("mediumint")) {
            return 8;
        }
        if (colType.startsWith("int")) {
            return 10;
        }
        if (colType.startsWith("integer")) {
            return 10;
        }
        if (colType.startsWith("bigint")) {
            return 19;
        }
        if (colType.startsWith("char")) {
            return 1;
        }
        if (colType.startsWith("varchar")) {
            return 3;
        }
        if (colType.startsWith("tinyblob")) {
            return 3;
        }
        if (colType.startsWith("tinytext")) {
            return 3;
        }
        if (colType.startsWith("blob")) {
            return 5;
        }
        if (colType.startsWith("text")) {
            return 5;
        }
        if (colType.startsWith("mediumblob")) {
            return 8;
        }
        if (colType.startsWith("mediumtext")) {
            return 8;
        }
        if (colType.startsWith("longblob")) {
            return 10;
        }
        if (colType.startsWith("longtext")) {
            return 10;
        }
        if (colType.startsWith("bit")) {
            return 1;
        }
        if (colType.startsWith("binary")) {
            return 1;
        }
        if (colType.startsWith("varbinary")) {
            return 3;
        }
        return 0;
    }

    private static int _defaultScale(String colType) {
        if (colType.startsWith("float")) {
            return 9;
        }
        if (colType.startsWith("double")) {
            return 16;
        }
        if (colType.startsWith("decimal")) {
            return 16;
        }
        return 0;
    }

    private static String _addEscSequences(String input) {
        Character singleQuote = new Character('\'');
        if (-1 != input.indexOf("'")) {
            String output = new String();
            for (int i = 0; i < input.length(); ++i) {
                Character nextChar = new Character(input.charAt(i));
                output = nextChar.equals(singleQuote) ? output + "''" : output + nextChar.charValue();
            }
            return output;
        }
        return input;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum INTERNAL_TYPE_CODES {
        _TINYINT_,
        _SMALLINT_,
        _MEDIUMINT_,
        _INT_,
        _INTEGER_,
        _BIGINT_,
        _FLOAT_,
        _DOUBLE_,
        _DOUBLE_PRECISION_,
        _REAL_,
        _DECIMAL_,
        _NUMERIC_,
        _DATE_,
        _DATETIME_,
        _TIMESTAMP_,
        _TIME_,
        _YEAR_,
        _CHAR_,
        _VARCHAR_,
        _TINYBLOB_,
        _TINYTEXT_,
        _BLOB_,
        _TEXT_,
        _MEDIUMBLOB_,
        _MEDIUMTEXT_,
        _LONGBLOB_,
        _LONGTEXT_,
        _ENUM_,
        _SET_,
        _BIT_,
        _INVALID_,
        _VARBINARY_,
        _BINARY_;

    }
}

