/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.dbtools.migration.workbench.plugin.mysql.MySQLConstraintDetails;

public class MySQLConstraintExtractor {
    private String m_createStatement;
    private ArrayList<MySQLConstraintDetails> m_constraints;

    public MySQLConstraintExtractor(String createStatement) {
        this.m_createStatement = createStatement;
        this.m_constraints = new ArrayList();
        this.parseCreateStatement();
    }

    public String[] getConstraintNames() {
        String[] ret = new String[this.m_constraints.size()];
        int i = 0;
        for (MySQLConstraintDetails detail : this.m_constraints) {
            ret[i++] = detail.getName();
        }
        return ret;
    }

    public MySQLConstraintDetails[] getConstraintDetails() {
        return this.m_constraints.toArray(new MySQLConstraintDetails[this.m_constraints.size()]);
    }

    private void parseCreateStatement() {
        int fromIndex = 0;
        int startPosition = 0;
        ArrayList<String> fkStatements = new ArrayList<String>();
        while ((startPosition = this.m_createStatement.indexOf("CONSTRAINT", fromIndex)) != -1) {
            int endOfConstraint = this.m_createStatement.indexOf("\n", startPosition);
            String constraintText = "";
            if (endOfConstraint != -1) {
                constraintText = this.m_createStatement.substring(startPosition, endOfConstraint);
                if (constraintText.endsWith(",")) {
                    constraintText = constraintText.substring(0, constraintText.length() - 1);
                }
                fkStatements.add(constraintText);
            }
            fromIndex = endOfConstraint;
        }
        int fkID = 0;
        for (String fkStatement : fkStatements) {
            MySQLConstraintDetails constraintDetail = new MySQLConstraintDetails();
            ++fkID;
            int fkKeysStartPos = fkStatement.indexOf("CONSTRAINT", 0);
            if (fkKeysStartPos == -1) continue;
            int fkNameStartPos = fkStatement.indexOf("`", fkKeysStartPos);
            int fkNameEndPos = fkStatement.indexOf("`", fkNameStartPos + 1);
            if (fkNameStartPos != -1 && fkNameEndPos != -1) {
                String fkName = fkStatement.substring(fkNameStartPos + 1, fkNameEndPos);
                constraintDetail.setName(fkName);
                this.m_constraints.add(constraintDetail);
            }
            fkKeysStartPos = fkStatement.indexOf("(", fkKeysStartPos);
            int fkKeysEndPos = fkStatement.indexOf(")", fkKeysStartPos);
            if (fkKeysStartPos == -1 || fkKeysEndPos == -1) continue;
            StringTokenizer fkTokens = new StringTokenizer(fkStatement.substring(fkKeysStartPos + 1, fkKeysEndPos), ",");
            while (fkTokens.hasMoreTokens()) {
                String token = fkTokens.nextToken();
                if ((token = token.trim()).startsWith("`")) {
                    token = token.substring(1, token.length());
                }
                if (token.endsWith("`")) {
                    token = token.substring(0, token.length() - 1);
                }
                constraintDetail.addFKey(token);
            }
            int refTableStartPos = fkStatement.indexOf("REFERENCES", fkKeysEndPos);
            if (refTableStartPos == -1) continue;
            refTableStartPos = fkStatement.indexOf("`", refTableStartPos);
            int refTableEndPos = fkStatement.indexOf("`", refTableStartPos + 1);
            if (refTableStartPos != -1 && refTableEndPos != -1) {
                String refTableName = fkStatement.substring(refTableStartPos, refTableEndPos);
                if (refTableName.startsWith("`")) {
                    refTableName = refTableName.substring(1, refTableName.length());
                }
                if (refTableName.endsWith("`")) {
                    refTableName = refTableName.substring(0, refTableName.length() - 1);
                }
                constraintDetail.setReferencedTableName(refTableName);
            }
            int refKeysStartPos = fkStatement.indexOf("(", refTableEndPos);
            int refKeysEndPos = fkStatement.indexOf(")", refKeysStartPos);
            if (refKeysStartPos == -1 || refKeysEndPos == -1) continue;
            StringTokenizer refTokens = new StringTokenizer(fkStatement.substring(refKeysStartPos + 1, refKeysEndPos), ",");
            while (refTokens.hasMoreTokens()) {
                String token = refTokens.nextToken();
                if ((token = token.trim()).startsWith("`")) {
                    token = token.substring(1, token.length());
                }
                if (token.endsWith("`")) {
                    token = token.substring(0, token.length() - 1);
                }
                constraintDetail.addReferencedKey(token);
            }
            int fkRuleStartPos = fkStatement.indexOf("ON", refKeysEndPos);
            if (fkRuleStartPos == -1) continue;
            String fkRule = fkStatement.substring(fkRuleStartPos, fkStatement.length());
            if ((fkRule = fkRule.trim()).endsWith(",")) {
                fkRule = fkRule.substring(0, fkRule.length() - 1);
            }
            constraintDetail.setRule(fkRule);
        }
    }
}

