/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.AbstractConverter;
import oracle.dbtools.migration.convert.ConvertException;
import oracle.dbtools.migration.convert.ConvertResult;
import oracle.dbtools.migration.convert.ConvertResultImpl;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.translation.api.ITranslator;

public class MySQLConverter
extends AbstractConverter {
    private static final String CRLF = "\r\n";
    private static ArrayList<DBObjectId> s_listOfSchema = new ArrayList();
    private static String s_functionName = "getTokenizer";

    public ITranslator getPlaformTranslator() {
        return null;
    }

    public String getDefaultValueMappingXML() {
        return "/oracle/dbtools/migration/workbench/plugin/mysql/MySQLDefaultValuesMappingRules.xml";
    }

    public ConvertResult convertObject(PersistableObject schemaObj, String matchingKey, PersistenceManager pman) throws ConvertException {
        if (matchingKey.equals("ENUM")) {
            return this.transformEnum((MdColumn)schemaObj, pman);
        }
        if (matchingKey.equals("SET")) {
            return this.transformSet((MdColumn)schemaObj, pman);
        }
        return null;
    }

    public String[] getPropertyKeyList() {
        String[] interestingKeys = new String[]{"ENUM", "SET"};
        return interestingKeys;
    }

    protected ConvertResult transformEnum(MdColumn col, PersistenceManager pman) throws ConvertException {
        String tableName;
        try {
            MdTable parent = MdTable.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)col.getTableId());
            tableName = parent.getTableName();
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException((Exception)((Object)nsoe));
        }
        catch (PersistenceException pex) {
            throw new ConvertException((Exception)((Object)pex));
        }
        ArrayList<String> enumValList = new ArrayList<String>();
        for (AdditionalProperty prop : col.getAdditionalProperties()) {
            if (!prop.getKey().equals("ENUM")) continue;
            enumValList.add(prop.getValue());
        }
        if (enumValList.size() == 0) {
            throw new ConvertException("No enum values found");
        }
        String[] enumVals = enumValList.toArray(new String[enumValList.size()]);
        String newName = ConvertUtils.generateName((String)(tableName + "_" + col.getColumnName() + "_ETRG"));
        String triggerText = this.createTriggerText(tableName, col.getColumnName(), PersistenceUtility.isColumnNullable((MdColumn)col), enumVals, newName);
        MdTrigger trigger = new MdTrigger(col.getTableId(), "T", "OracleSQL");
        trigger.setNativeSql(triggerText);
        trigger.setTriggerName(newName);
        trigger.setTriggerTiming("BEFORE");
        trigger.setTriggerOperation("INSERT OR UPDATE");
        ConvertResultImpl res = new ConvertResultImpl((PersistableObject)col);
        res.addNewDerivedObject((PersistableObject)trigger);
        return res;
    }

    protected ConvertResult transformSet(MdColumn col, PersistenceManager pman) throws ConvertException {
        String tableName;
        MdTable parent;
        try {
            parent = MdTable.retrieveExistingInstance((PersistenceManager)pman, (DBObjectId)col.getTableId());
            tableName = parent.getTableName();
        }
        catch (NoSuchObjectException nsoe) {
            throw new ConvertException((Exception)((Object)nsoe));
        }
        catch (PersistenceException pex) {
            throw new ConvertException((Exception)((Object)pex));
        }
        ArrayList<String> setValList = new ArrayList<String>();
        for (AdditionalProperty prop : col.getAdditionalProperties()) {
            if (!prop.getKey().equals("SET")) continue;
            setValList.add(prop.getValue());
        }
        if (setValList.size() == 0) {
            throw new ConvertException("No set values found");
        }
        String[] setVals = setValList.toArray(new String[setValList.size()]);
        String newTriggerName = ConvertUtils.generateName((String)(tableName + "_" + col.getColumnName() + "_STRG"));
        DBObjectId schemaId = parent.getSchemaId();
        String triggerText = this.createSetTriggerText(tableName, col.getColumnName(), PersistenceUtility.isColumnNullable((MdColumn)col), setVals, newTriggerName);
        ConvertResultImpl res = new ConvertResultImpl((PersistableObject)col);
        res.setMaintainOrder(true);
        boolean isFunctionExists = false;
        if (s_listOfSchema.contains(schemaId)) {
            isFunctionExists = true;
        }
        if (!isFunctionExists) {
            String functionText = this.createSetFunctionText();
            MdStoredProgram setFunction = new MdStoredProgram(schemaId, "OracleSQL");
            setFunction.setProgramtype("FUNCTION");
            setFunction.setNativeSql(functionText);
            res.addNewDerivedObject((PersistableObject)setFunction);
            s_listOfSchema.add(schemaId);
        }
        MdTrigger trigger = new MdTrigger(col.getTableId(), "T", "OracleSQL");
        trigger.setNativeSql(triggerText);
        trigger.setTriggerName(newTriggerName);
        trigger.setTriggerTiming("BEFORE");
        trigger.setTriggerOperation("INSERT OR UPDATE");
        res.addNewDerivedObject((PersistableObject)trigger);
        return res;
    }

    private String createSetFunctionText() {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("CREATE OR REPLACE FUNCTION " + s_functionName + "(");
        sBuf.append(CRLF);
        sBuf.append("the_list  varchar2,");
        sBuf.append(CRLF);
        sBuf.append("the_index number,");
        sBuf.append(CRLF);
        sBuf.append("delim     varchar2 := ','");
        sBuf.append(CRLF);
        sBuf.append(")");
        sBuf.append(CRLF);
        sBuf.append("return    varchar2");
        sBuf.append(CRLF);
        sBuf.append("is");
        sBuf.append(CRLF);
        sBuf.append("start_pos number;");
        sBuf.append(CRLF);
        sBuf.append("end_pos   number;");
        sBuf.append(CRLF);
        sBuf.append("begin");
        sBuf.append(CRLF);
        sBuf.append(" if the_index = 1 then");
        sBuf.append(CRLF);
        sBuf.append("start_pos := 1;");
        sBuf.append(CRLF);
        sBuf.append("else");
        sBuf.append(CRLF);
        sBuf.append("start_pos := instr(the_list,delim,1,the_index - 1);");
        sBuf.append(CRLF);
        sBuf.append("if start_pos = 0 then");
        sBuf.append(CRLF);
        sBuf.append("return null;");
        sBuf.append(CRLF);
        sBuf.append("else");
        sBuf.append(CRLF);
        sBuf.append("start_pos := start_pos + length(delim);");
        sBuf.append(CRLF);
        sBuf.append("end if;");
        sBuf.append(CRLF);
        sBuf.append("end if;");
        sBuf.append(CRLF);
        sBuf.append("end_pos := instr(the_list,delim,start_pos,1);");
        sBuf.append(CRLF);
        sBuf.append("if end_pos = 0 then");
        sBuf.append(CRLF);
        sBuf.append("return substr(the_list,start_pos);");
        sBuf.append(CRLF);
        sBuf.append("else");
        sBuf.append(CRLF);
        sBuf.append("return substr(the_list,start_pos,end_pos - start_pos);");
        sBuf.append(CRLF);
        sBuf.append("end if;");
        sBuf.append(CRLF);
        sBuf.append("end " + s_functionName + ";");
        return sBuf.toString();
    }

    private String createSetTriggerText(String tableName, String columnName, boolean isNullable, String[] setVals, String newName) {
        int i;
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("CREATE OR REPLACE TRIGGER " + newName);
        sBuf.append(CRLF);
        sBuf.append("BEFORE INSERT OR UPDATE ON " + tableName);
        sBuf.append(CRLF);
        sBuf.append("FOR EACH ROW");
        sBuf.append(CRLF);
        sBuf.append("DECLARE");
        sBuf.append(CRLF);
        sBuf.append("  input varchar2(500);");
        sBuf.append(CRLF);
        sBuf.append("  val varchar2(50);");
        sBuf.append(CRLF);
        sBuf.append("  cnt number := 1;");
        sBuf.append(CRLF);
        sBuf.append("  num number := 0;");
        sBuf.append(CRLF);
        sBuf.append("  str VARCHAR2(50);");
        sBuf.append(CRLF);
        sBuf.append("  returnStr varchar2(500);");
        sBuf.append(CRLF);
        sBuf.append("  setValue number :=0;");
        sBuf.append(CRLF);
        sBuf.append("  type array_value is table of number index by varchar2(40);");
        sBuf.append(CRLF);
        sBuf.append("  value_array array_value;");
        sBuf.append(CRLF);
        sBuf.append("  type array_order is table of varchar2(40) index by BINARY_INTEGER;");
        sBuf.append(CRLF);
        sBuf.append("  order_array array_order;");
        sBuf.append(CRLF);
        sBuf.append("BEGIN");
        sBuf.append(CRLF);
        for (i = 0; i < setVals.length; ++i) {
            sBuf.append("value_array('" + setVals[i] + "') := 0;");
            sBuf.append(CRLF);
        }
        for (i = 0; i < setVals.length; ++i) {
            sBuf.append("order_array(" + i + ") :='" + setVals[i] + "';");
            sBuf.append(CRLF);
        }
        sBuf.append(CRLF);
        sBuf.append("input := TRIM(:new." + columnName + ");");
        sBuf.append(CRLF);
        sBuf.append("LOOP");
        sBuf.append(CRLF);
        sBuf.append("  val := " + s_functionName + "(input,cnt);");
        sBuf.append(CRLF);
        sBuf.append("  cnt := cnt + 1;");
        sBuf.append(CRLF);
        sBuf.append("  if val is not null then ");
        sBuf.append(CRLF);
        sBuf.append("     if value_array.exists(val) then");
        sBuf.append(CRLF);
        sBuf.append("        value_array(val) := 1;");
        sBuf.append(CRLF);
        sBuf.append("     end if;");
        sBuf.append(CRLF);
        sBuf.append("  else");
        sBuf.append(CRLF);
        sBuf.append("     exit;");
        sBuf.append(CRLF);
        sBuf.append("  end if;");
        sBuf.append(CRLF);
        sBuf.append("end loop;");
        sBuf.append(CRLF);
        sBuf.append("num := order_array.FIRST;");
        sBuf.append(CRLF);
        sBuf.append("LOOP");
        sBuf.append(CRLF);
        sBuf.append("  EXIT WHEN NOT order_array.EXISTS(num);");
        sBuf.append(CRLF);
        sBuf.append("  str := order_array(num);");
        sBuf.append(CRLF);
        sBuf.append("  setValue := value_array(str);");
        sBuf.append(CRLF);
        sBuf.append("  if (setValue = 1) then");
        sBuf.append(CRLF);
        sBuf.append("    if returnStr is null then");
        sBuf.append(CRLF);
        sBuf.append("      returnStr := str;");
        sBuf.append(CRLF);
        sBuf.append("    else");
        sBuf.append(CRLF);
        sBuf.append("      returnStr := returnStr || ',' || str;");
        sBuf.append(CRLF);
        sBuf.append("    end if;");
        sBuf.append(CRLF);
        sBuf.append("  end if;");
        sBuf.append(CRLF);
        sBuf.append("  num := order_array.next(num);");
        sBuf.append(CRLF);
        sBuf.append("END LOOP;");
        sBuf.append(CRLF);
        sBuf.append(CRLF);
        sBuf.append("returnStr := substr(returnStr,0,length(returnStr));");
        sBuf.append(CRLF);
        sBuf.append("if returnStr is not null then");
        sBuf.append(CRLF);
        sBuf.append("  :new." + columnName + " := returnStr;");
        sBuf.append(CRLF);
        sBuf.append("else");
        sBuf.append(CRLF);
        sBuf.append("  :new." + columnName + " := ' ';");
        sBuf.append(CRLF);
        sBuf.append("END IF;");
        sBuf.append(CRLF);
        sBuf.append("END;");
        sBuf.append(CRLF);
        return sBuf.toString();
    }

    private String createTriggerText(String tableName, String columnName, boolean isNullable, String[] enumVals, String newName) {
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("CREATE OR REPLACE TRIGGER " + newName);
        sBuf.append(CRLF);
        sBuf.append("BEFORE INSERT OR UPDATE ON " + tableName);
        sBuf.append(CRLF);
        sBuf.append("FOR EACH ROW");
        sBuf.append(CRLF);
        sBuf.append("DECLARE");
        sBuf.append(CRLF);
        sBuf.append("  v_val " + tableName + "." + columnName + "%TYPE;");
        sBuf.append(CRLF);
        sBuf.append("  v_test " + tableName + "." + columnName + "%TYPE;");
        sBuf.append(CRLF);
        sBuf.append("BEGIN");
        sBuf.append(CRLF);
        if (isNullable) {
            sBuf.append("  v_val := null;");
        } else if (enumVals[0].trim().length() == 0) {
            sBuf.append("  v_val := ' ';");
        } else {
            sBuf.append("  v_val := '" + enumVals[0] + "';");
        }
        sBuf.append(CRLF);
        sBuf.append("  v_test := TRIM(:new." + columnName + ");");
        sBuf.append(CRLF);
        for (int i = 0; i < enumVals.length; ++i) {
            if (i == 0) {
                sBuf.append("  if");
            } else {
                sBuf.append("  elsif");
            }
            sBuf.append(" v_test = '" + (i + 1) + "' OR v_test = '" + enumVals[i] + "' THEN ");
            sBuf.append(CRLF);
            if (!isNullable && enumVals[i].trim().length() == 0) {
                sBuf.append("  v_val := ' ';");
            } else {
                sBuf.append("  v_val := '" + enumVals[i].trim() + "';");
            }
            sBuf.append(CRLF);
        }
        sBuf.append("  end if;");
        sBuf.append("  :new." + columnName + " := v_val;");
        sBuf.append(CRLF);
        sBuf.append("END;");
        return sBuf.toString();
    }
}

