/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.dbtools.migration.capture.OnlineCapturer;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.plugin.MySQLCapturer;
import oracle.ide.util.Assert;

public class MySQLDbProvider
extends ThirdPartyDbProvider {
    private String m_label;
    private MySQLCapturer m_capturer;

    public MySQLDbProvider(Connection conn) {
        super(conn);
    }

    public OnlineCapturer getCapturer(MigrationStorer storer) {
        if (this.m_capturer == null) {
            this.m_capturer = new MySQLCapturer(storer, this._conn);
        }
        return this.m_capturer;
    }

    public String getConnectionLabel() {
        if (this.m_label == null) {
            try {
                DatabaseMetaData dbmd = this.getConnection().getMetaData();
                String url = dbmd.getURL();
                String[] parts = url.split("/");
                String user = dbmd.getUserName();
                String[] userParts = user.split("@");
                this.m_label = userParts[0] + "@" + parts[2] + ":" + this.getConnection().getCatalog() + " (" + dbmd.getDatabaseProductName() + ")";
            }
            catch (SQLException sqlex) {
                Assert.printStackTrace((Throwable)sqlex);
                this.m_label = "MySQL Model";
            }
        }
        return this.m_label;
    }
}

