/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.AdditionalProperty;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdEnumColumn;
import oracle.dbtools.metadata.persistence.MdIdentityColumn;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSetColumn;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.AbstractOfflineCapturer;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.plugin.MySQLColumnHelper;
import oracle.dbtools.migration.workbench.plugin.MySQLConstraintExtractor;
import oracle.dbtools.migration.workbench.plugin.MySQLOfflineUtils;
import oracle.dbtools.migration.workbench.plugin.mysql.MySQLConstraintDetails;

public class MySQLOfflineCapturer
extends AbstractOfflineCapturer {
    public static final String MY_LANGUAGE_ID = "MySQL";
    protected String m_inputDirectory;
    protected Properties m_properties;
    protected static final String ENUM_DATA_TYPE = "ENUM";
    protected static final String SET_DATA_TYPE = "SET";
    protected static final String PRIMARY_KEY_INDICATOR = "PRI";
    protected HashMap<String, String> m_columnIndexKey = new HashMap();
    protected int m_minorVersion;
    protected HashMap<String, Integer> m_getMaxOfColumn;

    public String captureInitializeImpl(String inputDirectory, Properties props) throws OfflineCaptureException {
        this.m_inputDirectory = inputDirectory;
        this.m_properties = props;
        return "MySQLOffline3";
    }

    public void cleanUp() throws OfflineCaptureException {
    }

    public String[] generateScripts(String outputDirectory, int platformCode) throws OfflineCaptureException {
        return null;
    }

    public void captureObjects(String objType, CaptureContext context, MigrationObjectFilter filter) throws PersistenceException, CaptureException {
        if (objType.equals("MD_CATALOGS")) {
            this.storeDefaultCatalog(context);
            String columnMaxInfoFilePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("max_column_info"));
            this.m_getMaxOfColumn = MySQLOfflineUtils.getMaxOfColumn(columnMaxInfoFilePath);
        } else if (objType.equals("MD_SCHEMAS")) {
            this.captureSchema(context);
            this.captureColumns(context);
            this.captureIndexes(context);
            this.captureConstraints(context);
        }
    }

    protected void storeDefaultCatalog(CaptureContext context) throws PersistenceException {
        String filePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("version_info"));
        this.m_minorVersion = MySQLOfflineUtils.getMinorVersion(filePath);
        DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
        MdCatalog catalog = new MdCatalog(connectionId);
        catalog.setDummyFlag("Y");
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)142), "");
        context.getAudience().fireListeners(event);
        catalog = (MdCatalog)this.getStorer().storeObject((PersistableObject)catalog);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void captureSchema(CaptureContext context) throws PersistenceException {
        try {
            String filePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("table_info"));
            HashMap<String, ArrayList<String>> schemaAndTables = MySQLOfflineUtils.getSchemaAndTables(filePath);
            Set<String> keySet = schemaAndTables.keySet();
            for (String schemaName : keySet) {
                CaptureAudience audience = context.getAudience();
                DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
                MdSchema schema = new MdSchema(catalogId);
                schema.setName(schemaName);
                CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)141), schema.getName());
                audience.fireListeners(event);
                schema = (MdSchema)this.getStorer().storeObject((PersistableObject)schema);
                event.setEventId(4);
                audience.fireListeners(event);
                context.setContextVariable("SCHEMAID", (Object)schema.getKey());
                ArrayList<String> tables = schemaAndTables.get(schemaName);
                for (String tableName : tables) {
                    DBObjectId schemaId = (DBObjectId)context.getContextVariable("SCHEMAID");
                    String qualifiedName = "";
                    MdCatalog catalog = (MdCatalog)context.getContextVariable("CATALOG");
                    if (catalog != null && !catalog.getDummyFlag().equals("Y")) {
                        qualifiedName = catalog.getCatalogName() + ".";
                    }
                    qualifiedName = qualifiedName + schemaName + ".";
                    qualifiedName = qualifiedName + tableName;
                    MdTable table = new MdTable(schemaId, tableName, qualifiedName);
                    event = new CaptureEvent(3, MigrationAddinArb.getString((int)138), table.getTableName());
                    context.getAudience().fireListeners(event);
                    table = (MdTable)this.getStorer().storeObject((PersistableObject)table);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected void captureColumns(CaptureContext context) throws PersistenceException {
        try {
            String columnInfoFilePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("column_table_info"));
            HashMap<String, ArrayList<String>> columns = MySQLOfflineUtils.getColumns(columnInfoFilePath);
            Set<String> keySet = columns.keySet();
            DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
            DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            DBObjectId schemaId = null;
            DBObjectId tableId = null;
            for (String key : keySet) {
                CaptureAudience audience = context.getAudience();
                String schemaName = key.substring(0, key.indexOf("."));
                String tableName = key.substring(key.indexOf(".") + 1);
                CloseableIterator schemasforCatalogId = util.getSchemasforCatalogId(catalogId);
                while (schemasforCatalogId.hasNext()) {
                    MdSchema mdSchema = (MdSchema)schemasforCatalogId.next();
                    String schema = mdSchema.getName();
                    if (!schema.equals(schemaName)) continue;
                    schemaId = mdSchema.getKey();
                    break;
                }
                CloseableIterator tablesForSchemaId = util.getTablesForSchemaId(schemaId);
                while (tablesForSchemaId.hasNext()) {
                    MdTable mdTable = (MdTable)tablesForSchemaId.next();
                    String table = mdTable.getTableName();
                    if (!table.equals(tableName)) continue;
                    tableId = mdTable.getKey();
                    break;
                }
                ArrayList<String> columnsList = columns.get(key);
                for (String columnVal : columnsList) {
                    Object column = null;
                    int order = 1;
                    boolean isColumnCreated = false;
                    String[] groupValues = null;
                    String columnName = "";
                    String columnType = "";
                    int i = 1;
                    StringTokenizer st = new StringTokenizer(columnVal, ";");
                    while (st.hasMoreElements()) {
                        String token = st.nextToken();
                        if (i == 1) {
                            columnName = token;
                        } else if (i == 2) {
                            columnType = token;
                        }
                        ++i;
                    }
                    String qualifiedColumnName = "`" + schemaName + "`.`" + tableName + "`.`" + columnName + "`";
                    MySQLColumnHelper mysqlColumnHelper = new MySQLColumnHelper(columnType);
                    String dataType = mysqlColumnHelper.getDataTypeName();
                    if ((dataType.equals(ENUM_DATA_TYPE) || dataType.equals(SET_DATA_TYPE)) && (groupValues = this.getAllValues(columnType)) != null) {
                        column = dataType.equals(ENUM_DATA_TYPE) ? new MdEnumColumn(tableId, columnName, Integer.valueOf(order++), groupValues, connectionId) : new MdSetColumn(tableId, columnName, Integer.valueOf(order++), groupValues, connectionId);
                        isColumnCreated = true;
                    }
                    if (columnVal.endsWith("auto_increment") && this.m_getMaxOfColumn.containsKey(qualifiedColumnName) && !isColumnCreated) {
                        Integer maxValue = this.m_getMaxOfColumn.get(qualifiedColumnName);
                        column = new MdIdentityColumn(tableId, columnName, Integer.valueOf(order++), 0L, 1L, (long)maxValue.intValue(), connectionId);
                        isColumnCreated = true;
                    }
                    if (!isColumnCreated) {
                        column = new MdColumn(tableId, columnName, Integer.valueOf(order++));
                    }
                    column.setColumnType(dataType);
                    column.setPrecision(Integer.valueOf(mysqlColumnHelper.getPrecision()));
                    if (mysqlColumnHelper.hasPrecisionAndScale()) {
                        column.setScale(Integer.valueOf(mysqlColumnHelper.getScale()));
                    }
                    if (columnVal.contains("YES")) {
                        column.setNullable("Y");
                    } else {
                        column.setNullable("N");
                    }
                    if (columnVal.contains(PRIMARY_KEY_INDICATOR)) {
                        this.m_columnIndexKey.put(qualifiedColumnName, PRIMARY_KEY_INDICATOR);
                    } else if (columnVal.contains("MUL")) {
                        this.m_columnIndexKey.put(qualifiedColumnName, "MUL");
                    } else if (columnVal.contains("UNI")) {
                        this.m_columnIndexKey.put(qualifiedColumnName, "UNI");
                    }
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)134), column.getColumnName());
                    audience.fireListeners(event);
                    column = (MdColumn)this.getStorer().storeObject((PersistableObject)column);
                    event.setEventId(4);
                    audience.fireListeners(event);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected String[] getAllValues(String dataTypedef) {
        String remBraces = dataTypedef.substring(dataTypedef.indexOf("(") + 1, dataTypedef.indexOf(")"));
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(remBraces, "'");
        while (st.hasMoreTokens()) {
            String nextElement = (String)st.nextElement();
            if (nextElement.equals(",")) continue;
            values.add(nextElement);
        }
        return values.toArray(new String[values.size()]);
    }

    protected void captureIndexes(CaptureContext context) throws PersistenceException {
        try {
            String filePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("index_info"));
            HashMap<String, ArrayList<String>> indexes = MySQLOfflineUtils.getIndexes(filePath);
            Set<String> keySet = indexes.keySet();
            DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            DBObjectId schemaId = null;
            DBObjectId tableId = null;
            for (String key : keySet) {
                String schemaName = key.substring(0, key.indexOf("."));
                String tableName = key.substring(key.indexOf(".") + 1);
                CloseableIterator schemasforCatalogId = util.getSchemasforCatalogId(catalogId);
                while (schemasforCatalogId.hasNext()) {
                    MdSchema mdSchema = (MdSchema)schemasforCatalogId.next();
                    String schema = mdSchema.getName();
                    if (!schema.equals(schemaName)) continue;
                    schemaId = mdSchema.getKey();
                    break;
                }
                CloseableIterator tablesForSchemaId = util.getTablesForSchemaId(schemaId);
                while (tablesForSchemaId.hasNext()) {
                    MdTable mdTable = (MdTable)tablesForSchemaId.next();
                    String table = mdTable.getTableName();
                    if (!table.equals(tableName)) continue;
                    tableId = mdTable.getKey();
                    break;
                }
                ArrayList<String> columnsList = indexes.get(key);
                MdIndexe previousIndex = null;
                MdConstraint previousConstraint = null;
                boolean indexCreated = false;
                boolean constraintCreated = false;
                for (String columnVal : columnsList) {
                    MdIndexe index = null;
                    MdConstraint constraint = null;
                    String[] indexDetails = this.retreiveIndexDetails(columnVal, this.getIndexDetailsSize());
                    if (indexDetails[3].equals("1")) {
                        CaptureEvent event;
                        String keyName = indexDetails[2];
                        String qualifiedColumnName = "`" + schemaName + "`.`" + tableName + "`.`" + indexDetails[4] + "`";
                        String indexkey = this.m_columnIndexKey.get(qualifiedColumnName);
                        if (indexkey.startsWith(PRIMARY_KEY_INDICATOR) && indexDetails[1].equals("0") && indexDetails[2].equals("PRIMARY")) {
                            indexCreated = false;
                            constraintCreated = true;
                            constraint = new MdConstraint(tableId, MY_LANGUAGE_ID);
                            constraint.setName(keyName);
                            constraint.setConstraintType("PK");
                            previousConstraint = constraint;
                            event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), keyName);
                            context.getAudience().fireListeners(event);
                            constraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)constraint);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                        } else {
                            indexCreated = true;
                            constraintCreated = false;
                            index = new MdIndexe(tableId);
                            index.setIndexName(keyName);
                            previousIndex = index;
                            if (indexkey.startsWith("UNI")) {
                                index.setIndexType("UNIQUE");
                            } else {
                                index.setIndexType("NON_UNIQUE");
                            }
                            if (indexDetails.length == 11 && indexDetails[10] != null && indexDetails[11].trim().length() > 0) {
                                DBObjectId connectionId = (DBObjectId)context.getContextVariable("CONNECTIONID");
                                index.addProperty(new AdditionalProperty("INDEX_TYPE", indexDetails[11]), connectionId);
                            }
                            event = new CaptureEvent(3, MigrationAddinArb.getString((int)140), index.getIndexName());
                            context.getAudience().fireListeners(event);
                            index = (MdIndexe)this.getStorer().storeObject((PersistableObject)index);
                            event.setEventId(4);
                            context.getAudience().fireListeners(event);
                        }
                    }
                    if (indexCreated && !constraintCreated) {
                        this.createIndexDetails(context, previousIndex, indexDetails[4], indexDetails[7], indexDetails[3]);
                        continue;
                    }
                    if (indexCreated || !constraintCreated) continue;
                    this.createConstraintIndexDetails(context, previousConstraint, indexDetails[4], indexDetails[3]);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected int getIndexDetailsSize() {
        return 10;
    }

    private String[] retreiveIndexDetails(String columnVal, int size) {
        int i = 0;
        String[] indexDetails = new String[size];
        StringTokenizer st = new StringTokenizer(columnVal, ";");
        while (st.hasMoreElements()) {
            String token;
            indexDetails[i] = token = st.nextToken();
            ++i;
        }
        return indexDetails;
    }

    protected void createConstraintIndexDetails(CaptureContext context, MdConstraint constraint, String columnName, String sequenceOrder) throws PersistenceException {
        MdConstraintDetail detail = new MdConstraintDetail(constraint.getKey(), new Integer(sequenceOrder));
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        detail.setColumnId(util.getIdForColumn(constraint.getTableId(), columnName));
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), constraint.getObjectName());
        context.getAudience().fireListeners(event);
        detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void createIndexDetails(CaptureContext context, MdIndexe index, String columnName, String subPart, String sequenceOrder) throws PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        MdIndexDetail detail = new MdIndexDetail(index.getKey(), util.getIdForColumn(index.getTableId(), columnName), new Integer(sequenceOrder));
        if (!subPart.equals("NULL")) {
            detail.setIndexPortion(new Integer(subPart));
        }
        CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)143), index.getIndexName());
        context.getAudience().fireListeners(event);
        detail = (MdIndexDetail)this.getStorer().storeObject((PersistableObject)detail);
        event.setEventId(4);
        context.getAudience().fireListeners(event);
    }

    protected void captureConstraints(CaptureContext context) throws PersistenceException {
        try {
            String filePath = this.getInputDirectory().concat(File.separator).concat(this.m_properties.getProperty("constraint_table_info"));
            PersistenceUtility util = this.getStorer().getPersistenceUtility();
            HashMap<String, String> allConstraints = MySQLOfflineUtils.getConstraints(filePath);
            DBObjectId catalogId = (DBObjectId)context.getContextVariable("CATALOGID");
            DBObjectId schemaId = null;
            DBObjectId tableId = null;
            Set<String> keySet = allConstraints.keySet();
            for (String element : keySet) {
                MySQLConstraintDetails[] constraints;
                String constraint = allConstraints.get(element);
                MySQLConstraintExtractor extractor = new MySQLConstraintExtractor(constraint);
                for (MySQLConstraintDetails cons : constraints = extractor.getConstraintDetails()) {
                    if (context.shouldCancel()) {
                        CaptureEvent event = new CaptureEvent(-1, MigrationAddinArb.getString((int)139), "");
                        context.getAudience().fireListeners(event);
                        return;
                    }
                    int indexOfDot = element.indexOf(".");
                    String schemaName = element.substring(1, indexOfDot - 1);
                    String tableName = element.substring(indexOfDot + 2, element.length() - 2);
                    CloseableIterator schemasforCatalogId = util.getSchemasforCatalogId(catalogId);
                    while (schemasforCatalogId.hasNext()) {
                        MdSchema mdSchema = (MdSchema)schemasforCatalogId.next();
                        String schema = mdSchema.getName();
                        if (!schema.equals(schemaName)) continue;
                        schemaId = mdSchema.getKey();
                        break;
                    }
                    CloseableIterator tablesForSchemaId = util.getTablesForSchemaId(schemaId);
                    while (tablesForSchemaId.hasNext()) {
                        MdTable mdTable = (MdTable)tablesForSchemaId.next();
                        String table = mdTable.getTableName();
                        if (!table.equals(tableName)) continue;
                        tableId = mdTable.getKey();
                        break;
                    }
                    MdConstraint migrconstraint = new MdConstraint(tableId, MY_LANGUAGE_ID);
                    migrconstraint.setConstraintType("FOREIGN KEY");
                    migrconstraint.setName(cons.getName());
                    DBObjectId refTableId = util.getIdForTable(schemaId, cons.getReferencedTableName());
                    migrconstraint.setReftableId(refTableId);
                    CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)139), migrconstraint.getName());
                    context.getAudience().fireListeners(event);
                    migrconstraint = (MdConstraint)this.getStorer().storeObject((PersistableObject)migrconstraint);
                    int order = this.createConstraintDetails(tableId, migrconstraint, cons.getColumnNames(), "N", 1, context);
                    this.createConstraintDetails(refTableId, migrconstraint, cons.getReferencedColumnNames(), "Y", order, context);
                    event.setEventId(4);
                    context.getAudience().fireListeners(event);
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    protected int createConstraintDetails(DBObjectId tableId, MdConstraint migrconstraint, String[] columnNames, String flagIndicator, int order, CaptureContext context) throws PersistenceException {
        PersistenceUtility util = this.getStorer().getPersistenceUtility();
        int constraintOrder = order;
        for (String colname : columnNames) {
            MdConstraintDetail detail = new MdConstraintDetail(migrconstraint.getKey(), Integer.valueOf(constraintOrder++));
            DBObjectId colId = util.getIdForColumn(tableId, colname);
            detail.setColumnId(colId);
            detail.setRefFlag(flagIndicator);
            CaptureEvent event = new CaptureEvent(3, MigrationAddinArb.getString((int)147), migrconstraint.getName());
            context.getAudience().fireListeners(event);
            detail = (MdConstraintDetail)this.getStorer().storeObject((PersistableObject)detail);
            event.setEventId(4);
            context.getAudience().fireListeners(event);
        }
        return constraintOrder;
    }

    public String getModelName() throws CaptureException {
        return "MySQL3";
    }

    public String getSourceURL() throws CaptureException {
        return null;
    }

    public String[] getScriptFiles(int platformCode) throws OfflineCaptureException {
        String[] files = new String[]{"master.", "get_table.", "get_col_table.", "get_max_col.", "get_index_table.", "get_constraint.", "mysql3.ocp"};
        for (int i = 0; i < files.length - 1; ++i) {
            files[i] = platformCode == 2 ? files[i].concat("sh") : files[i].concat("bat");
        }
        return files;
    }

    public String getInputDirectory() {
        return this.m_inputDirectory;
    }

    public Properties getProperties() {
        return this.m_properties;
    }
}

