/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MySQLOfflineUtils {
    private MySQLOfflineUtils() {
    }

    public static ArrayList<String> getViews(String filePath) {
        ArrayList<String> listOfViews = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(new File(filePath));
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            String firstLine = br.readLine();
            while ((line = firstLine) != null) {
                if (line.startsWith("TABLE_SCHEMA")) {
                    String viewLine = "";
                    while ((viewLine = br.readLine()) != null) {
                        int indexOf = viewLine.indexOf("/* ALGORITHM=UNDEFINED */");
                        if (indexOf == -1) continue;
                        StringTokenizer st = new StringTokenizer(viewLine, "\t");
                        while (st.hasMoreElements()) {
                            listOfViews.add(st.nextToken());
                        }
                    }
                }
                firstLine = br.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return listOfViews;
    }

    public static HashMap<String, String> getRoutines(String filePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            String firstLine = br.readLine();
            while ((line = firstLine) != null) {
                if (line.startsWith("SCHEMA")) {
                    br.readLine();
                    String value = br.readLine();
                    int indexOf = value.indexOf("CREATE DEFINER");
                    if (indexOf != -1) {
                        StringBuffer buf = new StringBuffer(value.substring(indexOf, value.length()));
                        if (value.endsWith("\\nEND")) {
                            map.put(line, buf.toString());
                        } else {
                            MySQLOfflineUtils.getStoredProcName(br, buf);
                            map.put(line, buf.toString());
                        }
                    }
                }
                firstLine = br.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return map;
    }

    private static void getStoredProcName(BufferedReader br, StringBuffer buf) {
        try {
            String nextLine = "";
            nextLine = br.readLine();
            if (nextLine != null) {
                if (nextLine.startsWith("\\nEND")) {
                    buf.append(nextLine);
                    return;
                }
                buf.append(nextLine);
                MySQLOfflineUtils.getStoredProcName(br, buf);
            }
        }
        catch (IOException e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
    }

    public static HashMap<String, Integer> getMaxOfColumn(String filePath) {
        HashMap<String, Integer> getMaxColumn = new HashMap<String, Integer>();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            String firstLine = br.readLine();
            while ((line = firstLine) != null) {
                if (line.startsWith("`")) {
                    String columnName = br.readLine();
                    if (columnName == null) {
                        br.readLine();
                    }
                    if (columnName != null && columnName.startsWith("MAX")) {
                        String value = br.readLine();
                        try {
                            int intValue = 0;
                            intValue = value.equals("NULL") ? 0 : new Integer(value);
                            columnName = columnName.substring(columnName.indexOf("(") + 1, columnName.indexOf(")"));
                            columnName = columnName.startsWith("`") && columnName.endsWith("`") ? line.trim() + "." + columnName : line.trim() + ".`" + columnName + "`";
                            getMaxColumn.put(columnName, intValue);
                        }
                        catch (NumberFormatException nfe) {
                            firstLine = value;
                        }
                        continue;
                    }
                    firstLine = columnName;
                    continue;
                }
                firstLine = br.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return getMaxColumn;
    }

    public static HashMap<String, String> getConstraints(String filePath) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                String value;
                int indexOf;
                String maxLine;
                if (!line.startsWith("`") || !(maxLine = br.readLine()).startsWith("Table") || (indexOf = (value = br.readLine()).indexOf("CREATE TABLE")) == -1) continue;
                String tableDefinition = value.substring(indexOf, value.length());
                tableDefinition = tableDefinition.replace("\\n", "\n");
                map.put(line, tableDefinition);
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return map;
    }

    public static HashMap<String, ArrayList<String>> getSchemaAndTables(String filePath) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            ArrayList<String> listOfTables = new ArrayList<String>();
            String schema = "";
            boolean lineGot = false;
            while (lineGot || (line = br.readLine()) != null) {
                lineGot = false;
                if (line.startsWith("`")) {
                    schema = line.substring(1, line.length() - 1);
                    String maxLine = br.readLine();
                    if (maxLine.startsWith("Tables_in_")) {
                        String value = br.readLine();
                        if (!map.containsKey(schema)) {
                            listOfTables = new ArrayList();
                        }
                        listOfTables.add(value);
                        map.put(schema, listOfTables);
                        continue;
                    }
                    if (!map.containsKey(schema)) {
                        listOfTables = new ArrayList();
                    }
                    map.put(schema, listOfTables);
                    lineGot = true;
                    line = maxLine;
                    continue;
                }
                listOfTables.add(line);
                map.put(schema, listOfTables);
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return map;
    }

    public static HashMap<String, ArrayList<String>> getColumns(String filePath) {
        HashMap<String, ArrayList<String>> columns = new HashMap<String, ArrayList<String>>();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            ArrayList<String> listOfColumns = new ArrayList<String>();
            String table = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("`")) {
                    table = line.replace("`", "");
                    String maxLine = br.readLine();
                    if (!maxLine.startsWith("Field")) continue;
                    String value = br.readLine();
                    if (!columns.containsKey(table)) {
                        listOfColumns = new ArrayList();
                    }
                    value = value.trim();
                    listOfColumns.add(MySQLOfflineUtils.getColumnTokenized(value));
                    columns.put(table, listOfColumns);
                    continue;
                }
                line = line.trim();
                listOfColumns.add(MySQLOfflineUtils.getColumnTokenized(line));
                columns.put(table, listOfColumns);
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return columns;
    }

    private static String getColumnTokenized(String value) {
        StringTokenizer st = new StringTokenizer(value, "\t");
        StringBuffer buf = new StringBuffer();
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            buf.append(token);
            buf.append(";");
        }
        return buf.toString().substring(0, buf.length() - 1);
    }

    public static HashMap<String, ArrayList<String>> getIndexes(String filePath) {
        HashMap<String, ArrayList<String>> indexes = new HashMap<String, ArrayList<String>>();
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            ArrayList<String> listOfIndexes = new ArrayList<String>();
            String table = "";
            String firstLine = br.readLine();
            while ((line = firstLine) != null) {
                if (line.startsWith("`")) {
                    table = line.replace("`", "");
                    String maxLine = br.readLine();
                    if (maxLine.startsWith("Table")) {
                        String value = br.readLine();
                        if (!indexes.containsKey(table)) {
                            listOfIndexes = new ArrayList();
                        }
                        value = value.trim();
                        listOfIndexes.add(MySQLOfflineUtils.getColumnTokenized(value));
                        indexes.put(table, listOfIndexes);
                        firstLine = br.readLine();
                        continue;
                    }
                    if (!maxLine.startsWith("`")) continue;
                    firstLine = maxLine;
                    continue;
                }
                line = line.trim();
                listOfIndexes.add(MySQLOfflineUtils.getColumnTokenized(line));
                indexes.put(table, listOfIndexes);
                firstLine = br.readLine();
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return indexes;
    }

    public static int getMinorVersion(String filePath) {
        int minVersion = 0;
        try {
            String encoding = Ide.getEnvironOptions().getEncoding();
            InputStreamReader fr = null;
            fr = encoding == null ? new InputStreamReader(new FileInputStream(new File(filePath))) : new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), encoding);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                if (!line.toLowerCase().startsWith("version")) continue;
                String viewLine = br.readLine();
                String minorVersion = viewLine.substring(viewLine.indexOf(".") + 1, viewLine.lastIndexOf("."));
                minVersion = new Integer(minorVersion);
            }
            fr.close();
        }
        catch (Exception e) {
            Logger.getLogger(MySQLOfflineUtils.class.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
        }
        return minVersion;
    }
}

