/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.plugin.MySQLConverter;
import oracle.dbtools.migration.workbench.plugin.MySQLDbProvider;
import oracle.dbtools.migration.workbench.plugin.MySQLOfflineCapturer;
import oracle.dbtools.migration.workbench.plugin.MySQLQuoter;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;

public class MySQLPlugin
extends AbstractMigrationPlugin {
    public static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static boolean s_driverLoaded = false;
    protected Converter m_converter;
    public static final String[] CAPTURE_MENU = new String[]{"TABLE", "TABLE_FOLDER", "VIEW", "VIEW_FOLDER", "FUNCTIONS", "FUNCTIONS_FOLDER", "PROCEDURES", "PROCEDURES_FOLDER", "INDEX", "INDEX_FOLDER", "USER", "USER_FOLDER"};

    public String getPlatformName() {
        return "MySQL";
    }

    public String getPluginName() {
        return this.getPlatformName();
    }

    public String getVersionNumber() {
        return "3.23";
    }

    public ThirdPartyDbProvider getProvider(String url) throws MigrationPluginException {
        try {
            MySQLPlugin.loadDriver();
            Connection conn = DriverManager.getConnection(url);
            return new MySQLDbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, Properties info) throws MigrationPluginException {
        MySQLPlugin.loadDriver();
        try {
            MySQLPlugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, info);
            return new MySQLDbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(String url, String user, String password) throws MigrationPluginException {
        try {
            MySQLPlugin.loadDriver();
            Connection conn = DriverManager.getConnection(url, user, password);
            return new MySQLDbProvider(conn);
        }
        catch (SQLException sqlex) {
            throw new MigrationPluginException((Throwable)sqlex);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection conn) throws MigrationPluginException {
        return new MySQLDbProvider(conn);
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Class.forName(DRIVER_CLASS).newInstance();
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException cnfe) {
                throw new MigrationPluginException((Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                throw new MigrationPluginException((Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                throw new MigrationPluginException((Throwable)iae);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public String getPublishedVersion() {
        return this.getVersionNumber();
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new MySQLConverter();
        }
        return this.m_converter;
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String platform, int major, int minor, String productversion) {
        if (!platform.equals(this.getPlatformName())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (major == 3 && minor >= 23) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/mysql/images/mysqllogo.png";
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.mysql");
    }

    public Quoter getQuoter() {
        return new MySQLQuoter();
    }

    public boolean getDataExportCommmand(String srcTable, MdColumn[] srcTableCols, Offline3rdPartyPrintStream printStream) {
        MigrationConfig config = MigrationAddin.getMigrationConfig();
        String endColDelimiter = config.getEndColumnDelimiter();
        String endRowDelimiter = config.getEndRowDelimiter();
        Preferences p = Preferences.getPreferences();
        MigrationConfig o = MigrationConfig.getInstance((PropertyStorage)p);
        String databaseString = null;
        String srcTableString = null;
        String cmd = null;
        int localIndex = srcTable.indexOf(".");
        if (localIndex != -1 && localIndex > 0 && localIndex < srcTable.length() - 1) {
            databaseString = srcTable.substring(0, localIndex);
            srcTableString = srcTable.substring(localIndex + 1);
            cmd = "mysqldump -h localhost -u <USERNAME> -p<PASSWORD>  -T \"<DESTINATION_PATH>\" --fields-terminated-by=\"" + endColDelimiter + "\" " + "--fields-escaped-by=\"\" --lines-terminated-by=\"" + endRowDelimiter + "\" \"" + databaseString + "\" \"" + srcTableString + "\" ";
        } else {
            cmd = "mysqldump -h localhost -u <USERNAME> -p<PASSWORD>  -T \"<DESTINATION_PATH>\" --fields-terminated-by=\"" + endColDelimiter + "\" " + "--fields-escaped-by=\"\" --lines-terminated-by=\"" + endRowDelimiter + "\" \"<DBNAME>\" \"" + srcTable + "\"";
        }
        printStream.println(cmd);
        return true;
    }

    public String maybeUnqualifyTable(String qualifiedTable) {
        int lastDot;
        if (qualifiedTable != null && (lastDot = qualifiedTable.lastIndexOf(".")) < qualifiedTable.length() - 1) {
            return qualifiedTable.substring(lastDot + 1);
        }
        return qualifiedTable;
    }

    public String getDatafileExtension() {
        return "txt";
    }

    public String formatSQLLoaderColumn(MdColumn column, MdColumn tgtColumn) {
        String format = "";
        boolean addNullIf = true;
        String columnName = tgtColumn.getColumnName();
        String tgtDataType = tgtColumn.getColumnType();
        Integer tgtPrecision = tgtColumn.getPrecision();
        int columnLength = 0;
        columnLength = tgtPrecision == null ? 0 : tgtPrecision;
        if (tgtDataType.equalsIgnoreCase("CHAR") || tgtDataType.equalsIgnoreCase("NCHAR") || tgtDataType.equalsIgnoreCase("VARCHAR2") || tgtDataType.equalsIgnoreCase("NVARCHAR2") || tgtDataType.equalsIgnoreCase("CLOB") || tgtDataType.equalsIgnoreCase("NCLOB")) {
            if (columnLength >= 255) {
                format = "CHAR(" + columnLength + ")";
            }
            if (tgtDataType.equalsIgnoreCase("VARCHAR2") || tgtDataType.equalsIgnoreCase("NVARCHAR2") || tgtDataType.equalsIgnoreCase("CHAR") || tgtDataType.equalsIgnoreCase("NCHAR")) {
                format = MigrationAddin.getMigrationConfig().getEmptyStringIsSpace() ? format + " \"DECODE(:" + columnName + ", 'NULL', NULL, NULL, ' ', :" + columnName + ")\"" : format + " \"DECODE(:" + columnName + ", 'NULL', NULL, NULL, NULL, :" + columnName + ")\"";
                addNullIf = false;
            }
            if (tgtDataType.equalsIgnoreCase("CLOB") || tgtDataType.equalsIgnoreCase("NCLOB")) {
                format = format + "CHAR(2000000)";
            }
        } else if (tgtDataType.equalsIgnoreCase("TIMESTAMP")) {
            format = "\"TO_TIMESTAMP(DECODE(:" + columnName + ", 'NULL', NULL, :" + columnName + "), '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
            addNullIf = false;
        } else if (tgtDataType.equalsIgnoreCase("DATE")) {
            format = "\"TO_DATE(DECODE(:" + columnName + ", 'NULL', NULL, :" + columnName + "),  '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
            addNullIf = false;
        } else if (tgtDataType.equalsIgnoreCase("BLOB")) {
            format = " CHAR(2000000) ";
        }
        if (addNullIf) {
            format = format + " NULLIF " + columnName + " = 'NULL'";
        }
        return format;
    }

    public int getPlatformMask() {
        return 1;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new MySQLOfflineCapturer();
    }
}

