/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Vector;
import oracle.xml.classgen.CGNode;
import oracle.xml.classgen.InvalidContentException;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public abstract class CGDocument
extends CGNode
implements Externalizable {
    XMLDocument xmlDocument = new XMLDocument();
    Vector all_ids = new Vector();
    Vector all_idrefs = new Vector();

    protected CGDocument(String string, DTD dTD) {
        super(string);
        this.setDocument(this);
        this.xmlDocument.setDoctype(dTD.getName(), dTD.getSystemId(), dTD.getPublicId());
        this.xmlDocument.appendChild((Node)this.theElement);
    }

    protected void print(OutputStream outputStream) throws InvalidContentException {
        this.setDocument(this);
        if (this.isValidating) {
            if (!this.verifyIDREFS()) {
                throw new InvalidContentException("Invalid IDREF specified");
            }
            this.validateContent();
        }
        try {
            this.xmlDocument.print(outputStream);
        }
        catch (IOException iOException) {
            throw new InvalidContentException(iOException.getMessage());
        }
    }

    protected void print(OutputStream outputStream, String string) throws InvalidContentException {
        this.setDocument(this);
        if (this.isValidating) {
            if (!this.verifyIDREFS()) {
                throw new InvalidContentException("Invalid IDREF specified");
            }
            this.validateContent();
        }
        try {
            this.xmlDocument.print(outputStream, string);
        }
        catch (IOException iOException) {
            throw new InvalidContentException(iOException.getMessage());
        }
    }

    void storeID(String string) {
        this.all_ids.addElement(string);
    }

    void storeIDREF(String string) {
        this.all_idrefs.addElement(string);
    }

    boolean verifyIDREF(String string) {
        return this.all_ids.contains(string);
    }

    boolean verifyIDREFS() {
        super.verifyIDREFS();
        int n = this.all_idrefs.size();
        for (int i = 0; i < n; ++i) {
            if (this.all_ids.contains((String)this.all_idrefs.elementAt(i))) continue;
            this.all_ids = new Vector();
            this.all_idrefs = new Vector();
            return false;
        }
        this.all_ids = new Vector();
        this.all_idrefs = new Vector();
        return true;
    }

    protected void readExternal(ObjectInput objectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        XMLObjectInput xMLObjectInput = new XMLObjectInput(objectInput);
        super.readExternal(xMLObjectInput, cXMLContext);
        this.xmlDocument.appendChild((Node)this.theElement);
        this.theElement = null;
    }
}

