/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.classgen.CGDocument;
import oracle.xml.classgen.CGUtil;
import oracle.xml.classgen.InvalidContentException;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.io.XMLObjectInput;
import oracle.xml.io.XMLObjectOutput;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CGNode
implements CXMLConstants {
    XMLElement theElement;
    Vector children = null;
    CGNode parent;
    CGDocument theDocument = null;
    Hashtable m_ids;
    Hashtable m_idrefs;
    protected boolean isValidating = true;

    protected CGNode(String string) {
        this.theElement = new XMLElement(string);
    }

    protected void setElementNode(XMLElement xMLElement) {
        this.theElement = xMLElement;
    }

    protected XMLElement getElementNode() {
        return this.theElement;
    }

    void addChild(CGNode cGNode) throws InvalidContentException {
        if (this.isValidating) {
            DTD dTD = this.getDTDNode();
            ElementDecl elementDecl = dTD.findElementDecl(this.theElement.getNodeName());
            Vector vector = elementDecl.expectedElements((Element)this.theElement);
            boolean bl = false;
            if (vector != null) {
                String string = cGNode.theElement.getNodeName();
                String string2 = "Invalid element '" + string + "', expected elements are [";
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    String string3 = (String)vector.elementAt(i);
                    string2 = string2 + string3;
                    if (i < n - 1) {
                        string2 = string2 + ",";
                    }
                    if (!string3.equals(string)) continue;
                    bl = true;
                    break;
                }
                string2 = string2 + ']';
                if (!bl) {
                    throw new InvalidContentException(string2);
                }
            }
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addElement(cGNode);
        cGNode.parent = this;
    }

    protected void addData(String string) throws InvalidContentException {
        XMLText xMLText = new XMLText(string);
        this.theElement.appendChild((Node)xMLText);
    }

    protected void deleteData(String string) throws InvalidContentException {
        XMLText xMLText = new XMLText(string);
        NodeList nodeList = this.theElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = nodeList.item(i).getNodeValue();
            if (!string2.equals(string)) continue;
            this.theElement.removeChild((Node)((XMLNode)nodeList.item(i)));
        }
    }

    protected String getData() throws InvalidContentException {
        NodeList nodeList = this.theElement.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            short s = nodeList.item(i).getNodeType();
            if (s != 3) continue;
            String string = nodeList.item(i).getNodeValue();
            return string;
        }
        return null;
    }

    protected void addCDATASection(String string) throws InvalidContentException {
        XMLCDATA xMLCDATA = new XMLCDATA(string);
        this.theElement.appendChild((Node)xMLCDATA);
    }

    protected void addNode(CGNode cGNode) throws InvalidContentException {
        XMLElement xMLElement = cGNode.theElement;
        this.addChild(cGNode);
        this.theElement.appendChild((Node)xMLElement);
    }

    protected Object getNode(String string) throws InvalidContentException {
        if (this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CGNode cGNode = (CGNode)enumeration.nextElement();
                String string2 = cGNode.theElement.getNodeName();
                if (!string.equals(string2)) continue;
                return cGNode;
            }
        }
        return null;
    }

    public void setDocument(CGDocument cGDocument) {
        this.theDocument = cGDocument;
        if (this.children != null) {
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                CGNode cGNode = (CGNode)enumeration.nextElement();
                cGNode.setDocument(cGDocument);
            }
        }
    }

    protected CGDocument getCGDocument() {
        if (this.theDocument == null && this.parent != null) {
            this.theDocument = this.parent.getCGDocument();
        }
        return this.theDocument;
    }

    protected abstract DTD getDTDNode();

    protected void setAttribute(String string, String string2) {
        this.theElement.setAttribute(string, string2);
    }

    protected String getAttribute(String string) {
        return this.theElement.getAttribute(string);
    }

    protected void storeID(String string, String string2) {
        if (this.m_ids == null) {
            this.m_ids = new Hashtable();
        }
        this.m_ids.put(string, string2);
    }

    protected void storeIDREF(String string, String string2) {
        if (this.m_idrefs == null) {
            this.m_idrefs = new Hashtable();
        }
        this.m_idrefs.put(string, string2);
    }

    protected boolean validID(String string) {
        char c = string.charAt(0);
        if (Character.isLetter(c) || c == '_' || c == ':') {
            int n = string.length();
            for (int i = 1; i < n; ++i) {
                c = string.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_' || c == ':' || c == '-' || c == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validEntity(String string) {
        return this.verifyEntity(string, this.getDTDNode());
    }

    boolean verifyEntity(String string, DTD dTD) {
        return dTD.findEntity(string, false) != null;
    }

    protected boolean validNMTOKEN(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == ':' || c == '-' || c == '.') continue;
            return false;
        }
        return true;
    }

    protected void validateContent() throws InvalidContentException {
        DTD dTD = this.getDTDNode();
        ElementDecl elementDecl = dTD.findElementDecl(this.theElement.getNodeName());
        if (!elementDecl.validateContent((Element)this.theElement)) {
            Vector vector = elementDecl.expectedElements((Element)this.theElement);
            String string = vector != null ? "Expected elements are [" + vector.toString() + "]" : "Invalid Content";
            throw new InvalidContentException(string);
        }
    }

    boolean verifyIDREFS() {
        String string;
        Enumeration enumeration;
        if (this.m_ids != null) {
            enumeration = this.m_ids.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                this.theDocument.storeID(string);
            }
        }
        if (this.children != null) {
            Enumeration enumeration2 = this.children.elements();
            while (enumeration2.hasMoreElements()) {
                CGNode cGNode = (CGNode)enumeration2.nextElement();
                cGNode.verifyIDREFS();
            }
        }
        if (this.m_idrefs != null) {
            enumeration = this.m_idrefs.elements();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (this.theDocument.verifyIDREF(string)) continue;
                this.theDocument.storeIDREF(string);
            }
        }
        return true;
    }

    protected void writeExternal(XMLObjectOutput xMLObjectOutput, CXMLContext cXMLContext) throws IOException {
        this.theElement.writeExternal(xMLObjectOutput.getObjectOutput());
    }

    protected void readExternal(XMLObjectInput xMLObjectInput, CXMLContext cXMLContext) throws IOException, ClassNotFoundException {
        XMLElement xMLElement = new XMLElement();
        xMLElement.readExternal(xMLObjectInput.getObjectInput());
        this.expandContent(xMLElement);
    }

    private void expandContent(XMLElement xMLElement) throws IOException, ClassNotFoundException {
        this.theElement = xMLElement;
        for (XMLNode xMLNode = (XMLNode)xMLElement.getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            if (!(xMLNode instanceof XMLElement)) continue;
            try {
                xMLElement = (XMLElement)xMLNode;
                String string = CGUtil.className(xMLElement.getNodeName());
                Class<?> clazz = Class.forName(string);
                CGNode cGNode = (CGNode)clazz.newInstance();
                cGNode.expandContent(xMLElement);
                this.addNode(cGNode);
                continue;
            }
            catch (InstantiationException instantiationException) {
                throw new IOException("Error in Unmarshalling. " + instantiationException.toString());
            }
            catch (Exception exception) {
                throw new IOException("Error in Unmarshalling. " + exception.toString());
            }
        }
    }
}

