/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.classgen.CGUtil;
import oracle.xml.parser.v2.AttrDecl;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.ElementDecl;
import org.w3c.dom.NamedNodeMap;

public class DTDClassGenerator {
    private DTD m_dtd;
    private String m_doctype;
    boolean m_bSerialize = false;
    boolean m_bComments = true;
    boolean m_bValidate = true;
    String m_dirName;
    String m_packageName;
    String m_className;
    String m_elementName;

    public void setGenerateComments(boolean bl) {
        this.m_bComments = bl;
    }

    public void setValidationMode(boolean bl) {
        this.m_bValidate = bl;
    }

    public void setOutputDirectory(String string) {
        this.m_dirName = string;
    }

    public void setSerializationMode(boolean bl) {
        this.m_bSerialize = bl;
    }

    public void setJavaPackage(Vector vector) {
        this.m_packageName = (String)vector.elementAt(0);
    }

    public void generate(DTD dTD, String string) {
        this.m_dtd = dTD;
        this.m_doctype = CGUtil.className(string);
        try {
            NamedNodeMap namedNodeMap = dTD.getElementDecls();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                ElementDecl elementDecl = (ElementDecl)namedNodeMap.item(i);
                this.createClass(elementDecl.getNodeName());
            }
            if (this.m_bSerialize) {
                this.serializeDTD();
            } else {
                this.printDTD();
            }
        }
        catch (Exception exception) {
            System.out.println("A error occurred generating the classes: " + exception.toString());
            exception.printStackTrace();
        }
    }

    private void printStaticInitializers() {
        CGUtil.tabPrint(1, "public static DTD globalDTD = null;");
        CGUtil.tabPrint(1, "static DOMParser parser = new DOMParser();");
        CGUtil.tabPrint();
        CGUtil.tabPrint(1, "static");
        CGUtil.tabPrint(1, "{");
        if (this.m_bSerialize) {
            CGUtil.tabPrint(2, "String dtdFile = \"" + this.m_doctype + "_dtd.ser\";");
        } else {
            CGUtil.tabPrint(2, "String dtdFile = \"" + this.m_doctype + "_dtd.txt\";");
        }
        CGUtil.tabPrint(2, "URL url = null;");
        CGUtil.tabPrint();
        CGUtil.tabPrint(2, "try");
        CGUtil.tabPrint(2, "{");
        if (this.m_bSerialize) {
            CGUtil.tabPrint(3, "XMLDocument doc;");
            CGUtil.tabPrint(3, "InputStream is = new FileInputStream(dtdFile);");
            CGUtil.tabPrint(3, "ObjectInputStream ois = new ObjectInputStream(is);");
            CGUtil.tabPrint(3, "globalDTD = (DTD)ois.readObject();");
            CGUtil.tabPrint(3, "doc = (XMLDocument)globalDTD.getParentNode();");
            CGUtil.tabPrint(3, "if (doc != null)");
            CGUtil.tabPrint(3, "{");
            CGUtil.tabPrint(4, "globalDTD = (DTD)doc.removeChild(globalDTD);");
            CGUtil.tabPrint(3, "}");
            CGUtil.tabPrint(3, "ois.close();");
        } else {
            CGUtil.tabPrint(3, "parser.setPreserveWhitespace(false);");
            CGUtil.tabPrint(3, "url = ClassLoader.getSystemResource(dtdFile);");
            CGUtil.tabPrint(3, "parser.parseDTD(url, " + CGUtil.quoteString(this.m_dtd.getNodeName()) + ");");
            CGUtil.tabPrint(3, "globalDTD = (DTD)parser.getDoctype();");
        }
        CGUtil.tabPrint(2, "}");
        CGUtil.tabPrint(2, "catch (Exception e)");
        CGUtil.tabPrint(2, "{");
        CGUtil.tabPrint(3, "System.out.println(\"Unexpected error opening DTD file\");");
        CGUtil.tabPrint(2, "}");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printClassDef() {
        if (this.m_className.equals(this.m_doctype)) {
            if (this.m_bComments) {
                CGUtil.tabPrint(0, "/**");
                CGUtil.tabPrint(0, " * The Document Class (for the root element " + CGUtil.initCaps(this.m_doctype) + ")");
                CGUtil.tabPrint(0, " */");
            }
            CGUtil.tabPrint(0, "public class " + this.m_className + " extends CGDocument implements Externalizable");
            CGUtil.tabPrint(0, "{");
            CGUtil.tabPrint();
            this.printStaticInitializers();
        } else {
            if (this.m_bComments) {
                CGUtil.tabPrint(0, "/**");
                CGUtil.tabPrint(0, " * The Node Class (for the root element " + CGUtil.initCaps(this.m_className) + ")");
                CGUtil.tabPrint(0, " */");
            }
            CGUtil.tabPrint(0, "public class " + this.m_className + " extends CGNode" + " implements Externalizable");
            CGUtil.tabPrint(0, "{");
        }
        CGUtil.tabPrint();
    }

    private void printConstructors() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Default Constructor");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public " + this.m_className + "()");
        CGUtil.tabPrint(1, "{");
        if (this.m_className.equals(this.m_doctype)) {
            CGUtil.tabPrint(2, "super(" + CGUtil.quoteString(this.m_elementName) + ", globalDTD);");
        } else {
            CGUtil.tabPrint(2, "super(" + CGUtil.quoteString(this.m_elementName) + ");");
        }
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "isValidating = true;");
        } else {
            CGUtil.tabPrint(2, "isValidating = false;");
        }
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printConstructors(Vector vector) {
        String string;
        AttrDecl attrDecl;
        int n;
        int n2 = 0;
        n2 = vector.size();
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Constructor with the required Attributes");
            for (n = 0; n < n2; ++n) {
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                CGUtil.tabPrint(1, " * @param " + CGUtil.variableName(string) + " for the Attribute " + string);
                CGUtil.tabPrint(1, " * @exception InvalidContentException if invalid value is specified for an attribute");
            }
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public " + this.m_className + "(", false);
        block6: for (n = 0; n < n2; ++n) {
            if (n > 0) {
                CGUtil.tabPrint(0, ", ", false);
            }
            attrDecl = (AttrDecl)vector.elementAt(n);
            string = attrDecl.getNodeName();
            int n3 = attrDecl.getAttrType();
            switch (n3) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    CGUtil.tabPrint(0, "String " + CGUtil.variableName(string), false);
                    continue block6;
                }
                case 3: 
                case 5: 
                case 7: {
                    CGUtil.tabPrint(0, "String[] " + CGUtil.variableName(string), false);
                    continue block6;
                }
                case 8: 
                case 9: {
                    CGUtil.tabPrint(0, "int " + CGUtil.variableName(string), false);
                    continue block6;
                }
            }
        }
        CGUtil.tabPrint(0, ") throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        if (this.m_className.equals(this.m_doctype)) {
            CGUtil.tabPrint(2, "super(" + CGUtil.quoteString(this.m_elementName) + ", globalDTD);");
        } else {
            CGUtil.tabPrint(2, "super(" + CGUtil.quoteString(this.m_elementName) + ");");
        }
        CGUtil.tabPrint(2, "try");
        CGUtil.tabPrint(2, "{");
        for (n = 0; n < n2; ++n) {
            attrDecl = (AttrDecl)vector.elementAt(n);
            string = attrDecl.getNodeName();
            CGUtil.tabPrint(3, CGUtil.setFunctionName(string) + "(" + CGUtil.variableName(string) + ");");
        }
        CGUtil.tabPrint(2, "}");
        CGUtil.tabPrint(2, "catch (IllegalArgumentException e) { ");
        CGUtil.tabPrint(3, "throw new InvalidContentException(\"Invalid Attribute value specified\"); }");
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "isValidating = true;");
        } else {
            CGUtil.tabPrint(2, "isValidating = false;");
        }
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printPCDATAConstructors(Vector vector) {
        String string;
        AttrDecl attrDecl;
        int n;
        int n2 = 0;
        if (vector == null) {
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Constructor taking <code>#PCDATA</code>");
                CGUtil.tabPrint(1, " * @param theData  text for the Element");
                CGUtil.tabPrint(1, " * @exception InvalidContentException   <code>theData</code> is invalid");
                CGUtil.tabPrint(1, " */");
            }
            CGUtil.tabPrint(1, "public " + this.m_className + "(String theData) " + " throws InvalidContentException");
        } else {
            n2 = vector.size();
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Constructor with the required Attributes and <code>#PCDATA</code>");
                for (n = 0; n < n2; ++n) {
                    attrDecl = (AttrDecl)vector.elementAt(n);
                    string = attrDecl.getNodeName();
                    CGUtil.tabPrint(1, " * @param " + CGUtil.variableName(string) + " for the Attribute " + string);
                    CGUtil.tabPrint(1, " * @exception InvalidContentException  if  invalid value is specified for an attribute");
                    CGUtil.tabPrint(1, " *           or <code>theData</code> is invalid");
                }
                CGUtil.tabPrint(1, " */");
            }
            CGUtil.tabPrint(1, "public " + this.m_className + "(String theData");
            block6: for (n = 0; n < n2; ++n) {
                CGUtil.tabPrint(1, ",");
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                int n3 = attrDecl.getAttrType();
                switch (n3) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 6: {
                        CGUtil.tabPrint(0, "String " + CGUtil.variableName(string));
                        continue block6;
                    }
                    case 3: 
                    case 5: 
                    case 7: {
                        CGUtil.tabPrint(0, "String[] " + CGUtil.variableName(string));
                        continue block6;
                    }
                    case 8: 
                    case 9: {
                        CGUtil.tabPrint(0, "int " + CGUtil.variableName(string));
                        continue block6;
                    }
                }
            }
            CGUtil.tabPrint(1, ") throws InvalidContentException");
        }
        CGUtil.tabPrint(1, "{");
        if (vector != null) {
            CGUtil.tabPrint(2, "this(");
            for (n = 0; n < n2; ++n) {
                if (n > 0) {
                    CGUtil.tabPrint(1, ", ");
                }
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                CGUtil.tabPrint(1, CGUtil.variableName(string));
            }
            CGUtil.tabPrint(0, ");");
        } else {
            CGUtil.tabPrint(2, "this();");
        }
        CGUtil.tabPrint(2, "super.addData(theData);");
        if (vector != null) {
            CGUtil.tabPrint(2, "try");
            CGUtil.tabPrint(2, "{");
            for (n = 0; n < n2; ++n) {
                attrDecl = (AttrDecl)vector.elementAt(n);
                string = attrDecl.getNodeName();
                CGUtil.tabPrint(3, CGUtil.setFunctionName(string) + "(" + CGUtil.variableName(string) + ");");
            }
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "catch (IllegalArgumentException e) { ");
            CGUtil.tabPrint(3, "throw new InvalidContentException(\"Invalid Attribute value specified\"); }");
        }
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "isValidating = true;");
        } else {
            CGUtil.tabPrint(2, "isValidating = false;");
        }
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printAddNodeMethod(String string) {
        String string2 = string.substring(0, 1);
        if (string2.equals(string)) {
            string2 = "the" + string2;
        }
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Add <code>" + string + "</code> to <code>" + CGUtil.initCaps(this.m_elementName) + "</code>");
            CGUtil.tabPrint(1, " * @param " + string2 + " Node of type <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if node cannot be added as per ");
            CGUtil.tabPrint(1, " *            the Content model of the element.");
            CGUtil.tabPrint(1, " * @deprecated Use the " + CGUtil.setFunctionName(string) + "method instead. ");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void addNode(" + string + " " + string2 + ") throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.addNode(" + string2 + ");");
        if (this.m_className.equals(this.m_doctype)) {
            CGUtil.tabPrint(2, string2 + ".setDocument(this);");
        }
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetChildNodeMethod(String string) {
        String string2 = string.substring(0, 1);
        if (string2.equals(string)) {
            string2 = "the" + string2;
        }
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Add the child node to the element " + CGUtil.initCaps(this.m_elementName));
            CGUtil.tabPrint(1, " * @param " + string2 + " Node of type " + string);
            CGUtil.tabPrint(1, " * @exception InvalidContentException if node cannot be added as per");
            CGUtil.tabPrint(1, " *            the Content model of the elemnt. ");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(" + string + "  " + string2 + ")throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.addNode(" + string2 + ");");
        if (this.m_className.equals(this.m_doctype)) {
            CGUtil.tabPrint(2, string2 + ".setDocument(this);");
        }
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printGetChildNodeMethod(String string) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Get the child node of the element " + CGUtil.initCaps(this.m_elementName));
            CGUtil.tabPrint(1, " * @param " + string + " Node of type " + string);
            CGUtil.tabPrint(1, " * @exception InvalidContentException if the node cannot be found ");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public " + CGUtil.className(string) + " " + CGUtil.getFunctionName(CGUtil.className(string)) + "()" + " throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "return (" + CGUtil.className(string) + ")" + "super.getNode(" + CGUtil.quoteString(string) + ");");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printAddDataMethod() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Add  a text node to <code>" + this.m_elementName + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the text node");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void addData(String theData) throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.addData(theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printDeleteDataMethod() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Delete the text node from <code>" + this.m_elementName + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the text node");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void  deleteData(String theData) throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.deleteData(theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printGetDataMethod() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Get  a text node from <code>" + this.m_elementName + "</code>");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public String getData() throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "return super.getData();");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printCDATASectionMethod() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Add  a CDATA node to <code>" + this.m_elementName + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the CDATA node");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void addCDATASection(String theData) throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.addCDATASection(theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printDeleteCDATASectionMethod() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Add  a CDATA node to <code>" + this.m_elementName + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the CDATA node");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the value of the text node is invalid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void deleteCDATASection(String theData) throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.deleteData(theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetCData(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String theData) ");
        CGUtil.tabPrint();
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetID(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException ");
            CGUtil.tabPrint(1, " *            if the value of the attribute (ID) is invalid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "if (!validID(theData))");
            CGUtil.tabPrint(3, "throw new IllegalArgumentException();");
            CGUtil.tabPrint(2, "storeID(" + CGUtil.quoteString(string) + ", theData);");
        }
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetIDREF(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException ");
            CGUtil.tabPrint(1, " *           if the value of the attribute (IDREF) is not a valid ID");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "if (!validID(theData))");
            CGUtil.tabPrint(3, "throw new IllegalArgumentException(" + CGUtil.quoteString("Invalid ID has been specified") + ");");
            CGUtil.tabPrint(2, "storeIDREF(" + CGUtil.quoteString(string) + ", theData);");
        }
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetIDREFS(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException ");
            CGUtil.tabPrint(1, " *           if the one of the ids in the attribute (IDREFS) is not valid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String[] theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "String concatenatedData = new String();");
        CGUtil.tabPrint();
        CGUtil.tabPrint(2, "for (int i=0; i < theData.length; i++)");
        CGUtil.tabPrint(2, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(3, "if (!validID(theData[i]))");
            CGUtil.tabPrint(4, "throw new IllegalArgumentException(" + CGUtil.quoteString("Invalid ID has been specified") + ");");
            CGUtil.tabPrint(3, "storeIDREF(" + CGUtil.quoteString(string) + ", theData[i]);");
        }
        CGUtil.tabPrint(3, "concatenatedData = concatenatedData.concat(theData[i] + \" \");");
        CGUtil.tabPrint(3, "}");
        CGUtil.tabPrint(2, "concatenatedData = concatenatedData.trim();");
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", concatenatedData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetEntity(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException  ");
            CGUtil.tabPrint(1, " *           if the value of the attribute (ENTITY) is not a valid ENTITY");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "if (!validEntity(theData))");
            CGUtil.tabPrint(3, "throw new IllegalArgumentException(" + CGUtil.quoteString("An entity has not been declared in the DTD.") + ");");
        }
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetEntities(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException  ");
            CGUtil.tabPrint(1, " *           if the one of the entities in the attribute (ENTITIES) is not valid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String[] theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "String concatenatedData = new String();");
        CGUtil.tabPrint();
        CGUtil.tabPrint(2, "for (int i=0; i < theData.length; i++)");
        CGUtil.tabPrint(2, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(3, "if (!validEntity(theData[i]))");
            CGUtil.tabPrint(4, "throw new IllegalArgumentException(" + CGUtil.quoteString("An entity has not been declared in the DTD.") + ");");
        }
        CGUtil.tabPrint(3, "concatenatedData = concatenatedData.concat(theData[i] + \" \");");
        CGUtil.tabPrint(3, "}");
        CGUtil.tabPrint(2, "concatenatedData = concatenatedData.trim();");
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", concatenatedData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetNMTOKEN(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException  ");
            CGUtil.tabPrint(1, " *           if the value of the attribute (NMTOKEN) is not a valid NMTOKEN");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(2, "if (!validNMTOKEN(theData))");
            CGUtil.tabPrint(3, "throw new IllegalArgumentException(" + CGUtil.quoteString("Invalid NMTOKEN hasbeen specified") + ");");
        }
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", theData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetNMTOKENS(String string, AttrDecl attrDecl) {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException  ");
            CGUtil.tabPrint(1, " *           if the one of the entities in the  attribute (NMTOKENS) is not valid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(String[] theData) throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "String concatenatedData = new String();");
        CGUtil.tabPrint();
        CGUtil.tabPrint(2, "for (int i=0; i < theData.length; i++)");
        CGUtil.tabPrint(2, "{");
        if (this.m_bValidate) {
            CGUtil.tabPrint(3, "if (!validNMTOKEN(theData[i]))");
            CGUtil.tabPrint(4, "throw new IllegalArgumentException(" + CGUtil.quoteString("Invalid NMTOKEN has been specified") + ");");
        }
        CGUtil.tabPrint(3, "concatenatedData = concatenatedData.concat(theData[i] + \" \");");
        CGUtil.tabPrint(3, "}");
        CGUtil.tabPrint(2, "concatenatedData = concatenatedData.trim();");
        CGUtil.tabPrint(2, "setAttribute(" + CGUtil.quoteString(string) + ", concatenatedData);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetEnumeration(String string, AttrDecl attrDecl) {
        String string2;
        int n = 1;
        Enumeration enumeration = attrDecl.getEnumerationValues().elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Constant for enumerated value <code>" + string2 + "</code> for Attribute <code>" + string + "</code>");
                CGUtil.tabPrint(1, " */");
            }
            CGUtil.tabPrint(1, "public static final int " + CGUtil.enumeratedName(string, string2) + " = " + n + ";");
            ++n;
        }
        CGUtil.tabPrint();
        String string3 = CGUtil.variableName(string);
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Sets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param " + string3 + " value of the attribute");
            CGUtil.tabPrint(1, " * @exception IllegalArgumentException  ");
            CGUtil.tabPrint(1, " *           if the value is out of range");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void " + CGUtil.setFunctionName(string) + "(int " + string3 + ") throws IllegalArgumentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "int MAX_VALUE = " + (n - 1) + ";");
        CGUtil.tabPrint(2, "if ((" + string3 + ">MAX_VALUE) || (" + string3 + "<1))");
        CGUtil.tabPrint(3, "throw new IllegalArgumentException();");
        CGUtil.tabPrint();
        CGUtil.tabPrint(2, "switch (" + string3 + ")");
        CGUtil.tabPrint(2, "{");
        n = 1;
        enumeration = attrDecl.getEnumerationValues().elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            CGUtil.tabPrint(3, "case(" + CGUtil.enumeratedName(string, string2) + "):");
            CGUtil.tabPrint(4, "setAttribute(" + CGUtil.quoteString(string) + ", " + CGUtil.quoteString(string2) + ");");
            CGUtil.tabPrint(4, "break;");
        }
        CGUtil.tabPrint(2, "}");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printSetMethod(AttrDecl attrDecl) {
        String string = attrDecl.getNodeName();
        int n = attrDecl.getAttrType();
        switch (n) {
            case 0: {
                this.printSetCData(string, attrDecl);
                break;
            }
            case 1: {
                this.printSetID(string, attrDecl);
                break;
            }
            case 2: {
                this.printSetIDREF(string, attrDecl);
                break;
            }
            case 3: {
                this.printSetIDREFS(string, attrDecl);
                break;
            }
            case 4: {
                this.printSetEntity(string, attrDecl);
                break;
            }
            case 5: {
                this.printSetEntities(string, attrDecl);
                break;
            }
            case 6: {
                this.printSetNMTOKEN(string, attrDecl);
                break;
            }
            case 7: {
                this.printSetNMTOKENS(string, attrDecl);
                break;
            }
            case 8: {
                this.printSetEnumeration(string, attrDecl);
                break;
            }
            case 9: {
                this.printSetEnumeration(string, attrDecl);
                break;
            }
        }
    }

    private void printGetMethod(AttrDecl attrDecl) {
        String string = attrDecl.getNodeName();
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Gets the value of attribute <code>" + string + "</code>");
            CGUtil.tabPrint(1, " * @param theData value of the attribute");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public String " + CGUtil.getFunctionName(string) + "() ");
        CGUtil.tabPrint();
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "return super.getAttribute(" + CGUtil.quoteString(string) + ");");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printMiscMethods() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/** ");
            CGUtil.tabPrint(1, " * Returns the " + CGUtil.initCaps(this.m_doctype) + " DTD.");
            CGUtil.tabPrint(1, " * @return the DTD");
            CGUtil.tabPrint(1, " * @see oracle.xml.parser.v2.DTD");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public DTD getDTDNode()");
        CGUtil.tabPrint(1, "{");
        if (this.m_className.equals(this.m_doctype)) {
            CGUtil.tabPrint(2, "return globalDTD;");
        } else {
            CGUtil.tabPrint(2, "return " + this.m_doctype + ".globalDTD;");
        }
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Validate contents of element <code>" + this.m_className + "</code>");
            CGUtil.tabPrint(1, " * @return true if valid contents, else false");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the document is not valid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void validateContent() throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.validateContent();");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
        if (!this.m_className.equals(this.m_doctype)) {
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Get Document Class <code>" + CGUtil.initCaps(this.m_doctype) + "</code>");
                CGUtil.tabPrint(1, " * @return <code>" + CGUtil.initCaps(this.m_doctype) + "</code> class");
                CGUtil.tabPrint(1, " */");
            }
            CGUtil.tabPrint(1, "public " + CGUtil.initCaps(this.m_doctype) + " getDocument()");
            CGUtil.tabPrint(1, "{");
            CGUtil.tabPrint(2, "return (" + CGUtil.initCaps(this.m_doctype) + ")super.getCGDocument();");
            CGUtil.tabPrint(1, "}");
        }
        CGUtil.tabPrint();
    }

    private void printPackage() {
        if (this.m_packageName != null) {
            CGUtil.tabPrint(1, "package " + this.m_packageName + ";");
            CGUtil.tabPrint();
        }
    }

    private void printImports() {
        if (this.m_className.equals(this.m_doctype)) {
            CGUtil.tabPrint(0, "import oracle.xml.parser.v2.DTD;");
            CGUtil.tabPrint(0, "import oracle.xml.parser.v2.XMLDocument;");
            CGUtil.tabPrint(0, "import oracle.xml.parser.v2.XMLElement;");
            CGUtil.tabPrint(0, "import oracle.xml.parser.v2.XMLNode;");
            CGUtil.tabPrint(0, "import oracle.xml.parser.v2.DOMParser;");
            CGUtil.tabPrint(0, "import oracle.xml.io.XMLObjectInput;");
            CGUtil.tabPrint(0, "import oracle.xml.io.XMLObjectOutput;");
            CGUtil.tabPrint(0, "import oracle.xml.comp.CXMLContext;");
            CGUtil.tabPrint(0, "import oracle.xml.classgen.CGNode;");
            CGUtil.tabPrint(0, "import oracle.xml.classgen.CGDocument;");
            CGUtil.tabPrint(0, "import oracle.xml.classgen.InvalidContentException;");
            CGUtil.tabPrint(0, "import oracle.xml.classgen.UnmarshalException;");
            CGUtil.tabPrint();
            CGUtil.tabPrint(0, "import java.io.InputStream;");
            CGUtil.tabPrint(0, "import java.io.OutputStream;");
            CGUtil.tabPrint(0, "import java.io.FileInputStream;");
            CGUtil.tabPrint(0, "import java.io.FileOutputStream;");
            CGUtil.tabPrint(0, "import java.io.ObjectInput;");
            CGUtil.tabPrint(0, "import java.io.ObjectOutput;");
            CGUtil.tabPrint(0, "import java.io.ObjectInputStream;");
            CGUtil.tabPrint(0, "import java.io.ObjectOutputStream;");
            CGUtil.tabPrint(0, "import java.io.Externalizable;");
            CGUtil.tabPrint(0, "import java.io.IOException;");
            CGUtil.tabPrint(0, "import java.net.URL;");
            CGUtil.tabPrint();
        } else {
            CGUtil.tabPrint(0, "import oracle.xml.parser.v2.DTD;");
            CGUtil.tabPrint(0, "import oracle.xml.io.XMLObjectInput;");
            CGUtil.tabPrint(0, "import oracle.xml.io.XMLObjectOutput;");
            CGUtil.tabPrint(0, "import oracle.xml.comp.CXMLContext;");
            CGUtil.tabPrint(0, "import oracle.xml.classgen.CGNode;");
            CGUtil.tabPrint(0, "import oracle.xml.classgen.InvalidContentException;");
            CGUtil.tabPrint(0, "import java.io.ObjectInput;");
            CGUtil.tabPrint(0, "import java.io.ObjectOutput;");
            CGUtil.tabPrint(0, "import java.io.IOException;");
            CGUtil.tabPrint(0, "import java.io.Externalizable;");
        }
    }

    private void createClass(String string) throws Exception {
        AttrDecl attrDecl;
        int n;
        int n2;
        ElementDecl elementDecl = this.m_dtd.findElementDecl(string);
        NamedNodeMap namedNodeMap = elementDecl.getAttrDecls();
        this.m_elementName = string;
        this.m_className = CGUtil.className(string);
        CGUtil.openFile(this.m_dirName, this.m_packageName, this.m_className);
        this.printPackage();
        this.printImports();
        this.printClassDef();
        Vector<AttrDecl> vector = null;
        if (namedNodeMap != null) {
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                attrDecl = (AttrDecl)namedNodeMap.item(n);
                int n3 = attrDecl.getAttrPresence();
                if (n3 != 1) continue;
                if (vector == null) {
                    vector = new Vector<AttrDecl>();
                }
                vector.addElement(attrDecl);
            }
        }
        this.printConstructors();
        if (vector != null) {
            this.printConstructors(vector);
        }
        if (elementDecl.getContentType() == 3) {
            this.printPCDATAConstructors(vector);
        }
        switch (elementDecl.getContentType()) {
            case 1: {
                break;
            }
            case 2: {
                String string2;
                NamedNodeMap namedNodeMap2 = this.m_dtd.getElementDecls();
                n = namedNodeMap2.getLength();
                for (int i = 0; i < n; ++i) {
                    ElementDecl elementDecl2 = (ElementDecl)namedNodeMap2.item(i);
                    string2 = elementDecl2.getNodeName();
                    this.printAddNodeMethod(CGUtil.className(string2));
                    this.printSetChildNodeMethod(CGUtil.className(string2));
                    this.printGetChildNodeMethod(string2);
                }
                break;
            }
            case 3: {
                String string2;
                Vector vector2 = elementDecl.getContentElements();
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if (string2.equals("PCDATA")) {
                        this.printAddDataMethod();
                        this.printDeleteDataMethod();
                        this.printCDATASectionMethod();
                        this.printDeleteCDATASectionMethod();
                        continue;
                    }
                    this.printAddNodeMethod(CGUtil.className(string2));
                    this.printSetChildNodeMethod(CGUtil.className(string2));
                    this.printGetChildNodeMethod(string2);
                }
                break;
            }
            case 4: {
                String string2;
                Vector vector2 = elementDecl.getContentElements();
                Enumeration enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    this.printAddNodeMethod(CGUtil.className(string2));
                    this.printSetChildNodeMethod(CGUtil.className(string2));
                    this.printGetChildNodeMethod(string2);
                }
                break;
            }
        }
        if (namedNodeMap != null) {
            n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                attrDecl = (AttrDecl)namedNodeMap.item(n);
                int n4 = attrDecl.getAttrPresence();
                if (n4 == 3) continue;
                this.printSetMethod(attrDecl);
                this.printGetMethod(attrDecl);
            }
        }
        if (this.m_className.equals(this.m_doctype)) {
            this.printDocumentMethods();
        }
        this.printMiscMethods();
        this.printUnmarshalMethods();
        CGUtil.tabPrint(0, "}");
        CGUtil.closeFile();
        this.m_elementName = null;
    }

    private void serializeDTD() {
        try {
            String string = this.m_doctype + "_dtd.ser";
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.m_dtd);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("XML Class Generator: Error serializing DTD: " + iOException.toString());
        }
    }

    private void printDTD() {
        try {
            String string = this.m_doctype + "_dtd.txt";
            File file = this.m_dirName != null ? new File(this.m_dirName, string) : new File(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.m_dtd.printExternalDTD((OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("XML Class Generator: Error writing DTD: " + iOException.toString());
        }
    }

    private void printDocumentMethods() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Prints the document to the specified OutputStream");
            CGUtil.tabPrint(1, " * @param out Java outputstream.");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the document is not valid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void print(OutputStream out) throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.print(out);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Prints the document to the specified OutputStream");
            CGUtil.tabPrint(1, " * in the given encoding");
            CGUtil.tabPrint(1, " * @param out Java outputstream.");
            CGUtil.tabPrint(1, " * @exception InvalidContentException  if the document is not valid");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void print(OutputStream out, String enc) throws InvalidContentException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "super.print(out, enc);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }

    private void printUnmarshalMethods() {
        if (this.m_className.equals(this.m_doctype)) {
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Unmarshals the input  URL  to create an object. ");
                CGUtil.tabPrint(1, " * @params url The URL  ");
                CGUtil.tabPrint(1, " * @returns " + this.m_className + " an instance object ");
                CGUtil.tabPrint(1, " * @exception IOException if there there is an IO error ");
                CGUtil.tabPrint(1, " * @exception UnmarshalException if there error in unmarshalling ");
                CGUtil.tabPrint(1, " */");
            }
            CGUtil.tabPrint(1, "public static " + this.m_className + " unmarshal(URL url) ");
            CGUtil.tabPrint(1, "       throws UnmarshalException");
            CGUtil.tabPrint(1, "{");
            CGUtil.tabPrint(2, "try");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "parser.parse(url);");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "catch (Exception e)");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "throw new UnmarshalException(e.toString());");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "return unmarshal();");
            CGUtil.tabPrint(1, "}");
            CGUtil.tabPrint();
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Unmarshals the input XML stream to create an object. ");
                CGUtil.tabPrint(1, " * @params in The XML InputStream ");
                CGUtil.tabPrint(1, " * @returns " + this.m_className + " an instance object ");
                CGUtil.tabPrint(1, " * @exception IOException if there there is an IO error ");
                CGUtil.tabPrint(1, " * @exception UnmarshalException if there error in unmarshalling ");
                CGUtil.tabPrint(1, " */");
            }
            CGUtil.tabPrint(1, "public static " + this.m_className + " unmarshal(InputStream in) ");
            CGUtil.tabPrint(1, "       throws UnmarshalException");
            CGUtil.tabPrint(1, "{");
            CGUtil.tabPrint(2, "try");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "parser.parse(in);");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "catch (Exception e)");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "throw new UnmarshalException(e.toString());");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "return unmarshal();");
            CGUtil.tabPrint(1, "}");
            if (this.m_bComments) {
                CGUtil.tabPrint(1, "/**");
                CGUtil.tabPrint(1, " * Unmarshals the input file to create an instance of object. ");
                CGUtil.tabPrint(1, " * @returns " + this.m_className + " an instance object ");
                CGUtil.tabPrint(1, " * @exception IOException if there there is an IO error ");
                CGUtil.tabPrint(1, " * @exception UnmarshalException if there error in unmarshalling ");
                CGUtil.tabPrint(1, " */");
            }
            String string = "the" + this.m_className;
            CGUtil.tabPrint(1, "private static " + this.m_className + " unmarshal() ");
            CGUtil.tabPrint(1, "       throws UnmarshalException");
            CGUtil.tabPrint(1, "{");
            CGUtil.tabPrint(2, "XMLDocument doc = null;");
            CGUtil.tabPrint(2, "XMLElement elem = null;");
            CGUtil.tabPrint(2, "try");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "doc = parser.getDocument();");
            CGUtil.tabPrint(3, "OutputStream os = new FileOutputStream(\"xml.ser\");");
            CGUtil.tabPrint(3, "ObjectOutputStream oos = new ObjectOutputStream(os);");
            CGUtil.tabPrint(3, "elem = (XMLElement)doc.getDocumentElement();");
            CGUtil.tabPrint(3, "elem.writeExternal(oos);");
            CGUtil.tabPrint(3, "oos.flush();");
            CGUtil.tabPrint(3, "oos.close();");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "catch (Exception e)");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "throw new UnmarshalException(e.toString());");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, this.m_className + " " + string + "=  new " + this.m_className + "();");
            CGUtil.tabPrint(2, "try");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "InputStream is = new FileInputStream(\"xml.ser\");");
            CGUtil.tabPrint(3, "ObjectInputStream ois = new ObjectInputStream(is);");
            CGUtil.tabPrint(3, "elem = " + string + ".getElementNode();");
            CGUtil.tabPrint(3, "elem.readExternal(ois);");
            CGUtil.tabPrint(3, string + ".setElementNode(elem);");
            CGUtil.tabPrint(3, "ois.close();");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "catch (Exception e)");
            CGUtil.tabPrint(2, "{");
            CGUtil.tabPrint(3, "throw new UnmarshalException(e.toString());");
            CGUtil.tabPrint(2, "}");
            CGUtil.tabPrint(2, "return " + string + ";");
            CGUtil.tabPrint(1, "}");
        }
        this.printExternalizableMethods();
    }

    private void printExternalizableMethods() {
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Saves the state of the object by creating a binary compressed ");
            CGUtil.tabPrint(1, " * stream with information about the object. ");
            CGUtil.tabPrint(1, " * @param out The ObjectOutput stream used to write the  compressed stream. ");
            CGUtil.tabPrint(1, " * @exception IOException is thrown when there is an exception ");
            CGUtil.tabPrint(1, "              in writing the compressed stream. ");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void writeExternal(ObjectOutput out)");
        CGUtil.tabPrint(1, "            throws IOException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "XMLObjectOutput xout = new XMLObjectOutput(out);");
        CGUtil.tabPrint(2, "CXMLContext cxmlContext = new CXMLContext();");
        CGUtil.tabPrint(2, "super.writeExternal(xout, cxmlContext);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
        if (this.m_bComments) {
            CGUtil.tabPrint(1, "/**");
            CGUtil.tabPrint(1, " * Reads the information written in the compressed stream and  restores the object. ");
            CGUtil.tabPrint(1, " * @param in the ObjectInput stream used for reading the  compressed stream");
            CGUtil.tabPrint(1, " * @exception IOException is thrown when there is an error in ");
            CGUtil.tabPrint(1, "              reading the input stream.");
            CGUtil.tabPrint(1, " * @exception ClassNotFoundException is thrown when the class is not found");
            CGUtil.tabPrint(1, " */");
        }
        CGUtil.tabPrint(1, "public void readExternal(ObjectInput in)");
        CGUtil.tabPrint(1, "          throws IOException, ClassNotFoundException");
        CGUtil.tabPrint(1, "{");
        CGUtil.tabPrint(2, "XMLObjectInput xin = new XMLObjectInput(in);");
        CGUtil.tabPrint(2, "CXMLContext cxmlContext = new CXMLContext();");
        CGUtil.tabPrint(2, "super.readExternal(xin, cxmlContext);");
        CGUtil.tabPrint(1, "}");
        CGUtil.tabPrint();
    }
}

