/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.classgen.CGUtil;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XMLSchemaNode;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstrainingFacet;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDGroup;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;

public class SchemaClassGenerator {
    boolean m_bComments = true;
    String m_dirName = null;
    boolean m_bSerialize = false;
    private Hashtable m_packages = new Hashtable();
    private Hashtable elemClassTable = null;
    private Hashtable typeClassTable = null;
    private Hashtable attrClassTable = null;
    private String m_fileName;
    private int m_indent = 0;
    static final int ELEMENT = 1;
    static final int TYPE = 2;
    static final int ATTRIBUTE = 3;
    static final int REF_RESOLVED = 0;
    static final int REF_UNRESOLVED = 1;
    static final int TYPE_RESOLVED = 2;
    static final int TYPE_UNRESOLVED = 3;
    private Vector groupElemVector = new Vector();

    public SchemaClassGenerator() {
    }

    public SchemaClassGenerator(String string) {
        this.m_fileName = string;
    }

    void setSerializationMode(boolean bl) {
        this.m_bSerialize = bl;
    }

    public void setGenerateComments(boolean bl) {
        this.m_bComments = bl;
    }

    public void setOutputDirectory(String string) {
        this.m_dirName = string;
    }

    public void setJavaPackage(XMLSchema xMLSchema, Vector vector) {
        String[] stringArray = xMLSchema.getAllTargetNS();
        if ((stringArray.length == 0 || stringArray.length == 1) && vector.size() == 0) {
            return;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == "" || stringArray[i].equals("http://www.w3.org/2001/XMLSchema") || stringArray[i].equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
            try {
                String string = (String)vector.elementAt(n);
                this.m_packages.put(stringArray[i], string);
                ++n;
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                System.out.println("Error: The command line input for the  schema packages do not match the number of target  namespace");
                System.exit(0);
            }
        }
    }

    public void generate(XMLSchema xMLSchema) {
        try {
            int n;
            XSDNode[] xSDNodeArray;
            XSDNode[] xSDNodeArray2;
            XSDNode[] xSDNodeArray3;
            XSDNode[] xSDNodeArray4;
            XMLSchemaNode xMLSchemaNode;
            String string;
            Enumeration enumeration = xMLSchema.getXMLSchemaNodeTable().keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                xMLSchemaNode = xMLSchema.getSchemaByTargetNS(string);
                xSDNodeArray4 = xMLSchemaNode.getElementSet();
                xSDNodeArray3 = xMLSchemaNode.getSimpleTypeSet();
                xSDNodeArray2 = xMLSchemaNode.getComplexTypeSet();
                xSDNodeArray = xMLSchemaNode.getAttributeSet();
                for (n = 0; n < xSDNodeArray4.length; ++n) {
                    this.generateClassNames(xSDNodeArray4[n], 1);
                }
                for (n = 0; n < xSDNodeArray3.length; ++n) {
                    this.generateClassNames(xSDNodeArray3[n], 2);
                }
                for (n = 0; n < xSDNodeArray2.length; ++n) {
                    this.generateClassNames(xSDNodeArray2[n], 2);
                }
                for (n = 0; n < xSDNodeArray.length; ++n) {
                    this.generateClassNames(xSDNodeArray[n], 3);
                }
            }
            enumeration = xMLSchema.getXMLSchemaNodeTable().keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.equals("http://www.w3.org/2001/XMLSchema") || string.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                xMLSchemaNode = xMLSchema.getSchemaByTargetNS(string);
                xSDNodeArray4 = xMLSchemaNode.getElementSet();
                xSDNodeArray3 = xMLSchemaNode.getSimpleTypeSet();
                xSDNodeArray2 = xMLSchemaNode.getComplexTypeSet();
                xSDNodeArray = xMLSchemaNode.getAttributeSet();
                for (n = 0; n < xSDNodeArray3.length; ++n) {
                    this.createSchemaClass(xSDNodeArray3[n], 2);
                }
                for (n = 0; n < xSDNodeArray2.length; ++n) {
                    this.createSchemaClass(xSDNodeArray2[n], 2);
                }
                for (n = 0; n < xSDNodeArray4.length; ++n) {
                    this.createSchemaClass(xSDNodeArray4[n], 1);
                }
                for (n = 0; n < xSDNodeArray.length; ++n) {
                    this.createSchemaClass(xSDNodeArray[n], 3);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("An error in generating class: " + exception.toString());
        }
    }

    private void generateClassNames(XSDNode xSDNode, int n) {
        String string = null;
        String string2 = CGUtil.className(xSDNode.getName());
        String string3 = xSDNode.getTargetNS();
        String string4 = (String)this.m_packages.get(string3);
        string = string4 != null ? string4 + "." + string2 : string2;
        if (n == 1) {
            if (this.elemClassTable == null) {
                this.elemClassTable = new Hashtable();
            }
            this.elemClassTable.put(xSDNode.getName(), string);
        } else if (n == 2) {
            string = string4 != null ? string4 + ".types." + string2 : "types." + string2;
            if (this.typeClassTable == null) {
                this.typeClassTable = new Hashtable();
            }
            this.typeClassTable.put(xSDNode.getName(), string);
        } else if (n == 3) {
            string = string4 + ".attributes." + string2;
            if (this.attrClassTable == null) {
                this.attrClassTable = new Hashtable();
            }
            this.attrClassTable.put(xSDNode.getName(), string);
        }
    }

    private void createSchemaClass(XSDNode xSDNode, int n) {
        String string;
        String string2 = "";
        String string3 = "";
        String string4 = System.getProperty("file.separator");
        String string5 = xSDNode.getTargetNS();
        if ((String)this.m_packages.get(string5) != null) {
            string2 = (String)this.m_packages.get(string5);
        }
        if (n == 1) {
            string3 = CGUtil.getInnerClassName((String)this.elemClassTable.get(xSDNode.getName()));
        } else if (n == 2) {
            string2 = string2 + ".types";
            string3 = CGUtil.getInnerClassName((String)this.typeClassTable.get(xSDNode.getName()));
        } else if (n == 3) {
            string2 = string2 + ".attributes";
            string3 = CGUtil.getInnerClassName((String)this.attrClassTable.get(xSDNode.getName()));
        }
        try {
            CGUtil.openFile(this.m_dirName, string2, string3);
        }
        catch (Exception exception) {
            System.out.println("Error in creating java class file");
        }
        if (string2 != "") {
            if (string2.equals(".types")) {
                CGUtil.tabPrint(this.m_indent, "package types;");
            } else if (string2.equals(".attributes")) {
                CGUtil.tabPrint(this.m_indent, "package attributes; ");
            } else {
                CGUtil.tabPrint(this.m_indent, "package " + string2 + ";");
            }
            CGUtil.tabPrint();
        }
        CGUtil.tabPrint(this.m_indent, "import oracle.xml.parser.schema.*;");
        CGUtil.tabPrint(this.m_indent, "import oracle.xml.parser.v2.*;");
        CGUtil.tabPrint(this.m_indent, "import oracle.xml.classgen.CGXSDElement;");
        CGUtil.tabPrint(this.m_indent, "import oracle.xml.classgen.InvalidContentException;");
        CGUtil.tabPrint();
        CGUtil.tabPrint(this.m_indent, "import java.io.*;");
        CGUtil.tabPrint(this.m_indent, "import java.net.*;");
        CGUtil.tabPrint(this.m_indent, "import java.util.*;");
        CGUtil.tabPrint();
        String string6 = "CGXSDElement";
        if (xSDNode instanceof XSDComplexType && (string = ((XSDComplexType)xSDNode).getRefLocalname()) != null && !this.isDerivedDataType(string) && !this.isJavaDataType(string) && !string.equals("anyType")) {
            string6 = CGUtil.className(string);
        }
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * The class corresponding to the top level schema node item (Element or ");
            CGUtil.tabPrint(this.m_indent, " * SimpleType element or ComplexType element) ");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public class " + string3 + " extends " + string6);
        CGUtil.tabPrint(this.m_indent, "{");
        ++this.m_indent;
        if (xSDNode instanceof XSDSimpleType) {
            this.printConstructors(xSDNode, string3);
        } else if (xSDNode instanceof XSDComplexType) {
            this.printComplexTypeClass(xSDNode, string3);
            this.printGetElements();
            this.printElements();
        } else {
            this.printElementClass(xSDNode, string3);
        }
        --this.m_indent;
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.closeFile();
    }

    private void printElementClass(XSDNode xSDNode, String string) {
        String string2 = string;
        String string3 = ((XSDElement)xSDNode).getRefLocalname();
        String string4 = xSDNode.getName();
        String string5 = xSDNode.getTargetNS();
        CGUtil.tabPrint(this.m_indent, "static final String name = " + CGUtil.quoteString(string4) + ";");
        CGUtil.tabPrint(this.m_indent, "static final String namespace = " + CGUtil.quoteString(string5) + ";");
        this.printConstructors(xSDNode, string);
        string2 = string3 != null && !string3.equals("anyType") ? (this.isDerivedDataType(string3) || this.isJavaDataType(string3) ? CGUtil.className(this.getDataType(string3)) : (String)this.typeClassTable.get(string3)) : string + "." + CGUtil.className(CGUtil.getInnerClassName(string)) + "_Type";
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Sets the type of the element node.");
            CGUtil.tabPrint(this.m_indent, " * @param " + string3 + " the type to which the element is set");
            CGUtil.tabPrint(this.m_indent, " * @exception   IllegalArgumentException if the type is not valid.");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void setType(" + string2 + "  elemtype)");
        CGUtil.tabPrint(this.m_indent + 2, " throws IllegalArgumentException");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "this.type = elemtype;");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Prints in XML format the node. corresponding to the class.");
            CGUtil.tabPrint(this.m_indent, " * @param  out the Output Stream ");
            CGUtil.tabPrint(this.m_indent, " * @exception  IOException if there is an error in writing the output");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void print(XMLOutputStream out)");
        CGUtil.tabPrint(this.m_indent + 3, "throws IOException");
        CGUtil.tabPrint(this.m_indent, "{");
        if (this.isJavaDataType(string2)) {
            CGUtil.tabPrint(this.m_indent + 1, "out.writeNewLine();");
            CGUtil.tabPrint(this.m_indent + 1, "out.writeChars(" + CGUtil.quoteString("<") + "+ name +" + CGUtil.quoteString(">") + ");");
            CGUtil.tabPrint(this.m_indent + 1, "out.writeChars((" + string2 + ")type);");
            CGUtil.tabPrint(this.m_indent + 1, "out.writeChars(" + CGUtil.quoteString("</") + "+ name +" + CGUtil.quoteString(">") + ");");
        } else {
            CGUtil.tabPrint(this.m_indent + 1, "super.printAttributes(out, name, namespace);");
        }
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
        if (string3 == null || string3.equals("anyType")) {
            XSDNode xSDNode2 = ((XSDElement)xSDNode).getType();
            if (this.m_bComments) {
                CGUtil.tabPrint(this.m_indent, "/** ");
                CGUtil.tabPrint(this.m_indent, " * The class corresponding to the local element ");
                CGUtil.tabPrint(this.m_indent, " */");
            }
            String string6 = "CGXSDElement";
            if (xSDNode2.getNodeType() == 1) {
                String string7 = ((XSDComplexType)xSDNode2).getRefLocalname();
                if (!(string7 == null || this.isDerivedDataType(string7) || this.isJavaDataType(string7) || string7.equals("anyType"))) {
                    string6 = (String)this.typeClassTable.get(string7);
                }
                String string8 = CGUtil.getInnerClassName(string) + "_Type";
                CGUtil.tabPrint(this.m_indent, "public static class " + string8 + " extends " + string6);
                CGUtil.tabPrint(this.m_indent, "{");
                ++this.m_indent;
                this.printComplexTypeClass(xSDNode2, string8, string5, string2);
                this.printGetElements();
                this.printElements();
                --this.m_indent;
            } else if (xSDNode2.getNodeType() == 2) {
                String string9 = CGUtil.getInnerClassName(string) + "_Type";
                CGUtil.tabPrint(this.m_indent, "public static class " + string9 + " extends " + string6);
                CGUtil.tabPrint(this.m_indent, "{");
                ++this.m_indent;
                this.printConstructors(xSDNode2, string9);
                this.printGetElements();
                this.printElements();
                --this.m_indent;
            }
            CGUtil.tabPrint(this.m_indent, "}");
            CGUtil.tabPrint();
        }
        this.printValidateElement();
    }

    private void printComplexTypeClass(XSDNode xSDNode, String string) {
        String string2 = xSDNode.getName();
        String string3 = xSDNode.getTargetNS();
        this.printComplexTypeClass(xSDNode, string2, string3, string);
    }

    private void printComplexTypeClass(XSDNode xSDNode, String string, String string2, String string3) {
        int n;
        String string4;
        String string5;
        String string6;
        String string7;
        XSDNode xSDNode2;
        int n2;
        CGUtil.tabPrint(this.m_indent, "static final String name = " + CGUtil.quoteString(string) + ";");
        CGUtil.tabPrint(this.m_indent, "static final String namespace = " + CGUtil.quoteString(string2) + ";");
        Vector vector = this.getInnerLocalAttributes(xSDNode);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            xSDNode2 = (XSDNode)vector.elementAt(n2);
            string7 = xSDNode2.getName();
            if (string7 == null) continue;
            string7 = "a" + string7;
            string6 = ((XSDElement)xSDNode2).getRefLocalname();
            string5 = null;
            if (string6 != null) {
                string4 = this.getDataType(string6);
                if (!(string4.equals("String") || string4.equals("Byte") || string4.equals("Boolean") || string4.equals("Double") || string4.equals("Float") || string4.equals("Integer") || string4.equals("Long") || string4.equals("Short"))) {
                    if (this.typeClassTable != null && this.typeClassTable.containsKey(string6)) {
                        string5 = (String)this.typeClassTable.get(string6);
                    } else if (this.attrClassTable != null && this.attrClassTable.containsKey(string6)) {
                        string5 = (String)this.attrClassTable.get(string6);
                    }
                    CGUtil.tabPrint(this.m_indent, "protected " + string5 + " " + string7 + ";");
                    continue;
                }
                CGUtil.tabPrint(this.m_indent, "protected " + string4 + "  " + string7 + ";");
                continue;
            }
            CGUtil.tabPrint(this.m_indent, "protected " + string3 + "." + CGUtil.className(xSDNode2.getName()) + " " + string7 + ";");
        }
        this.printConstructors(xSDNode, string3);
        for (n2 = 0; n2 < vector.size(); ++n2) {
            xSDNode2 = (XSDNode)vector.elementAt(n2);
            string7 = xSDNode2.getName();
            string6 = "a" + string7;
            if (string7 == null) continue;
            string5 = ((XSDElement)xSDNode2).getRefLocalname();
            if (string5 != null) {
                this.printSetAttribute(xSDNode2);
                this.printGetAttribute(xSDNode2);
                continue;
            }
            string4 = ((XSDElement)xSDNode2).getType();
            if (string4.getNodeType() != 2) continue;
            String string8 = CGUtil.className(xSDNode2.getName());
            string3 = string3 + "." + string8;
            CGUtil.tabPrint(this.m_indent, "public void " + CGUtil.setFunctionName(string7) + "(" + string3 + " " + CGUtil.getMethodParam(string7) + ")");
            CGUtil.tabPrint(this.m_indent + 2, " throws IllegalArgumentException");
            CGUtil.tabPrint(this.m_indent, "{");
            CGUtil.tabPrint(this.m_indent + 1, "this." + string6 + " =  " + CGUtil.getMethodParam(string7) + ";");
            CGUtil.tabPrint(this.m_indent + 1, "super.addAttribute(" + CGUtil.quoteString(string7) + " , " + CGUtil.getMethodParam(string7) + ".getNodeValue());");
            CGUtil.tabPrint(this.m_indent, "}");
            CGUtil.tabPrint();
            if (this.m_bComments) {
                CGUtil.tabPrint(this.m_indent, "/**");
                CGUtil.tabPrint(this.m_indent, " * Create the inner class");
                CGUtil.tabPrint(this.m_indent, " */");
            }
            CGUtil.tabPrint(this.m_indent, "public static class " + string8 + " extends CGXSDElement");
            CGUtil.tabPrint(this.m_indent, "{");
            ++this.m_indent;
            this.printConstructors((XSDNode)string4, string3);
            --this.m_indent;
            CGUtil.tabPrint(this.m_indent, "}");
            CGUtil.tabPrint();
        }
        XSDNode[] xSDNodeArray = this.getInnerLocalElements(xSDNode);
        for (n = 0; xSDNodeArray != null && n < xSDNodeArray.length; ++n) {
            this.printAddElement(xSDNodeArray[n], string3);
        }
        for (n = 0; xSDNodeArray != null && n < xSDNodeArray.length; ++n) {
            if (((XSDElement)xSDNodeArray[n]).getRefState() == 0) continue;
            this.printInnerClassElement(xSDNodeArray[n], string3);
        }
        if (((XSDComplexType)xSDNode).getContent() == 13) {
            this.printAddText();
        }
    }

    private XSDNode[] getInnerLocalElements(XSDNode xSDNode) {
        Object[] objectArray;
        XSDNode[] xSDNodeArray = ((XSDComplexType)xSDNode).getElementSet();
        Vector vector = new Vector();
        for (int i = 0; xSDNodeArray != null && i < xSDNodeArray.length; ++i) {
            if (xSDNodeArray[i] instanceof XSDGroup) {
                vector = this.getGroupElements(xSDNodeArray[i], vector);
                continue;
            }
            if (xSDNodeArray[i].getName() == null) continue;
            vector.addElement(xSDNodeArray[i]);
        }
        XSDNode[] xSDNodeArray2 = null;
        if (((XSDComplexType)xSDNode).getDerivationMethod() == 1) {
            int n;
            objectArray = ((XSDComplexType)xSDNode).getBaseType();
            if (objectArray != null && objectArray instanceof XSDComplexType) {
                xSDNodeArray2 = ((XSDComplexType)objectArray).getElementSet();
            }
            Vector vector2 = new Vector();
            for (n = 0; xSDNodeArray2 != null && n < xSDNodeArray2.length; ++n) {
                if (xSDNodeArray2[n] instanceof XSDGroup) {
                    vector2 = this.getGroupElements(xSDNodeArray2[n], vector2);
                    continue;
                }
                vector2.addElement(xSDNodeArray2[n]);
            }
            for (n = 0; n < vector2.size(); ++n) {
                XSDNode xSDNode2 = (XSDNode)vector2.elementAt(n);
                for (int i = 0; i < vector.size(); ++i) {
                    XSDNode xSDNode3 = (XSDNode)vector.elementAt(i);
                    if (!xSDNode3.getName().equals(xSDNode2.getName())) continue;
                    vector.removeElementAt(i);
                }
            }
        }
        objectArray = new XSDNode[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private Vector getInnerLocalAttributes(XSDNode xSDNode) {
        XSDNode[] xSDNodeArray = ((XSDComplexType)xSDNode).getAttributeSet();
        Vector<XSDNode> vector = new Vector<XSDNode>();
        if (((XSDComplexType)xSDNode).getDerivationMethod() == 1) {
            XSDNode[] xSDNodeArray2 = null;
            XSDNode xSDNode2 = ((XSDComplexType)xSDNode).getBaseType();
            if (xSDNode2 != null && xSDNode2 instanceof XSDComplexType) {
                xSDNodeArray2 = ((XSDComplexType)xSDNode2).getAttributeSet();
            }
            boolean bl = false;
            if (xSDNodeArray2 != null) {
                for (int i = 0; i < xSDNodeArray.length; ++i) {
                    bl = false;
                    for (int j = 0; j < xSDNodeArray2.length; ++j) {
                        if (xSDNodeArray[i].getName() == null || xSDNodeArray2[j].getName() == null || !xSDNodeArray[i].getName().equals(xSDNodeArray2[j].getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    vector.addElement(xSDNodeArray[i]);
                }
            } else {
                for (int i = 0; i < xSDNodeArray.length; ++i) {
                    vector.addElement(xSDNodeArray[i]);
                }
            }
        } else {
            for (int i = 0; i < xSDNodeArray.length; ++i) {
                vector.addElement(xSDNodeArray[i]);
            }
        }
        return vector;
    }

    private void printAddText() {
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Add the text to the node. ");
            CGUtil.tabPrint(this.m_indent, " * @param text the node text ");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void addText(String text)");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "super.addElement(new String(text));");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Add CDATA to the node. ");
            CGUtil.tabPrint(this.m_indent, " * @param text the node CDATA ");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void addCDATA(String text)");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "super.addElement(new String(text));");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
    }

    private void printSetAttribute(XSDNode xSDNode) {
        String string = xSDNode.getName();
        String string2 = "a" + string;
        String string3 = ((XSDElement)xSDNode).getRefLocalname();
        CGUtil.tabPrint();
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Sets the value of attribute ");
            CGUtil.tabPrint(this.m_indent, " * @param " + string + " " + " the value to which the attribute is set");
            CGUtil.tabPrint(this.m_indent, " * @exception IllegalArgumentException  if the attribute is not valid. ");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        String string4 = this.getDataType(string3);
        String string5 = CGUtil.getMethodParam(string);
        if (!(string4.equals("String") || string4.equals("Byte") || string4.equals("Boolean") || string4.equals("Double") || string4.equals("Float") || string4.equals("Integer") || string4.equals("Long") || string4.equals("Short"))) {
            if (this.typeClassTable != null && this.typeClassTable.containsKey(string3)) {
                string4 = (String)this.typeClassTable.get(string3);
                string5 = string5 + ".getNodeValue()";
            } else if (this.attrClassTable != null && this.attrClassTable.containsKey(string3)) {
                string4 = (String)this.attrClassTable.get(string3);
                string5 = "((CGXSDElement)" + string2 + "." + "getType()).getNodeValue()";
            }
        } else if (string4 == null) {
            string4 = CGUtil.className(string3);
            string5 = string5 + ".getNodeValue()";
        }
        CGUtil.tabPrint(this.m_indent, "public void " + CGUtil.setFunctionName(string) + "(" + string4 + " " + CGUtil.getMethodParam(string) + ")");
        CGUtil.tabPrint(this.m_indent + 2, " throws IllegalArgumentException");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "this." + string2 + " =  " + CGUtil.getMethodParam(string) + ";");
        CGUtil.tabPrint(this.m_indent + 1, "super.addAttribute(" + CGUtil.quoteString(string) + " , " + string5 + ");");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
    }

    private void printGetAttribute(XSDNode xSDNode) {
        String string = xSDNode.getName();
        String string2 = "a" + string;
        String string3 = ((XSDElement)xSDNode).getRefLocalname();
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Gets the value of attribute ");
            CGUtil.tabPrint(this.m_indent, " * @returns " + string + " the attribute ");
            CGUtil.tabPrint(this.m_indent, " * @exception IllegalArgumentException  if the attribute is not valid. ");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        String string4 = this.getDataType(string3);
        if (string3 != null) {
            if (!(string4.equals("String") || string4.equals("Byte") || string4.equals("Boolean") || string4.equals("Double") || string4.equals("Float") || string4.equals("Integer") || string4.equals("Long") || string4.equals("Short"))) {
                if (this.typeClassTable != null && this.typeClassTable.containsKey(string3)) {
                    string4 = (String)this.typeClassTable.get(string3);
                } else if (this.attrClassTable != null && this.attrClassTable.containsKey(string3)) {
                    string4 = (String)this.attrClassTable.get(string3);
                }
            } else if (string4 == null) {
                string4 = CGUtil.className(string3);
            }
        } else {
            string4 = "XSDSimpleType";
        }
        CGUtil.tabPrint(this.m_indent, "public " + string4 + " " + CGUtil.getFunctionName(string) + "()");
        CGUtil.tabPrint(this.m_indent + 2, " throws IllegalArgumentException");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "return this." + string2 + ";");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
    }

    private Vector getGroupElements(XSDNode xSDNode, Vector vector) {
        Vector vector2 = ((XSDGroup)xSDNode).getNodeVector();
        for (int i = 0; i < vector2.size(); ++i) {
            XSDNode xSDNode2 = (XSDNode)vector2.elementAt(i);
            if (xSDNode2 instanceof XSDGroup) {
                vector = this.getGroupElements(xSDNode2, vector);
                continue;
            }
            if (xSDNode2.getName() == null) continue;
            boolean bl = false;
            for (int j = 0; j < vector.size(); ++j) {
                XSDElement xSDElement = (XSDElement)vector.elementAt(j);
                if (!xSDElement.getName().equals(xSDNode2.getName())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(xSDNode2);
        }
        return vector;
    }

    private void printAddGroup(XSDNode xSDNode, String string) {
        Vector vector = ((XSDGroup)xSDNode).getNodeVector();
        for (int i = 0; i < vector.size(); ++i) {
            XSDNode xSDNode2 = (XSDNode)vector.elementAt(i);
            if (xSDNode2 instanceof XSDGroup) {
                this.printAddGroup(xSDNode2, string);
                continue;
            }
            String string2 = xSDNode2.getName();
            if (this.groupElemVector.contains(string2)) continue;
            this.printAddElement(xSDNode2, string);
            this.groupElemVector.addElement(string2);
        }
    }

    private void printAddElement(XSDNode xSDNode, String string) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = null;
        String string7 = xSDNode.getName();
        String string8 = string + "." + CGUtil.className(string7);
        if (!(string7 == null || (string6 = ((XSDElement)xSDNode).getRefLocalname()) == null || string6.equals("anyType") || this.isDerivedDataType(string6) || this.isJavaDataType(string6) || ((XSDElement)xSDNode).getRefState() != 0)) {
            String string9 = ((XSDElement)xSDNode).getRefNamespace();
            String string10 = (String)this.m_packages.get(string9);
            string8 = string10 + "." + CGUtil.className(string7);
        }
        string5 = CGUtil.addFunctionName(string7);
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Adds the local element ");
            CGUtil.tabPrint(this.m_indent, " * @param " + string7 + " the element node");
            CGUtil.tabPrint(this.m_indent, " * @exception  InvalidContentException if the element is not valid. ");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void " + string5 + "(" + string8 + " " + CGUtil.getMethodParam(string7) + ")");
        CGUtil.tabPrint(this.m_indent + 2, "throws InvalidContentException");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "super.addElement(" + CGUtil.getMethodParam(string7) + ");");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
        if (xSDNode instanceof XSDGroup) {
            this.printAddGroup(xSDNode, string);
        }
    }

    private void printInnerClassGroup(XSDNode xSDNode, String string) {
        Vector vector = ((XSDGroup)xSDNode).getNodeVector();
        for (int i = 0; i < vector.size(); ++i) {
            XSDNode xSDNode2 = (XSDNode)vector.elementAt(i);
            if (xSDNode2 instanceof XSDGroup) {
                this.printInnerClassGroup(xSDNode2, string);
                continue;
            }
            String string2 = xSDNode2.getName();
            if (this.groupElemVector.contains(string2)) continue;
            this.printInnerClassElement(xSDNode2, string);
            this.groupElemVector.addElement(string2);
        }
    }

    private void printInnerClassElement(XSDNode xSDNode, String string) {
        String string2 = "";
        String string3 = "CGXSDElement";
        String string4 = xSDNode.getName();
        if (string4 != null) {
            string2 = ((XSDElement)xSDNode).getRefLocalname();
            String string5 = CGUtil.className(string4);
            if (this.m_bComments) {
                CGUtil.tabPrint(this.m_indent, "/**");
                CGUtil.tabPrint(this.m_indent, " * The class corresponding to the inner type or element ");
                CGUtil.tabPrint(this.m_indent, " */");
            }
            CGUtil.tabPrint(this.m_indent, "public static class " + string5 + " extends " + string3);
            CGUtil.tabPrint(this.m_indent, "{");
            ++this.m_indent;
            string = string + "." + string5;
            this.printElementClass(xSDNode, string);
            --this.m_indent;
            CGUtil.tabPrint(this.m_indent, "}");
            CGUtil.tabPrint();
        }
    }

    private void printGetElements() {
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Get the local elements");
            CGUtil.tabPrint(this.m_indent, " * @return elements stored in Vector");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public Vector getChildElements()");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "return super.getChildElements();");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
    }

    private void printElements() {
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Prints in XML format the node. corresponding to the class.");
            CGUtil.tabPrint(this.m_indent, " * @param  out the Output Stream ");
            CGUtil.tabPrint(this.m_indent, " * @exception  IOException if there is an error in writing the output");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void print(XMLOutputStream out)");
        CGUtil.tabPrint(this.m_indent + 3, "throws IOException");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent + 1, "super.print(out);");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
    }

    private void printValidateElement() {
        if (this.m_bComments) {
            CGUtil.tabPrint(this.m_indent, "/**");
            CGUtil.tabPrint(this.m_indent, " * Validate the element");
            CGUtil.tabPrint(this.m_indent, " * @param schema the XML Schema node");
            CGUtil.tabPrint(this.m_indent, " */");
        }
        CGUtil.tabPrint(this.m_indent, "public void validate(XMLSchema schema) ");
        CGUtil.tabPrint(this.m_indent, "{");
        CGUtil.tabPrint(this.m_indent, "}");
        CGUtil.tabPrint();
    }

    private void printConstructors(XSDNode xSDNode, String string) {
        if (xSDNode instanceof XSDSimpleType) {
            String string2;
            int n;
            Vector vector;
            int n2;
            int n3 = ((XSDSimpleType)xSDNode).getBasicType();
            String string3 = XSDSimpleType.sTypes[n3];
            XSDConstrainingFacet[] xSDConstrainingFacetArray = ((XSDSimpleType)xSDNode).getFacets();
            if (this.m_bComments) {
                CGUtil.tabPrint(this.m_indent, "/**");
                CGUtil.tabPrint(this.m_indent, " * Constructor taking XSDStringType and ");
                CGUtil.tabPrint(this.m_indent, " * XSDDataValue as parameters.");
                CGUtil.tabPrint(this.m_indent, " * @param elemType XSDStringType element node");
                CGUtil.tabPrint(this.m_indent, " * @param elemValue XSDDataValue of the ndoe");
                CGUtil.tabPrint(this.m_indent, " * @exception InvalidContentException");
                CGUtil.tabPrint(this.m_indent, " *       if the value is invalid");
                CGUtil.tabPrint(this.m_indent, " */");
            }
            CGUtil.tabPrint(this.m_indent, "public " + CGUtil.getInnerClassName(string) + "(XSDDataValue elemValue)");
            CGUtil.tabPrint(this.m_indent + 2, "throws InvalidContentException ");
            CGUtil.tabPrint(this.m_indent, "{");
            CGUtil.tabPrint(this.m_indent + 1, "try");
            CGUtil.tabPrint(this.m_indent + 1, "{");
            CGUtil.tabPrint(this.m_indent + 2, "Hashtable h = XSDSimpleType.getBuiltInDatatypes();");
            CGUtil.tabPrint(this.m_indent + 2, "XSDSimpleType baseType = (XSDSimpleType)h.get(" + CGUtil.quoteString(string3) + ");");
            CGUtil.tabPrint(this.m_indent + 2, "type = XSDSimpleType.derivedFrom(baseType," + CGUtil.quoteString(string3) + ", \" \");");
            CGUtil.tabPrint(this.m_indent + 2, "XSDSimpleType stype = (XSDSimpleType)type;");
            for (n2 = 0; n2 < 13; ++n2) {
                if (xSDConstrainingFacetArray[n2] == null) continue;
                if (XSDSimpleType.sFacets[n2].equals("enumeration")) {
                    vector = xSDConstrainingFacetArray[n2].getLexicalEnumeration();
                    for (n = 0; n < vector.size(); ++n) {
                        string2 = (String)vector.elementAt(n);
                        CGUtil.tabPrint(this.m_indent + 2, "stype.setFacet(" + CGUtil.quoteString(XSDSimpleType.sFacets[n2]) + "," + "\"" + string2 + "\");");
                    }
                    continue;
                }
                string2 = CGUtil.parseFacet(xSDConstrainingFacetArray[n2].getLexicalValue());
                CGUtil.tabPrint(this.m_indent + 2, "stype.setFacet(" + CGUtil.quoteString(XSDSimpleType.sFacets[n2]) + "," + "\"" + string2 + "\");");
            }
            CGUtil.tabPrint(this.m_indent + 2, "String nodeValue = elemValue.getLexicalValue();");
            CGUtil.tabPrint(this.m_indent + 2, "stype.validateValue(nodeValue);");
            CGUtil.tabPrint(this.m_indent + 2, "super.setNodeValue(nodeValue);");
            CGUtil.tabPrint(this.m_indent + 1, "}");
            CGUtil.tabPrint(this.m_indent + 1, "catch (Exception e)");
            CGUtil.tabPrint(this.m_indent + 1, "{");
            CGUtil.tabPrint(this.m_indent + 2, "throw new InvalidContentException(" + CGUtil.quoteString("Error: Invalid value.") + ");");
            CGUtil.tabPrint(this.m_indent + 1, "}");
            CGUtil.tabPrint(this.m_indent, "}");
            if (this.m_bComments) {
                CGUtil.tabPrint(this.m_indent, "/**");
                CGUtil.tabPrint(this.m_indent, " * Constructor taking String as value of the ");
                CGUtil.tabPrint(this.m_indent, " * simpleType node data value.");
                CGUtil.tabPrint(this.m_indent, " * @param value data value of the node");
                CGUtil.tabPrint(this.m_indent, " * @exception InvalidContentException");
                CGUtil.tabPrint(this.m_indent, " *       if the value is invalid");
                CGUtil.tabPrint(this.m_indent, " */");
            }
            CGUtil.tabPrint(this.m_indent, "public " + CGUtil.getInnerClassName(string) + "(String value)");
            CGUtil.tabPrint(this.m_indent + 2, "throws InvalidContentException ");
            CGUtil.tabPrint(this.m_indent, "{");
            CGUtil.tabPrint(this.m_indent + 1, "try");
            CGUtil.tabPrint(this.m_indent + 1, "{");
            CGUtil.tabPrint(this.m_indent + 2, "Hashtable h = XSDSimpleType.getBuiltInDatatypes();");
            CGUtil.tabPrint(this.m_indent + 2, "XSDSimpleType baseType = (XSDSimpleType)h.get(" + CGUtil.quoteString(string3) + ");");
            CGUtil.tabPrint(this.m_indent + 2, "type = XSDSimpleType.derivedFrom(baseType," + CGUtil.quoteString(string3) + ", \" \");");
            CGUtil.tabPrint(this.m_indent + 2, "XSDSimpleType stype = (XSDSimpleType)type;");
            for (n2 = 0; n2 < 13; ++n2) {
                if (xSDConstrainingFacetArray[n2] == null) continue;
                if (XSDSimpleType.sFacets[n2].equals("enumeration")) {
                    vector = xSDConstrainingFacetArray[n2].getLexicalEnumeration();
                    for (n = 0; n < vector.size(); ++n) {
                        string2 = (String)vector.elementAt(n);
                        CGUtil.tabPrint(this.m_indent + 2, "stype.setFacet(" + CGUtil.quoteString(XSDSimpleType.sFacets[n2]) + "," + "\"" + string2 + "\");");
                    }
                    continue;
                }
                string2 = CGUtil.parseFacet(xSDConstrainingFacetArray[n2].getLexicalValue());
                CGUtil.tabPrint(this.m_indent + 2, "stype.setFacet(" + CGUtil.quoteString(XSDSimpleType.sFacets[n2]) + "," + "\"" + string2 + "\");");
            }
            CGUtil.tabPrint(this.m_indent + 2, "stype.validateValue(value);");
            CGUtil.tabPrint(this.m_indent + 2, "super.setNodeValue(value);");
            CGUtil.tabPrint(this.m_indent + 1, "}");
            CGUtil.tabPrint(this.m_indent + 1, "catch (Exception e)");
            CGUtil.tabPrint(this.m_indent + 1, "{");
            CGUtil.tabPrint(this.m_indent + 2, "throw new InvalidContentException(" + CGUtil.quoteString("Error: Invalid value.") + ");");
            CGUtil.tabPrint(this.m_indent + 1, "}");
            CGUtil.tabPrint(this.m_indent, "}");
            CGUtil.tabPrint();
        } else if (xSDNode instanceof XSDComplexType) {
            String string4 = ((XSDComplexType)xSDNode).getRefLocalname();
            if (string4 != null && (this.isDerivedDataType(string4) || this.isJavaDataType(string4))) {
                CGUtil.tabPrint(this.m_indent, "public " + CGUtil.getInnerClassName(string) + "(String value)");
                CGUtil.tabPrint(this.m_indent + 2, "throws InvalidContentException ");
                CGUtil.tabPrint(this.m_indent, "{");
                CGUtil.tabPrint(this.m_indent + 1, "try");
                CGUtil.tabPrint(this.m_indent + 1, "{");
                CGUtil.tabPrint(this.m_indent + 2, "super.setNodeValue(value);");
                CGUtil.tabPrint(this.m_indent + 1, "}");
                CGUtil.tabPrint(this.m_indent + 1, "catch (Exception e)");
                CGUtil.tabPrint(this.m_indent + 1, "{");
                CGUtil.tabPrint(this.m_indent + 2, "throw new InvalidContentException(" + CGUtil.quoteString("Error: Invalid value.") + ");");
                CGUtil.tabPrint(this.m_indent + 1, "}");
                CGUtil.tabPrint(this.m_indent, "}");
                CGUtil.tabPrint();
            }
        } else {
            String string5 = CGUtil.getInnerClassName(string);
            if (this.m_bComments) {
                CGUtil.tabPrint(this.m_indent, "/**");
                CGUtil.tabPrint(this.m_indent, " * Default constructor");
                CGUtil.tabPrint(this.m_indent, " */");
            }
            CGUtil.tabPrint(this.m_indent, "public " + string5 + "()");
            CGUtil.tabPrint(this.m_indent, "{");
            CGUtil.tabPrint(this.m_indent + 1, "super();");
            CGUtil.tabPrint(this.m_indent, "}");
            CGUtil.tabPrint();
        }
    }

    private boolean isDerivedDataType(String string) {
        return string.equals("decimal") || string.equals("time") || string.equals("date") || string.equals("QName") || string.equals("normalizedString") || string.equals("token") || string.equals("language") || string.equals("Name") || string.equals("NCName") || string.equals("NMTOKEN") || string.equals("NMTOKENS") || string.equals("ID") || string.equals("IDREF") || string.equals("IDREFS") || string.equals("ENTITY") || string.equals("ENTITIES") || string.equals("nonPositiveInteger") || string.equals("nonNegativeInteger") || string.equals("unsignedLong") || string.equals("unsignedInt") || string.equals("unsignedShort") || string.equals("unsignedByte") || string.equals("positiveInteger") || string.equals("negativeInteger") || string.equals("duration") || string.equals("dateTime") || string.equals("gMonth") || string.equals("gYear") || string.equals("hexBinary") || string.equals("anyURI");
    }

    private String getDataType(String string) {
        if (string.equals("string")) {
            return "String";
        }
        if (string.equals("byte") || string.equals("unsignedByte")) {
            return "Byte";
        }
        if (string.equals("boolean")) {
            return "Boolean";
        }
        if (string.equals("double") || string.equals("decimal")) {
            return "Double";
        }
        if (string.equals("float")) {
            return "Float";
        }
        if (string.equals("int") || string.equals("integer") || string.equals("nonPositiveInteger") || string.equals("positiveInteger") || string.equals("nonNegativeInteger") || string.equals("negativeInteger") || string.equals("unsignedInt")) {
            return "Integer";
        }
        if (string.equals("long") || string.equals("unsignedLong")) {
            return "Long";
        }
        if (string.equals("short") || string.equals("unsignedShort")) {
            return "Short";
        }
        if (string.equals("time") || string.equals("date") || string.equals("QName") || string.equals("normalizedString") || string.equals("token") || string.equals("language") || string.equals("Name") || string.equals("NCName") || string.equals("NMTOKEN") || string.equals("NMTOKENS") || string.equals("ID") || string.equals("IDREF") || string.equals("IDREFS") || string.equals("ENTITY") || string.equals("ENTITIES") || string.equals("duration") || string.equals("dateTime") || string.equals("anyURI") || string.equals("gMonth") || string.equals("gYear") || string.equals("hexBinary") || string.equals("anyURI")) {
            return "String";
        }
        return string;
    }

    private boolean isJavaDataType(String string) {
        return string.equals("byte") || string.equals("boolean") || string.equals("double") || string.equals("float") || string.equals("integer") || string.equals("int") || string.equals("long") || string.equals("short") || string.equals("string");
    }
}

