/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.classgen;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import oracle.xml.classgen.DTDClassGenerator;
import oracle.xml.classgen.SchemaClassGenerator;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;

public class oracg {
    boolean comments = false;
    boolean serialize = false;
    boolean dtdRoot = false;
    Vector packageName = new Vector();
    String outputDir = ".";
    String rootName = null;
    String fileName = null;
    int schemaType = -1;
    int DTDTYPE = 1;
    int SCHEMATYPE = 2;
    private OutputStream errors = System.err;
    private static final String newline = System.getProperty("line.separator");
    private static final String usageMessage = "Usage: oracg [-option] <filename>" + newline + "where options include:" + newline + "   -help                    Print the help message text" + newline + "   -version                 Print the release version" + newline + "   -dtd [-root <rootName>] <DTD File>" + newline + "                            The input file is a DTD file or DTD based XML file" + newline + "   -schema <Schema File>    The input file is an XML Schema file" + newline + "   -outputDir <Output Dir>  The directory name where the java classes" + " are generated" + newline + "   -package <Package Names> List of package name(s) of the generated" + newline + "                            java classes separted by spaces" + newline + "   -comment                 Generate comments for the java classes" + newline;

    public static void main(String[] stringArray) {
        oracg oracg2 = new oracg();
        oracg2.process(stringArray);
        oracg2.generate();
    }

    private void process(String[] stringArray) {
        int n = stringArray.length;
        boolean bl = false;
        if (n == 0) {
            this.printUsage("");
            System.exit(0);
        }
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("-help")) {
                this.printUsage("");
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-version")) {
                DOMParser dOMParser = new DOMParser();
                String string = dOMParser.getReleaseVersion();
                System.out.println("Release version: " + string);
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-dtd")) {
                if (this.schemaType == -1) {
                    this.schemaType = this.DTDTYPE;
                } else {
                    this.printUsage("\nError: Can not have both -dtd and -schema options set.");
                    System.exit(1);
                }
                if (stringArray[i + 1].equals("-root")) {
                    ++i;
                    this.dtdRoot = true;
                    this.rootName = stringArray[++i];
                }
                this.fileName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-schema")) {
                if (this.schemaType == -1) {
                    this.schemaType = this.SCHEMATYPE;
                } else {
                    this.printUsage("\nError: Can not have both -dtd and -schema options set.");
                    System.exit(1);
                }
                this.fileName = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-comment")) {
                this.comments = true;
                continue;
            }
            if (stringArray[i].equals("-serialize")) {
                this.serialize = true;
                continue;
            }
            if (stringArray[i].equals("-outputDir")) {
                this.outputDir = stringArray[++i];
                continue;
            }
            if (!stringArray[i].equals("-package")) continue;
            ++i;
            while (i < n && stringArray[i].charAt(0) != '-') {
                this.packageName.addElement(stringArray[i]);
                ++i;
            }
        }
    }

    private void generate() {
        DTD dTD = null;
        Object var3_2 = null;
        if (this.schemaType == this.DTDTYPE) {
            try {
                Object object;
                DOMParser dOMParser = new DOMParser();
                if (this.dtdRoot) {
                    dOMParser.parseDTD(this.fileToURL(this.fileName), this.rootName);
                    dTD = dOMParser.getDoctype();
                } else {
                    dOMParser.parse(this.fileToURL(this.fileName));
                    object = dOMParser.getDocument();
                    dTD = (DTD)object.getDoctype();
                    this.rootName = object.getDocumentElement().getTagName();
                }
                object = new DTDClassGenerator();
                ((DTDClassGenerator)object).setGenerateComments(this.comments);
                ((DTDClassGenerator)object).setSerializationMode(this.serialize);
                ((DTDClassGenerator)object).setOutputDirectory(this.outputDir);
                ((DTDClassGenerator)object).setValidationMode(true);
                ((DTDClassGenerator)object).generate(dTD, this.rootName);
            }
            catch (Exception exception) {
                System.out.println("\nError: DTD Class Generator failed to generate classes.  " + exception.toString());
            }
        } else if (this.schemaType == this.SCHEMATYPE) {
            try {
                XSDBuilder xSDBuilder = new XSDBuilder();
                XMLSchema xMLSchema = xSDBuilder.build(this.fileToURL(this.fileName));
                SchemaClassGenerator schemaClassGenerator = new SchemaClassGenerator(this.fileName);
                schemaClassGenerator.setGenerateComments(this.comments);
                if (this.serialize) {
                    System.out.println("\nSerialization is not yet supported in Schema Class Generator.");
                }
                schemaClassGenerator.setOutputDirectory(this.outputDir);
                schemaClassGenerator.setJavaPackage(xMLSchema, this.packageName);
                schemaClassGenerator.generate(xMLSchema);
            }
            catch (Exception exception) {
                System.out.println("\nError: Schema Class Generator failed  to generate classes. " + exception.toString());
            }
        } else {
            this.printUsage("\nError: DTD or Schema file is required as input for the  XML Class Generator to generate classes.");
            System.exit(1);
        }
    }

    private URL fileToURL(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        String string3 = System.getProperty("file.separator");
        if (string3 != null && string3.length() == 1) {
            string2 = string2.replace(string3.charAt(0), '/');
        }
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        try {
            return new URL("file", null, string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("unexpected MalformedURLException");
        }
    }

    private void printUsage(String string) {
        System.out.println(string + newline + newline + usageMessage);
    }
}

