/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import com.timesten.jdbc.JdbcOdbcBoundCol;
import com.timesten.jdbc.JdbcOdbcObject;
import com.timesten.jdbc.JdbcOdbcPreparedStatement;
import com.timesten.jdbc.JdbcOdbcSQLWarning;
import com.timesten.jdbc.JdbcOdbcStatement;
import com.timesten.jdbc.Logger;
import com.timesten.jdbc.ObservableConnection;
import com.timesten.jdbc.RetVal;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Date;

public abstract class JdbcOdbc
extends JdbcOdbcObject {
    private ObservableConnection myObserver = null;
    private boolean isBadConn = false;
    protected String charSet;
    protected static final String myMajorVersion = "6";
    protected static final String myMinorVersion = "0";
    protected static final String myPatchVersion = "4";
    protected static final String myVersion;

    void setObserver(ObservableConnection observableConnection) {
        this.myObserver = observableConnection;
    }

    ObservableConnection getObserver() {
        return this.myObserver;
    }

    boolean isConnBad() {
        return this.isBadConn;
    }

    public int SQLAllocEnv() throws SQLException {
        int n = 0;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocEnv()");
        }
        byte[] byArray = new byte[1];
        n = this.allocEnv(byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], n, 0, 0);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocEnv(): Returning hEnv=" + n);
        }
        return n;
    }

    public int SQLAllocConnect(int n) throws SQLException {
        int n2 = 0;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocConnect(" + n + ")");
        }
        byte[] byArray = new byte[1];
        n2 = this.allocConnect(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], n, n2, 0);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocConnect(" + n + ") : Returning hDbc=" + n2);
        }
        return n2;
    }

    public int SQLAllocStmt(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocStmt(" + n + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.allocStmt(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, n2);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocStmt(" + n + "): Returning hStmt=" + n2);
        }
        return n2;
    }

    public void SQLBindInParameterAtExec(int n, int n2, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, int[] nArray) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.*SQLBindInParameterAtExec(" + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ")");
        }
        byte[] byArray3 = new byte[1];
        this.bindInParameterAtExec(n, n2, n3, n4, n5, byArray, byArray2, byArray3, nArray);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0, 0, n2);
        }
    }

    public void SQLBindOutParameterString(int n, int n2, int n3, int n4, byte[] byArray, byte[] byArray2, int[] nArray) throws SQLException {
        short s;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.*SQLBindOutParameterString(" + n + ", " + n2 + ", " + n3 + ", " + (byArray.length - 1) + ", " + n4 + ")");
        }
        if ((s = this.bindOutParameterString(n, n2, n3, n4, byArray, byArray2, nArray)) != 0) {
            this.standardError(s, 0, 0, n);
        }
    }

    public String SQLBrowseConnect(int n, String string) throws SQLException, SQLWarning {
        String string2 = null;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLBrowseConnect(" + n + "," + string + ")");
        }
        byte[] byArray = new byte[2000];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        short s = this.browseConnect(n, byArray2, byArray);
        if (s == 99) {
            string2 = new String(byArray);
            string2 = string2.trim();
            s = 0;
        }
        if (s != 0) {
            this.standardError(s, 0, n, 0);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLBrowseConnect(" + n + "): Returning attributes=" + string2);
        }
        return string2;
    }

    public void SQLCancel(int n) throws SQLException, SQLWarning {
        short s;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLCancel(" + n + ")");
        }
        if ((s = this.cancel(n)) != 0) {
            this.standardError(s, 0, 0, n);
        }
    }

    public int SQLColAttributes(int n, int n2, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLColAttributes(" + n + ", " + n2 + ", " + n3);
        }
        byte[] byArray = new byte[1];
        int n4 = this.colAttributes(n, n2, n3, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n4);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLColAttributes(" + n + "): Returning via Warning, value = " + n4);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLColAttributes(" + n + "): Returning value = " + n4);
        }
        return n4;
    }

    public String SQLColAttributesString(int n, int n2, int n3) throws SQLException, JdbcOdbcSQLWarning {
        String string;
        byte[] byArray;
        short s;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLColAttributesString(" + n + ", " + n2 + ", " + n3);
        }
        if ((s = this.colAttributesString(n, n2, n3, byArray = new byte[300])) != 0) {
            try {
                this.standardError(s, 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string2;
                try {
                    string2 = JdbcOdbc.BytesToChars(this.charSet, byArray).trim();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.log(unsupportedEncodingException);
                    string2 = "";
                }
                jdbcOdbcSQLWarning.value = string2;
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLColAttributesString(" + n + "): Returning via Warning, value = " + string2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        try {
            string = JdbcOdbc.BytesToChars(this.charSet, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
            string = "";
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLColAttributesString(" + n + "): Returning value = " + string.trim());
        }
        return string.trim();
    }

    public void SQLColumns(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLColumns(" + n + ", " + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray4 = JdbcOdbc.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray5 = new byte[1];
        this.columns(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4, string4 == null, byArray5);
        if (byArray5[0] != 0) {
            this.standardError(byArray5[0], 0, 0, n);
        }
    }

    public void SQLColumnPrivileges(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("(SQLColumnPrivileges(" + n + ", " + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray4 = JdbcOdbc.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray5 = new byte[1];
        this.columnPrivileges(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4, string4 == null, byArray5);
        if (byArray5[0] != 0) {
            this.standardError(byArray5[0], 0, 0, n);
        }
    }

    public int SQLDescribeParamType(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamType(" + n + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 1, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamType(" + n + ", " + n2 + "): Returning type=" + n3);
        }
        return n3;
    }

    public int SQLDescribeParamPrecision(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamPrecision(" + n + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamPrecision(" + n + ", " + n2 + "): Returning precision=" + n3);
        }
        return n3;
    }

    public int SQLDescribeParamScale(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamScale(" + n + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        int n3 = this.describeParam(n, n2, 3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamScale(" + n + ", " + n2 + "): Returning scale=" + n3);
        }
        return n3;
    }

    public int SQLDescribeParamNullable(int n, int n2) throws SQLException, JdbcOdbcSQLWarning {
        int n3;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamNullable(" + n + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        int n4 = this.describeParam(n, n2, 4, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        int n5 = n4 == 0 ? 0 : (n3 = n4 == 1 ? 1 : 2);
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDescribeParamNullable(" + n + ", " + n2 + "): Returning nullable=" + n3);
        }
        return n3;
    }

    public void SQLDisconnect(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLDisconnect(" + n + ")");
        }
        byte[] byArray = new byte[1];
        this.disconnect(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public void SQLDriverConnect(int n, String string) throws SQLException, SQLWarning {
        block8: {
            if (Logger.isTracingOn()) {
                Logger.logln("*JdbcOdbc.SQLDriverConnect(" + n + ", " + string + ")");
            }
            byte[] byArray = null;
            char[] cArray = null;
            if (string != null) {
                cArray = string.toCharArray();
            }
            try {
                if (string != null) {
                    byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.log(unsupportedEncodingException);
            }
            byte[] byArray2 = new byte[1];
            this.driverConnect(n, byArray, byArray2);
            if (byArray2[0] != 0) {
                try {
                    this.standardError(byArray2[0], 0, n, 0);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) break block8;
                    throw jdbcOdbcSQLWarning;
                }
            }
        }
    }

    public void SQLExecDirect(int n, String string) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLExecDirect(" + n + ", " + string + ")");
        }
        Object var3_3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        byte[] byArray = new byte[2];
        short s = this.execDirect(n, cArray);
        byArray[1] = (byte)(s >> 8);
        byArray[0] = (byte)(s & 0xFF);
        if (byArray[1] == -99) {
            String string2 = "Memory allocation Failure";
            String string3 = "S1001";
            throw new SQLException(string2, string3);
        }
        if (byArray[1] == -98) {
            String string4 = "Can not convert from unicode character to ascii character";
            String string5 = "S1001";
            throw new SQLException(string4, string5);
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public boolean SQLExecute(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLExecute(" + n + ")");
        }
        short s = this.execute(n);
        boolean bl = false;
        if (s == 99) {
            bl = true;
            s = 0;
        }
        if (s != 0) {
            try {
                this.standardError(s, 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Boolean(bl);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLExecute(" + n + "): Returning needData=" + bl);
        }
        return bl;
    }

    public boolean SQLFetch(int n, byte[] byArray, int n2, JdbcOdbcBoundCol[] jdbcOdbcBoundColArray, int n3) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLFetch(" + n + ")");
        }
        byArray[1] = 0;
        byArray[0] = (byte)this.fetch(n, n2, jdbcOdbcBoundColArray, n3);
        boolean bl = true;
        if (byArray[0] != 0) {
            if (byArray[0] == 100) {
                bl = false;
                byArray[0] = 0;
            } else {
                this.standardError(byArray[0], 0, 0, n, true);
                byArray[1] = -94;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLFetch(" + n + "): Returning hasRow=" + bl);
        }
        return bl;
    }

    public void SQLForeignKeys(int n, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLForeignKeys(" + n + ", " + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        byte[] byArray6 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        char[] cArray5 = null;
        char[] cArray6 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        if (string5 != null) {
            cArray5 = string5.toCharArray();
        }
        if (string6 != null) {
            cArray6 = string6.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray4 = JdbcOdbc.CharsToBytes(this.charSet, cArray4);
            }
            if (string5 != null) {
                byArray5 = JdbcOdbc.CharsToBytes(this.charSet, cArray5);
            }
            if (string6 != null) {
                byArray6 = JdbcOdbc.CharsToBytes(this.charSet, cArray6);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray7 = new byte[1];
        this.foreignKeys(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4, string4 == null, byArray5, string5 == null, byArray6, string6 == null, byArray7);
        if (byArray7[0] != 0) {
            this.standardError(byArray7[0], 0, 0, n);
        }
    }

    public void SQLFreeConnect(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLFreeConnect(" + n + ")");
        }
        byte[] byArray = new byte[1];
        this.freeConnect(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public void SQLFreeEnv(int n) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLFreeEnv(" + n + ")");
        }
        byte[] byArray = new byte[1];
        this.freeEnv(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], n, 0, 0);
        }
    }

    public void SQLFreeStmt(int n, int n2) throws SQLException {
        short s;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLFreeStmt(" + n + ", " + n2 + ")");
        }
        if ((s = this.freeStmt(n, n2)) != 0) {
            this.standardError(s, 0, 0, n);
        }
    }

    public int SQLGetConnectOption(int n, short s) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetConnectOption(" + n + ", " + s + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.getConnectOption(n, s, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, n, 0);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Integer(n2);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetConnectOption(" + n + "): Returning vParam=" + n2);
        }
        return n2;
    }

    public String SQLGetConnectOptionString(int n, short s) throws SQLException {
        String string;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetConnectOptionString(" + n + ", " + s + ")");
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.getConnectOptionString(n, s, byArray2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        try {
            string = JdbcOdbc.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "";
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetConnectOptionString(" + n + "): Returning svalue = " + string.trim());
        }
        return string.trim();
    }

    public String SQLGetCursorName(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetCursorName(" + n + ")");
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[300];
        this.getCursorName(n, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                String string;
                try {
                    string = JdbcOdbc.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Logger.log(unsupportedEncodingException);
                    string = "";
                }
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetCursorName(" + n + "): Returning via Warning, svalue = " + string.trim());
                }
                jdbcOdbcSQLWarning.value = string.trim();
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = new String(byArray2);
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetCursorName(" + n + "): Returning svalue = " + string.trim());
        }
        return string.trim();
    }

    public int SQLGetDataBinary(int n, int n2, int n3, byte[] byArray, byte[] byArray2) throws SQLException, JdbcOdbcSQLWarning {
        return this.SQLGetDataBinary(n, n2, n3, -2, byArray, byArray.length, byArray2);
    }

    public int SQLGetDataBinary(int n, int n2, int n3, int n4, byte[] byArray, int n5, byte[] byArray2) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataBinary(" + n + ", " + n3 + ", " + n4 + ", " + n5 + ")");
        }
        int n6 = this.getDataBinary(n, n2, n3, n4, byArray, n5, byArray2);
        if (byArray2[1] == -99) {
            String string = "Memory allocation Failure";
            String string2 = "S1001";
            throw new SQLException(string, string2);
        }
        boolean bl = false;
        if (n5 < n6 || n4 == -8 && n5 <= n6) {
            bl = true;
        }
        if (!(byArray2[0] == 0 || byArray2[0] == 1 && bl)) {
            try {
                this.standardError(byArray2[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataBinary(" + n + "): Returning via Warning, bytesAvailable=" + n6);
                }
                jdbcOdbcSQLWarning.value = new Integer(n6);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataBinary(" + n + "): Returning bytesAvailable=" + n6);
        }
        return n6;
    }

    public int SQLGetDataStream(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6, byte[] byArray2) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataStream(" + n + ", " + n3 + ", " + n4 + ", " + n5 + ")");
        }
        int n7 = this.getDataStream(n, n2, n3, n4, byArray, n5, n6, byArray2);
        if (byArray2[1] == -99) {
            String string = "Memory allocation Failure";
            String string2 = "S1001";
            throw new SQLException(string, string2);
        }
        if (byArray2[0] != 0) {
            try {
                this.standardError(byArray2[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataStream(" + n + "): Returning via Warning, bytesAvailable=" + n7);
                }
                jdbcOdbcSQLWarning.value = new Integer(n7);
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataStream(" + n + "): Returning bytesAvailable=" + n7);
        }
        return n7;
    }

    public double SQLGetDataDouble(int n, int n2, int n3, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataDouble(" + n + ", " + n3 + ")");
        }
        double d = this.getDataDouble(n, n2, n3, byArray);
        if (byArray[1] == -1) {
            d = 0.0;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Double(d);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataDouble(" + n + "): Returning via Warning, value = " + d);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataDouble(" + n + "): Returning value = " + d);
        }
        return d;
    }

    public long SQLGetDataLong(int n, int n2, int n3, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataLong(" + n + ", " + n3 + ")");
        }
        long l = this.getDataLong(n, n2, n3, byArray);
        if (byArray[1] == -1) {
            l = 0L;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Long(l);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataLong(" + n + "): Returning via Warning, value = " + l);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataLong(" + n + "): Returning value = " + l);
        }
        return l;
    }

    public float SQLGetDataFloat(int n, int n2, int n3, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataFloat(" + n + ", " + n3 + ")");
        }
        float f = this.getDataFloat(n, n2, n3, byArray);
        if (byArray[1] == -1) {
            f = 0.0f;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Float(f);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataFloat(" + n + "): Returning via Warning, value = " + f);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataFloat(" + n + "): Returning value = " + f);
        }
        return f;
    }

    public short SQLGetDataShort(int n, int n2, int n3, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataShort(" + n + ", " + n3 + ")");
        }
        short s = this.getDataShort(n, n2, n3, byArray);
        if (byArray[1] == -1) {
            s = 0;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Short(s);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataShort(" + n + "): Returning via Warning, value = " + s);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataShort(" + n + "): Returning value = " + s);
        }
        return s;
    }

    public int SQLGetDataInteger(int n, int n2, int n3, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataInteger(" + n + ", " + n3 + ")");
        }
        int n4 = this.getDataInteger(n, n2, n3, byArray);
        if (byArray[1] == -1) {
            n4 = 0;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Integer(n4);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetDataInteger(" + n + "): Returning via Warning, value = " + n4);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataInteger(" + n + "): Returning value = " + n4);
        }
        return n4;
    }

    public int SQLGetDataString(int n, int n2, char[] cArray, byte[] byArray, int n3, int n4, int n5) throws SQLException, JdbcOdbcSQLWarning {
        int n6;
        int n7;
        block14: {
            if (Logger.isTracingOn()) {
                Logger.logln("*JdbcOdbc.SQLGetDataString(" + n + ", " + n3 + ", " + n4 + ")");
            }
            n7 = this.getDataString(n, n2, n3, cArray, byArray, n5);
            if (byArray[1] == -97) {
                String string = "JDBC Internal Error: Column size inconsistency";
                String string2 = "S1000";
                throw new SQLException(string, string2);
            }
            if (byArray[1] == -99) {
                String string = "Memory allocation Failure";
                String string3 = "S1001";
                throw new SQLException(string, string3);
            }
            n6 = n7;
            if (n7 > n4 || n7 == -4) {
                n6 = n4;
            }
            if (byArray[0] != 0) {
                try {
                    this.standardError(byArray[0], 0, 0, n);
                }
                catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                    if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) break block14;
                    if (n7 == -1) {
                        if (Logger.isTracingOn()) {
                            Logger.logln("*JdbcOdbc.SQLGetDataString(" + n + "): Returning via Warning, string = null");
                        }
                        jdbcOdbcSQLWarning.value = null;
                    } else {
                        String string = new String(cArray, 0, n6);
                        if (Logger.isTracingOn()) {
                            Logger.logln("*JdbcOdbc.SQLGetDataString(" + n + "): Returning via Warning, string = " + string.trim());
                        }
                        jdbcOdbcSQLWarning.value = string;
                    }
                    throw jdbcOdbcSQLWarning;
                }
            }
        }
        if (Logger.isTracingOn()) {
            if (n7 == -1) {
                Logger.logln("*JdbcOdbc.SQLGetDataString(" + n + "): Returning string = null");
            } else {
                String string = new String(cArray, 0, n6);
                Logger.logln("*JdbcOdbc.SQLGetDataString(" + n + "): Returning string = " + string.trim());
            }
        }
        return n7;
    }

    public void SQLGetDataDate(int n, int n2, int[] nArray, byte[] byArray, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataDate(" + n + ", " + n3 + ")");
        }
        this.getDataDate(n, n2, n3, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            if (byArray[1] == -1) {
                Logger.logln("*JdbcOdbc.SQLGetDataDate(" + n + "): Returning nothing");
            } else {
                Logger.logln("*JdbcOdbc.SQLGetDataDate(" + n + "): Returning " + nArray[0] + "-" + nArray[1] + "-" + nArray[2]);
            }
        }
    }

    public void SQLGetDataTime(int n, int n2, int[] nArray, byte[] byArray, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataTime(" + n + ", " + n3 + ")");
        }
        this.getDataTime(n, n2, n3, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            if (byArray[1] == -1) {
                Logger.logln("*JdbcOdbc.SQLGetDataTime(" + n + "): Returning nothing");
            } else {
                Logger.logln("*JdbcOdbc.SQLGetDataTime(" + n + "): Returning " + nArray[0] + ":" + nArray[1] + ":" + nArray[2]);
            }
        }
    }

    public void SQLGetDataTimestamp(int n, int n2, int[] nArray, byte[] byArray, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataTimestamp(" + n + ", " + n3 + ")");
        }
        this.getDataTimestamp(n, n2, n3, nArray, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            if (byArray[1] == -1) {
                Logger.logln("*JdbcOdbc.SQLGetDataTimestamp(" + n + "): Returning nothing");
            } else {
                Logger.logln("*JdbcOdbc.SQLGetDataTimestamp(" + n + "): Returning " + nArray[0] + "-" + nArray[1] + "-" + nArray[2] + " " + nArray[3] + ":" + nArray[4] + ":" + nArray[5] + "." + nArray[6]);
            }
        }
    }

    public long SQLGetDataTimestampRaw(int n, int n2, byte[] byArray, int n3) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetDataTimestampRaw(" + n + ", " + n3 + ")");
        }
        long l = this.getDataTimestampRaw(n, n2, byArray, n3);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            if (byArray[1] == -1) {
                Logger.logln("*JdbcOdbc.SQLGetDataTimestampRaw(" + n + "): Returning nothing");
            } else {
                Logger.logln("*JdbcOdbc.SQLGetDataTimestampRaw(" + n + "): Returning " + l);
            }
        }
        return l;
    }

    public int SQLGetInfo(int n, short s) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfo(" + n + ", " + s + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.getInfo(n, s, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, n, 0);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Integer(n2);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetInfo(" + n + "): Returning via Warning, infovalue = " + n2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfo(" + n + "): Returning infovalue = " + n2);
        }
        return n2;
    }

    public int SQLGetInfoShort(int n, short s) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfoShort(" + n + ", " + s + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.getInfoShort(n, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfoShort(" + n + "): Returning infovalue = " + n2);
        }
        return n2;
    }

    public String SQLGetInfoString(int n, short s) throws SQLException {
        return this.SQLGetInfoString(n, s, 300);
    }

    public String SQLGetInfoString(int n, short s, int n2) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfoString(" + n + ", " + s + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[n2];
        this.getInfoString(n, s, byArray2, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, n, 0);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                try {
                    jdbcOdbcSQLWarning.value = JdbcOdbc.BytesToChars(this.charSet, byArray2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    jdbcOdbcSQLWarning.value = "";
                }
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetInfoString(" + n + "): Returning via Warning, svalue = " + ((String)jdbcOdbcSQLWarning.value).trim());
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        String string = null;
        try {
            string = JdbcOdbc.BytesToChars(this.charSet, byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string == null) {
            string = "";
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfoString(" + n + "): Returning svalue = " + string.trim());
        }
        return string.trim();
    }

    public int SQLGetStmtOption(int n, short s) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetStmtOption(" + n + ", " + s + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.getStmtOption(n, s, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLGetStmtOption(" + n + ") Returning via Warning, value = " + n2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetStmtOption(" + n + ") Returning value = " + n2);
        }
        return n2;
    }

    public void SQLGetTypeInfo(int n, short s) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetTypeInfo(" + n + ", " + s + ")");
        }
        byte[] byArray = new byte[1];
        this.getTypeInfo(n, s, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public boolean SQLMoreResults(int n) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLMoreResults(" + n + ")");
        }
        byte[] byArray = new byte[1];
        this.moreResults(n, byArray);
        boolean bl = true;
        if (byArray[0] == 100) {
            bl = false;
            byArray[0] = 0;
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLMoreResults(" + n + "): Returning " + bl);
        }
        return bl;
    }

    public String SQLNativeSql(int n, String string) throws SQLException {
        String string2;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLNativeSql(" + n + ", " + string + ")");
        }
        int n2 = 1024;
        if (string.length() * 4 > n2 && (n2 = string.length() * 4) > 32768) {
            n2 = 32768;
        }
        byte[] byArray = new byte[n2];
        byte[] byArray2 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string != null) {
            try {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        byte[] byArray3 = new byte[1];
        this.nativeSql(n, byArray2, byArray, byArray3);
        if (byArray3[0] != 0) {
            this.standardError(byArray3[0], 0, n, 0);
        }
        try {
            string2 = JdbcOdbc.BytesToChars(this.charSet, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = "";
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLNativeSql(" + n + "): Returning sValue = " + string2.trim());
        }
        return string2.trim();
    }

    public int SQLNumParams(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLNumParams(" + n + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.numParams(n, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLNumParams(" + n + ") Returning: numParams = " + n2);
        }
        return n2;
    }

    public int SQLNumResultCols(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLNumResultCols(" + n + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.numResultCols(n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                if (Logger.isTracingOn()) {
                    Logger.logln("value = " + n2);
                }
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLNumResultCols(hStmt=" + n + "): Returning via Warning, numCols = " + n2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLNumResultCols(hStmt=" + n + "): Returning numCols = " + n2);
        }
        return n2;
    }

    public int SQLParamData(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLParamData(" + n + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.paramData(n, byArray);
        if (byArray[0] == 99) {
            byArray[0] = 0;
        } else {
            n2 = -1;
        }
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Integer(n2);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLParamData(" + n + ") Returning via Warning, param = " + n2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLParamData(" + n + ") Returning param = " + n2);
        }
        return n2;
    }

    public void SQLPrepare(int n, String string) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLPrepare(" + n + ", " + string + ")");
        }
        Object var3_3 = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        byte[] byArray = new byte[2];
        this.prepare(n, cArray, byArray);
        if (byArray[1] == -99) {
            String string2 = "Memory allocation Failure";
            String string3 = "S1001";
            throw new SQLException(string2, string3);
        }
        if (byArray[1] == -98) {
            String string4 = "Can not convert from unicode character to ascii character";
            String string5 = "S1001";
            throw new SQLException(string4, string5);
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public void SQLPutData(int n, byte[] byArray, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLPutData(" + n + ", " + n2 + ")");
        }
        byte[] byArray2 = new byte[1];
        this.putData(n, byArray, n2, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public void SQLPrimaryKeys(int n, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLPrimaryKeys(" + n + ", " + string + ", " + string2 + ", " + string3 + ")");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray4 = new byte[1];
        this.primaryKeys(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0, 0, n);
        }
    }

    public void SQLProcedures(int n, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLProcedures(" + n + ", " + string + ", " + string2 + ", " + string3 + ")");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray4 = new byte[1];
        this.procedures(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0, 0, n);
        }
    }

    public void SQLProcedureColumns(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLProcedureColumns(" + n + ", " + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray4 = JdbcOdbc.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray5 = new byte[1];
        this.procedureColumns(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4, string4 == null, byArray5);
        if (byArray5[0] != 0) {
            this.standardError(byArray5[0], 0, 0, n);
        }
    }

    public int SQLRowCount(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLRowCount(" + n + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.rowCount(n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, 0, n);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = BigDecimal.valueOf(n2);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.SQLRowCount(" + n + "): Returning via Warning, " + n2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLRowCount(hStmt=" + n + "): Returning " + n2);
        }
        return n2;
    }

    public void SQLSetConnectOption(int n, short s, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLSetConnectOption(" + n + ", " + s + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        this.setConnectOption(n, s, n2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, n, 0);
        }
    }

    public void SQLSetConnectOption(int n, short s, String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLSetConnectOption(" + n + ", " + s + ", " + string + ")");
        }
        byte[] byArray = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray2 = new byte[1];
        this.setConnectOptionString(n, s, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, n, 0);
        }
    }

    public void SQLSetCursorName(int n, String string) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLSetCursorName(" + n + ", " + string + ")");
        }
        byte[] byArray = null;
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray2 = new byte[1];
        this.setCursorName(n, byArray, byArray2);
        if (byArray2[0] != 0) {
            this.standardError(byArray2[0], 0, 0, n);
        }
    }

    public void SQLSetStmtOption(int n, short s, int n2) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLSetStmtOption(" + n + ", " + s + ", " + n2 + ")");
        }
        byte[] byArray = new byte[1];
        this.setStmtOption(n, s, n2, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public void SQLSpecialColumns(int n, short s, String string, String string2, String string3, int n2, boolean bl) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLSpecialColumns(" + n + ", " + s + ", " + string + ", " + string2 + ", " + string3 + ", " + n2 + ", " + bl);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        byte[] byArray4 = new byte[1];
        this.specialColumns(n, s, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, n2, bl, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0, 0, n);
        }
    }

    public void SQLStatistics(int n, String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLStatistics(" + n + ", " + string + ", " + string2 + ", " + string3 + ", " + bl + ", " + bl2);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray4 = new byte[1];
        this.statistics(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, bl, bl2, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0, 0, n);
        }
    }

    public void SQLTables(int n, String string, String string2, String string3, String string4) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLTables(" + n + ", " + string + ", " + string2 + ", " + string3 + ", " + string4);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        char[] cArray4 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        if (string4 != null) {
            cArray4 = string4.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
            if (string4 != null) {
                byArray4 = JdbcOdbc.CharsToBytes(this.charSet, cArray4);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray5 = new byte[1];
        this.tables(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4, string4 == null, byArray5);
        if (byArray5[0] != 0) {
            this.standardError(byArray5[0], 0, 0, n);
        }
    }

    public void SQLTablePrivileges(int n, String string, String string2, String string3) throws SQLException, SQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLTables(" + n + ", " + string + ", " + string2 + ", " + string3);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        char[] cArray = null;
        char[] cArray2 = null;
        char[] cArray3 = null;
        if (string != null) {
            cArray = string.toCharArray();
        }
        if (string2 != null) {
            cArray2 = string2.toCharArray();
        }
        if (string3 != null) {
            cArray3 = string3.toCharArray();
        }
        try {
            if (string != null) {
                byArray = JdbcOdbc.CharsToBytes(this.charSet, cArray);
            }
            if (string2 != null) {
                byArray2 = JdbcOdbc.CharsToBytes(this.charSet, cArray2);
            }
            if (string3 != null) {
                byArray3 = JdbcOdbc.CharsToBytes(this.charSet, cArray3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.log(unsupportedEncodingException);
        }
        byte[] byArray4 = new byte[1];
        this.tablePrivileges(n, byArray, string == null, byArray2, string2 == null, byArray3, string3 == null, byArray4);
        if (byArray4[0] != 0) {
            this.standardError(byArray4[0], 0, 0, n);
        }
    }

    public void SQLTransact(int n, int n2, short s) throws SQLException {
        short s2;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLTransact(" + n + ", " + n2 + ", " + s + ")");
        }
        if ((s2 = this.transact(n, n2, s)) != 0) {
            this.standardError(s2, n, n2, 0);
        }
    }

    public static SQLWarning convertWarning(JdbcOdbcSQLWarning jdbcOdbcSQLWarning, int n, int n2, int n3) {
        SQLWarning sQLWarning = jdbcOdbcSQLWarning;
        if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) {
            DataTruncation dataTruncation = new DataTruncation(n, false, true, n2, n3);
            sQLWarning = dataTruncation;
        }
        return sQLWarning;
    }

    public static SQLWarning convertWarning(JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
        SQLWarning sQLWarning = jdbcOdbcSQLWarning;
        if (jdbcOdbcSQLWarning.getSQLState().equals("01004")) {
            DataTruncation dataTruncation = new DataTruncation(-1, false, true, 0, 0);
            sQLWarning = dataTruncation;
        }
        return sQLWarning;
    }

    public int SQLAllocAndBindCols(int n, int[] nArray, int[] nArray2, int[] nArray3, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLAllocAndBindCols(" + n + ")");
        }
        int n2 = this.allocAndBindAllCols(n, nArray, nArray2, nArray3, byArray, nArray.length);
        if (byArray[1] == -99) {
            String string = "Memory allocation Failure";
            String string2 = "S1001";
            throw new SQLException(string, string2);
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        return n2;
    }

    public void SQLJustRebindCols(int n, int n2, int n3, byte[] byArray) throws SQLException {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLJustRebindCols(" + n + ", " + n2 + ", " + n3 + ")");
        }
        this.justReBindAllCols(n, n2, n3, byArray);
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
    }

    public int SQLBindAllParams(int n, short[] sArray, int[] nArray, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLBindAllParams(" + n + ")");
        }
        int n2 = this.bindAllParams(n, sArray, nArray, byArray, sArray.length);
        if (byArray[1] == -99) {
            String string = "Memory allocation Failure";
            String string2 = "S1001";
            throw new SQLException(string, string2);
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        return n2;
    }

    public int SQLBindCol(int n, int n2, int n3, int n4, int n5, byte[] byArray) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLBindCol(" + n + ", " + n2 + ", " + n3 + ", " + n4 + ", " + n5 + ")");
        }
        int n6 = this.bindCol(n, n2, n3, n4, n5, byArray);
        if (byArray[1] == -97) {
            String string = "JDBC Internal Error: pBoundCols is null";
            String string2 = "S1000";
            throw new SQLException(string, string2);
        }
        if (byArray[1] == -99) {
            String string = "Memory allocation Failure";
            String string3 = "S1001";
            throw new SQLException(string, string3);
        }
        if (byArray[0] != 0) {
            this.standardError(byArray[0], 0, 0, n);
        }
        return n6;
    }

    public boolean isDataStoreValid(int n) throws SQLException, JdbcOdbcSQLWarning {
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.getDataStoreState(" + n + ")");
        }
        byte[] byArray = new byte[1];
        int n2 = this.getDataStoreState(n, byArray);
        if (byArray[0] != 0) {
            try {
                this.standardError(byArray[0], 0, n, 0);
            }
            catch (JdbcOdbcSQLWarning jdbcOdbcSQLWarning) {
                jdbcOdbcSQLWarning.value = new Integer(n2);
                if (Logger.isTracingOn()) {
                    Logger.logln("*JdbcOdbc.getDataStoreState(" + n + "): Returning via Warning, infovalue = " + n2);
                }
                throw jdbcOdbcSQLWarning;
            }
        }
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.SQLGetInfo(" + n + "): Returning infovalue = " + n2);
        }
        return n2 == 0;
    }

    protected void loadSharedLibrary(boolean bl) throws SQLException {
        String string = bl ? "ttJdbcCS" : "ttJdbc";
        try {
            String[] stringArray;
            String string2 = System.getProperty("os.name");
            Logger.logln("*JdbcOdbc.loadSharedLibrary: os.name " + string2);
            if (string2.startsWith("Windows") || string2.startsWith("windows")) {
                string = string + 60;
            }
            if (Logger.isTracingOn()) {
                stringArray = new Date();
                Logger.logln("*JdbcOdbc.loadSharedLibrary: Loading " + string + " " + stringArray.toString());
            }
            System.loadLibrary(string);
            Logger.logln("*JdbcOdbc.loadSharedLibrary: java.library.path " + System.getProperty("java.library.path"));
            Logger.logln("*JdbcOdbc.loadSharedLibrary: java.class.path " + System.getProperty("java.class.path"));
            stringArray = new String[]{this.getMajorVersion(), this.getMinorVersion(), this.getPatchVersion()};
            Logger.logln("*JdbcOdbc.loadSharedLibrary: Loading shared library version MAJOR " + stringArray[0] + " MINOR " + stringArray[1] + " PATCH " + stringArray[2]);
            if (!(myMajorVersion.equals(stringArray[0]) && myMinorVersion.equals(stringArray[1]) && myPatchVersion.equals(stringArray[2]))) {
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append("Specified driver could not be loaded, shared library version mismatch for [");
                stringBuffer.append(string);
                stringBuffer.append("].  Expected version=");
                stringBuffer.append(myVersion);
                stringBuffer.append("; loaded version=");
                stringBuffer.append(stringArray[0]);
                stringBuffer.append(".");
                stringBuffer.append(stringArray[1]);
                if (!stringArray[2].equals("")) {
                    stringBuffer.append(".");
                    stringBuffer.append(stringArray[2]);
                }
                throw new SQLException(stringBuffer.toString(), "IM003");
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Logger.logln("*JdbcOdbc.loadSharedLibrary: Unable to load, unsatisfied link error " + string + " library");
            throw new SQLException(unsatisfiedLinkError.getMessage());
        }
        catch (SecurityException securityException) {
            Logger.logln("*JdbcOdbc.loadSharedLibrary: Unable to load " + string + " library");
            throw new SQLException(securityException.getMessage());
        }
    }

    Object createSQLException(int n, int n2, int n3, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        SQLException sQLException = null;
        SQLException sQLException2 = null;
        if (Logger.isTracingOn()) {
            Logger.logln("*JdbcOdbc.createSQLException(" + n + ", " + n2 + ", " + n3 + ", " + bl + ", " + bl2 + ")");
        }
        while (true) {
            object2 = new byte[2];
            object = new byte[6];
            byte[] byArray = new byte[512];
            int n4 = this.error(n, n2, n3, (byte[])object, byArray, (byte[])object2);
            if (object2[0] != 0 && object2[0] != 1) break;
            String string = "";
            String string2 = "";
            try {
                string = JdbcOdbc.BytesToChars(this.charSet, byArray);
                string2 = JdbcOdbc.BytesToChars(this.charSet, object);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Logger.log(unsupportedEncodingException);
            }
            if (bl2 && n4 == 0 && (string2.equals("01004") || string2.equals("07006") || string2.equals("22003") || string2.equals("22005") || string2.equals("22008"))) {
                return null;
            }
            if (object2[1] == -95) {
                string = string + "...msg truncated";
            }
            SQLException sQLException3 = null;
            if (bl) {
                sQLException3 = new SQLException(string.trim(), string2.trim(), n4);
                if (Logger.isTracingOn()) {
                    SQLException sQLException4 = sQLException3;
                    Logger.logln("*JdbcOdbc.createSQLException:Reason = " + sQLException4.getMessage() + "; SQLstate = " + sQLException4.getSQLState() + "; VendorCode = " + sQLException4.getErrorCode());
                    Logger.log(sQLException4);
                }
                if (!this.isBadConn && JdbcOdbc.isConnectionBroken(sQLException3)) {
                    this.isBadConn = true;
                    if (this.myObserver != null) {
                        this.myObserver.notifyError(sQLException3);
                    }
                }
            } else {
                sQLException3 = new JdbcOdbcSQLWarning(string.trim(), string2.trim(), n4);
            }
            if (sQLException == null) {
                sQLException = sQLException3;
            } else if (bl) {
                ((SQLException)sQLException2).setNextException(sQLException3);
            } else {
                ((SQLWarning)sQLException2).setNextWarning((SQLWarning)sQLException3);
            }
            sQLException2 = sQLException3;
        }
        if (sQLException == null) {
            if (bl) {
                object2 = "General error";
                object = "S1000";
                sQLException = new SQLException((String)object2, (String)object);
            } else {
                object2 = "General warning";
                object = "S1000";
                sQLException = new JdbcOdbcSQLWarning((String)object2, (String)object);
            }
        }
        return sQLException;
    }

    void throwGenericSQLException() throws SQLException {
        String string = "General error";
        String string2 = "S1000";
        if (Logger.isTracingOn()) {
            Logger.logln("ERROR - " + string2 + " " + string);
        }
        throw new SQLException(string, string2);
    }

    public void standardError(short s, int n, int n2, int n3) throws SQLException, SQLWarning {
        this.standardError(s, n, n2, n3, false);
    }

    void standardError(short s, int n, int n2, int n3, boolean bl) throws SQLException, SQLWarning {
        Logger.logln("*JdbcOdbc.standardError(" + s + ", " + n + ", " + n2 + ", " + n3 + ")");
        switch (s) {
            case -1: {
                SQLException sQLException = (SQLException)this.createSQLException(n, n2, n3, true, bl);
                if (sQLException == null) break;
                throw sQLException;
            }
            case 1: {
                SQLWarning sQLWarning = (SQLWarning)this.createSQLException(n, n2, n3, false, bl);
                if (sQLWarning == null) break;
                throw sQLWarning;
            }
            case -2: {
                String string = "Invalid handle";
                throw new SQLException(string, "");
            }
            case 100: {
                String string = "No data found";
                throw new SQLException(string, "");
            }
            default: {
                this.throwGenericSQLException();
            }
        }
    }

    public native int bufferToInt(byte[] var1);

    public native boolean isLittleEndianPlatform();

    protected native int allocConnect(int var1, byte[] var2);

    protected native int allocEnv(byte[] var1);

    protected native int allocStmt(int var1, byte[] var2);

    protected native short cancel(int var1);

    protected native void bindInParameterAtExec(int var1, int var2, int var3, int var4, int var5, byte[] var6, byte[] var7, byte[] var8, int[] var9);

    protected native short bindOutParameterString(int var1, int var2, int var3, int var4, byte[] var5, byte[] var6, int[] var7);

    protected native short browseConnect(int var1, byte[] var2, byte[] var3);

    protected native int colAttributes(int var1, int var2, int var3, byte[] var4);

    protected native short colAttributesString(int var1, int var2, int var3, byte[] var4);

    protected native void columns(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, byte[] var10);

    protected native void columnPrivileges(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, byte[] var10);

    protected native int describeParam(int var1, int var2, int var3, byte[] var4);

    protected native void disconnect(int var1, byte[] var2);

    protected native void driverConnect(int var1, byte[] var2, byte[] var3);

    protected native int error(int var1, int var2, int var3, byte[] var4, byte[] var5, byte[] var6);

    protected native short execDirect(int var1, char[] var2);

    protected native short execute(int var1);

    protected native short execStatementBatch(int var1, JdbcOdbcStatement var2, String[] var3, int[] var4);

    protected native short execPreparedStatementBatch(int var1, JdbcOdbcPreparedStatement var2, int var3, short[] var4, int var5, int var6, short[] var7, Object[] var8, Object[] var9, int[] var10);

    protected native short rebindAllParams(int var1, int var2, short[] var3, int var4);

    protected native int fetch(int var1, int var2, JdbcOdbcBoundCol[] var3, int var4);

    protected native void foreignKeys(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, byte[] var10, boolean var11, byte[] var12, boolean var13, byte[] var14);

    protected native void freeConnect(int var1, byte[] var2);

    protected native void freeEnv(int var1, byte[] var2);

    protected native short freeStmt(int var1, int var2);

    protected native int getConnectOption(int var1, short var2, byte[] var3);

    protected native void getConnectOptionString(int var1, short var2, byte[] var3, byte[] var4);

    protected native void getCursorName(int var1, byte[] var2, byte[] var3);

    protected native int getStmtOption(int var1, short var2, byte[] var3);

    protected native int getDataBinary(int var1, int var2, int var3, int var4, byte[] var5, int var6, byte[] var7);

    protected native int getDataStream(int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7, byte[] var8);

    protected native double getDataDouble(int var1, int var2, int var3, byte[] var4);

    protected native float getDataFloat(int var1, int var2, int var3, byte[] var4);

    protected native long getDataLong(int var1, int var2, int var3, byte[] var4);

    protected native int getDataInteger(int var1, int var2, int var3, byte[] var4);

    protected native short getDataShort(int var1, int var2, int var3, byte[] var4);

    protected native int getDataString(int var1, int var2, int var3, char[] var4, byte[] var5, int var6);

    protected native void getDataDate(int var1, int var2, int var3, int[] var4, byte[] var5);

    protected native void getDataTime(int var1, int var2, int var3, int[] var4, byte[] var5);

    protected native void getDataTimestamp(int var1, int var2, int var3, int[] var4, byte[] var5);

    protected native long getDataTimestampRaw(int var1, int var2, byte[] var3, int var4);

    protected native int getInfo(int var1, short var2, byte[] var3);

    protected native int getInfoShort(int var1, short var2, byte[] var3);

    protected native void getInfoString(int var1, short var2, byte[] var3, byte[] var4);

    protected native void getTypeInfo(int var1, short var2, byte[] var3);

    protected native void moreResults(int var1, byte[] var2);

    protected native void nativeSql(int var1, byte[] var2, byte[] var3, byte[] var4);

    protected native int numParams(int var1, byte[] var2);

    protected native int numResultCols(int var1, byte[] var2);

    protected native int paramData(int var1, byte[] var2);

    protected native void prepare(int var1, char[] var2, byte[] var3);

    protected native void primaryKeys(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8);

    protected native void procedures(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8);

    protected native void procedureColumns(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, byte[] var10);

    protected native void putData(int var1, byte[] var2, int var3, byte[] var4);

    protected native int rowCount(int var1, byte[] var2);

    protected native void setConnectOption(int var1, short var2, int var3, byte[] var4);

    protected native void setConnectOptionString(int var1, short var2, byte[] var3, byte[] var4);

    protected native void setCursorName(int var1, byte[] var2, byte[] var3);

    protected native void setStmtOption(int var1, short var2, int var3, byte[] var4);

    protected native void specialColumns(int var1, short var2, byte[] var3, boolean var4, byte[] var5, boolean var6, byte[] var7, boolean var8, int var9, boolean var10, byte[] var11);

    protected native void statistics(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, boolean var8, boolean var9, byte[] var10);

    protected native void tables(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8, boolean var9, byte[] var10);

    protected native void tablePrivileges(int var1, byte[] var2, boolean var3, byte[] var4, boolean var5, byte[] var6, boolean var7, byte[] var8);

    protected native short transact(int var1, int var2, short var3);

    protected native void ReleaseStoredBytes(int var1, int var2);

    protected native void ReleaseStoredChars(int var1, int var2);

    protected native int allocAndBindAllCols(int var1, int[] var2, int[] var3, int[] var4, byte[] var5, int var6);

    protected native void justReBindAllCols(int var1, int var2, int var3, byte[] var4);

    protected native void getStmtTypeInfo(int var1, int[] var2, int[] var3, byte[] var4, int var5);

    protected native int bindCol(int var1, int var2, int var3, int var4, int var5, byte[] var6);

    protected native int getInteger(int var1, byte[] var2, int var3);

    protected native void getString(int var1, int var2, RetVal var3, int var4);

    protected native int getDataLength(int var1, byte[] var2, int var3);

    protected native void getBytes(int var1, byte[] var2, byte[] var3, int var4);

    protected native void freeBoundColBuffers(int var1, int var2);

    protected native float getFloat(int var1, byte[] var2, int var3);

    protected native double getDouble(int var1, byte[] var2, int var3);

    protected native long getLong(int var1, byte[] var2, int var3);

    protected native short getShort(int var1, byte[] var2, int var3);

    protected native void getDate(int var1, byte[] var2, int var3, int[] var4);

    protected native void getTime(int var1, byte[] var2, int var3, int[] var4);

    protected native void getTimestamp(int var1, byte[] var2, int var3, int[] var4);

    protected native long getTimestampRaw(int var1, byte[] var2, int var3);

    protected native BigDecimal getBigDecimal(int var1, int var2);

    protected native void getStream(int var1, byte[] var2, byte[] var3, int var4, int var5);

    protected native int bindAllParams(int var1, short[] var2, int[] var3, byte[] var4, int var5);

    protected native short setInteger(int var1, int var2, int var3, int var4);

    protected native short setLong(int var1, int var2, long var3, int var5);

    protected native void setNull(int var1, int var2, byte[] var3, int var4);

    protected native void setString(int var1, int var2, String var3, byte[] var4, int var5);

    protected native short setFloat(int var1, int var2, float var3, int var4);

    protected native short setDouble(int var1, int var2, double var3, int var5);

    protected native void setBytes(int var1, int var2, byte[] var3, byte[] var4, int var5);

    protected native void setTimestamp(int var1, int var2, long var3, byte[] var5, int var6);

    protected native void freeBoundParams(int var1, int var2);

    public native int getDataStoreState(int var1, byte[] var2);

    public native String getMajorVersion();

    public native String getMinorVersion();

    public native String getPatchVersion();

    static {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(myMajorVersion);
        stringBuffer.append(".");
        stringBuffer.append(myMinorVersion);
        if (!myPatchVersion.equals("")) {
            stringBuffer.append(".");
            stringBuffer.append(myPatchVersion);
        }
        myVersion = stringBuffer.toString();
        stringBuffer = null;
    }
}

