/*
 * Decompiled with CFR 0.152.
 */
package com.timesten.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Vector;

public class JdbcOdbcBatchParams {
    private static final int BATCH_PARAM_TYPE_STRING = 0;
    private static final int BATCH_PARAM_TYPE_INTEGRAL = 1;
    private static final int BATCH_PARAM_TYPE_FLOAT = 2;
    private static final int BATCH_PARAM_TYPE_BYTES = 3;
    private static final int BATCH_PARAM_TYPE_NULL = 4;
    private static final int BATCH_ROWONLY_PARAM_TYPE_NULL = 5;
    private static final int BATCH_ROWONLY_PARAM_TYPE_TIMESTAMP = 6;
    private static final int BATCH_ROWONLY_PARAM_TYPE_BINARY_STREAM = 7;
    private static final int BATCH_ROWONLY_PARAM_TYPE_UNICODE_STREAM = 8;
    private static final int BATCH_ROWONLY_PARAM_TYPE_ASCII_STREAM = 9;
    private String[] m_rowStringParams;
    private long[] m_rowIntegralParams;
    private double[] m_rowFloatParams;
    private Timestamp[] m_rowTimestampParams;
    private byte[][] m_rowBytesParams;
    private InputStream[] m_rowStreamParams;
    private short[] m_rowJavaTypes;
    private short[] m_sqlTypes;
    private int m_numParams;
    private int m_capacityIncrement;
    private Object[] m_batchParams;
    private Object[] m_batchPrimitiveNullParams;
    private short[] m_batchJavaTypes;
    private int m_batchSize;

    public JdbcOdbcBatchParams(int n, short[] sArray) {
        this.m_capacityIncrement = n;
        this.m_sqlTypes = sArray;
        this.m_numParams = sArray != null ? sArray.length : 0;
        this.m_rowStringParams = new String[this.m_numParams];
        this.m_rowIntegralParams = new long[this.m_numParams];
        this.m_rowFloatParams = new double[this.m_numParams];
        this.m_rowTimestampParams = new Timestamp[this.m_numParams];
        this.m_rowBytesParams = new byte[this.m_numParams][];
        this.m_rowStreamParams = new InputStream[this.m_numParams];
        this.m_rowJavaTypes = new short[this.m_numParams];
        this.clear();
    }

    public void clear() {
        this.m_batchParams = new Object[this.m_numParams];
        this.m_batchPrimitiveNullParams = new Object[this.m_numParams];
        this.m_batchJavaTypes = null;
        this.m_batchSize = 0;
    }

    public void addParamRow() throws SQLException {
        if (this.m_batchJavaTypes == null) {
            this.initBatchJavaTypes();
        } else {
            this.checkRowTypeCompatibility();
            this.ensureCapacity();
        }
        for (int i = 0; i < this.m_numParams; ++i) {
            try {
                switch (this.m_rowJavaTypes[i]) {
                    case 0: {
                        this.addStringParam(i, this.m_rowStringParams[i]);
                        break;
                    }
                    case 1: {
                        this.addIntegralParam(i, this.m_rowIntegralParams[i]);
                        break;
                    }
                    case 2: {
                        this.addFloatParam(i, this.m_rowFloatParams[i]);
                        break;
                    }
                    case 3: {
                        this.addBytesParam(i, this.m_rowBytesParams[i]);
                        break;
                    }
                    case 5: {
                        this.addNullParam(i);
                        break;
                    }
                    case 6: {
                        this.addStringParam(i, String.valueOf(this.m_rowTimestampParams[i]));
                        break;
                    }
                    case 7: {
                        this.addBinaryStreamParam(i, this.m_rowStreamParams[i]);
                        break;
                    }
                    case 8: {
                        this.addUnicodeStreamParam(i, this.m_rowStreamParams[i]);
                        break;
                    }
                    case 9: {
                        this.addAsciiStreamParam(i, this.m_rowStreamParams[i]);
                    }
                }
                continue;
            }
            catch (SQLException sQLException) {
                this.rollbackAddParamRow(i - 1);
                throw sQLException;
            }
        }
        ++this.m_batchSize;
    }

    public int size() {
        return this.m_batchSize;
    }

    public Object[] getBatch() {
        Object[] objectArray = new Object[this.m_numParams];
        block4: for (int i = 0; i < this.m_numParams; ++i) {
            switch (this.m_batchJavaTypes[i]) {
                case 0: 
                case 3: 
                case 4: {
                    objectArray[i] = ((Vector)this.m_batchParams[i]).toArray();
                    continue block4;
                }
                case 1: 
                case 2: {
                    objectArray[i] = this.m_batchParams[i];
                }
            }
        }
        return objectArray;
    }

    public Object[] getBatchPrimitiveNulls() {
        return this.m_batchPrimitiveNullParams;
    }

    public short[] getBatchCTypes() {
        short[] sArray = new short[this.m_numParams];
        block6: for (int i = 0; i < this.m_numParams; ++i) {
            switch (this.m_batchJavaTypes[i]) {
                case 0: 
                case 4: {
                    if (this.m_sqlTypes[i] == -8 || this.m_sqlTypes[i] == -9 || this.m_sqlTypes[i] == -10) {
                        sArray[i] = -8;
                        continue block6;
                    }
                    sArray[i] = 1;
                    continue block6;
                }
                case 1: {
                    sArray[i] = -25;
                    continue block6;
                }
                case 2: {
                    sArray[i] = 8;
                    continue block6;
                }
                case 3: {
                    sArray[i] = -2;
                }
            }
        }
        return sArray;
    }

    public void setString(int n, String string) {
        this.m_rowJavaTypes[n] = 0;
        this.m_rowStringParams[n] = string;
    }

    public void setIntegral(int n, long l) {
        this.m_rowJavaTypes[n] = 1;
        this.m_rowIntegralParams[n] = l;
    }

    public void setBytes(int n, byte[] byArray) {
        this.m_rowJavaTypes[n] = 3;
        this.m_rowBytesParams[n] = byArray;
    }

    public void setTimestamp(int n, Timestamp timestamp) {
        this.m_rowJavaTypes[n] = 6;
        this.m_rowTimestampParams[n] = timestamp;
    }

    public void setFloat(int n, double d) {
        this.m_rowJavaTypes[n] = 2;
        this.m_rowFloatParams[n] = d;
    }

    public void setNull(int n) {
        this.m_rowJavaTypes[n] = 5;
    }

    public void setInputStream(int n, InputStream inputStream, int n2) throws SQLException {
        switch (n2) {
            case 3: {
                this.m_rowJavaTypes[n] = 7;
                break;
            }
            case 2: {
                this.m_rowJavaTypes[n] = 8;
                break;
            }
            case 1: {
                this.m_rowJavaTypes[n] = 9;
                break;
            }
            default: {
                this.throwBatchProcessingException("Invalid stream type.");
            }
        }
        this.m_rowStreamParams[n] = inputStream;
    }

    private void rollbackAddParamRow(int n) {
        for (int i = n; i >= 0; --i) {
            switch (this.m_batchJavaTypes[i]) {
                case 0: 
                case 3: 
                case 4: {
                    ((Vector)this.m_batchParams[i]).removeElementAt(this.m_batchSize);
                }
            }
        }
    }

    private void initBatchJavaTypes() {
        int n;
        this.m_batchJavaTypes = new short[this.m_numParams];
        block12: for (n = 0; n < this.m_numParams; ++n) {
            switch (this.m_rowJavaTypes[n]) {
                case 0: 
                case 6: 
                case 8: 
                case 9: {
                    this.m_batchJavaTypes[n] = 0;
                    continue block12;
                }
                case 3: 
                case 7: {
                    this.m_batchJavaTypes[n] = 3;
                    continue block12;
                }
                case 1: {
                    this.m_batchJavaTypes[n] = 1;
                    continue block12;
                }
                case 2: {
                    this.m_batchJavaTypes[n] = 2;
                    continue block12;
                }
                case 5: {
                    this.m_batchJavaTypes[n] = 4;
                }
            }
        }
        block13: for (n = 0; n < this.m_numParams; ++n) {
            switch (this.m_batchJavaTypes[n]) {
                case 0: 
                case 3: 
                case 4: {
                    this.m_batchParams[n] = new Vector(this.m_capacityIncrement, this.m_capacityIncrement);
                    continue block13;
                }
                case 1: {
                    this.m_batchParams[n] = new long[this.m_capacityIncrement];
                    this.m_batchPrimitiveNullParams[n] = new int[this.m_capacityIncrement];
                    continue block13;
                }
                case 2: {
                    this.m_batchParams[n] = new double[this.m_capacityIncrement];
                    this.m_batchPrimitiveNullParams[n] = new int[this.m_capacityIncrement];
                }
            }
        }
    }

    private void checkRowTypeCompatibility() throws SQLException {
        block19: for (int i = 0; i < this.m_numParams; ++i) {
            if (this.m_batchJavaTypes[i] == 4 && this.m_rowJavaTypes[i] != 5) {
                switch (this.m_rowJavaTypes[i]) {
                    case 0: 
                    case 6: 
                    case 8: 
                    case 9: {
                        this.m_batchJavaTypes[i] = 0;
                        break;
                    }
                    case 3: 
                    case 7: {
                        this.m_batchJavaTypes[i] = 3;
                        break;
                    }
                    case 1: {
                        this.m_batchJavaTypes[i] = 1;
                        break;
                    }
                    case 2: {
                        this.m_batchJavaTypes[i] = 2;
                    }
                }
                int n = this.m_batchSize + this.m_capacityIncrement - (this.m_batchSize + this.m_capacityIncrement) % this.m_capacityIncrement;
                switch (this.m_batchJavaTypes[i]) {
                    case 1: {
                        this.m_batchParams[i] = new long[n];
                        this.m_batchPrimitiveNullParams[i] = new int[n];
                        break;
                    }
                    case 2: {
                        this.m_batchParams[i] = new double[n];
                        this.m_batchPrimitiveNullParams[i] = new int[n];
                    }
                }
                for (int j = 0; j < this.m_batchSize; ++j) {
                    switch (this.m_batchJavaTypes[i]) {
                        case 1: 
                        case 2: {
                            ((int[])this.m_batchPrimitiveNullParams[i])[j] = -1;
                        }
                    }
                }
            }
            switch (this.m_rowJavaTypes[i]) {
                case 0: 
                case 6: 
                case 8: 
                case 9: {
                    if (this.m_batchJavaTypes[i] == 0) continue block19;
                    this.throwBatchProcessingException("A parameter set in the current row is not type compatible with the current batch.");
                    continue block19;
                }
                case 3: 
                case 7: {
                    if (this.m_batchJavaTypes[i] == 3) continue block19;
                    this.throwBatchProcessingException("A parameter set in the current row is not type compatible with the current batch.");
                    continue block19;
                }
                case 1: {
                    if (this.m_batchJavaTypes[i] == 1) continue block19;
                    this.throwBatchProcessingException("A parameter set in the current row is not type compatible with the current batch.");
                    continue block19;
                }
                case 2: {
                    if (this.m_batchJavaTypes[i] == 2) continue block19;
                    this.throwBatchProcessingException("A parameter set in the current row is not type compatible with the current batch.");
                }
            }
        }
    }

    private void addStringParam(int n, String string) {
        ((Vector)this.m_batchParams[n]).add(string);
    }

    private void addBytesParam(int n, byte[] byArray) {
        ((Vector)this.m_batchParams[n]).add(byArray);
    }

    private void addIntegralParam(int n, long l) {
        ((long[])this.m_batchParams[n])[this.m_batchSize] = l;
    }

    private void addFloatParam(int n, double d) {
        ((double[])this.m_batchParams[n])[this.m_batchSize] = d;
    }

    private void addNullParam(int n) {
        switch (this.m_batchJavaTypes[n]) {
            case 0: 
            case 3: 
            case 4: {
                ((Vector)this.m_batchParams[n]).add(null);
                break;
            }
            case 1: 
            case 2: {
                ((int[])this.m_batchPrimitiveNullParams[n])[this.m_batchSize] = -1;
            }
        }
    }

    private void addBinaryStreamParam(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.addNullParam(n);
        } else {
            byte[] byArray = this.getStreamBytes(inputStream);
            this.addBytesParam(n, byArray);
        }
    }

    private void addAsciiStreamParam(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.addNullParam(n);
        } else {
            byte[] byArray = this.getStreamBytes(inputStream);
            char[] cArray = new char[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                cArray[i] = (char)byArray[i];
            }
            this.addStringParam(n, new String(cArray));
        }
    }

    private void addUnicodeStreamParam(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.addNullParam(n);
        } else {
            byte[] byArray = this.getStreamBytes(inputStream);
            char[] cArray = new char[byArray.length / 2];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(((char)byArray[i * 2] & 0xFF) << 8);
                cArray[i] = (char)(cArray[i] | (char)byArray[i * 2 + 1] & 0xFF);
            }
            this.addStringParam(n, new String(cArray));
        }
    }

    private void ensureCapacity() {
        if ((this.m_batchSize + 1) % this.m_capacityIncrement != 0) {
            return;
        }
        block4: for (int i = 0; i < this.m_numParams; ++i) {
            switch (this.m_batchJavaTypes[i]) {
                case 1: {
                    this.m_batchParams[i] = this.reallocateLongArray((long[])this.m_batchParams[i]);
                    this.m_batchPrimitiveNullParams[i] = this.reallocateJpointerArray((int[])this.m_batchPrimitiveNullParams[i]);
                    continue block4;
                }
                case 2: {
                    this.m_batchParams[i] = this.reallocateDoubleArray((double[])this.m_batchParams[i]);
                    this.m_batchPrimitiveNullParams[i] = this.reallocateJpointerArray((int[])this.m_batchPrimitiveNullParams[i]);
                }
            }
        }
    }

    private int[] reallocateJpointerArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length + this.m_capacityIncrement];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private long[] reallocateLongArray(long[] lArray) {
        long[] lArray2 = new long[lArray.length + this.m_capacityIncrement];
        System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
        return lArray2;
    }

    private int[] reallocateIntArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length + this.m_capacityIncrement];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        return nArray2;
    }

    private byte[] reallocateByteArray(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + this.m_capacityIncrement];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    private double[] reallocateDoubleArray(double[] dArray) {
        double[] dArray2 = new double[dArray.length + this.m_capacityIncrement];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    private byte[] getStreamBytes(InputStream inputStream) throws SQLException {
        byte[] byArray = new byte[this.m_capacityIncrement];
        int n = -1;
        int n2 = 0;
        do {
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                this.throwBatchProcessingException(iOException.getMessage());
            }
            if (n == -1) continue;
            byArray[n2] = (byte)n;
            if (++n2 != byArray.length) continue;
            byArray = this.reallocateByteArray(byArray);
        } while (n != -1);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    private void throwBatchProcessingException(String string) throws SQLException {
        throw new SQLException("An error occured while processing the batch: " + string, "S1000");
    }
}

